/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.trader.ApiCallback;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.ApiException;
import net.jacobpeterson.alpaca.openapi.trader.ApiResponse;
import net.jacobpeterson.alpaca.openapi.trader.Configuration;
import net.jacobpeterson.alpaca.openapi.trader.Pair;
import net.jacobpeterson.alpaca.openapi.trader.model.AddAssetToWatchlistByNameRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.AddAssetToWatchlistRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.UpdateWatchlistRequest;
import net.jacobpeterson.alpaca.openapi.trader.model.Watchlist;
import okhttp3.Call;

public class WatchlistsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WatchlistsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WatchlistsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected Call addAssetToWatchlistCall(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddAssetToWatchlistRequest localVarPostBody = addAssetToWatchlistRequest;
        String localVarPath = "/v2/watchlists/{watchlist_id}".replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAssetToWatchlistValidateBeforeCall(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest, ApiCallback _callback) throws ApiException {
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling addAssetToWatchlist(Async)");
        }
        return this.addAssetToWatchlistCall(watchlistId, addAssetToWatchlistRequest, _callback);
    }

    public Watchlist addAssetToWatchlist(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.addAssetToWatchlistWithHttpInfo(watchlistId, addAssetToWatchlistRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> addAssetToWatchlistWithHttpInfo(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest) throws ApiException {
        Call localVarCall = this.addAssetToWatchlistValidateBeforeCall(watchlistId, addAssetToWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call addAssetToWatchlistAsync(UUID watchlistId, AddAssetToWatchlistRequest addAssetToWatchlistRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.addAssetToWatchlistValidateBeforeCall(watchlistId, addAssetToWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call addAssetToWatchlistByNameCall(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AddAssetToWatchlistByNameRequest localVarPostBody = addAssetToWatchlistByNameRequest;
        String localVarPath = "/v2/watchlists:by_name";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAssetToWatchlistByNameValidateBeforeCall(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling addAssetToWatchlistByName(Async)");
        }
        return this.addAssetToWatchlistByNameCall(name, addAssetToWatchlistByNameRequest, _callback);
    }

    public Watchlist addAssetToWatchlistByName(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.addAssetToWatchlistByNameWithHttpInfo(name, addAssetToWatchlistByNameRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> addAssetToWatchlistByNameWithHttpInfo(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest) throws ApiException {
        Call localVarCall = this.addAssetToWatchlistByNameValidateBeforeCall(name, addAssetToWatchlistByNameRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call addAssetToWatchlistByNameAsync(String name, AddAssetToWatchlistByNameRequest addAssetToWatchlistByNameRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.addAssetToWatchlistByNameValidateBeforeCall(name, addAssetToWatchlistByNameRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call deleteWatchlistByIdCall(UUID watchlistId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/watchlists/{watchlist_id}".replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWatchlistByIdValidateBeforeCall(UUID watchlistId, ApiCallback _callback) throws ApiException {
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling deleteWatchlistById(Async)");
        }
        return this.deleteWatchlistByIdCall(watchlistId, _callback);
    }

    public void deleteWatchlistById(UUID watchlistId) throws ApiException {
        this.deleteWatchlistByIdWithHttpInfo(watchlistId);
    }

    protected ApiResponse<Void> deleteWatchlistByIdWithHttpInfo(UUID watchlistId) throws ApiException {
        Call localVarCall = this.deleteWatchlistByIdValidateBeforeCall(watchlistId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteWatchlistByIdAsync(UUID watchlistId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWatchlistByIdValidateBeforeCall(watchlistId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call deleteWatchlistByNameCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/watchlists:by_name";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWatchlistByNameValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteWatchlistByName(Async)");
        }
        return this.deleteWatchlistByNameCall(name, _callback);
    }

    public void deleteWatchlistByName(String name) throws ApiException {
        this.deleteWatchlistByNameWithHttpInfo(name);
    }

    protected ApiResponse<Void> deleteWatchlistByNameWithHttpInfo(String name) throws ApiException {
        Call localVarCall = this.deleteWatchlistByNameValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    protected Call deleteWatchlistByNameAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWatchlistByNameValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    protected Call getWatchlistByIdCall(UUID watchlistId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/watchlists/{watchlist_id}".replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWatchlistByIdValidateBeforeCall(UUID watchlistId, ApiCallback _callback) throws ApiException {
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling getWatchlistById(Async)");
        }
        return this.getWatchlistByIdCall(watchlistId, _callback);
    }

    public Watchlist getWatchlistById(UUID watchlistId) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.getWatchlistByIdWithHttpInfo(watchlistId);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> getWatchlistByIdWithHttpInfo(UUID watchlistId) throws ApiException {
        Call localVarCall = this.getWatchlistByIdValidateBeforeCall(watchlistId, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getWatchlistByIdAsync(UUID watchlistId, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.getWatchlistByIdValidateBeforeCall(watchlistId, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getWatchlistByNameCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/watchlists:by_name";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWatchlistByNameValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getWatchlistByName(Async)");
        }
        return this.getWatchlistByNameCall(name, _callback);
    }

    public Watchlist getWatchlistByName(String name) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.getWatchlistByNameWithHttpInfo(name);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> getWatchlistByNameWithHttpInfo(String name) throws ApiException {
        Call localVarCall = this.getWatchlistByNameValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getWatchlistByNameAsync(String name, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.getWatchlistByNameValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call getWatchlistsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/watchlists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWatchlistsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getWatchlistsCall(_callback);
    }

    public List<Watchlist> getWatchlists() throws ApiException {
        ApiResponse<List<Watchlist>> localVarResp = this.getWatchlistsWithHttpInfo();
        return localVarResp.getData();
    }

    protected ApiResponse<List<Watchlist>> getWatchlistsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getWatchlistsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call getWatchlistsAsync(ApiCallback<List<Watchlist>> _callback) throws ApiException {
        Call localVarCall = this.getWatchlistsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call postWatchlistCall(UpdateWatchlistRequest updateWatchlistRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateWatchlistRequest localVarPostBody = updateWatchlistRequest;
        String localVarPath = "/v2/watchlists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postWatchlistValidateBeforeCall(UpdateWatchlistRequest updateWatchlistRequest, ApiCallback _callback) throws ApiException {
        if (updateWatchlistRequest == null) {
            throw new ApiException("Missing the required parameter 'updateWatchlistRequest' when calling postWatchlist(Async)");
        }
        return this.postWatchlistCall(updateWatchlistRequest, _callback);
    }

    public Watchlist postWatchlist(UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.postWatchlistWithHttpInfo(updateWatchlistRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> postWatchlistWithHttpInfo(UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        Call localVarCall = this.postWatchlistValidateBeforeCall(updateWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call postWatchlistAsync(UpdateWatchlistRequest updateWatchlistRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.postWatchlistValidateBeforeCall(updateWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call removeAssetFromWatchlistCall(UUID watchlistId, String symbol, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v2/watchlists/{watchlist_id}/{symbol}".replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString())).replace("{symbol}", this.localVarApiClient.escapeString(symbol.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call removeAssetFromWatchlistValidateBeforeCall(UUID watchlistId, String symbol, ApiCallback _callback) throws ApiException {
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling removeAssetFromWatchlist(Async)");
        }
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling removeAssetFromWatchlist(Async)");
        }
        return this.removeAssetFromWatchlistCall(watchlistId, symbol, _callback);
    }

    public Watchlist removeAssetFromWatchlist(UUID watchlistId, String symbol) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.removeAssetFromWatchlistWithHttpInfo(watchlistId, symbol);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> removeAssetFromWatchlistWithHttpInfo(UUID watchlistId, String symbol) throws ApiException {
        Call localVarCall = this.removeAssetFromWatchlistValidateBeforeCall(watchlistId, symbol, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call removeAssetFromWatchlistAsync(UUID watchlistId, String symbol, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.removeAssetFromWatchlistValidateBeforeCall(watchlistId, symbol, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call updateWatchlistByIdCall(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateWatchlistRequest localVarPostBody = updateWatchlistRequest;
        String localVarPath = "/v2/watchlists/{watchlist_id}".replace("{watchlist_id}", this.localVarApiClient.escapeString(watchlistId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateWatchlistByIdValidateBeforeCall(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest, ApiCallback _callback) throws ApiException {
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling updateWatchlistById(Async)");
        }
        return this.updateWatchlistByIdCall(watchlistId, updateWatchlistRequest, _callback);
    }

    public Watchlist updateWatchlistById(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.updateWatchlistByIdWithHttpInfo(watchlistId, updateWatchlistRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> updateWatchlistByIdWithHttpInfo(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        Call localVarCall = this.updateWatchlistByIdValidateBeforeCall(watchlistId, updateWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call updateWatchlistByIdAsync(UUID watchlistId, UpdateWatchlistRequest updateWatchlistRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.updateWatchlistByIdValidateBeforeCall(watchlistId, updateWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    protected Call updateWatchlistByNameCall(String name, UpdateWatchlistRequest updateWatchlistRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateWatchlistRequest localVarPostBody = updateWatchlistRequest;
        String localVarPath = "/v2/watchlists:by_name";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"API_Key", "API_Secret"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateWatchlistByNameValidateBeforeCall(String name, UpdateWatchlistRequest updateWatchlistRequest, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateWatchlistByName(Async)");
        }
        return this.updateWatchlistByNameCall(name, updateWatchlistRequest, _callback);
    }

    public Watchlist updateWatchlistByName(String name, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = this.updateWatchlistByNameWithHttpInfo(name, updateWatchlistRequest);
        return localVarResp.getData();
    }

    protected ApiResponse<Watchlist> updateWatchlistByNameWithHttpInfo(String name, UpdateWatchlistRequest updateWatchlistRequest) throws ApiException {
        Call localVarCall = this.updateWatchlistByNameValidateBeforeCall(name, updateWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    protected Call updateWatchlistByNameAsync(String name, UpdateWatchlistRequest updateWatchlistRequest, ApiCallback<Watchlist> _callback) throws ApiException {
        Call localVarCall = this.updateWatchlistByNameValidateBeforeCall(name, updateWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

