/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.openapi.trader.model.AccountStatus;

public class Account {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private AccountStatus status;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CASH = "cash";
    @SerializedName(value="cash")
    private String cash;
    public static final String SERIALIZED_NAME_PORTFOLIO_VALUE = "portfolio_value";
    @SerializedName(value="portfolio_value")
    private String portfolioValue;
    public static final String SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER = "non_marginable_buying_power";
    @SerializedName(value="non_marginable_buying_power")
    private String nonMarginableBuyingPower;
    public static final String SERIALIZED_NAME_ACCRUED_FEES = "accrued_fees";
    @SerializedName(value="accrued_fees")
    private String accruedFees;
    public static final String SERIALIZED_NAME_PENDING_TRANSFER_IN = "pending_transfer_in";
    @SerializedName(value="pending_transfer_in")
    private String pendingTransferIn;
    public static final String SERIALIZED_NAME_PENDING_TRANSFER_OUT = "pending_transfer_out";
    @SerializedName(value="pending_transfer_out")
    private String pendingTransferOut;
    public static final String SERIALIZED_NAME_PATTERN_DAY_TRADER = "pattern_day_trader";
    @SerializedName(value="pattern_day_trader")
    private Boolean patternDayTrader;
    public static final String SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER = "trade_suspended_by_user";
    @SerializedName(value="trade_suspended_by_user")
    private Boolean tradeSuspendedByUser;
    public static final String SERIALIZED_NAME_TRADING_BLOCKED = "trading_blocked";
    @SerializedName(value="trading_blocked")
    private Boolean tradingBlocked;
    public static final String SERIALIZED_NAME_TRANSFERS_BLOCKED = "transfers_blocked";
    @SerializedName(value="transfers_blocked")
    private Boolean transfersBlocked;
    public static final String SERIALIZED_NAME_ACCOUNT_BLOCKED = "account_blocked";
    @SerializedName(value="account_blocked")
    private Boolean accountBlocked;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_SHORTING_ENABLED = "shorting_enabled";
    @SerializedName(value="shorting_enabled")
    private Boolean shortingEnabled;
    public static final String SERIALIZED_NAME_LONG_MARKET_VALUE = "long_market_value";
    @SerializedName(value="long_market_value")
    private String longMarketValue;
    public static final String SERIALIZED_NAME_SHORT_MARKET_VALUE = "short_market_value";
    @SerializedName(value="short_market_value")
    private String shortMarketValue;
    public static final String SERIALIZED_NAME_EQUITY = "equity";
    @SerializedName(value="equity")
    private String equity;
    public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
    @SerializedName(value="last_equity")
    private String lastEquity;
    public static final String SERIALIZED_NAME_MULTIPLIER = "multiplier";
    @SerializedName(value="multiplier")
    private String multiplier;
    public static final String SERIALIZED_NAME_BUYING_POWER = "buying_power";
    @SerializedName(value="buying_power")
    private String buyingPower;
    public static final String SERIALIZED_NAME_INITIAL_MARGIN = "initial_margin";
    @SerializedName(value="initial_margin")
    private String initialMargin;
    public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN = "maintenance_margin";
    @SerializedName(value="maintenance_margin")
    private String maintenanceMargin;
    public static final String SERIALIZED_NAME_SMA = "sma";
    @SerializedName(value="sma")
    private String sma;
    public static final String SERIALIZED_NAME_DAYTRADE_COUNT = "daytrade_count";
    @SerializedName(value="daytrade_count")
    private Integer daytradeCount;
    public static final String SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN = "last_maintenance_margin";
    @SerializedName(value="last_maintenance_margin")
    private String lastMaintenanceMargin;
    public static final String SERIALIZED_NAME_DAYTRADING_BUYING_POWER = "daytrading_buying_power";
    @SerializedName(value="daytrading_buying_power")
    private String daytradingBuyingPower;
    public static final String SERIALIZED_NAME_REGT_BUYING_POWER = "regt_buying_power";
    @SerializedName(value="regt_buying_power")
    private String regtBuyingPower;
    public static final String SERIALIZED_NAME_OPTIONS_BUYING_POWER = "options_buying_power";
    @SerializedName(value="options_buying_power")
    private String optionsBuyingPower;
    public static final String SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL = "options_approved_level";
    @SerializedName(value="options_approved_level")
    private OptionsApprovedLevelEnum optionsApprovedLevel;
    public static final String SERIALIZED_NAME_OPTIONS_TRADING_LEVEL = "options_trading_level";
    @SerializedName(value="options_trading_level")
    private OptionsTradingLevelEnum optionsTradingLevel;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Account id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Account accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Account status(AccountStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public Account currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Account cash(String cash) {
        this.cash = cash;
        return this;
    }

    @Nullable
    public String getCash() {
        return this.cash;
    }

    public void setCash(String cash) {
        this.cash = cash;
    }

    public Account portfolioValue(String portfolioValue) {
        this.portfolioValue = portfolioValue;
        return this;
    }

    @Nullable
    public String getPortfolioValue() {
        return this.portfolioValue;
    }

    public void setPortfolioValue(String portfolioValue) {
        this.portfolioValue = portfolioValue;
    }

    public Account nonMarginableBuyingPower(String nonMarginableBuyingPower) {
        this.nonMarginableBuyingPower = nonMarginableBuyingPower;
        return this;
    }

    @Nullable
    public String getNonMarginableBuyingPower() {
        return this.nonMarginableBuyingPower;
    }

    public void setNonMarginableBuyingPower(String nonMarginableBuyingPower) {
        this.nonMarginableBuyingPower = nonMarginableBuyingPower;
    }

    public Account accruedFees(String accruedFees) {
        this.accruedFees = accruedFees;
        return this;
    }

    @Nullable
    public String getAccruedFees() {
        return this.accruedFees;
    }

    public void setAccruedFees(String accruedFees) {
        this.accruedFees = accruedFees;
    }

    public Account pendingTransferIn(String pendingTransferIn) {
        this.pendingTransferIn = pendingTransferIn;
        return this;
    }

    @Nullable
    public String getPendingTransferIn() {
        return this.pendingTransferIn;
    }

    public void setPendingTransferIn(String pendingTransferIn) {
        this.pendingTransferIn = pendingTransferIn;
    }

    public Account pendingTransferOut(String pendingTransferOut) {
        this.pendingTransferOut = pendingTransferOut;
        return this;
    }

    @Nullable
    public String getPendingTransferOut() {
        return this.pendingTransferOut;
    }

    public void setPendingTransferOut(String pendingTransferOut) {
        this.pendingTransferOut = pendingTransferOut;
    }

    public Account patternDayTrader(Boolean patternDayTrader) {
        this.patternDayTrader = patternDayTrader;
        return this;
    }

    @Nullable
    public Boolean getPatternDayTrader() {
        return this.patternDayTrader;
    }

    public void setPatternDayTrader(Boolean patternDayTrader) {
        this.patternDayTrader = patternDayTrader;
    }

    public Account tradeSuspendedByUser(Boolean tradeSuspendedByUser) {
        this.tradeSuspendedByUser = tradeSuspendedByUser;
        return this;
    }

    @Nullable
    public Boolean getTradeSuspendedByUser() {
        return this.tradeSuspendedByUser;
    }

    public void setTradeSuspendedByUser(Boolean tradeSuspendedByUser) {
        this.tradeSuspendedByUser = tradeSuspendedByUser;
    }

    public Account tradingBlocked(Boolean tradingBlocked) {
        this.tradingBlocked = tradingBlocked;
        return this;
    }

    @Nullable
    public Boolean getTradingBlocked() {
        return this.tradingBlocked;
    }

    public void setTradingBlocked(Boolean tradingBlocked) {
        this.tradingBlocked = tradingBlocked;
    }

    public Account transfersBlocked(Boolean transfersBlocked) {
        this.transfersBlocked = transfersBlocked;
        return this;
    }

    @Nullable
    public Boolean getTransfersBlocked() {
        return this.transfersBlocked;
    }

    public void setTransfersBlocked(Boolean transfersBlocked) {
        this.transfersBlocked = transfersBlocked;
    }

    public Account accountBlocked(Boolean accountBlocked) {
        this.accountBlocked = accountBlocked;
        return this;
    }

    @Nullable
    public Boolean getAccountBlocked() {
        return this.accountBlocked;
    }

    public void setAccountBlocked(Boolean accountBlocked) {
        this.accountBlocked = accountBlocked;
    }

    public Account createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Account shortingEnabled(Boolean shortingEnabled) {
        this.shortingEnabled = shortingEnabled;
        return this;
    }

    @Nullable
    public Boolean getShortingEnabled() {
        return this.shortingEnabled;
    }

    public void setShortingEnabled(Boolean shortingEnabled) {
        this.shortingEnabled = shortingEnabled;
    }

    public Account longMarketValue(String longMarketValue) {
        this.longMarketValue = longMarketValue;
        return this;
    }

    @Nullable
    public String getLongMarketValue() {
        return this.longMarketValue;
    }

    public void setLongMarketValue(String longMarketValue) {
        this.longMarketValue = longMarketValue;
    }

    public Account shortMarketValue(String shortMarketValue) {
        this.shortMarketValue = shortMarketValue;
        return this;
    }

    @Nullable
    public String getShortMarketValue() {
        return this.shortMarketValue;
    }

    public void setShortMarketValue(String shortMarketValue) {
        this.shortMarketValue = shortMarketValue;
    }

    public Account equity(String equity) {
        this.equity = equity;
        return this;
    }

    @Nullable
    public String getEquity() {
        return this.equity;
    }

    public void setEquity(String equity) {
        this.equity = equity;
    }

    public Account lastEquity(String lastEquity) {
        this.lastEquity = lastEquity;
        return this;
    }

    @Nullable
    public String getLastEquity() {
        return this.lastEquity;
    }

    public void setLastEquity(String lastEquity) {
        this.lastEquity = lastEquity;
    }

    public Account multiplier(String multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    @Nullable
    public String getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(String multiplier) {
        this.multiplier = multiplier;
    }

    public Account buyingPower(String buyingPower) {
        this.buyingPower = buyingPower;
        return this;
    }

    @Nullable
    public String getBuyingPower() {
        return this.buyingPower;
    }

    public void setBuyingPower(String buyingPower) {
        this.buyingPower = buyingPower;
    }

    public Account initialMargin(String initialMargin) {
        this.initialMargin = initialMargin;
        return this;
    }

    @Nullable
    public String getInitialMargin() {
        return this.initialMargin;
    }

    public void setInitialMargin(String initialMargin) {
        this.initialMargin = initialMargin;
    }

    public Account maintenanceMargin(String maintenanceMargin) {
        this.maintenanceMargin = maintenanceMargin;
        return this;
    }

    @Nullable
    public String getMaintenanceMargin() {
        return this.maintenanceMargin;
    }

    public void setMaintenanceMargin(String maintenanceMargin) {
        this.maintenanceMargin = maintenanceMargin;
    }

    public Account sma(String sma) {
        this.sma = sma;
        return this;
    }

    @Nullable
    public String getSma() {
        return this.sma;
    }

    public void setSma(String sma) {
        this.sma = sma;
    }

    public Account daytradeCount(Integer daytradeCount) {
        this.daytradeCount = daytradeCount;
        return this;
    }

    @Nullable
    public Integer getDaytradeCount() {
        return this.daytradeCount;
    }

    public void setDaytradeCount(Integer daytradeCount) {
        this.daytradeCount = daytradeCount;
    }

    public Account lastMaintenanceMargin(String lastMaintenanceMargin) {
        this.lastMaintenanceMargin = lastMaintenanceMargin;
        return this;
    }

    @Nullable
    public String getLastMaintenanceMargin() {
        return this.lastMaintenanceMargin;
    }

    public void setLastMaintenanceMargin(String lastMaintenanceMargin) {
        this.lastMaintenanceMargin = lastMaintenanceMargin;
    }

    public Account daytradingBuyingPower(String daytradingBuyingPower) {
        this.daytradingBuyingPower = daytradingBuyingPower;
        return this;
    }

    @Nullable
    public String getDaytradingBuyingPower() {
        return this.daytradingBuyingPower;
    }

    public void setDaytradingBuyingPower(String daytradingBuyingPower) {
        this.daytradingBuyingPower = daytradingBuyingPower;
    }

    public Account regtBuyingPower(String regtBuyingPower) {
        this.regtBuyingPower = regtBuyingPower;
        return this;
    }

    @Nullable
    public String getRegtBuyingPower() {
        return this.regtBuyingPower;
    }

    public void setRegtBuyingPower(String regtBuyingPower) {
        this.regtBuyingPower = regtBuyingPower;
    }

    public Account optionsBuyingPower(String optionsBuyingPower) {
        this.optionsBuyingPower = optionsBuyingPower;
        return this;
    }

    @Nullable
    public String getOptionsBuyingPower() {
        return this.optionsBuyingPower;
    }

    public void setOptionsBuyingPower(String optionsBuyingPower) {
        this.optionsBuyingPower = optionsBuyingPower;
    }

    public Account optionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
        this.optionsApprovedLevel = optionsApprovedLevel;
        return this;
    }

    @Nullable
    public OptionsApprovedLevelEnum getOptionsApprovedLevel() {
        return this.optionsApprovedLevel;
    }

    public void setOptionsApprovedLevel(OptionsApprovedLevelEnum optionsApprovedLevel) {
        this.optionsApprovedLevel = optionsApprovedLevel;
    }

    public Account optionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
        this.optionsTradingLevel = optionsTradingLevel;
        return this;
    }

    @Nullable
    public OptionsTradingLevelEnum getOptionsTradingLevel() {
        return this.optionsTradingLevel;
    }

    public void setOptionsTradingLevel(OptionsTradingLevelEnum optionsTradingLevel) {
        this.optionsTradingLevel = optionsTradingLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.id, account.id) && Objects.equals(this.accountNumber, account.accountNumber) && Objects.equals((Object)this.status, (Object)account.status) && Objects.equals(this.currency, account.currency) && Objects.equals(this.cash, account.cash) && Objects.equals(this.portfolioValue, account.portfolioValue) && Objects.equals(this.nonMarginableBuyingPower, account.nonMarginableBuyingPower) && Objects.equals(this.accruedFees, account.accruedFees) && Objects.equals(this.pendingTransferIn, account.pendingTransferIn) && Objects.equals(this.pendingTransferOut, account.pendingTransferOut) && Objects.equals(this.patternDayTrader, account.patternDayTrader) && Objects.equals(this.tradeSuspendedByUser, account.tradeSuspendedByUser) && Objects.equals(this.tradingBlocked, account.tradingBlocked) && Objects.equals(this.transfersBlocked, account.transfersBlocked) && Objects.equals(this.accountBlocked, account.accountBlocked) && Objects.equals(this.createdAt, account.createdAt) && Objects.equals(this.shortingEnabled, account.shortingEnabled) && Objects.equals(this.longMarketValue, account.longMarketValue) && Objects.equals(this.shortMarketValue, account.shortMarketValue) && Objects.equals(this.equity, account.equity) && Objects.equals(this.lastEquity, account.lastEquity) && Objects.equals(this.multiplier, account.multiplier) && Objects.equals(this.buyingPower, account.buyingPower) && Objects.equals(this.initialMargin, account.initialMargin) && Objects.equals(this.maintenanceMargin, account.maintenanceMargin) && Objects.equals(this.sma, account.sma) && Objects.equals(this.daytradeCount, account.daytradeCount) && Objects.equals(this.lastMaintenanceMargin, account.lastMaintenanceMargin) && Objects.equals(this.daytradingBuyingPower, account.daytradingBuyingPower) && Objects.equals(this.regtBuyingPower, account.regtBuyingPower) && Objects.equals(this.optionsBuyingPower, account.optionsBuyingPower) && Objects.equals((Object)this.optionsApprovedLevel, (Object)account.optionsApprovedLevel) && Objects.equals((Object)this.optionsTradingLevel, (Object)account.optionsTradingLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountNumber, this.status, this.currency, this.cash, this.portfolioValue, this.nonMarginableBuyingPower, this.accruedFees, this.pendingTransferIn, this.pendingTransferOut, this.patternDayTrader, this.tradeSuspendedByUser, this.tradingBlocked, this.transfersBlocked, this.accountBlocked, this.createdAt, this.shortingEnabled, this.longMarketValue, this.shortMarketValue, this.equity, this.lastEquity, this.multiplier, this.buyingPower, this.initialMargin, this.maintenanceMargin, this.sma, this.daytradeCount, this.lastMaintenanceMargin, this.daytradingBuyingPower, this.regtBuyingPower, this.optionsBuyingPower, this.optionsApprovedLevel, this.optionsTradingLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    cash: ").append(this.toIndentedString(this.cash)).append("\n");
        sb.append("    portfolioValue: ").append(this.toIndentedString(this.portfolioValue)).append("\n");
        sb.append("    nonMarginableBuyingPower: ").append(this.toIndentedString(this.nonMarginableBuyingPower)).append("\n");
        sb.append("    accruedFees: ").append(this.toIndentedString(this.accruedFees)).append("\n");
        sb.append("    pendingTransferIn: ").append(this.toIndentedString(this.pendingTransferIn)).append("\n");
        sb.append("    pendingTransferOut: ").append(this.toIndentedString(this.pendingTransferOut)).append("\n");
        sb.append("    patternDayTrader: ").append(this.toIndentedString(this.patternDayTrader)).append("\n");
        sb.append("    tradeSuspendedByUser: ").append(this.toIndentedString(this.tradeSuspendedByUser)).append("\n");
        sb.append("    tradingBlocked: ").append(this.toIndentedString(this.tradingBlocked)).append("\n");
        sb.append("    transfersBlocked: ").append(this.toIndentedString(this.transfersBlocked)).append("\n");
        sb.append("    accountBlocked: ").append(this.toIndentedString(this.accountBlocked)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    shortingEnabled: ").append(this.toIndentedString(this.shortingEnabled)).append("\n");
        sb.append("    longMarketValue: ").append(this.toIndentedString(this.longMarketValue)).append("\n");
        sb.append("    shortMarketValue: ").append(this.toIndentedString(this.shortMarketValue)).append("\n");
        sb.append("    equity: ").append(this.toIndentedString(this.equity)).append("\n");
        sb.append("    lastEquity: ").append(this.toIndentedString(this.lastEquity)).append("\n");
        sb.append("    multiplier: ").append(this.toIndentedString(this.multiplier)).append("\n");
        sb.append("    buyingPower: ").append(this.toIndentedString(this.buyingPower)).append("\n");
        sb.append("    initialMargin: ").append(this.toIndentedString(this.initialMargin)).append("\n");
        sb.append("    maintenanceMargin: ").append(this.toIndentedString(this.maintenanceMargin)).append("\n");
        sb.append("    sma: ").append(this.toIndentedString(this.sma)).append("\n");
        sb.append("    daytradeCount: ").append(this.toIndentedString(this.daytradeCount)).append("\n");
        sb.append("    lastMaintenanceMargin: ").append(this.toIndentedString(this.lastMaintenanceMargin)).append("\n");
        sb.append("    daytradingBuyingPower: ").append(this.toIndentedString(this.daytradingBuyingPower)).append("\n");
        sb.append("    regtBuyingPower: ").append(this.toIndentedString(this.regtBuyingPower)).append("\n");
        sb.append("    optionsBuyingPower: ").append(this.toIndentedString(this.optionsBuyingPower)).append("\n");
        sb.append("    optionsApprovedLevel: ").append(this.toIndentedString((Object)this.optionsApprovedLevel)).append("\n");
        sb.append("    optionsTradingLevel: ").append(this.toIndentedString((Object)this.optionsTradingLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Account is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Account` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        AccountStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CASH) != null && !jsonObj.get(SERIALIZED_NAME_CASH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CASH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `portfolio_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTFOLIO_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `non_marginable_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCRUED_FEES) != null && !jsonObj.get(SERIALIZED_NAME_ACCRUED_FEES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCRUED_FEES).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accrued_fees` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCRUED_FEES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_IN) != null && !jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_IN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_IN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pending_transfer_in` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_IN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT) != null && !jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pending_transfer_out` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PENDING_TRANSFER_OUT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `long_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LONG_MARKET_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `short_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHORT_MARKET_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EQUITY) != null && !jsonObj.get(SERIALIZED_NAME_EQUITY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EQUITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EQUITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_EQUITY) != null && !jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_EQUITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MULTIPLIER) != null && !jsonObj.get(SERIALIZED_NAME_MULTIPLIER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MULTIPLIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `multiplier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MULTIPLIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN) != null && !jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `initial_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INITIAL_MARGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN) != null && !jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SMA) != null && !jsonObj.get(SERIALIZED_NAME_SMA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SMA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sma` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SMA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN) != null && !jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_maintenance_margin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `daytrading_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DAYTRADING_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `regt_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGT_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `options_buying_power` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS_BUYING_POWER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL).isJsonNull()) {
            OptionsApprovedLevelEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL).isJsonNull()) {
            OptionsTradingLevelEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL));
        }
    }

    public static Account fromJson(String jsonString) throws IOException {
        return (Account)JSON.getGson().fromJson(jsonString, Account.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_CASH);
        openapiFields.add(SERIALIZED_NAME_PORTFOLIO_VALUE);
        openapiFields.add(SERIALIZED_NAME_NON_MARGINABLE_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_ACCRUED_FEES);
        openapiFields.add(SERIALIZED_NAME_PENDING_TRANSFER_IN);
        openapiFields.add(SERIALIZED_NAME_PENDING_TRANSFER_OUT);
        openapiFields.add(SERIALIZED_NAME_PATTERN_DAY_TRADER);
        openapiFields.add(SERIALIZED_NAME_TRADE_SUSPENDED_BY_USER);
        openapiFields.add(SERIALIZED_NAME_TRADING_BLOCKED);
        openapiFields.add(SERIALIZED_NAME_TRANSFERS_BLOCKED);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_BLOCKED);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_SHORTING_ENABLED);
        openapiFields.add(SERIALIZED_NAME_LONG_MARKET_VALUE);
        openapiFields.add(SERIALIZED_NAME_SHORT_MARKET_VALUE);
        openapiFields.add(SERIALIZED_NAME_EQUITY);
        openapiFields.add(SERIALIZED_NAME_LAST_EQUITY);
        openapiFields.add(SERIALIZED_NAME_MULTIPLIER);
        openapiFields.add(SERIALIZED_NAME_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_INITIAL_MARGIN);
        openapiFields.add(SERIALIZED_NAME_MAINTENANCE_MARGIN);
        openapiFields.add(SERIALIZED_NAME_SMA);
        openapiFields.add(SERIALIZED_NAME_DAYTRADE_COUNT);
        openapiFields.add(SERIALIZED_NAME_LAST_MAINTENANCE_MARGIN);
        openapiFields.add(SERIALIZED_NAME_DAYTRADING_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_REGT_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_OPTIONS_BUYING_POWER);
        openapiFields.add(SERIALIZED_NAME_OPTIONS_APPROVED_LEVEL);
        openapiFields.add(SERIALIZED_NAME_OPTIONS_TRADING_LEVEL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OptionsApprovedLevelEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private OptionsApprovedLevelEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OptionsApprovedLevelEnum fromValue(Integer value) {
            for (OptionsApprovedLevelEnum b : OptionsApprovedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            Integer value = jsonElement.getAsInt();
            OptionsApprovedLevelEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<OptionsApprovedLevelEnum> {
            public void write(JsonWriter jsonWriter, OptionsApprovedLevelEnum enumeration) throws IOException {
                jsonWriter.value((Number)enumeration.getValue());
            }

            public OptionsApprovedLevelEnum read(JsonReader jsonReader) throws IOException {
                Integer value = jsonReader.nextInt();
                return OptionsApprovedLevelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OptionsTradingLevelEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private OptionsTradingLevelEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OptionsTradingLevelEnum fromValue(Integer value) {
            for (OptionsTradingLevelEnum b : OptionsTradingLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            Integer value = jsonElement.getAsInt();
            OptionsTradingLevelEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<OptionsTradingLevelEnum> {
            public void write(JsonWriter jsonWriter, OptionsTradingLevelEnum enumeration) throws IOException {
                jsonWriter.value((Number)enumeration.getValue());
            }

            public OptionsTradingLevelEnum read(JsonReader jsonReader) throws IOException {
                Integer value = jsonReader.nextInt();
                return OptionsTradingLevelEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Account.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Account.class));
            return new TypeAdapter<Account>(){

                public void write(JsonWriter out, Account value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Account read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Account.validateJsonElement(jsonElement);
                    return (Account)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

