/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum AssetClass {
    US_EQUITY("us_equity"),
    US_OPTION("us_option"),
    CRYPTO("crypto");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private AssetClass(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetClass fromValue(String value) {
        for (AssetClass b : AssetClass.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        AssetClass.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<AssetClass> {
        public void write(JsonWriter jsonWriter, AssetClass enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AssetClass read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AssetClass.fromValue(value);
        }
    }
}

