/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.openapi.trader.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.trader.model.Exchange;

public class Assets {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_PROPERTY_CLASS = "class";
    @SerializedName(value="class")
    private AssetClass propertyClass;
    public static final String SERIALIZED_NAME_EXCHANGE = "exchange";
    @SerializedName(value="exchange")
    private Exchange exchange;
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TRADABLE = "tradable";
    @SerializedName(value="tradable")
    private Boolean tradable;
    public static final String SERIALIZED_NAME_MARGINABLE = "marginable";
    @SerializedName(value="marginable")
    private Boolean marginable;
    public static final String SERIALIZED_NAME_SHORTABLE = "shortable";
    @SerializedName(value="shortable")
    private Boolean shortable;
    public static final String SERIALIZED_NAME_EASY_TO_BORROW = "easy_to_borrow";
    @SerializedName(value="easy_to_borrow")
    private Boolean easyToBorrow;
    public static final String SERIALIZED_NAME_FRACTIONABLE = "fractionable";
    @SerializedName(value="fractionable")
    private Boolean fractionable;
    public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT = "maintenance_margin_requirement";
    @SerializedName(value="maintenance_margin_requirement")
    private String maintenanceMarginRequirement;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private List<AttributesEnum> attributes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public Assets id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Assets propertyClass(AssetClass propertyClass) {
        this.propertyClass = propertyClass;
        return this;
    }

    @Nonnull
    public AssetClass getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(AssetClass propertyClass) {
        this.propertyClass = propertyClass;
    }

    public Assets exchange(Exchange exchange) {
        this.exchange = exchange;
        return this;
    }

    @Nonnull
    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public Assets symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Assets name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Assets status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Assets tradable(Boolean tradable) {
        this.tradable = tradable;
        return this;
    }

    @Nonnull
    public Boolean getTradable() {
        return this.tradable;
    }

    public void setTradable(Boolean tradable) {
        this.tradable = tradable;
    }

    public Assets marginable(Boolean marginable) {
        this.marginable = marginable;
        return this;
    }

    @Nonnull
    public Boolean getMarginable() {
        return this.marginable;
    }

    public void setMarginable(Boolean marginable) {
        this.marginable = marginable;
    }

    public Assets shortable(Boolean shortable) {
        this.shortable = shortable;
        return this;
    }

    @Nonnull
    public Boolean getShortable() {
        return this.shortable;
    }

    public void setShortable(Boolean shortable) {
        this.shortable = shortable;
    }

    public Assets easyToBorrow(Boolean easyToBorrow) {
        this.easyToBorrow = easyToBorrow;
        return this;
    }

    @Nonnull
    public Boolean getEasyToBorrow() {
        return this.easyToBorrow;
    }

    public void setEasyToBorrow(Boolean easyToBorrow) {
        this.easyToBorrow = easyToBorrow;
    }

    public Assets fractionable(Boolean fractionable) {
        this.fractionable = fractionable;
        return this;
    }

    @Nonnull
    public Boolean getFractionable() {
        return this.fractionable;
    }

    public void setFractionable(Boolean fractionable) {
        this.fractionable = fractionable;
    }

    public Assets maintenanceMarginRequirement(String maintenanceMarginRequirement) {
        this.maintenanceMarginRequirement = maintenanceMarginRequirement;
        return this;
    }

    @Nullable
    public String getMaintenanceMarginRequirement() {
        return this.maintenanceMarginRequirement;
    }

    public void setMaintenanceMarginRequirement(String maintenanceMarginRequirement) {
        this.maintenanceMarginRequirement = maintenanceMarginRequirement;
    }

    public Assets attributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Assets addAttributesItem(AttributesEnum attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributesEnum>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    public List<AttributesEnum> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributesEnum> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assets assets = (Assets)o;
        return Objects.equals(this.id, assets.id) && Objects.equals((Object)this.propertyClass, (Object)assets.propertyClass) && Objects.equals((Object)this.exchange, (Object)assets.exchange) && Objects.equals(this.symbol, assets.symbol) && Objects.equals(this.name, assets.name) && Objects.equals((Object)this.status, (Object)assets.status) && Objects.equals(this.tradable, assets.tradable) && Objects.equals(this.marginable, assets.marginable) && Objects.equals(this.shortable, assets.shortable) && Objects.equals(this.easyToBorrow, assets.easyToBorrow) && Objects.equals(this.fractionable, assets.fractionable) && Objects.equals(this.maintenanceMarginRequirement, assets.maintenanceMarginRequirement) && Objects.equals(this.attributes, assets.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.propertyClass, this.exchange, this.symbol, this.name, this.status, this.tradable, this.marginable, this.shortable, this.easyToBorrow, this.fractionable, this.maintenanceMarginRequirement, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Assets {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    propertyClass: ").append(this.toIndentedString((Object)this.propertyClass)).append("\n");
        sb.append("    exchange: ").append(this.toIndentedString((Object)this.exchange)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tradable: ").append(this.toIndentedString(this.tradable)).append("\n");
        sb.append("    marginable: ").append(this.toIndentedString(this.marginable)).append("\n");
        sb.append("    shortable: ").append(this.toIndentedString(this.shortable)).append("\n");
        sb.append("    easyToBorrow: ").append(this.toIndentedString(this.easyToBorrow)).append("\n");
        sb.append("    fractionable: ").append(this.toIndentedString(this.fractionable)).append("\n");
        sb.append("    maintenanceMarginRequirement: ").append(this.toIndentedString(this.maintenanceMarginRequirement)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Assets is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Assets` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        AssetClass.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PROPERTY_CLASS));
        Exchange.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXCHANGE));
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT) != null && !jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintenance_margin_requirement` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).toString()));
        }
    }

    public static Assets fromJson(String jsonString) throws IOException {
        return (Assets)JSON.getGson().fromJson(jsonString, Assets.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PROPERTY_CLASS);
        openapiFields.add(SERIALIZED_NAME_EXCHANGE);
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRADABLE);
        openapiFields.add(SERIALIZED_NAME_MARGINABLE);
        openapiFields.add(SERIALIZED_NAME_SHORTABLE);
        openapiFields.add(SERIALIZED_NAME_EASY_TO_BORROW);
        openapiFields.add(SERIALIZED_NAME_FRACTIONABLE);
        openapiFields.add(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PROPERTY_CLASS);
        openapiRequiredFields.add(SERIALIZED_NAME_EXCHANGE);
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_TRADABLE);
        openapiRequiredFields.add(SERIALIZED_NAME_MARGINABLE);
        openapiRequiredFields.add(SERIALIZED_NAME_SHORTABLE);
        openapiRequiredFields.add(SERIALIZED_NAME_EASY_TO_BORROW);
        openapiRequiredFields.add(SERIALIZED_NAME_FRACTIONABLE);
        validate = false;
        isValid = jsonElement -> true;
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Assets.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Assets.class));
            return new TypeAdapter<Assets>(){

                public void write(JsonWriter out, Assets value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Assets read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Assets.validateJsonElement(jsonElement);
                    return (Assets)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AttributesEnum {
        PTP_NO_EXCEPTION("ptp_no_exception"),
        PTP_WITH_EXCEPTION("ptp_with_exception"),
        IPO("ipo"),
        OPTIONS_ENABLED("options_enabled");

        private String value;
        public static boolean validate;
        public static Predicate<JsonElement> isValid;

        private AttributesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AttributesEnum fromValue(String value) {
            for (AttributesEnum b : AttributesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            if (!isValid.test(jsonElement)) {
                throw new RuntimeException();
            }
            if (!validate) {
                return;
            }
            String value = jsonElement.getAsString();
            AttributesEnum.fromValue(value);
        }

        static {
            validate = false;
            isValid = jsonElement -> true;
        }

        public static class Adapter
        extends TypeAdapter<AttributesEnum> {
            public void write(JsonWriter jsonWriter, AttributesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AttributesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AttributesEnum.fromValue(value);
            }
        }
    }
}

