/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.openapi.trader.model.CryptoTransferStatus;
import net.jacobpeterson.alpaca.openapi.trader.model.TransferDirection;

public class CryptoTransfer {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_TX_HASH = "tx_hash";
    @SerializedName(value="tx_hash")
    private String txHash;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private TransferDirection direction;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private CryptoTransferStatus status;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_USD_VALUE = "usd_value";
    @SerializedName(value="usd_value")
    private String usdValue;
    public static final String SERIALIZED_NAME_NETWORK_FEE = "network_fee";
    @SerializedName(value="network_fee")
    private String networkFee;
    public static final String SERIALIZED_NAME_FEES = "fees";
    @SerializedName(value="fees")
    private String fees;
    public static final String SERIALIZED_NAME_CHAIN = "chain";
    @SerializedName(value="chain")
    private String chain;
    public static final String SERIALIZED_NAME_ASSET = "asset";
    @SerializedName(value="asset")
    private String asset;
    public static final String SERIALIZED_NAME_FROM_ADDRESS = "from_address";
    @SerializedName(value="from_address")
    private String fromAddress;
    public static final String SERIALIZED_NAME_TO_ADDRESS = "to_address";
    @SerializedName(value="to_address")
    private String toAddress;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public CryptoTransfer id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public CryptoTransfer txHash(String txHash) {
        this.txHash = txHash;
        return this;
    }

    @Nullable
    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public CryptoTransfer direction(TransferDirection direction) {
        this.direction = direction;
        return this;
    }

    @Nullable
    public TransferDirection getDirection() {
        return this.direction;
    }

    public void setDirection(TransferDirection direction) {
        this.direction = direction;
    }

    public CryptoTransfer status(CryptoTransferStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public CryptoTransferStatus getStatus() {
        return this.status;
    }

    public void setStatus(CryptoTransferStatus status) {
        this.status = status;
    }

    public CryptoTransfer amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public CryptoTransfer usdValue(String usdValue) {
        this.usdValue = usdValue;
        return this;
    }

    @Nullable
    public String getUsdValue() {
        return this.usdValue;
    }

    public void setUsdValue(String usdValue) {
        this.usdValue = usdValue;
    }

    public CryptoTransfer networkFee(String networkFee) {
        this.networkFee = networkFee;
        return this;
    }

    @Nullable
    public String getNetworkFee() {
        return this.networkFee;
    }

    public void setNetworkFee(String networkFee) {
        this.networkFee = networkFee;
    }

    public CryptoTransfer fees(String fees) {
        this.fees = fees;
        return this;
    }

    @Nullable
    public String getFees() {
        return this.fees;
    }

    public void setFees(String fees) {
        this.fees = fees;
    }

    public CryptoTransfer chain(String chain) {
        this.chain = chain;
        return this;
    }

    @Nullable
    public String getChain() {
        return this.chain;
    }

    public void setChain(String chain) {
        this.chain = chain;
    }

    public CryptoTransfer asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    public String getAsset() {
        return this.asset;
    }

    public void setAsset(String asset) {
        this.asset = asset;
    }

    public CryptoTransfer fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @Nullable
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public CryptoTransfer toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @Nullable
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public CryptoTransfer createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CryptoTransfer cryptoTransfer = (CryptoTransfer)o;
        return Objects.equals(this.id, cryptoTransfer.id) && Objects.equals(this.txHash, cryptoTransfer.txHash) && Objects.equals((Object)this.direction, (Object)cryptoTransfer.direction) && Objects.equals((Object)this.status, (Object)cryptoTransfer.status) && Objects.equals(this.amount, cryptoTransfer.amount) && Objects.equals(this.usdValue, cryptoTransfer.usdValue) && Objects.equals(this.networkFee, cryptoTransfer.networkFee) && Objects.equals(this.fees, cryptoTransfer.fees) && Objects.equals(this.chain, cryptoTransfer.chain) && Objects.equals(this.asset, cryptoTransfer.asset) && Objects.equals(this.fromAddress, cryptoTransfer.fromAddress) && Objects.equals(this.toAddress, cryptoTransfer.toAddress) && Objects.equals(this.createdAt, cryptoTransfer.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.txHash, this.direction, this.status, this.amount, this.usdValue, this.networkFee, this.fees, this.chain, this.asset, this.fromAddress, this.toAddress, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CryptoTransfer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    txHash: ").append(this.toIndentedString(this.txHash)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    usdValue: ").append(this.toIndentedString(this.usdValue)).append("\n");
        sb.append("    networkFee: ").append(this.toIndentedString(this.networkFee)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    chain: ").append(this.toIndentedString(this.chain)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CryptoTransfer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CryptoTransfer` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TX_HASH) != null && !jsonObj.get(SERIALIZED_NAME_TX_HASH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TX_HASH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tx_hash` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TX_HASH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIRECTION) != null && !jsonObj.get(SERIALIZED_NAME_DIRECTION).isJsonNull()) {
            TransferDirection.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DIRECTION));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            CryptoTransferStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USD_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_USD_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USD_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `usd_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USD_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_FEE) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_FEE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORK_FEE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network_fee` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_FEE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEES) != null && !jsonObj.get(SERIALIZED_NAME_FEES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FEES).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fees` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FEES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHAIN) != null && !jsonObj.get(SERIALIZED_NAME_CHAIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CHAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `chain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET) != null && !jsonObj.get(SERIALIZED_NAME_ASSET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ASSET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `asset` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `from_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_TO_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TO_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO_ADDRESS).toString()));
        }
    }

    public static CryptoTransfer fromJson(String jsonString) throws IOException {
        return (CryptoTransfer)JSON.getGson().fromJson(jsonString, CryptoTransfer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_TX_HASH);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_USD_VALUE);
        openapiFields.add(SERIALIZED_NAME_NETWORK_FEE);
        openapiFields.add(SERIALIZED_NAME_FEES);
        openapiFields.add(SERIALIZED_NAME_CHAIN);
        openapiFields.add(SERIALIZED_NAME_ASSET);
        openapiFields.add(SERIALIZED_NAME_FROM_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_TO_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CryptoTransfer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CryptoTransfer.class));
            return new TypeAdapter<CryptoTransfer>(){

                public void write(JsonWriter out, CryptoTransfer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CryptoTransfer read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CryptoTransfer.validateJsonElement(jsonElement);
                    return (CryptoTransfer)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

