/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.openapi.trader.model.AbstractOpenApiSchema;
import net.jacobpeterson.alpaca.openapi.trader.model.NonTradeActivities;
import net.jacobpeterson.alpaca.openapi.trader.model.TradingActivities;

public class GetAccountActivitiesByActivityType200ResponseInner
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(GetAccountActivitiesByActivityType200ResponseInner.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public GetAccountActivitiesByActivityType200ResponseInner() {
        super("oneOf", Boolean.FALSE);
    }

    public GetAccountActivitiesByActivityType200ResponseInner(NonTradeActivities o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public GetAccountActivitiesByActivityType200ResponseInner(TradingActivities o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof TradingActivities) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof NonTradeActivities) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be NonTradeActivities, TradingActivities");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public TradingActivities getTradingActivities() throws ClassCastException {
        return (TradingActivities)super.getActualInstance();
    }

    public NonTradeActivities getNonTradeActivities() throws ClassCastException {
        return (NonTradeActivities)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            TradingActivities.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for TradingActivities failed with `%s`.", e.getMessage()));
        }
        try {
            NonTradeActivities.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for NonTradeActivities failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for GetAccountActivitiesByActivityType200ResponseInner with oneOf schemas: NonTradeActivities, TradingActivities. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    public static GetAccountActivitiesByActivityType200ResponseInner fromJson(String jsonString) throws IOException {
        return (GetAccountActivitiesByActivityType200ResponseInner)JSON.getGson().fromJson(jsonString, GetAccountActivitiesByActivityType200ResponseInner.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("TradingActivities", TradingActivities.class);
        schemas.put("NonTradeActivities", NonTradeActivities.class);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetAccountActivitiesByActivityType200ResponseInner.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterTradingActivities = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TradingActivities.class));
            final TypeAdapter adapterNonTradeActivities = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NonTradeActivities.class));
            return new TypeAdapter<GetAccountActivitiesByActivityType200ResponseInner>(){

                public void write(JsonWriter out, GetAccountActivitiesByActivityType200ResponseInner value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof TradingActivities) {
                        JsonElement element = adapterTradingActivities.toJsonTree((Object)((TradingActivities)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof NonTradeActivities) {
                        JsonElement element = adapterNonTradeActivities.toJsonTree((Object)((NonTradeActivities)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: NonTradeActivities, TradingActivities");
                }

                public GetAccountActivitiesByActivityType200ResponseInner read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        TradingActivities.validateJsonElement(jsonElement);
                        actualAdapter = adapterTradingActivities;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'TradingActivities'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for TradingActivities failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'TradingActivities'", e);
                    }
                    try {
                        NonTradeActivities.validateJsonElement(jsonElement);
                        actualAdapter = adapterNonTradeActivities;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'NonTradeActivities'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for NonTradeActivities failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'NonTradeActivities'", e);
                    }
                    if (match == 1) {
                        GetAccountActivitiesByActivityType200ResponseInner ret = new GetAccountActivitiesByActivityType200ResponseInner();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for GetAccountActivitiesByActivityType200ResponseInner: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }
}

