/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.openapi.trader.model.ActivityType;

public class NonTradeActivities {
    public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activity_type";
    @SerializedName(value="activity_type")
    private ActivityType activityType;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private OffsetDateTime date;
    public static final String SERIALIZED_NAME_NET_AMOUNT = "net_amount";
    @SerializedName(value="net_amount")
    private String netAmount;
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_QTY = "qty";
    @SerializedName(value="qty")
    private String qty;
    public static final String SERIALIZED_NAME_PER_SHARE_AMOUNT = "per_share_amount";
    @SerializedName(value="per_share_amount")
    private String perShareAmount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public NonTradeActivities activityType(ActivityType activityType) {
        this.activityType = activityType;
        return this;
    }

    @Nullable
    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public NonTradeActivities id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NonTradeActivities date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public NonTradeActivities netAmount(String netAmount) {
        this.netAmount = netAmount;
        return this;
    }

    @Nullable
    public String getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(String netAmount) {
        this.netAmount = netAmount;
    }

    public NonTradeActivities symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public NonTradeActivities qty(String qty) {
        this.qty = qty;
        return this;
    }

    @Nullable
    public String getQty() {
        return this.qty;
    }

    public void setQty(String qty) {
        this.qty = qty;
    }

    public NonTradeActivities perShareAmount(String perShareAmount) {
        this.perShareAmount = perShareAmount;
        return this;
    }

    @Nullable
    public String getPerShareAmount() {
        return this.perShareAmount;
    }

    public void setPerShareAmount(String perShareAmount) {
        this.perShareAmount = perShareAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonTradeActivities nonTradeActivities = (NonTradeActivities)o;
        return Objects.equals((Object)this.activityType, (Object)nonTradeActivities.activityType) && Objects.equals(this.id, nonTradeActivities.id) && Objects.equals(this.date, nonTradeActivities.date) && Objects.equals(this.netAmount, nonTradeActivities.netAmount) && Objects.equals(this.symbol, nonTradeActivities.symbol) && Objects.equals(this.qty, nonTradeActivities.qty) && Objects.equals(this.perShareAmount, nonTradeActivities.perShareAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityType, this.id, this.date, this.netAmount, this.symbol, this.qty, this.perShareAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NonTradeActivities {\n");
        sb.append("    activityType: ").append(this.toIndentedString((Object)this.activityType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    netAmount: ").append(this.toIndentedString(this.netAmount)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    qty: ").append(this.toIndentedString(this.qty)).append("\n");
        sb.append("    perShareAmount: ").append(this.toIndentedString(this.perShareAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in NonTradeActivities is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NonTradeActivities` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACTIVITY_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ACTIVITY_TYPE).isJsonNull()) {
            ActivityType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACTIVITY_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NET_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_NET_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NET_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `net_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NET_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QTY) != null && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QTY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `per_share_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PER_SHARE_AMOUNT).toString()));
        }
    }

    public static NonTradeActivities fromJson(String jsonString) throws IOException {
        return (NonTradeActivities)JSON.getGson().fromJson(jsonString, NonTradeActivities.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVITY_TYPE);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_DATE);
        openapiFields.add(SERIALIZED_NAME_NET_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_QTY);
        openapiFields.add(SERIALIZED_NAME_PER_SHARE_AMOUNT);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NonTradeActivities.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NonTradeActivities.class));
            return new TypeAdapter<NonTradeActivities>(){

                public void write(JsonWriter out, NonTradeActivities value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NonTradeActivities read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    NonTradeActivities.validateJsonElement(jsonElement);
                    return (NonTradeActivities)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

