/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum OrderClass {
    SIMPLE("simple"),
    BRACKET("bracket"),
    OCO("oco"),
    OTO("oto"),
    EMPTY("");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private OrderClass(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderClass fromValue(String value) {
        for (OrderClass b : OrderClass.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        OrderClass.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<OrderClass> {
        public void write(JsonWriter jsonWriter, OrderClass enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public OrderClass read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OrderClass.fromValue(value);
        }
    }
}

