/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Predicate;

@JsonAdapter(value=Adapter.class)
public enum OrderType {
    MARKET("market"),
    LIMIT("limit"),
    STOP("stop"),
    STOP_LIMIT("stop_limit"),
    TRAILING_STOP("trailing_stop");

    private String value;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    private OrderType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderType fromValue(String value) {
        for (OrderType b : OrderType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        String value = jsonElement.getAsString();
        OrderType.fromValue(value);
    }

    static {
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class Adapter
    extends TypeAdapter<OrderType> {
        public void write(JsonWriter jsonWriter, OrderType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public OrderType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OrderType.fromValue(value);
        }
    }
}

