/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.openapi.trader.model.TimeInForce;

public class PatchOrderRequest {
    public static final String SERIALIZED_NAME_QTY = "qty";
    @SerializedName(value="qty")
    private String qty;
    public static final String SERIALIZED_NAME_TIME_IN_FORCE = "time_in_force";
    @SerializedName(value="time_in_force")
    private TimeInForce timeInForce;
    public static final String SERIALIZED_NAME_LIMIT_PRICE = "limit_price";
    @SerializedName(value="limit_price")
    private String limitPrice;
    public static final String SERIALIZED_NAME_STOP_PRICE = "stop_price";
    @SerializedName(value="stop_price")
    private String stopPrice;
    public static final String SERIALIZED_NAME_TRAIL = "trail";
    @SerializedName(value="trail")
    private String trail;
    public static final String SERIALIZED_NAME_CLIENT_ORDER_ID = "client_order_id";
    @SerializedName(value="client_order_id")
    private String clientOrderId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public PatchOrderRequest qty(String qty) {
        this.qty = qty;
        return this;
    }

    @Nullable
    public String getQty() {
        return this.qty;
    }

    public void setQty(String qty) {
        this.qty = qty;
    }

    public PatchOrderRequest timeInForce(TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
        return this;
    }

    @Nullable
    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public void setTimeInForce(TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
    }

    public PatchOrderRequest limitPrice(String limitPrice) {
        this.limitPrice = limitPrice;
        return this;
    }

    @Nullable
    public String getLimitPrice() {
        return this.limitPrice;
    }

    public void setLimitPrice(String limitPrice) {
        this.limitPrice = limitPrice;
    }

    public PatchOrderRequest stopPrice(String stopPrice) {
        this.stopPrice = stopPrice;
        return this;
    }

    @Nullable
    public String getStopPrice() {
        return this.stopPrice;
    }

    public void setStopPrice(String stopPrice) {
        this.stopPrice = stopPrice;
    }

    public PatchOrderRequest trail(String trail) {
        this.trail = trail;
        return this;
    }

    @Nullable
    public String getTrail() {
        return this.trail;
    }

    public void setTrail(String trail) {
        this.trail = trail;
    }

    public PatchOrderRequest clientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
        return this;
    }

    @Nullable
    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchOrderRequest patchOrderRequest = (PatchOrderRequest)o;
        return Objects.equals(this.qty, patchOrderRequest.qty) && Objects.equals((Object)this.timeInForce, (Object)patchOrderRequest.timeInForce) && Objects.equals(this.limitPrice, patchOrderRequest.limitPrice) && Objects.equals(this.stopPrice, patchOrderRequest.stopPrice) && Objects.equals(this.trail, patchOrderRequest.trail) && Objects.equals(this.clientOrderId, patchOrderRequest.clientOrderId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.qty, this.timeInForce, this.limitPrice, this.stopPrice, this.trail, this.clientOrderId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchOrderRequest {\n");
        sb.append("    qty: ").append(this.toIndentedString(this.qty)).append("\n");
        sb.append("    timeInForce: ").append(this.toIndentedString((Object)this.timeInForce)).append("\n");
        sb.append("    limitPrice: ").append(this.toIndentedString(this.limitPrice)).append("\n");
        sb.append("    stopPrice: ").append(this.toIndentedString(this.stopPrice)).append("\n");
        sb.append("    trail: ").append(this.toIndentedString(this.trail)).append("\n");
        sb.append("    clientOrderId: ").append(this.toIndentedString(this.clientOrderId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PatchOrderRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PatchOrderRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_QTY) != null && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QTY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_IN_FORCE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_IN_FORCE).isJsonNull()) {
            TimeInForce.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TIME_IN_FORCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `limit_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STOP_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_STOP_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STOP_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stop_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STOP_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRAIL) != null && !jsonObj.get(SERIALIZED_NAME_TRAIL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TRAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `trail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID).toString()));
        }
    }

    public static PatchOrderRequest fromJson(String jsonString) throws IOException {
        return (PatchOrderRequest)JSON.getGson().fromJson(jsonString, PatchOrderRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QTY);
        openapiFields.add(SERIALIZED_NAME_TIME_IN_FORCE);
        openapiFields.add(SERIALIZED_NAME_LIMIT_PRICE);
        openapiFields.add(SERIALIZED_NAME_STOP_PRICE);
        openapiFields.add(SERIALIZED_NAME_TRAIL);
        openapiFields.add(SERIALIZED_NAME_CLIENT_ORDER_ID);
        openapiRequiredFields = new HashSet();
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PatchOrderRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PatchOrderRequest.class));
            return new TypeAdapter<PatchOrderRequest>(){

                public void write(JsonWriter out, PatchOrderRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PatchOrderRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PatchOrderRequest.validateJsonElement(jsonElement);
                    return (PatchOrderRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

