/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.openapi.trader.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.openapi.trader.model.OrderClass;
import net.jacobpeterson.alpaca.openapi.trader.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.trader.model.OrderType;
import net.jacobpeterson.alpaca.openapi.trader.model.TimeInForce;

public class PostOrderRequest {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    private String symbol;
    public static final String SERIALIZED_NAME_QTY = "qty";
    @SerializedName(value="qty")
    private String qty;
    public static final String SERIALIZED_NAME_NOTIONAL = "notional";
    @SerializedName(value="notional")
    private String notional;
    public static final String SERIALIZED_NAME_SIDE = "side";
    @SerializedName(value="side")
    private OrderSide side;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private OrderType type;
    public static final String SERIALIZED_NAME_TIME_IN_FORCE = "time_in_force";
    @SerializedName(value="time_in_force")
    private TimeInForce timeInForce;
    public static final String SERIALIZED_NAME_LIMIT_PRICE = "limit_price";
    @SerializedName(value="limit_price")
    private String limitPrice;
    public static final String SERIALIZED_NAME_STOP_PRICE = "stop_price";
    @SerializedName(value="stop_price")
    private String stopPrice;
    public static final String SERIALIZED_NAME_TRAIL_PRICE = "trail_price";
    @SerializedName(value="trail_price")
    private String trailPrice;
    public static final String SERIALIZED_NAME_TRAIL_PERCENT = "trail_percent";
    @SerializedName(value="trail_percent")
    private String trailPercent;
    public static final String SERIALIZED_NAME_EXTENDED_HOURS = "extended_hours";
    @SerializedName(value="extended_hours")
    private Boolean extendedHours;
    public static final String SERIALIZED_NAME_CLIENT_ORDER_ID = "client_order_id";
    @SerializedName(value="client_order_id")
    private String clientOrderId;
    public static final String SERIALIZED_NAME_ORDER_CLASS = "order_class";
    @SerializedName(value="order_class")
    private OrderClass orderClass;
    public static final String SERIALIZED_NAME_TAKE_PROFIT = "take_profit";
    @SerializedName(value="take_profit")
    private Object takeProfit;
    public static final String SERIALIZED_NAME_STOP_LOSS = "stop_loss";
    @SerializedName(value="stop_loss")
    private Object stopLoss;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    public static boolean validate;
    public static Predicate<JsonElement> isValid;

    public PostOrderRequest symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public PostOrderRequest qty(String qty) {
        this.qty = qty;
        return this;
    }

    @Nullable
    public String getQty() {
        return this.qty;
    }

    public void setQty(String qty) {
        this.qty = qty;
    }

    public PostOrderRequest notional(String notional) {
        this.notional = notional;
        return this;
    }

    @Nullable
    public String getNotional() {
        return this.notional;
    }

    public void setNotional(String notional) {
        this.notional = notional;
    }

    public PostOrderRequest side(OrderSide side) {
        this.side = side;
        return this;
    }

    @Nonnull
    public OrderSide getSide() {
        return this.side;
    }

    public void setSide(OrderSide side) {
        this.side = side;
    }

    public PostOrderRequest type(OrderType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public OrderType getType() {
        return this.type;
    }

    public void setType(OrderType type) {
        this.type = type;
    }

    public PostOrderRequest timeInForce(TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
        return this;
    }

    @Nonnull
    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public void setTimeInForce(TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
    }

    public PostOrderRequest limitPrice(String limitPrice) {
        this.limitPrice = limitPrice;
        return this;
    }

    @Nullable
    public String getLimitPrice() {
        return this.limitPrice;
    }

    public void setLimitPrice(String limitPrice) {
        this.limitPrice = limitPrice;
    }

    public PostOrderRequest stopPrice(String stopPrice) {
        this.stopPrice = stopPrice;
        return this;
    }

    @Nullable
    public String getStopPrice() {
        return this.stopPrice;
    }

    public void setStopPrice(String stopPrice) {
        this.stopPrice = stopPrice;
    }

    public PostOrderRequest trailPrice(String trailPrice) {
        this.trailPrice = trailPrice;
        return this;
    }

    @Nullable
    public String getTrailPrice() {
        return this.trailPrice;
    }

    public void setTrailPrice(String trailPrice) {
        this.trailPrice = trailPrice;
    }

    public PostOrderRequest trailPercent(String trailPercent) {
        this.trailPercent = trailPercent;
        return this;
    }

    @Nullable
    public String getTrailPercent() {
        return this.trailPercent;
    }

    public void setTrailPercent(String trailPercent) {
        this.trailPercent = trailPercent;
    }

    public PostOrderRequest extendedHours(Boolean extendedHours) {
        this.extendedHours = extendedHours;
        return this;
    }

    @Nullable
    public Boolean getExtendedHours() {
        return this.extendedHours;
    }

    public void setExtendedHours(Boolean extendedHours) {
        this.extendedHours = extendedHours;
    }

    public PostOrderRequest clientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
        return this;
    }

    @Nullable
    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
    }

    public PostOrderRequest orderClass(OrderClass orderClass) {
        this.orderClass = orderClass;
        return this;
    }

    @Nullable
    public OrderClass getOrderClass() {
        return this.orderClass;
    }

    public void setOrderClass(OrderClass orderClass) {
        this.orderClass = orderClass;
    }

    public PostOrderRequest takeProfit(Object takeProfit) {
        this.takeProfit = takeProfit;
        return this;
    }

    @Nullable
    public Object getTakeProfit() {
        return this.takeProfit;
    }

    public void setTakeProfit(Object takeProfit) {
        this.takeProfit = takeProfit;
    }

    public PostOrderRequest stopLoss(Object stopLoss) {
        this.stopLoss = stopLoss;
        return this;
    }

    @Nullable
    public Object getStopLoss() {
        return this.stopLoss;
    }

    public void setStopLoss(Object stopLoss) {
        this.stopLoss = stopLoss;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostOrderRequest postOrderRequest = (PostOrderRequest)o;
        return Objects.equals(this.symbol, postOrderRequest.symbol) && Objects.equals(this.qty, postOrderRequest.qty) && Objects.equals(this.notional, postOrderRequest.notional) && Objects.equals((Object)this.side, (Object)postOrderRequest.side) && Objects.equals((Object)this.type, (Object)postOrderRequest.type) && Objects.equals((Object)this.timeInForce, (Object)postOrderRequest.timeInForce) && Objects.equals(this.limitPrice, postOrderRequest.limitPrice) && Objects.equals(this.stopPrice, postOrderRequest.stopPrice) && Objects.equals(this.trailPrice, postOrderRequest.trailPrice) && Objects.equals(this.trailPercent, postOrderRequest.trailPercent) && Objects.equals(this.extendedHours, postOrderRequest.extendedHours) && Objects.equals(this.clientOrderId, postOrderRequest.clientOrderId) && Objects.equals((Object)this.orderClass, (Object)postOrderRequest.orderClass) && Objects.equals(this.takeProfit, postOrderRequest.takeProfit) && Objects.equals(this.stopLoss, postOrderRequest.stopLoss);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.qty, this.notional, this.side, this.type, this.timeInForce, this.limitPrice, this.stopPrice, this.trailPrice, this.trailPercent, this.extendedHours, this.clientOrderId, this.orderClass, this.takeProfit, this.stopLoss});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostOrderRequest {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    qty: ").append(this.toIndentedString(this.qty)).append("\n");
        sb.append("    notional: ").append(this.toIndentedString(this.notional)).append("\n");
        sb.append("    side: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    timeInForce: ").append(this.toIndentedString((Object)this.timeInForce)).append("\n");
        sb.append("    limitPrice: ").append(this.toIndentedString(this.limitPrice)).append("\n");
        sb.append("    stopPrice: ").append(this.toIndentedString(this.stopPrice)).append("\n");
        sb.append("    trailPrice: ").append(this.toIndentedString(this.trailPrice)).append("\n");
        sb.append("    trailPercent: ").append(this.toIndentedString(this.trailPercent)).append("\n");
        sb.append("    extendedHours: ").append(this.toIndentedString(this.extendedHours)).append("\n");
        sb.append("    clientOrderId: ").append(this.toIndentedString(this.clientOrderId)).append("\n");
        sb.append("    orderClass: ").append(this.toIndentedString((Object)this.orderClass)).append("\n");
        sb.append("    takeProfit: ").append(this.toIndentedString(this.takeProfit)).append("\n");
        sb.append("    stopLoss: ").append(this.toIndentedString(this.stopLoss)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (!isValid.test(jsonElement)) {
            throw new RuntimeException();
        }
        if (!validate) {
            return;
        }
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PostOrderRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PostOrderRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QTY) != null && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QTY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QTY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIONAL) != null && !jsonObj.get(SERIALIZED_NAME_NOTIONAL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NOTIONAL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `notional` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIONAL).toString()));
        }
        OrderSide.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SIDE));
        OrderType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE));
        TimeInForce.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TIME_IN_FORCE));
        if (jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `limit_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LIMIT_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STOP_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_STOP_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STOP_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stop_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STOP_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRAIL_PRICE) != null && !jsonObj.get(SERIALIZED_NAME_TRAIL_PRICE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TRAIL_PRICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `trail_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRAIL_PRICE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRAIL_PERCENT) != null && !jsonObj.get(SERIALIZED_NAME_TRAIL_PERCENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TRAIL_PERCENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `trail_percent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRAIL_PERCENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_ORDER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_CLASS) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_CLASS).isJsonNull()) {
            OrderClass.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ORDER_CLASS));
        }
    }

    public static PostOrderRequest fromJson(String jsonString) throws IOException {
        return (PostOrderRequest)JSON.getGson().fromJson(jsonString, PostOrderRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_QTY);
        openapiFields.add(SERIALIZED_NAME_NOTIONAL);
        openapiFields.add(SERIALIZED_NAME_SIDE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TIME_IN_FORCE);
        openapiFields.add(SERIALIZED_NAME_LIMIT_PRICE);
        openapiFields.add(SERIALIZED_NAME_STOP_PRICE);
        openapiFields.add(SERIALIZED_NAME_TRAIL_PRICE);
        openapiFields.add(SERIALIZED_NAME_TRAIL_PERCENT);
        openapiFields.add(SERIALIZED_NAME_EXTENDED_HOURS);
        openapiFields.add(SERIALIZED_NAME_CLIENT_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_ORDER_CLASS);
        openapiFields.add(SERIALIZED_NAME_TAKE_PROFIT);
        openapiFields.add(SERIALIZED_NAME_STOP_LOSS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_SIDE);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_TIME_IN_FORCE);
        validate = false;
        isValid = jsonElement -> true;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PostOrderRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PostOrderRequest.class));
            return new TypeAdapter<PostOrderRequest>(){

                public void write(JsonWriter out, PostOrderRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PostOrderRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PostOrderRequest.validateJsonElement(jsonElement);
                    return (PostOrderRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

