/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.rest.broker;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.util.function.BiFunction;
import net.jacobpeterson.alpaca.model.util.apitype.BrokerAPIEndpointType;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.api.AccountsApi;
import net.jacobpeterson.alpaca.openapi.broker.api.AssetsApi;
import net.jacobpeterson.alpaca.openapi.broker.api.CalendarApi;
import net.jacobpeterson.alpaca.openapi.broker.api.ClockApi;
import net.jacobpeterson.alpaca.openapi.broker.api.CorporateActionsApi;
import net.jacobpeterson.alpaca.openapi.broker.api.CountryInfoApi;
import net.jacobpeterson.alpaca.openapi.broker.api.DocumentsApi;
import net.jacobpeterson.alpaca.openapi.broker.api.FundingApi;
import net.jacobpeterson.alpaca.openapi.broker.api.FundingWalletsApi;
import net.jacobpeterson.alpaca.openapi.broker.api.JournalsApi;
import net.jacobpeterson.alpaca.openapi.broker.api.KycApi;
import net.jacobpeterson.alpaca.openapi.broker.api.LogosApi;
import net.jacobpeterson.alpaca.openapi.broker.api.OAuthApi;
import net.jacobpeterson.alpaca.openapi.broker.api.RebalancingApi;
import net.jacobpeterson.alpaca.openapi.broker.api.ReportingApi;
import net.jacobpeterson.alpaca.openapi.broker.api.TradingApi;
import net.jacobpeterson.alpaca.openapi.broker.api.WatchlistApi;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionLegacyNote;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionLiquidation;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionTransactionCancel;
import net.jacobpeterson.alpaca.openapi.broker.model.JNLC;
import net.jacobpeterson.alpaca.openapi.broker.model.JNLS;
import net.jacobpeterson.alpaca.openapi.broker.model.NonTradeActivity;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeActivity;
import net.jacobpeterson.alpaca.rest.broker.events.EventsApiSSE;
import net.jacobpeterson.alpaca.util.apikey.APIKeyUtil;
import okhttp3.OkHttpClient;

public class AlpacaBrokerAPI {
    private final ApiClient apiClient;
    private AccountsApi accounts;
    private AssetsApi assets;
    private CalendarApi calendar;
    private ClockApi clock;
    private CorporateActionsApi corporateActions;
    private CountryInfoApi countryInfo;
    private DocumentsApi documents;
    private EventsApiSSE events;
    private FundingApi funding;
    private FundingWalletsApi fundingWallets;
    private JournalsApi journals;
    private KycApi kyc;
    private LogosApi logos;
    private OAuthApi oAuth;
    private RebalancingApi rebalancing;
    private ReportingApi reporting;
    private TradingApi trading;
    private WatchlistApi watchlist;

    public AlpacaBrokerAPI(String brokerAPIKey, String brokerAPISecret, BrokerAPIEndpointType brokerAPIEndpointType, OkHttpClient okHttpClient) {
        Preconditions.checkNotNull((Object)brokerAPIKey);
        Preconditions.checkNotNull((Object)brokerAPISecret);
        Preconditions.checkNotNull((Object)((Object)brokerAPIEndpointType));
        Preconditions.checkNotNull((Object)okHttpClient);
        this.apiClient = new ApiClient(okHttpClient);
        this.apiClient.setServerIndex(switch (brokerAPIEndpointType) {
            case BrokerAPIEndpointType.SANDBOX -> 0;
            case BrokerAPIEndpointType.PRODUCTION -> 1;
            default -> throw new UnsupportedOperationException();
        });
        this.apiClient.addDefaultHeader("Authorization", "Basic " + APIKeyUtil.createBrokerAPIAuthKey(brokerAPIKey, brokerAPISecret));
    }

    public ApiClient getInternalAPIClient() {
        return this.apiClient;
    }

    public synchronized AccountsApi accounts() {
        if (this.accounts == null) {
            this.accounts = new AccountsApi(this.apiClient);
        }
        return this.accounts;
    }

    public synchronized AssetsApi assets() {
        if (this.assets == null) {
            this.assets = new AssetsApi(this.apiClient);
        }
        return this.assets;
    }

    public synchronized CalendarApi calendar() {
        if (this.calendar == null) {
            this.calendar = new CalendarApi(this.apiClient);
        }
        return this.calendar;
    }

    public synchronized ClockApi clock() {
        if (this.clock == null) {
            this.clock = new ClockApi(this.apiClient);
        }
        return this.clock;
    }

    public synchronized CorporateActionsApi corporateActions() {
        if (this.corporateActions == null) {
            this.corporateActions = new CorporateActionsApi(this.apiClient);
        }
        return this.corporateActions;
    }

    public synchronized CountryInfoApi countryInfo() {
        if (this.countryInfo == null) {
            this.countryInfo = new CountryInfoApi(this.apiClient);
        }
        return this.countryInfo;
    }

    public synchronized DocumentsApi documents() {
        if (this.documents == null) {
            this.documents = new DocumentsApi(this.apiClient);
        }
        return this.documents;
    }

    public synchronized EventsApiSSE events() {
        if (this.events == null) {
            this.events = new EventsApiSSE(this.apiClient);
        }
        return this.events;
    }

    public synchronized FundingApi funding() {
        if (this.funding == null) {
            this.funding = new FundingApi(this.apiClient);
        }
        return this.funding;
    }

    public synchronized FundingWalletsApi fundingWallets() {
        if (this.fundingWallets == null) {
            this.fundingWallets = new FundingWalletsApi(this.apiClient);
        }
        return this.fundingWallets;
    }

    public synchronized JournalsApi journals() {
        if (this.journals == null) {
            this.journals = new JournalsApi(this.apiClient);
        }
        return this.journals;
    }

    public synchronized KycApi kyc() {
        if (this.kyc == null) {
            this.kyc = new KycApi(this.apiClient);
        }
        return this.kyc;
    }

    public synchronized LogosApi logos() {
        if (this.logos == null) {
            this.logos = new LogosApi(this.apiClient);
        }
        return this.logos;
    }

    public synchronized OAuthApi oAuth() {
        if (this.oAuth == null) {
            this.oAuth = new OAuthApi(this.apiClient);
        }
        return this.oAuth;
    }

    public synchronized RebalancingApi rebalancing() {
        if (this.rebalancing == null) {
            this.rebalancing = new RebalancingApi(this.apiClient);
        }
        return this.rebalancing;
    }

    public synchronized ReportingApi reporting() {
        if (this.reporting == null) {
            this.reporting = new ReportingApi(this.apiClient);
        }
        return this.reporting;
    }

    public synchronized TradingApi trading() {
        if (this.trading == null) {
            this.trading = new TradingApi(this.apiClient);
        }
        return this.trading;
    }

    public synchronized WatchlistApi watchlist() {
        if (this.watchlist == null) {
            this.watchlist = new WatchlistApi(this.apiClient);
        }
        return this.watchlist;
    }

    static {
        TradeActivity.isValid = jsonElement -> jsonElement.getAsJsonObject().has("type");
        NonTradeActivity.isValid = jsonElement -> !jsonElement.getAsJsonObject().has("type");
        BiFunction<Boolean, JsonElement, Boolean> transferPredicate = (jnlc, jsonElement) -> {
            String entryType = jsonElement.getAsJsonObject().get("entry_type").getAsString();
            return jnlc != false ? entryType.equals("JNLC") : entryType.equals("JNLS");
        };
        JNLS.isValid = jsonElement -> (Boolean)transferPredicate.apply(true, (JsonElement)jsonElement);
        JNLC.isValid = jsonElement -> (Boolean)transferPredicate.apply(false, (JsonElement)jsonElement);
        AdminActionLegacyNote.isValid = jsonElement -> jsonElement.getAsJsonObject().get("type").getAsString().contains("note_admin_event");
        AdminActionLiquidation.isValid = jsonElement -> jsonElement.getAsJsonObject().get("type").getAsString().equals("liquidation_admin_event");
        AdminActionTransactionCancel.isValid = jsonElement -> jsonElement.getAsJsonObject().get("type").getAsString().equals("transaction_cancel_admin_event");
    }
}

