/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.rest.broker.events;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.JSON;
import net.jacobpeterson.alpaca.openapi.broker.api.EventsApi;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatusEvent;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalStatusEvent;
import net.jacobpeterson.alpaca.openapi.broker.model.SubscribeToAdminActionSSE200ResponseInner;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEvent;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEventV2;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferStatusEvent;
import net.jacobpeterson.alpaca.util.sse.SSEListener;
import net.jacobpeterson.alpaca.util.sse.SSERequest;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsApiSSE {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsApiSSE.class);
    private final EventsApi eventsAPI;
    private final EventSource.Factory eventSourceFactory;

    public EventsApiSSE(ApiClient apiClient) {
        this.eventsAPI = new EventsApi(apiClient);
        this.eventSourceFactory = EventSources.createFactory((Call.Factory)apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).build());
    }

    public SSERequest subscribeToNonTradingActivitiesEvents(String id, String since, String until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, Boolean includePreprocessing, SSEListener<Object> sseListener) throws ApiException {
        Request request = this.eventsAPI.getV1EventsNtaCall(id, since, until, sinceId, untilId, sinceUlid, untilUlid, includePreprocessing, null).request();
        return new SSERequest(this.eventSourceFactory.newEventSource(request, this.createEventSourceListener(sseListener, new TypeToken<Object>(){}.getType())));
    }

    public SSERequest subscribeToAdminAction(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, SSEListener<AccountStatusEvent> sseListener) throws ApiException {
        Request request = this.eventsAPI.subscribeToAdminActionSSECall(since, until, sinceId, untilId, null).request();
        return new SSERequest(this.eventSourceFactory.newEventSource(request, this.createEventSourceListener(sseListener, new TypeToken<SubscribeToAdminActionSSE200ResponseInner>(){}.getType())));
    }

    public SSERequest subscribeToJournalStatus(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, SSEListener<AccountStatusEvent> sseListener) throws ApiException {
        Request request = this.eventsAPI.subscribeToJournalStatusSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, null).request();
        return new SSERequest(this.eventSourceFactory.newEventSource(request, this.createEventSourceListener(sseListener, new TypeToken<JournalStatusEvent>(){}.getType())));
    }

    public SSERequest subscribeToTrade(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, SSEListener<AccountStatusEvent> sseListener) throws ApiException {
        Request request = this.eventsAPI.subscribeToTradeSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, null).request();
        return new SSERequest(this.eventSourceFactory.newEventSource(request, this.createEventSourceListener(sseListener, new TypeToken<TradeUpdateEvent>(){}.getType())));
    }

    public SSERequest subscribeToTradeV2(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, SSEListener<AccountStatusEvent> sseListener) throws ApiException {
        Request request = this.eventsAPI.subscribeToTradeV2SSECall(since, until, sinceId, untilId, null).request();
        return new SSERequest(this.eventSourceFactory.newEventSource(request, this.createEventSourceListener(sseListener, new TypeToken<TradeUpdateEventV2>(){}.getType())));
    }

    public SSERequest subscribeToTransferStatus(OffsetDateTime since, OffsetDateTime until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, SSEListener<AccountStatusEvent> sseListener) throws ApiException {
        Request request = this.eventsAPI.subscribeToTransferStatusSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, null).request();
        return new SSERequest(this.eventSourceFactory.newEventSource(request, this.createEventSourceListener(sseListener, new TypeToken<TransferStatusEvent>(){}.getType())));
    }

    public SSERequest subscribeToAccountStatus(LocalDate since, LocalDate until, Integer sinceId, Integer untilId, String sinceUlid, String untilUlid, String id, SSEListener<AccountStatusEvent> sseListener) throws ApiException {
        Request request = this.eventsAPI.suscribeToAccountStatusSSECall(since, until, sinceId, untilId, sinceUlid, untilUlid, id, null).request();
        return new SSERequest(this.eventSourceFactory.newEventSource(request, this.createEventSourceListener(sseListener, new TypeToken<AccountStatusEvent>(){}.getType())));
    }

    private <T> EventSourceListener createEventSourceListener(final SSEListener<T> sseListener, final Type responseTypeToken) {
        return new EventSourceListener(){

            public void onClosed(@NotNull EventSource eventSource) {
                LOGGER.info("Event source closed: eventSource={}", (Object)eventSource);
                sseListener.onClose();
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                LOGGER.trace("Event source event: eventSource={} id={}, type={}, data={}", new Object[]{eventSource, id, type, data});
                sseListener.onMessage(JSON.getGson().fromJson(data, responseTypeToken));
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable throwable, @Nullable Response response) {
                if (throwable != null && throwable.getMessage().equals("canceled")) {
                    sseListener.onClose();
                    return;
                }
                LOGGER.error("Event source failure: eventSource={} throwable={}, response={}", new Object[]{eventSource, throwable, response});
                sseListener.onError(throwable, response);
            }

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                LOGGER.info("Event source opened: {}", (Object)eventSource);
                sseListener.onOpen();
            }
        };
    }
}

