/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.rest.marketdata;

import com.google.common.base.Preconditions;
import net.jacobpeterson.alpaca.openapi.marketdata.ApiClient;
import net.jacobpeterson.alpaca.openapi.marketdata.api.CorporateActionsApi;
import net.jacobpeterson.alpaca.openapi.marketdata.api.CryptoApi;
import net.jacobpeterson.alpaca.openapi.marketdata.api.ForexApi;
import net.jacobpeterson.alpaca.openapi.marketdata.api.LogosApi;
import net.jacobpeterson.alpaca.openapi.marketdata.api.NewsApi;
import net.jacobpeterson.alpaca.openapi.marketdata.api.OptionApi;
import net.jacobpeterson.alpaca.openapi.marketdata.api.StockApi;
import net.jacobpeterson.alpaca.util.apikey.APIKeyUtil;
import okhttp3.OkHttpClient;

public class AlpacaMarketDataAPI {
    private final ApiClient apiClient;
    private CorporateActionsApi corporateActions;
    private CryptoApi crypto;
    private ForexApi forex;
    private LogosApi logos;
    private NewsApi news;
    private OptionApi option;
    private StockApi stock;

    public AlpacaMarketDataAPI(String traderKeyID, String traderSecretKey, String brokerAPIKey, String brokerAPISecret, OkHttpClient okHttpClient) {
        Preconditions.checkArgument((boolean)((traderKeyID != null && traderSecretKey != null) ^ (brokerAPIKey != null && brokerAPISecret != null)), (Object)"You must specify a (trader key ID and secret key) or an (broker API key and secret)!");
        Preconditions.checkNotNull((Object)okHttpClient);
        boolean traderKeysGiven = traderKeyID != null && traderSecretKey != null;
        this.apiClient = new ApiClient(okHttpClient);
        this.apiClient.setServerIndex(traderKeysGiven ? 0 : 1);
        if (traderKeysGiven) {
            this.apiClient.addDefaultHeader("APCA-API-KEY-ID", traderKeyID);
            this.apiClient.addDefaultHeader("APCA-API-SECRET-KEY", traderSecretKey);
        } else {
            this.apiClient.addDefaultHeader("Authorization", "Basic " + APIKeyUtil.createBrokerAPIAuthKey(brokerAPIKey, brokerAPISecret));
        }
    }

    public ApiClient getInternalAPIClient() {
        return this.apiClient;
    }

    public synchronized CorporateActionsApi corporateActions() {
        if (this.corporateActions == null) {
            this.corporateActions = new CorporateActionsApi(this.apiClient);
        }
        return this.corporateActions;
    }

    public synchronized CryptoApi crypto() {
        if (this.crypto == null) {
            this.crypto = new CryptoApi(this.apiClient);
        }
        return this.crypto;
    }

    public synchronized ForexApi forex() {
        if (this.forex == null) {
            this.forex = new ForexApi(this.apiClient);
        }
        return this.forex;
    }

    public synchronized LogosApi logos() {
        if (this.logos == null) {
            this.logos = new LogosApi(this.apiClient);
        }
        return this.logos;
    }

    public synchronized NewsApi news() {
        if (this.news == null) {
            this.news = new NewsApi(this.apiClient);
        }
        return this.news;
    }

    public synchronized OptionApi option() {
        if (this.option == null) {
            this.option = new OptionApi(this.apiClient);
        }
        return this.option;
    }

    public synchronized StockApi stock() {
        if (this.stock == null) {
            this.stock = new StockApi(this.apiClient);
        }
        return this.stock;
    }
}

