/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.rest.trader;

import com.google.common.base.Preconditions;
import net.jacobpeterson.alpaca.model.util.apitype.TraderAPIEndpointType;
import net.jacobpeterson.alpaca.openapi.trader.ApiClient;
import net.jacobpeterson.alpaca.openapi.trader.api.AccountActivitiesApi;
import net.jacobpeterson.alpaca.openapi.trader.api.AccountConfigurationsApi;
import net.jacobpeterson.alpaca.openapi.trader.api.AccountsApi;
import net.jacobpeterson.alpaca.openapi.trader.api.AssetsApi;
import net.jacobpeterson.alpaca.openapi.trader.api.CalendarApi;
import net.jacobpeterson.alpaca.openapi.trader.api.ClockApi;
import net.jacobpeterson.alpaca.openapi.trader.api.CorporateActionsApi;
import net.jacobpeterson.alpaca.openapi.trader.api.OrdersApi;
import net.jacobpeterson.alpaca.openapi.trader.api.PortfolioHistoryApi;
import net.jacobpeterson.alpaca.openapi.trader.api.PositionsApi;
import net.jacobpeterson.alpaca.openapi.trader.api.WatchlistsApi;
import net.jacobpeterson.alpaca.openapi.trader.model.NonTradeActivities;
import net.jacobpeterson.alpaca.openapi.trader.model.TradingActivities;
import okhttp3.OkHttpClient;

public class AlpacaTraderAPI {
    private final ApiClient apiClient;
    private AccountActivitiesApi accountActivities;
    private AccountConfigurationsApi accountConfigurations;
    private AccountsApi accounts;
    private AssetsApi assets;
    private CalendarApi calendar;
    private ClockApi clock;
    private CorporateActionsApi traderCorporateActions;
    private OrdersApi orders;
    private PortfolioHistoryApi portfolioHistory;
    private PositionsApi positions;
    private WatchlistsApi watchlists;

    public AlpacaTraderAPI(String traderKeyID, String traderSecretKey, String traderOAuthToken, TraderAPIEndpointType traderAPIEndpointType, OkHttpClient okHttpClient) {
        Preconditions.checkArgument((boolean)((traderKeyID != null && traderSecretKey != null) ^ traderOAuthToken != null), (Object)"You must specify a (trader key ID and secret key) or an (OAuth token)!");
        Preconditions.checkNotNull((Object)((Object)traderAPIEndpointType));
        Preconditions.checkNotNull((Object)okHttpClient);
        this.apiClient = new ApiClient(okHttpClient);
        this.apiClient.setServerIndex(switch (traderAPIEndpointType) {
            case TraderAPIEndpointType.PAPER -> 0;
            case TraderAPIEndpointType.LIVE -> 1;
            default -> throw new UnsupportedOperationException();
        });
        if (traderKeyID != null && traderSecretKey != null) {
            this.apiClient.addDefaultHeader("APCA-API-KEY-ID", traderKeyID);
            this.apiClient.addDefaultHeader("APCA-API-SECRET-KEY", traderSecretKey);
        } else {
            this.apiClient.addDefaultHeader("Authorization", "Bearer " + traderOAuthToken);
        }
    }

    public ApiClient getInternalAPIClient() {
        return this.apiClient;
    }

    public synchronized AccountActivitiesApi accountActivities() {
        if (this.accountActivities == null) {
            this.accountActivities = new AccountActivitiesApi(this.apiClient);
        }
        return this.accountActivities;
    }

    public synchronized AccountConfigurationsApi accountConfigurations() {
        if (this.accountConfigurations == null) {
            this.accountConfigurations = new AccountConfigurationsApi(this.apiClient);
        }
        return this.accountConfigurations;
    }

    public synchronized AccountsApi accounts() {
        if (this.accounts == null) {
            this.accounts = new AccountsApi(this.apiClient);
        }
        return this.accounts;
    }

    public synchronized AssetsApi assets() {
        if (this.assets == null) {
            this.assets = new AssetsApi(this.apiClient);
        }
        return this.assets;
    }

    public synchronized CalendarApi calendar() {
        if (this.calendar == null) {
            this.calendar = new CalendarApi(this.apiClient);
        }
        return this.calendar;
    }

    public synchronized ClockApi clock() {
        if (this.clock == null) {
            this.clock = new ClockApi(this.apiClient);
        }
        return this.clock;
    }

    public synchronized CorporateActionsApi traderCorporateActions() {
        if (this.traderCorporateActions == null) {
            this.traderCorporateActions = new CorporateActionsApi(this.apiClient);
        }
        return this.traderCorporateActions;
    }

    public synchronized OrdersApi orders() {
        if (this.orders == null) {
            this.orders = new OrdersApi(this.apiClient);
        }
        return this.orders;
    }

    public synchronized PortfolioHistoryApi portfolioHistory() {
        if (this.portfolioHistory == null) {
            this.portfolioHistory = new PortfolioHistoryApi(this.apiClient);
        }
        return this.portfolioHistory;
    }

    public synchronized PositionsApi positions() {
        if (this.positions == null) {
            this.positions = new PositionsApi(this.apiClient);
        }
        return this.positions;
    }

    public synchronized WatchlistsApi watchlists() {
        if (this.watchlists == null) {
            this.watchlists = new WatchlistsApi(this.apiClient);
        }
        return this.watchlists;
    }

    static {
        TradingActivities.isValid = jsonElement -> jsonElement.getAsJsonObject().has("type");
        NonTradeActivities.isValid = jsonElement -> !jsonElement.getAsJsonObject().has("type");
    }
}

