/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.util.sse;

import net.jacobpeterson.alpaca.util.sse.SSEListener;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEListenerAdapter<T>
implements SSEListener<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSEListenerAdapter.class);

    @Override
    public void onOpen() {
        LOGGER.info("SSE connection opened.");
    }

    @Override
    public void onClose() {
        LOGGER.info("SSE connection closed.");
    }

    @Override
    public void onError(@Nullable Throwable throwable, @Nullable Response response) {
        LOGGER.error("SSE connection error! response={}", (Object)response, (Object)throwable);
    }

    @Override
    public void onMessage(@NotNull T message) {
        LOGGER.info("SSE message received: message={}", message);
    }
}

