/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.websocket;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jacobpeterson.alpaca.websocket.AlpacaWebsocketStateListener;

public interface AlpacaWebsocketInterface {
    public void connect();

    public void disconnect();

    public boolean isConnected();

    public boolean isAuthenticated();

    default public boolean isValid() {
        return this.isConnected() && this.isAuthenticated();
    }

    public Future<Boolean> getAuthorizationFuture();

    default public boolean waitForAuthorization(long timeout, TimeUnit unit) {
        try {
            return this.getAuthorizationFuture().get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return false;
        }
    }

    public void setAlpacaWebsocketStateListener(AlpacaWebsocketStateListener var1);

    public boolean doesAutomaticallyReconnect();

    public void setAutomaticallyReconnect(boolean var1);
}

