/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.websocket.marketdata;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.jacobpeterson.alpaca.model.websocket.marketdata.model.MarketDataMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.model.control.ErrorMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.model.control.SuccessMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.model.control.SuccessMessageType;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.websocket.AlpacaWebsocket;
import net.jacobpeterson.alpaca.websocket.marketdata.MarketDataWebsocketInterface;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarketDataWebsocket<T, S extends MarketDataMessage, L>
extends AlpacaWebsocket
implements MarketDataWebsocketInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarketDataWebsocket.class);
    private static final Set<String> AUTH_FAILURE_MESSAGES = Set.of("auth failed", "auth timeout", "not authenticated");
    protected final String authKey;
    protected final String authSecret;
    protected final Class<T> messageTypeClass;
    protected final Class<S> subscriptionsMessageClass;
    protected S subscriptionsMessage;
    protected L listener;

    protected MarketDataWebsocket(OkHttpClient okHttpClient, HttpUrl websocketURL, String websocketMarketDataTypeName, String traderKeyID, String traderSecretKey, String brokerAPIKey, String brokerAPISecret, Class<T> messageTypeClass, Class<S> subscriptionsMessageClass) {
        super(okHttpClient, websocketURL, websocketMarketDataTypeName + " Market Data");
        boolean traderKeysGiven = traderKeyID != null && traderSecretKey != null;
        this.authKey = traderKeysGiven ? traderKeyID : brokerAPIKey;
        this.authSecret = traderKeysGiven ? traderSecretKey : brokerAPISecret;
        this.messageTypeClass = messageTypeClass;
        this.subscriptionsMessageClass = subscriptionsMessageClass;
    }

    @Override
    protected void cleanupState() {
        super.cleanupState();
        this.subscriptionsMessage = null;
    }

    @Override
    protected void onConnection() {
        this.sendAuthenticationMessage();
    }

    @Override
    protected void onReconnection() {
        this.sendAuthenticationMessage();
        if (this.waitForAuthorization(5L, TimeUnit.SECONDS) && this.subscriptionsMessage != null) {
            this.sendSubscriptionMessage(this.subscriptionsMessage, true);
        }
    }

    @Override
    protected void sendAuthenticationMessage() {
        this.getAuthorizationFuture();
        JsonObject authObject = new JsonObject();
        authObject.addProperty("action", "auth");
        authObject.addProperty("key", this.authKey);
        authObject.addProperty("secret", this.authSecret);
        LOGGER.info("{} websocket sending authentication message...", (Object)this.websocketName);
        this.sendWebsocketMessage(authObject.toString());
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String message) {
        LOGGER.trace("Websocket message received: {}", (Object)message);
        for (JsonElement arrayElement : JsonParser.parseString((String)message).getAsJsonArray()) {
            JsonObject messageObject = arrayElement.getAsJsonObject();
            Object messageType = JSON.getGson().fromJson(messageObject.get("T"), this.messageTypeClass);
            if (this.isSuccessMessageType(messageType)) {
                SuccessMessage successMessage = (SuccessMessage)JSON.getGson().fromJson((JsonElement)messageObject, SuccessMessage.class);
                if (successMessage.getMessageType() != SuccessMessageType.AUTHENTICATED) continue;
                LOGGER.info("{} websocket authenticated.", (Object)this.websocketName);
                this.authenticated = true;
                if (this.authenticationMessageFuture == null) continue;
                this.authenticationMessageFuture.complete(true);
                continue;
            }
            if (this.isErrorMessageType(messageType)) {
                ErrorMessage errorMessage = (ErrorMessage)JSON.getGson().fromJson((JsonElement)messageObject, ErrorMessage.class);
                if (AUTH_FAILURE_MESSAGES.contains(errorMessage.getMessage()) && this.authenticationMessageFuture != null) {
                    this.authenticated = false;
                    this.authenticationMessageFuture.complete(false);
                    throw new RuntimeException(this.websocketName + " websocket authentication failed!");
                }
                throw new RuntimeException(this.websocketName + " websocket error! Message: " + String.valueOf(errorMessage));
            }
            if (this.isSubscriptionMessageType(messageType)) {
                this.subscriptionsMessage = (MarketDataMessage)JSON.getGson().fromJson((JsonElement)messageObject, this.subscriptionsMessageClass);
                continue;
            }
            if (this.listener == null) continue;
            this.callListenerWithMessage(messageType, messageObject);
        }
    }

    protected void setSubscriptions(@NotNull Set<String> previousSubscriptions, @NotNull Set<String> newSubscriptions, @NotNull Function<Set<String>, S> subscriptionUpdateObjectCreator) {
        Sets.SetView subscribeSet;
        Sets.SetView unsubscribeSet = Sets.difference(previousSubscriptions, newSubscriptions);
        if (!unsubscribeSet.isEmpty()) {
            this.sendSubscriptionMessage((MarketDataMessage)subscriptionUpdateObjectCreator.apply((Set<String>)unsubscribeSet), false);
        }
        if (!(subscribeSet = Sets.difference(newSubscriptions, previousSubscriptions)).isEmpty()) {
            this.sendSubscriptionMessage((MarketDataMessage)subscriptionUpdateObjectCreator.apply((Set<String>)subscribeSet), true);
        }
    }

    private void sendSubscriptionMessage(S subscriptionsMessage, boolean subscribe) {
        JsonObject subscribeObject = JSON.getGson().toJsonTree(subscriptionsMessage).getAsJsonObject();
        subscribeObject.addProperty("action", subscribe ? "subscribe" : "unsubscribe");
        this.sendWebsocketMessage(JSON.getGson().toJson((JsonElement)subscribeObject));
    }

    protected abstract boolean isSuccessMessageType(T var1);

    protected abstract boolean isErrorMessageType(T var1);

    protected abstract boolean isSubscriptionMessageType(T var1);

    protected abstract void callListenerWithMessage(T var1, JsonObject var2);
}

