/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.websocket.marketdata.streams.crypto;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.CryptoMarketDataMessageType;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.bar.CryptoBarMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.control.CryptoSubscriptionsMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.orderbook.CryptoOrderBookMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.quote.CryptoQuoteMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.crypto.model.trade.CryptoTradeMessage;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.websocket.marketdata.MarketDataWebsocket;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.crypto.CryptoMarketDataListener;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.crypto.CryptoMarketDataWebsocketInterface;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class CryptoMarketDataWebsocket
extends MarketDataWebsocket<CryptoMarketDataMessageType, CryptoSubscriptionsMessage, CryptoMarketDataListener>
implements CryptoMarketDataWebsocketInterface {
    public CryptoMarketDataWebsocket(OkHttpClient okHttpClient, String traderKeyID, String traderSecretKey, String brokerAPIKey, String brokerAPISecret) {
        super(okHttpClient, new HttpUrl.Builder().scheme("https").host("stream.data.alpaca.markets").addPathSegments("v1beta3/crypto/us").build(), "Crypto", traderKeyID, traderSecretKey, brokerAPIKey, brokerAPISecret, CryptoMarketDataMessageType.class, CryptoSubscriptionsMessage.class);
    }

    @Override
    protected boolean isSuccessMessageType(CryptoMarketDataMessageType messageType) {
        return messageType == CryptoMarketDataMessageType.SUCCESS;
    }

    @Override
    protected boolean isErrorMessageType(CryptoMarketDataMessageType messageType) {
        return messageType == CryptoMarketDataMessageType.ERROR;
    }

    @Override
    protected boolean isSubscriptionMessageType(CryptoMarketDataMessageType messageType) {
        return messageType == CryptoMarketDataMessageType.SUBSCRIPTION;
    }

    @Override
    protected void callListenerWithMessage(CryptoMarketDataMessageType messageType, JsonObject messageObject) {
        switch (messageType) {
            case TRADES: {
                ((CryptoMarketDataListener)this.listener).onTrade((CryptoTradeMessage)JSON.getGson().fromJson((JsonElement)messageObject, CryptoTradeMessage.class));
                break;
            }
            case QUOTES: {
                ((CryptoMarketDataListener)this.listener).onQuote((CryptoQuoteMessage)JSON.getGson().fromJson((JsonElement)messageObject, CryptoQuoteMessage.class));
                break;
            }
            case MINUTE_BARS: {
                ((CryptoMarketDataListener)this.listener).onMinuteBar((CryptoBarMessage)JSON.getGson().fromJson((JsonElement)messageObject, CryptoBarMessage.class));
                break;
            }
            case DAILY_BARS: {
                ((CryptoMarketDataListener)this.listener).onDailyBar((CryptoBarMessage)JSON.getGson().fromJson((JsonElement)messageObject, CryptoBarMessage.class));
                break;
            }
            case UPDATED_BARS: {
                ((CryptoMarketDataListener)this.listener).onUpdatedBar((CryptoBarMessage)JSON.getGson().fromJson((JsonElement)messageObject, CryptoBarMessage.class));
                break;
            }
            case ORDER_BOOKS: {
                ((CryptoMarketDataListener)this.listener).onOrderBook((CryptoOrderBookMessage)JSON.getGson().fromJson((JsonElement)messageObject, CryptoOrderBookMessage.class));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setListener(CryptoMarketDataListener listener) {
        this.listener = listener;
    }

    @Override
    public void setTradeSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getTradeSubscriptions(), symbols, set -> this.newEmptyCryptoSubscriptionsMessage().withTrades((Set<String>)set));
    }

    @Override
    public Set<String> getTradeSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((CryptoSubscriptionsMessage)this.subscriptionsMessage).getTrades();
    }

    @Override
    public void setQuoteSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getQuoteSubscriptions(), symbols, set -> this.newEmptyCryptoSubscriptionsMessage().withQuotes((Set<String>)set));
    }

    @Override
    public Set<String> getQuoteSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((CryptoSubscriptionsMessage)this.subscriptionsMessage).getQuotes();
    }

    @Override
    public void setMinuteBarSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getMinuteBarSubscriptions(), symbols, set -> this.newEmptyCryptoSubscriptionsMessage().withMinuteBars((Set<String>)set));
    }

    @Override
    public Set<String> getMinuteBarSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((CryptoSubscriptionsMessage)this.subscriptionsMessage).getMinuteBars();
    }

    @Override
    public void setDailyBarSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getDailyBarSubscriptions(), symbols, set -> this.newEmptyCryptoSubscriptionsMessage().withDailyBars((Set<String>)set));
    }

    @Override
    public Set<String> getDailyBarSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((CryptoSubscriptionsMessage)this.subscriptionsMessage).getDailyBars();
    }

    @Override
    public void setUpdatedBarSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getUpdatedBarSubscriptions(), symbols, set -> this.newEmptyCryptoSubscriptionsMessage().withUpdatedBars((Set<String>)set));
    }

    @Override
    public Set<String> getUpdatedBarSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((CryptoSubscriptionsMessage)this.subscriptionsMessage).getUpdatedBars();
    }

    @Override
    public void setOrderBookSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getOrderBookSubscriptions(), symbols, set -> this.newEmptyCryptoSubscriptionsMessage().withOrderBooks((Set<String>)set));
    }

    @Override
    public Set<String> getOrderBookSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((CryptoSubscriptionsMessage)this.subscriptionsMessage).getOrderBooks();
    }

    private CryptoSubscriptionsMessage newEmptyCryptoSubscriptionsMessage() {
        return new CryptoSubscriptionsMessage().withTrades(null).withQuotes(null).withMinuteBars(null).withDailyBars(null).withUpdatedBars(null).withOrderBooks(null);
    }
}

