/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.websocket.marketdata.streams.news;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.news.model.NewsMarketDataMessageType;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.news.model.control.NewsSubscriptionsMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.news.model.news.NewsMessage;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.websocket.marketdata.MarketDataWebsocket;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.news.NewsMarketDataListener;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.news.NewsMarketDataWebsocketInterface;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class NewsMarketDataWebsocket
extends MarketDataWebsocket<NewsMarketDataMessageType, NewsSubscriptionsMessage, NewsMarketDataListener>
implements NewsMarketDataWebsocketInterface {
    public NewsMarketDataWebsocket(OkHttpClient okHttpClient, String traderKeyID, String traderSecretKey, String brokerAPIKey, String brokerAPISecret) {
        super(okHttpClient, new HttpUrl.Builder().scheme("https").host("stream.data.alpaca.markets").addPathSegments("v1beta1/news").build(), "News", traderKeyID, traderSecretKey, brokerAPIKey, brokerAPISecret, NewsMarketDataMessageType.class, NewsSubscriptionsMessage.class);
    }

    @Override
    protected boolean isSuccessMessageType(NewsMarketDataMessageType messageType) {
        return messageType == NewsMarketDataMessageType.SUCCESS;
    }

    @Override
    protected boolean isErrorMessageType(NewsMarketDataMessageType messageType) {
        return messageType == NewsMarketDataMessageType.ERROR;
    }

    @Override
    protected boolean isSubscriptionMessageType(NewsMarketDataMessageType messageType) {
        return messageType == NewsMarketDataMessageType.SUBSCRIPTION;
    }

    @Override
    protected void callListenerWithMessage(NewsMarketDataMessageType messageType, JsonObject messageObject) {
        if (messageType != NewsMarketDataMessageType.NEWS) {
            throw new UnsupportedOperationException();
        }
        ((NewsMarketDataListener)this.listener).onNews((NewsMessage)JSON.getGson().fromJson((JsonElement)messageObject, NewsMessage.class));
    }

    @Override
    public void setListener(NewsMarketDataListener listener) {
        this.listener = listener;
    }

    @Override
    public void setNewsSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getNewsSubscriptions(), symbols, set -> new NewsSubscriptionsMessage().withNews((Set<String>)set));
    }

    @Override
    public Set<String> getNewsSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((NewsSubscriptionsMessage)this.subscriptionsMessage).getNews();
    }
}

