/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.websocket.marketdata.streams.stock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import net.jacobpeterson.alpaca.model.util.apitype.MarketDataWebsocketSourceType;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.StockMarketDataMessageType;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.bar.StockBarMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.control.StockSubscriptionsMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.limituplimitdownband.StockLimitUpLimitDownBandMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.quote.StockQuoteMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.trade.StockTradeMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.tradecancelerror.StockTradeCancelErrorMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.tradecorrection.StockTradeCorrectionMessage;
import net.jacobpeterson.alpaca.model.websocket.marketdata.streams.stock.model.tradingstatus.StockTradingStatusMessage;
import net.jacobpeterson.alpaca.openapi.marketdata.JSON;
import net.jacobpeterson.alpaca.websocket.marketdata.MarketDataWebsocket;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.stock.StockMarketDataListener;
import net.jacobpeterson.alpaca.websocket.marketdata.streams.stock.StockMarketDataWebsocketInterface;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class StockMarketDataWebsocket
extends MarketDataWebsocket<StockMarketDataMessageType, StockSubscriptionsMessage, StockMarketDataListener>
implements StockMarketDataWebsocketInterface {
    private static HttpUrl createWebsocketURL(boolean isSandbox, MarketDataWebsocketSourceType marketDataWebsocketSourceType) {
        return new HttpUrl.Builder().scheme("https").host(isSandbox ? "stream.data.sandbox.alpaca.markets" : "stream.data.alpaca.markets").addPathSegment("v2").addPathSegment(marketDataWebsocketSourceType.toString()).build();
    }

    public StockMarketDataWebsocket(OkHttpClient okHttpClient, String traderKeyID, String traderSecretKey, String brokerAPIKey, String brokerAPISecret, MarketDataWebsocketSourceType marketDataWebsocketSourceType) {
        super(okHttpClient, StockMarketDataWebsocket.createWebsocketURL(brokerAPIKey != null && brokerAPISecret != null, marketDataWebsocketSourceType), "Stock", traderKeyID, traderSecretKey, brokerAPIKey, brokerAPISecret, StockMarketDataMessageType.class, StockSubscriptionsMessage.class);
    }

    @Override
    protected boolean isSuccessMessageType(StockMarketDataMessageType messageType) {
        return messageType == StockMarketDataMessageType.SUCCESS;
    }

    @Override
    protected boolean isErrorMessageType(StockMarketDataMessageType messageType) {
        return messageType == StockMarketDataMessageType.ERROR;
    }

    @Override
    protected boolean isSubscriptionMessageType(StockMarketDataMessageType messageType) {
        return messageType == StockMarketDataMessageType.SUBSCRIPTION;
    }

    @Override
    protected void callListenerWithMessage(StockMarketDataMessageType messageType, JsonObject messageObject) {
        switch (messageType) {
            case TRADES: {
                ((StockMarketDataListener)this.listener).onTrade((StockTradeMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockTradeMessage.class));
                break;
            }
            case QUOTES: {
                ((StockMarketDataListener)this.listener).onQuote((StockQuoteMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockQuoteMessage.class));
                break;
            }
            case MINUTE_BARS: {
                ((StockMarketDataListener)this.listener).onMinuteBar((StockBarMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockBarMessage.class));
                break;
            }
            case DAILY_BARS: {
                ((StockMarketDataListener)this.listener).onDailyBar((StockBarMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockBarMessage.class));
                break;
            }
            case UPDATED_BARS: {
                ((StockMarketDataListener)this.listener).onUpdatedBar((StockBarMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockBarMessage.class));
                break;
            }
            case TRADE_CORRECTIONS: {
                ((StockMarketDataListener)this.listener).onTradeCorrection((StockTradeCorrectionMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockTradeCorrectionMessage.class));
                break;
            }
            case TRADE_CANCEL_ERRORS: {
                ((StockMarketDataListener)this.listener).onTradeCancelError((StockTradeCancelErrorMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockTradeCancelErrorMessage.class));
                break;
            }
            case LIMIT_UP_LIMIT_DOWN_BANDS: {
                ((StockMarketDataListener)this.listener).onLimitUpLimitDownBand((StockLimitUpLimitDownBandMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockLimitUpLimitDownBandMessage.class));
                break;
            }
            case TRADING_STATUSES: {
                ((StockMarketDataListener)this.listener).onTradingStatus((StockTradingStatusMessage)JSON.getGson().fromJson((JsonElement)messageObject, StockTradingStatusMessage.class));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setListener(StockMarketDataListener listener) {
        this.listener = listener;
    }

    @Override
    public void setTradeSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getTradeSubscriptions(), symbols, set -> this.newEmptyStockSubscriptionsMessage().withTrades((Set<String>)set));
    }

    @Override
    public Set<String> getTradeSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((StockSubscriptionsMessage)this.subscriptionsMessage).getTrades();
    }

    @Override
    public void setQuoteSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getQuoteSubscriptions(), symbols, set -> this.newEmptyStockSubscriptionsMessage().withQuotes((Set<String>)set));
    }

    @Override
    public Set<String> getQuoteSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((StockSubscriptionsMessage)this.subscriptionsMessage).getQuotes();
    }

    @Override
    public void setMinuteBarSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getMinuteBarSubscriptions(), symbols, set -> this.newEmptyStockSubscriptionsMessage().withMinuteBars((Set<String>)set));
    }

    @Override
    public Set<String> getMinuteBarSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((StockSubscriptionsMessage)this.subscriptionsMessage).getMinuteBars();
    }

    @Override
    public void setDailyBarSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getDailyBarSubscriptions(), symbols, set -> this.newEmptyStockSubscriptionsMessage().withDailyBars((Set<String>)set));
    }

    @Override
    public Set<String> getDailyBarSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((StockSubscriptionsMessage)this.subscriptionsMessage).getDailyBars();
    }

    @Override
    public void setUpdatedBarSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getUpdatedBarSubscriptions(), symbols, set -> this.newEmptyStockSubscriptionsMessage().withUpdatedBars((Set<String>)set));
    }

    @Override
    public Set<String> getUpdatedBarSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((StockSubscriptionsMessage)this.subscriptionsMessage).getUpdatedBars();
    }

    @Override
    public void setLimitUpLimitDownBandSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getLimitUpLimitDownBandSubscriptions(), symbols, set -> this.newEmptyStockSubscriptionsMessage().withLimitUpLimitDownBands((Set<String>)set));
    }

    @Override
    public Set<String> getLimitUpLimitDownBandSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((StockSubscriptionsMessage)this.subscriptionsMessage).getLimitUpLimitDownBands();
    }

    @Override
    public void setTradingStatuseSubscriptions(Set<String> symbols) {
        symbols = symbols == null ? Set.of() : symbols;
        this.setSubscriptions(this.getTradingStatuseSubscriptions(), symbols, set -> this.newEmptyStockSubscriptionsMessage().withTradingStatuses((Set<String>)set));
    }

    @Override
    public Set<String> getTradingStatuseSubscriptions() {
        return this.subscriptionsMessage == null ? Set.of() : ((StockSubscriptionsMessage)this.subscriptionsMessage).getTradingStatuses();
    }

    private StockSubscriptionsMessage newEmptyStockSubscriptionsMessage() {
        return new StockSubscriptionsMessage().withTrades(null).withQuotes(null).withMinuteBars(null).withDailyBars(null).withUpdatedBars(null).withLimitUpLimitDownBands(null).withTradingStatuses(null);
    }
}

