/*
 * Decompiled with CFR 0.152.
 */
package net.jacobpeterson.alpaca.websocket.updates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.concurrent.TimeUnit;
import net.jacobpeterson.alpaca.model.util.apitype.TraderAPIEndpointType;
import net.jacobpeterson.alpaca.model.websocket.updates.model.UpdatesMessageType;
import net.jacobpeterson.alpaca.model.websocket.updates.model.authorization.AuthorizationMessage;
import net.jacobpeterson.alpaca.model.websocket.updates.model.tradeupdate.TradeUpdateMessage;
import net.jacobpeterson.alpaca.openapi.trader.JSON;
import net.jacobpeterson.alpaca.websocket.AlpacaWebsocket;
import net.jacobpeterson.alpaca.websocket.updates.UpdatesListener;
import net.jacobpeterson.alpaca.websocket.updates.UpdatesWebsocketInterface;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatesWebsocket
extends AlpacaWebsocket
implements UpdatesWebsocketInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatesWebsocket.class);
    protected final String keyID;
    protected final String secretKey;
    protected final String oAuthToken;
    protected UpdatesListener listener;
    protected boolean listenToTradeUpdates;

    private static HttpUrl createWebsocketURL(TraderAPIEndpointType traderAPIEndpointType) {
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme("https");
        return builder.host((switch (traderAPIEndpointType) {
            case TraderAPIEndpointType.LIVE -> "api";
            case TraderAPIEndpointType.PAPER -> "paper-api";
            default -> throw new UnsupportedOperationException();
        }) + ".alpaca.markets").addPathSegment("stream").build();
    }

    public UpdatesWebsocket(OkHttpClient okHttpClient, TraderAPIEndpointType traderAPIEndpointType, String keyID, String secretKey, String oAuthToken) {
        super(okHttpClient, UpdatesWebsocket.createWebsocketURL(traderAPIEndpointType), "Trades Stream");
        this.keyID = keyID;
        this.secretKey = secretKey;
        this.oAuthToken = oAuthToken;
    }

    @Override
    protected void cleanupState() {
        super.cleanupState();
    }

    @Override
    protected void onConnection() {
        this.sendAuthenticationMessage();
    }

    @Override
    protected void onReconnection() {
        this.sendAuthenticationMessage();
        if (this.waitForAuthorization(5L, TimeUnit.SECONDS) && this.listenToTradeUpdates) {
            this.sendTradeUpdatesListenMessage();
        }
    }

    @Override
    protected void sendAuthenticationMessage() {
        this.getAuthorizationFuture();
        JsonObject authObject = new JsonObject();
        authObject.addProperty("action", "authenticate");
        JsonObject authData = new JsonObject();
        if (this.oAuthToken != null) {
            authData.addProperty("oauth_token", this.oAuthToken);
        } else {
            authData.addProperty("key_id", this.keyID);
            authData.addProperty("secret_key", this.secretKey);
        }
        authObject.add("data", (JsonElement)authData);
        LOGGER.info("{} websocket sending authentication message...", (Object)this.websocketName);
        this.sendWebsocketMessage(authObject.toString());
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString byteString) {
        String messageString = byteString.utf8();
        LOGGER.trace("Websocket message received: message={}", (Object)messageString);
        JsonObject messageObject = JsonParser.parseString((String)messageString).getAsJsonObject();
        UpdatesMessageType messageType = (UpdatesMessageType)((Object)JSON.getGson().fromJson(messageObject.get("stream"), UpdatesMessageType.class));
        switch (messageType) {
            case AUTHORIZATION: {
                AuthorizationMessage authorizationMessage = (AuthorizationMessage)JSON.getGson().fromJson((JsonElement)messageObject, AuthorizationMessage.class);
                boolean bl = this.authenticated = authorizationMessage.getData().getAction().equalsIgnoreCase("authenticate") && authorizationMessage.getData().getStatus().equalsIgnoreCase("authorized");
                if (this.authenticationMessageFuture != null) {
                    this.authenticationMessageFuture.complete(this.authenticated);
                }
                if (!this.authenticated) {
                    throw new RuntimeException(this.websocketName + " websocket authentication failed!");
                }
                LOGGER.info("{} websocket authenticated.", (Object)this.websocketName);
                break;
            }
            case LISTENING: {
                break;
            }
            case TRADE_UPDATES: {
                if (this.listener == null) break;
                this.listener.onTradeUpdate((TradeUpdateMessage)JSON.getGson().fromJson((JsonElement)messageObject, TradeUpdateMessage.class));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setListener(UpdatesListener listener) {
        this.listener = listener;
    }

    @Override
    public void subscribeToTradeUpdates(boolean subscribe) {
        this.listenToTradeUpdates = subscribe;
        this.sendTradeUpdatesListenMessage();
    }

    private void sendTradeUpdatesListenMessage() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("action", "listen");
        JsonArray streamsArray = new JsonArray();
        if (this.listenToTradeUpdates) {
            streamsArray.add(UpdatesMessageType.TRADE_UPDATES.toString());
        }
        JsonObject dataObject = new JsonObject();
        dataObject.add("streams", (JsonElement)streamsArray);
        requestObject.add("data", (JsonElement)dataObject);
        this.sendWebsocketMessage(requestObject.toString());
        LOGGER.info("Requested streams: streams={}.", (Object)streamsArray);
    }
}

