/*
 * Decompiled with CFR 0.152.
 */
package jadecrawler.website;

import jadecrawler.dto.website.IcibaDto;
import jadecrawler.dto.website.NewWord;
import jadecrawler.dto.website.NewWordBook;
import jadecrawler.net.HTTPUtil$;
import jadecrawler.net.JadeHTTPResponse;
import jadecrawler.website.IcibaDao;
import jadecrawler.website.NewWordBookDao;
import jadecrawler.website.WebIcibaParser$;
import jadeutils.common.Logging;
import jadeutils.mongo.Condition;
import jadeutils.mongo.MongoModel;
import jadeutils.mongo.MongoResultSet;
import jadeutils.mongo.MongoServer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001\u001d\u0011A\"S2jE\u0006\u001c%/Y<mKJT!a\u0001\u0003\u0002\u000f],'m]5uK*\tQ!A\u0006kC\u0012,7M]1xY\u0016\u00148\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u000511m\\7n_:T\u0011aE\u0001\nU\u0006$W-\u001e;jYNL!!\u0006\t\u0003\u000f1{wmZ5oO\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0003i_N$\bCA\r\u001d\u001d\tI!$\u0003\u0002\u001c\u0015\u00051\u0001K]3eK\u001aL!!\b\u0010\u0003\rM#(/\u001b8h\u0015\tY\"\u0002\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0011\u0001xN\u001d;\u0011\u0005%\u0011\u0013BA\u0012\u000b\u0005\rIe\u000e\u001e\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u00051AMY!vi\"\u00042aJ\u00183\u001d\tASF\u0004\u0002*Y5\t!F\u0003\u0002,\r\u00051AH]8pizJ\u0011aC\u0005\u0003])\tq\u0001]1dW\u0006<W-\u0003\u00021c\t!A*[:u\u0015\tq#\u0002E\u0002\ngaI!\u0001\u000e\u0006\u0003\u000b\u0005\u0013(/Y=\t\u000bY\u0002A\u0011A\u001c\u0002\rqJg.\u001b;?)\u0011A$h\u000f\u001f\u0011\u0005e\u0002Q\"\u0001\u0002\t\u000b])\u0004\u0019\u0001\r\t\u000b\u0001*\u0004\u0019A\u0011\t\u000b\u0015*\u0004\u0019\u0001\u0014\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005\u00111/M\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111IE\u0001\u0006[>twm\\\u0005\u0003\u000b\n\u00131\"T8oO>\u001cVM\u001d<fe\"1q\t\u0001Q\u0001\n\u0001\u000b1a]\u0019!\u0011\u001dI\u0005A1A\u0005\u0002}\n!a\u001d\u001a\t\r-\u0003\u0001\u0015!\u0003A\u0003\r\u0019(\u0007\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0003!I7-\u001b2b\t\u0006|W#A(\u0011\u0005e\u0002\u0016BA)\u0003\u0005!I5-\u001b2b\t\u0006|\u0007BB*\u0001A\u0003%q*A\u0005jG&\u0014\u0017\rR1pA!9Q\u000b\u0001b\u0001\n\u00031\u0016A\u00038fo^{'\u000f\u001a#b_V\tq\u000b\u0005\u0002:1&\u0011\u0011L\u0001\u0002\u000f\u001d\u0016<xk\u001c:e\u0005>|7\u000eR1p\u0011\u0019Y\u0006\u0001)A\u0005/\u0006Ya.Z<X_J$G)Y8!\u0011\u0015i\u0006\u0001\"\u0001_\u0003%\u0019\u0018M^3M_\u000e\fG\u000e\u0006\u0002`EB\u0011\u0011\u0002Y\u0005\u0003C*\u0011A!\u00168ji\")1\r\u0018a\u0001I\u00061!/Z:vYR\u0004\"!Z5\u000e\u0003\u0019T!aA4\u000b\u0005!$\u0011a\u00013u_&\u0011!N\u001a\u0002\t\u0013\u000eL'-\u0019#u_\"9A\u000e\u0001b\u0001\n\u0003i\u0017\u0001B:ji\u0016,\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA\u000fq\u0011\u00191\b\u0001)A\u0005]\u0006)1/\u001b;fA!)\u0001\u0010\u0001C\u0001s\u00069\u0001O]8dKN\u001cHC\u00013{\u0011\u0015Yx\u000f1\u0001\u0019\u0003\u00119xN\u001d3\t\u000bu\u0004A\u0011\u0001@\u0002\u00131|\u0017\r\u001a'pG\u0006dGC\u00013\u0000\u0011\u0015YH\u00101\u0001\u0019\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tA\u0002\\8bI:+woV8sIN$\"\"a\u0002\u0002\u0018\u0005e\u00111DA\u0010!\u0019\tI!a\u0004\u0002\u00125\u0011\u00111\u0002\u0006\u0004\u0003\u001b\u0011\u0018\u0001B;uS2L1\u0001MA\u0006!\r)\u00171C\u0005\u0004\u0003+1'a\u0002(fo^{'\u000f\u001a\u0005\u0007/\u0005\u0005\u0001\u0019\u0001\r\t\r\u0001\n\t\u00011\u0001\"\u0011\u001d\ti\"!\u0001A\u0002a\t\u0001\"^:fe:\fW.\u001a\u0005\b\u0003C\t\t\u00011\u0001\u0019\u0003!\u0001\u0018m]:x_J$\u0007\u0002CA\u0013\u0001\u0001&I!a\n\u0002\u001fA\u0014xnY3tg:+woV8sIN$RbXA\u0015\u0003W\ti#a\f\u00022\u0005M\u0002BB\f\u0002$\u0001\u0007\u0001\u0004\u0003\u0004!\u0003G\u0001\r!\t\u0005\b\u0003;\t\u0019\u00031\u0001\u0019\u0011\u001d\t\t#a\tA\u0002aAaa_A\u0012\u0001\u0004A\u0002\u0002CA\u001b\u0003G\u0001\r!a\u000e\u0002\u000f!\fg\u000e\u001a7feBA\u0011\"!\u000f\u0019\u0003\u000f\t9!C\u0002\u0002<)\u0011\u0011BR;oGRLwN\u001c\u001a\t\u0011\u0005}\u0002\u0001)C\u0005\u0003\u0003\n!\"\u00193e/>\u0014Hm\u00149u)\u0019\t9!a\u0011\u0002F!110!\u0010A\u0002aA\u0001\"a\u0012\u0002>\u0001\u0007\u0011qA\u0001\u0006o>\u0014Hm\u001d\u0005\t\u0003\u0017\u0002\u0001\u0015\"\u0003\u0002N\u0005i!/Z7pm\u0016<vN\u001d3PaR$b!a\u0002\u0002P\u0005E\u0003BB>\u0002J\u0001\u0007\u0001\u0004\u0003\u0005\u0002H\u0005%\u0003\u0019AA\u0004\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n!\"\u00193e\u001d\u0016<xk\u001c:e)-y\u0016\u0011LA.\u0003;\ny&!\u0019\t\r]\t\u0019\u00061\u0001\u0019\u0011\u0019\u0001\u00131\u000ba\u0001C!9\u0011QDA*\u0001\u0004A\u0002bBA\u0011\u0003'\u0002\r\u0001\u0007\u0005\u0007w\u0006M\u0003\u0019\u0001\r\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h\u0005i!/Z7pm\u0016tUm^,pe\u0012$2bXA5\u0003W\ni'a\u001c\u0002r!1q#a\u0019A\u0002aAa\u0001IA2\u0001\u0004\t\u0003bBA\u000f\u0003G\u0002\r\u0001\u0007\u0005\b\u0003C\t\u0019\u00071\u0001\u0019\u0011\u0019Y\u00181\ra\u00011\u0001")
public class IcibaCrawler
implements Logging {
    private final MongoServer s1;
    private final MongoServer s2;
    private final IcibaDao icibaDao;
    private final NewWordBookDao newWordDao;
    private final String site;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        IcibaCrawler icibaCrawler = this;
        synchronized (icibaCrawler) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Logger getLoggerByName(String name) {
        return Logging.class.getLoggerByName((Logging)this, (String)name);
    }

    public void logTrace(String msg, Seq<Object> refs) {
        Logging.class.logTrace((Logging)this, (String)msg, refs);
    }

    public void logDebug(String msg, Seq<Object> refs) {
        Logging.class.logDebug((Logging)this, (String)msg, refs);
    }

    public void logInfo(String msg, Seq<Object> refs) {
        Logging.class.logInfo((Logging)this, (String)msg, refs);
    }

    public void logWarn(String msg, Seq<Object> refs) {
        Logging.class.logWarn((Logging)this, (String)msg, refs);
    }

    public void logError(String msg, Seq<Object> refs) {
        Logging.class.logError((Logging)this, (String)msg, refs);
    }

    public MongoServer s1() {
        return this.s1;
    }

    public MongoServer s2() {
        return this.s2;
    }

    public IcibaDao icibaDao() {
        return this.icibaDao;
    }

    public NewWordBookDao newWordDao() {
        return this.newWordDao;
    }

    public void saveLocal(IcibaDto result) {
        if (result != null) {
            this.logger().debug("iciba page parse OK: {}", new Object[]{result.word()});
            try {
                this.icibaDao().insert((MongoModel)result);
                this.logger().debug("iciba page save OK: {}", new Object[]{result.word()});
            }
            catch (Throwable throwable) {
                this.logger().error("iciba-save error: {}, {}", new Object[]{new Object[]{result.word(), throwable}});
            }
        }
    }

    public String site() {
        return this.site;
    }

    public IcibaDto process(String word) {
        IcibaDto icibaDto;
        String page;
        String string;
        try {
            JadeHTTPResponse resp = HTTPUtil$.MODULE$.doGet(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"http://").append((Object)this.site()).append((Object)"/%s").toString())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})), HTTPUtil$.MODULE$.firefoxParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)this.site())));
            string = resp != null && resp.content() != null && resp.content().length > 0 ? new String(resp.content()) : "";
        }
        catch (Throwable throwable) {
            this.logger().warn("query iciba error: {}, {}", new Object[]{new Object[]{word, throwable}});
            string = page = null;
        }
        if (page == null) {
            icibaDto = null;
        } else {
            try {
                icibaDto = (IcibaDto)WebIcibaParser$.MODULE$.parse(page).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                this.logger().warn("iciba page parse err: {}, {}", new Object[]{new Object[]{word, throwable}});
                icibaDto = null;
            }
        }
        return icibaDto;
    }

    public IcibaDto loadLocal(String word) {
        IcibaDto icibaDto;
        try {
            MongoResultSet rs = this.icibaDao().findByCondition(Condition.newCondition((String)"word", (Object)word));
            icibaDto = rs.hasNext() ? (IcibaDto)rs.next() : null;
        }
        catch (Throwable throwable) {
            this.logger().warn("iciba load local err: {}, {}", new Object[]{new Object[]{word, throwable}});
            icibaDto = null;
        }
        return icibaDto;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.util.List<NewWord> loadNewWords(String host, int port, String username, String password) {
        java.util.List list;
        NewWordBook user;
        NewWordBook newWordBook;
        try {
            MongoResultSet rs = this.newWordDao().findByCondition(Condition.newCondition((String)"username", (Object)username));
            newWordBook = rs.hasNext() ? (NewWordBook)rs.next() : null;
        }
        catch (Throwable throwable) {
            this.logger().warn("find iciba user eror: {}, {}", new Object[]{new Object[]{username, throwable}});
            newWordBook = user = null;
        }
        if (user != null) {
            String string = user.password();
            String string2 = password;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                list = user.words();
                return list;
            }
        }
        list = JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$);
        return list;
    }

    private void processNewWords(String host, int port, String username, String password, String word, Function2<String, java.util.List<NewWord>, java.util.List<NewWord>> handler) {
        NewWordBook user;
        NewWordBook newWordBook;
        try {
            MongoResultSet rs = this.newWordDao().findByCondition(Condition.newCondition((String)"username", (Object)username));
            newWordBook = rs.hasNext() ? (NewWordBook)rs.next() : null;
        }
        catch (Throwable throwable) {
            this.logger().warn("find iciba user eror: {}, {}", new Object[]{new Object[]{username, throwable}});
            newWordBook = user = null;
        }
        if (user != null) {
            String string = user.password();
            String string2 = password;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                user.words_$eq((java.util.List)handler.apply((Object)word, (Object)user.words()));
                this.newWordDao().updateOne(Condition.newCondition((String)"username", (Object)user.username()), Condition.newCondition((String)"$set", (Object)Condition.newCondition((String)"words", (Object)user.words())));
            }
        }
    }

    public java.util.List<NewWord> jadecrawler$website$IcibaCrawler$$addWordOpt(String word, java.util.List<NewWord> words) {
        java.util.List list;
        if (words == null || JavaConversions$.MODULE$.asScalaBuffer(words).length() == 0) {
            NewWord newWord = new NewWord(word, 1);
            list = JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$.$colon$colon((Object)newWord));
        } else {
            Boolean bl;
            Buffer l = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(words).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(NewWord w) {
                    return w.word();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            if (l.contains((Object)word)) {
                NewWord c = words.get(l.indexOf((Object)word));
                c.count_$eq(c.count() + 1);
                bl = BoxedUnit.UNIT;
            } else {
                bl = BoxesRunTime.boxToBoolean((boolean)words.add(new NewWord(word, 1)));
            }
            list = JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(words).sortWith((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(NewWord x$25, NewWord x$26) {
                    return x$25.count() > x$26.count();
                }
            }));
        }
        return list;
    }

    public java.util.List<NewWord> jadecrawler$website$IcibaCrawler$$removeWordOpt(String word, java.util.List<NewWord> words) {
        return words == null && JavaConversions$.MODULE$.asScalaBuffer(words).length() == 0 ? JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$) : JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(words).withFilter((Function1)new Serializable(this, word){
            public static final long serialVersionUID = 0L;
            private final String word$1;

            public final boolean apply(NewWord w) {
                String string = w.word();
                String string2 = this.word$1;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.word$1 = word$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewWord apply(NewWord w) {
                return w;
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public void addNewWord(String host, int port, String username, String password, String word) {
        this.processNewWords(host, port, username, password, word, (Function2<String, java.util.List<NewWord>, java.util.List<NewWord>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IcibaCrawler $outer;

            public final java.util.List<NewWord> apply(String word, java.util.List<NewWord> words) {
                return this.$outer.jadecrawler$website$IcibaCrawler$$addWordOpt(word, words);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void removeNewWord(String host, int port, String username, String password, String word) {
        this.processNewWords(host, port, username, password, word, (Function2<String, java.util.List<NewWord>, java.util.List<NewWord>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IcibaCrawler $outer;

            public final java.util.List<NewWord> apply(String word, java.util.List<NewWord> words) {
                return this.$outer.jadecrawler$website$IcibaCrawler$$removeWordOpt(word, words);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public IcibaCrawler(String host, int port, List<String[]> dbAuth) {
        Logging.class.$init$((Logging)this);
        this.s1 = new MongoServer(host, port, JavaConversions$.MODULE$.seqAsJavaList(dbAuth));
        this.s2 = new MongoServer(host, port, JavaConversions$.MODULE$.seqAsJavaList(dbAuth));
        MongoServer mongoServer = this.s1();
        this.icibaDao = new IcibaDao(JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$.$colon$colon((Object)mongoServer)));
        MongoServer mongoServer2 = this.s2();
        this.newWordDao = new NewWordBookDao(JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$.$colon$colon((Object)mongoServer2)));
        this.site = "www.iciba.com";
    }
}

