/*
 * Decompiled with CFR 0.152.
 */
package jadecrawler.website;

import jadecrawler.net.HTTPUtil$;
import jadecrawler.net.JadeHTTPResponse;
import jadecrawler.website.K1Parser$;
import jadeutils.common.Logging;
import java.io.File;
import java.io.FileOutputStream;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.util.matching.Regex;

public final class K1Crawler$
implements Logging {
    public static final K1Crawler$ MODULE$;
    private final String site;
    private final String localBookPath;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new K1Crawler$();
    }

    private Logger logger$lzycompute() {
        K1Crawler$ k1Crawler$ = this;
        synchronized (k1Crawler$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Logger getLoggerByName(String name) {
        return Logging.class.getLoggerByName((Logging)this, (String)name);
    }

    public void logTrace(String msg, Seq<Object> refs) {
        Logging.class.logTrace((Logging)this, (String)msg, refs);
    }

    public void logDebug(String msg, Seq<Object> refs) {
        Logging.class.logDebug((Logging)this, (String)msg, refs);
    }

    public void logInfo(String msg, Seq<Object> refs) {
        Logging.class.logInfo((Logging)this, (String)msg, refs);
    }

    public void logWarn(String msg, Seq<Object> refs) {
        Logging.class.logWarn((Logging)this, (String)msg, refs);
    }

    public void logError(String msg, Seq<Object> refs) {
        Logging.class.logError((Logging)this, (String)msg, refs);
    }

    public String site() {
        return this.site;
    }

    public String localBookPath() {
        return this.localBookPath;
    }

    public void processBook(String bookId) {
        String bookPage = this.fetchBook(bookId);
        Tuple3<String, String, IndexedSeq<Tuple3<String, String, Object>>> book = K1Parser$.MODULE$.parseBook(bookId, bookPage);
        ((IterableLike)book._3()).foreach((Function1)new Serializable(book){
            public static final long serialVersionUID = 0L;
            private final Tuple3 book$1;

            public final void apply(Tuple3<String, String, Object> vol) {
                K1Crawler$.MODULE$.processVol((String)this.book$1._1(), (String)this.book$1._2(), vol);
            }
            {
                this.book$1 = book$1;
            }
        });
    }

    public String fetchBook(String bookId) {
        String string;
        String url;
        String refer = url = new StringBuilder().append((Object)"http://").append((Object)this.site()).append((Object)"/").append((Object)bookId).append((Object)"/").toString();
        try {
            JadeHTTPResponse resp = HTTPUtil$.MODULE$.doGet(url, HTTPUtil$.MODULE$.firefoxParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)this.site())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Referer"), (Object)refer)));
            string = resp != null && resp.content() != null && resp.content().length > 0 ? new String(resp.content()) : "";
        }
        catch (Throwable throwable) {
            this.logger().warn("fetch 1kk page error: {}, {}", new Object[]{new Object[]{url, throwable}});
            string = null;
        }
        return string;
    }

    public void processVol(String bookId, String bookName, Tuple3<String, String, Object> vol) {
        File bookDir = new File(this.localBookPath());
        this.makeDir(bookDir);
        String bookImgDir = new StringBuilder().append((Object)this.localBookPath()).append((Object)"img/").toString();
        this.makeDir(new File(bookImgDir));
        this.makeDir(new File(new StringBuilder().append((Object)bookImgDir).append((Object)bookId).append((Object)"/").toString()));
        String volPath = new StringBuilder().append((Object)bookImgDir).append((Object)bookId).append((Object)"/").append(vol._1()).append((Object)"/").toString();
        this.makeDir(new File(volPath));
        String volData = this.fetchVol((String)vol._1());
        String cid = K1Parser$.MODULE$.parseCid(volData);
        IndexedSeq<Tuple3<String, Object, String>> pages = K1Parser$.MODULE$.parseVol((String)vol._1(), (String)vol._2(), cid, BoxesRunTime.unboxToInt((Object)vol._3()));
        IndexedSeq ll = (IndexedSeq)pages.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<String, Object, String> p) {
                return K1Crawler$.MODULE$.fetchPage((String)p._1(), (String)p._3());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq urls = (IndexedSeq)ll.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return K1Parser$.MODULE$.parseImage(l);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.logger().debug("{}", new Object[]{urls});
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), urls.size()).foreach$mVc$sp((Function1)new Serializable(vol, volPath, urls){
            public static final long serialVersionUID = 0L;
            private final Tuple3 vol$1;
            private final String volPath$1;
            private final IndexedSeq urls$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String url = (String)this.urls$1.apply(i);
                Regex.MatchIterator g = new StringOps(Predef$.MODULE$.augmentString("http://manhua.+\\.cdndm5.com.+(\\.[0-9a-zA-Z])\\?cid=.+")).r().findAllIn((CharSequence)url);
                String postfix = ".jpg";
                K1Crawler$.MODULE$.saveImage(new StringBuilder().append((Object)this.volPath$1).append((Object)new StringOps(Predef$.MODULE$.augmentString("%03d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))}))).append((Object)postfix).toString(), K1Crawler$.MODULE$.loadImage(url, (String)this.vol$1._1()));
            }
            {
                this.vol$1 = vol$1;
                this.volPath$1 = volPath$1;
                this.urls$1 = urls$1;
            }
        });
        this.makeDir(new File(new StringBuilder().append((Object)this.localBookPath()).append((Object)"pdf/").toString()));
        ProcessBuilder p = Process$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("bash ./genPdf.sh %s %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)"img/").append((Object)bookId).append((Object)"/").append(vol._1()).append((Object)"/").toString(), new StringBuilder().append((Object)"pdf/").append((Object)bookName).append((Object)"-").append(vol._2()).toString()})), bookDir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"LANG", (Object)"en_US")}));
        p.$bang();
    }

    public String fetchVol(String volId) {
        String string;
        String url;
        String refer = url = new StringBuilder().append((Object)"http://").append((Object)this.site()).append((Object)"/").append((Object)volId).append((Object)"/").toString();
        try {
            JadeHTTPResponse resp = HTTPUtil$.MODULE$.doGet(url, HTTPUtil$.MODULE$.firefoxParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)this.site())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Referer"), (Object)refer)));
            string = resp != null && resp.content() != null && resp.content().length > 0 ? new String(resp.content()) : "";
        }
        catch (Throwable throwable) {
            this.logger().warn("fetch 1kk page error: {}, {}", new Object[]{new Object[]{url, throwable}});
            string = null;
        }
        return string;
    }

    public String fetchPage(String volId, String url) {
        String string;
        String refer = new StringBuilder().append((Object)"http://").append((Object)this.site()).append((Object)"/m").append((Object)volId).append((Object)"/").toString();
        try {
            JadeHTTPResponse resp = HTTPUtil$.MODULE$.doGet(url, HTTPUtil$.MODULE$.firefoxParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)this.site())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Referer"), (Object)refer)));
            string = resp != null && resp.content() != null && resp.content().length > 0 ? new String(resp.content()) : "";
        }
        catch (Throwable throwable) {
            this.logger().warn("fetch 1kk img info error: {}, {}", new Object[]{new Object[]{url, throwable}});
            string = null;
        }
        String page = string;
        return page;
    }

    public byte[] loadImage(String url, String volId) {
        byte[] byArray;
        Regex.MatchIterator g = new StringOps(Predef$.MODULE$.augmentString("http://(manhua([-.0-9a-zA-Z])+.cdndm5.com)")).r().findAllIn((CharSequence)url);
        String site = g.hasNext() ? g.group(1) : "manhua-923-2.cdndm5.com";
        String refer = new StringBuilder().append((Object)"http://").append((Object)site).append((Object)"/m").append((Object)volId).append((Object)"/").toString();
        try {
            JadeHTTPResponse resp = HTTPUtil$.MODULE$.doGet(url, HTTPUtil$.MODULE$.firefoxParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)site)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Referer"), (Object)refer)));
            byArray = resp != null && resp.content() != null && resp.content().length > 0 ? resp.content() : new byte[]{};
        }
        catch (Throwable throwable) {
            this.logger().warn("fetch 1kk image error: {}, {}", new Object[]{new Object[]{url, throwable}});
            byArray = new byte[]{};
        }
        return byArray;
    }

    public void saveImage(String fileName, byte[] content) {
        File file = new File(fileName);
        FileOutputStream out = new FileOutputStream(file);
        out.write(content);
        out.close();
    }

    public void processPage() {
    }

    public void makeDir(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private K1Crawler$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.site = "tel.1kkk.com";
        this.localBookPath = "books/";
    }
}

