/*
 * Decompiled with CFR 0.152.
 */
package jadecrawler.website;

import jadecrawler.net.HTTPUtil$;
import jadecrawler.net.JadeHTTPResponse;
import jadecrawler.website.OpenWeatherParser$;
import jadeutils.common.Logging;
import org.slf4j.Logger;
import scala.Predef;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;

public final class OpenWeatherCrawler$
implements Logging {
    public static final OpenWeatherCrawler$ MODULE$;
    private final String site;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new OpenWeatherCrawler$();
    }

    private Logger logger$lzycompute() {
        OpenWeatherCrawler$ openWeatherCrawler$ = this;
        synchronized (openWeatherCrawler$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Logger getLoggerByName(String name) {
        return Logging.class.getLoggerByName((Logging)this, (String)name);
    }

    public void logTrace(String msg, Seq<Object> refs) {
        Logging.class.logTrace((Logging)this, (String)msg, refs);
    }

    public void logDebug(String msg, Seq<Object> refs) {
        Logging.class.logDebug((Logging)this, (String)msg, refs);
    }

    public void logInfo(String msg, Seq<Object> refs) {
        Logging.class.logInfo((Logging)this, (String)msg, refs);
    }

    public void logWarn(String msg, Seq<Object> refs) {
        Logging.class.logWarn((Logging)this, (String)msg, refs);
    }

    public void logError(String msg, Seq<Object> refs) {
        Logging.class.logError((Logging)this, (String)msg, refs);
    }

    public String site() {
        return this.site;
    }

    public Tuple5<String, String, String, String, List<Map<String, String>>> get16dayByCityName(String city, String localTimeZone, String apiKey) {
        Tuple5<String, String, String, String, List<Map<String, String>>> tuple5;
        String string;
        try {
            String url = new StringOps(Predef$.MODULE$.augmentString("http://%s/data/2.5/forecast/daily?q=%s&mode=xml&units=metric&cnt=7&appid=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.site(), city, apiKey}));
            this.logDebug(url, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            JadeHTTPResponse resp = HTTPUtil$.MODULE$.doGet(url, HTTPUtil$.MODULE$.firefoxParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)this.site())));
            string = resp != null && resp.content() != null && resp.content().length > 0 ? new String(resp.content()) : "";
        }
        catch (Throwable throwable) {
            this.logger().warn("query weather error: {}, {}, {}", new Object[]{new Object[]{city, localTimeZone, throwable}});
            string = null;
        }
        String page = string;
        this.logDebug(page, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        if (page == null) {
            tuple5 = null;
        } else {
            try {
                tuple5 = OpenWeatherParser$.MODULE$.parse16day(page, localTimeZone);
            }
            catch (Throwable throwable) {
                this.logger().warn("Weather page parse err: {}, {}, {}", new Object[]{new Object[]{city, localTimeZone, throwable}});
                tuple5 = null;
            }
        }
        return tuple5;
    }

    private OpenWeatherCrawler$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.site = "api.openweathermap.org";
    }
}

