/*
 * Decompiled with CFR 0.152.
 */
package jadecrawler.website;

import jadeutils.common.Logging;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.RichInt$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public final class OpenWeatherParser$
implements Logging {
    public static final OpenWeatherParser$ MODULE$;
    private final Map<String, String> iconMap;
    private final Map<String, String> arrowMap;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new OpenWeatherParser$();
    }

    private Logger logger$lzycompute() {
        OpenWeatherParser$ openWeatherParser$ = this;
        synchronized (openWeatherParser$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Logger getLoggerByName(String name) {
        return Logging.class.getLoggerByName((Logging)this, (String)name);
    }

    public void logTrace(String msg, Seq<Object> refs) {
        Logging.class.logTrace((Logging)this, (String)msg, refs);
    }

    public void logDebug(String msg, Seq<Object> refs) {
        Logging.class.logDebug((Logging)this, (String)msg, refs);
    }

    public void logInfo(String msg, Seq<Object> refs) {
        Logging.class.logInfo((Logging)this, (String)msg, refs);
    }

    public void logWarn(String msg, Seq<Object> refs) {
        Logging.class.logWarn((Logging)this, (String)msg, refs);
    }

    public void logError(String msg, Seq<Object> refs) {
        Logging.class.logError((Logging)this, (String)msg, refs);
    }

    public Map<String, String> iconMap() {
        return this.iconMap;
    }

    public Map<String, String> arrowMap() {
        return this.arrowMap;
    }

    public String formatConkyWeather(String timeZone, String local, Tuple5<String, String, String, String, List<Map<String, String>>> data) {
        StringBuffer sb = new StringBuffer();
        Map today = (Map)((LinearSeqOptimized)data._5()).apply(0);
        sb.append((String)data._1()).append(", ").append((String)data._2()).append(" ");
        String dow = this.jadecrawler$website$OpenWeatherParser$$getDayOfWeek((String)today.apply((Object)"day"), timeZone, local);
        sb.append(dow).append("\n");
        String smbChar = (String)this.iconMap().getOrElse(today.apply((Object)"smbVar"), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "b";
            }
        });
        sb.append(smbChar).append("\n");
        sb.append((String)today.apply((Object)"tmpMin")).append(" ~ ").append((String)today.apply((Object)"tmpMax"));
        sb.append("\u00b0C").append("\n");
        sb.append((String)today.apply((Object)"psuVal")).append((String)today.apply((Object)"psuUnt")).append("\n");
        sb.append((String)today.apply((Object)"wndMps")).append("Mps").append("\n");
        String wndArw = (String)this.arrowMap().getOrElse(today.apply((Object)"wndDct"), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return " ";
            }
        });
        sb.append(wndArw).append("\n");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach((Function1)new Serializable(timeZone, local, data, sb){
            public static final long serialVersionUID = 0L;
            private final String timeZone$1;
            private final String local$1;
            private final Tuple5 data$1;
            private final StringBuffer sb$1;

            public final StringBuffer apply(int i) {
                String str = OpenWeatherParser$.MODULE$.jadecrawler$website$OpenWeatherParser$$getDayOfWeek((String)((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"day"), this.timeZone$1, this.local$1);
                return i > 1 ? this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%12s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str}))) : this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%4s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            }
            {
                this.timeZone$1 = timeZone$1;
                this.local$1 = local$1;
                this.data$1 = data$1;
                this.sb$1 = sb$1;
            }
        });
        sb.append("\n");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach((Function1)new Serializable(data, sb){
            public static final long serialVersionUID = 0L;
            private final Tuple5 data$1;
            private final StringBuffer sb$1;

            public final StringBuffer apply(int i) {
                String str = (String)OpenWeatherParser$.MODULE$.iconMap().getOrElse(((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"smbVar"), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "b";
                    }
                });
                return i > 1 ? this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%4s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str}))) : this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%2s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            }
            {
                this.data$1 = data$1;
                this.sb$1 = sb$1;
            }
        });
        sb.append("\n");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach((Function1)new Serializable(data, sb){
            public static final long serialVersionUID = 0L;
            private final Tuple5 data$1;
            private final StringBuffer sb$1;

            public final StringBuffer apply(int i) {
                String str = new StringBuilder().append((Object)((String)((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"humVal"))).append(((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"humUnt")).toString();
                return i == 1 ? this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%6s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str}))) : this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%12s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            }
            {
                this.data$1 = data$1;
                this.sb$1 = sb$1;
            }
        });
        sb.append("\n");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach((Function1)new Serializable(data, sb){
            public static final long serialVersionUID = 0L;
            private final Tuple5 data$1;
            private final StringBuffer sb$1;

            public final StringBuffer apply(int i) {
                String str = new StringBuilder().append((Object)((String)((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"wndMps"))).append((Object)"Mps").toString();
                return i == 1 ? this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%8s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str}))) : this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%12s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            }
            {
                this.data$1 = data$1;
                this.sb$1 = sb$1;
            }
        });
        sb.append("\n");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach((Function1)new Serializable(data, sb){
            public static final long serialVersionUID = 0L;
            private final Tuple5 data$1;
            private final StringBuffer sb$1;

            public final StringBuffer apply(int i) {
                return this.sb$1.append((String)OpenWeatherParser$.MODULE$.arrowMap().getOrElse(((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"wndDct"), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return " ";
                    }
                })).append("\n");
            }
            {
                this.data$1 = data$1;
                this.sb$1 = sb$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach((Function1)new Serializable(data, sb){
            public static final long serialVersionUID = 0L;
            private final Tuple5 data$1;
            private final StringBuffer sb$1;

            public final StringBuffer apply(int i) {
                String str = new StringBuilder().append((Object)((String)((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"tmpMax"))).append((Object)"\u00b0C").toString();
                return i == 1 ? this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%9s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str}))) : this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%11s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            }
            {
                this.data$1 = data$1;
                this.sb$1 = sb$1;
            }
        });
        sb.append("\n");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach((Function1)new Serializable(data, sb){
            public static final long serialVersionUID = 0L;
            private final Tuple5 data$1;
            private final StringBuffer sb$1;

            public final StringBuffer apply(int i) {
                String str = new StringBuilder().append((Object)((String)((MapLike)((LinearSeqOptimized)this.data$1._5()).apply(i)).apply((Object)"tmpMin"))).append((Object)"\u00b0C").toString();
                return i == 1 ? this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%9s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str}))) : this.sb$1.append(new StringOps(Predef$.MODULE$.augmentString("%11s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            }
            {
                this.data$1 = data$1;
                this.sb$1 = sb$1;
            }
        });
        sb.append("\n");
        sb.append((String)today.apply((Object)"smbNme")).append("\n");
        sb.append((String)today.apply((Object)"humVal")).append((String)today.apply((Object)"humUnt")).append("\n");
        sb.append((String)data._3()).append("\n").append((String)data._4()).append("\n");
        return sb.toString();
    }

    public Tuple5<String, String, String, String, List<Map<String, String>>> parse16day(String str, String localTimeZone) {
        Elem data = (Elem)XML$.MODULE$.loadString(str);
        String location = data.$bslash("location").$bslash("name").text();
        String country = data.$bslash("location").$bslash("country").text();
        String sunRise = this.parseTime(data.$bslash("sun").$bslash("@rise").text().replaceAll("T", " "), localTimeZone);
        String sunSet = this.parseTime(data.$bslash("sun").$bslash("@set").text().replaceAll("T", " "), localTimeZone);
        Nil$ nil$ = Nil$.MODULE$;
        List days = (List)((SeqLike)data.$bslash$bslash("time").$div$colon((Object)nil$, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Map<String, String>> apply(List<Map<String, String>> lst, Node rec) {
                String day = rec.$bslash("@day").toString();
                String smbNum = rec.$bslash("symbol").$bslash("@number").toString();
                String smbVar = rec.$bslash("symbol").$bslash("@var").toString();
                String smbNme = rec.$bslash("symbol").$bslash("@name").toString();
                String pcpType = rec.$bslash("precipitation").$bslash("@type").toString();
                String pcpValue = rec.$bslash("precipitation").$bslash("@value").toString();
                String humUnt = rec.$bslash("humidity").$bslash("@unit").toString();
                String humVal = rec.$bslash("humidity").$bslash("@value").toString();
                String wndDct = rec.$bslash("windDirection").$bslash("@code").toString();
                String wndSpd = rec.$bslash("windSpeed").$bslash("@name").toString();
                String wndMps = rec.$bslash("windSpeed").$bslash("@mps").toString();
                String tmpMin = rec.$bslash("temperature").$bslash("@min").toString();
                String tmpMax = rec.$bslash("temperature").$bslash("@max").toString();
                String tmpMrn = rec.$bslash("temperature").$bslash("@morn").toString();
                String tmpDay = rec.$bslash("temperature").$bslash("@day").toString();
                String tmpNig = rec.$bslash("temperature").$bslash("@night").toString();
                String tmpEve = rec.$bslash("temperature").$bslash("@eve").toString();
                String psuUnt = rec.$bslash("pressure").$bslash("@unit").toString();
                String psuVal = rec.$bslash("pressure").$bslash("@value").toString();
                String cludVal = rec.$bslash("clouds").$bslash("@value").toString();
                String cludAll = rec.$bslash("clouds").$bslash("@all").toString();
                String cludUnt = rec.$bslash("clouds").$bslash("@unit").toString();
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"day"), (Object)day), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"smbVar"), (Object)smbVar), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"smbNum"), (Object)smbNum), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"smbNme"), (Object)smbNme), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pcpType"), (Object)pcpType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pcpValue"), (Object)pcpValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"humUnt"), (Object)humUnt), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"humVal"), (Object)humVal), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wndDct"), (Object)wndDct), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wndSpd"), (Object)wndSpd), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wndMps"), (Object)wndMps), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tmpMin"), (Object)tmpMin), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tmpMax"), (Object)tmpMax), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tmpMrn"), (Object)tmpMrn), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tmpDay"), (Object)tmpDay), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tmpNig"), (Object)tmpNig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tmpEve"), (Object)tmpEve), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"psuUnt"), (Object)psuUnt), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"psuVal"), (Object)psuVal), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cludVal"), (Object)cludVal), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cludAll"), (Object)cludAll), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cludUnt"), (Object)cludUnt)}));
                return lst.$colon$colon((Object)map);
            }
        })).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Map<String, String> a, Map<String, String> b) {
                return ((String)a.getOrElse((Object)"day", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })).compareTo((String)b.getOrElse((Object)"day", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) < 0;
            }
        });
        return new Tuple5((Object)location, (Object)country, (Object)sunRise, (Object)sunSet, (Object)days);
    }

    private String parseTime(String time, String localTimeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(sdf.parse(time).getTime());
        SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm");
        return sdf2.format(this.transTimezone$1(date, "GMT", localTimeZone));
    }

    public String jadecrawler$website$OpenWeatherParser$$getDayOfWeek(String str, String timeZone, String local) {
        String string;
        String[] lArr = local.split("_");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date day = sdf.parse(str);
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(timeZone), new Locale(lArr[0], lArr[1]));
        c.setTime(day);
        int n = c.get(7);
        switch (n) {
            default: {
                string = "???";
                break;
            }
            case 7: {
                string = "Sat";
                break;
            }
            case 6: {
                string = "Fri";
                break;
            }
            case 5: {
                string = "Thu";
                break;
            }
            case 4: {
                string = "Wen";
                break;
            }
            case 3: {
                string = "Tue";
                break;
            }
            case 2: {
                string = "Mon";
                break;
            }
            case 1: {
                string = "Sun";
            }
        }
        return string;
    }

    private final Date transTimezone$1(Date date, String src, String dest) {
        return new Date(date.getTime() - (long)TimeZone.getTimeZone(src).getRawOffset() + (long)TimeZone.getTimeZone(dest).getRawOffset());
    }

    private OpenWeatherParser$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.iconMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"01d"), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"01"), (Object)"N"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"02d"), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"02"), (Object)"l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"03d"), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"03"), (Object)"n"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"04d"), (Object)"e"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"04"), (Object)"o"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"09d"), (Object)"h"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"09"), (Object)"r"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"10d"), (Object)"g"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"10"), (Object)"q"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"11d"), (Object)"i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"11"), (Object)"s")}));
        this.arrowMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"N"), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NNE"), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NE"), (Object)"c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ENE"), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"E"), (Object)"e"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ESE"), (Object)"f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SE"), (Object)"g"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SSE"), (Object)"h"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"S"), (Object)"i"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SSW"), (Object)"j"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SW"), (Object)"k"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WSW"), (Object)"l"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"W"), (Object)"m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WNW"), (Object)"n"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NW"), (Object)"o"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NNW"), (Object)"p")}));
    }
}

