/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.dao;

import jadeutils.dao.JadeDaoException;
import jadeutils.dao.PageSplitDto;
import java.util.ArrayList;
import java.util.List;

public class PageSpliter {
    public static int getOffSet(int currentPageNo, int pageSize) {
        if (currentPageNo < 2 || pageSize < 1) {
            return 0;
        }
        return (currentPageNo - 1) * pageSize;
    }

    public static int countPages(int recNumber, int pageSize) {
        if (recNumber < 1 || pageSize < 1) {
            return 1;
        }
        return (recNumber + pageSize - 1) / pageSize;
    }

    private static List<String> prePageNumbers(int start, int end) {
        if (start < 1) {
            start = 1;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            l.add("" + i);
        }
        return l;
    }

    private static List<String> posPageNumbers(int start, int end) {
        if (end < start) {
            end = start;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = start + 1; i <= end; ++i) {
            l.add("" + i);
        }
        return l;
    }

    public static final void splitPage(PageSplitDto dto) throws JadeDaoException {
        int spNo = 4;
        try {
            int prePageNo;
            int countPageNumber = 0;
            try {
                countPageNumber = PageSpliter.countPages(dto.getCountRecNumber(), dto.getPageSize());
            }
            catch (Exception e) {
                countPageNumber = 1;
            }
            dto.setCountPageNumber(countPageNumber);
            int currentPageNo = dto.getCurrPageNo();
            int nextPageNo = currentPageNo + 1;
            if (nextPageNo > countPageNumber) {
                nextPageNo = countPageNumber;
            }
            dto.setNextPageNo(nextPageNo);
            if (currentPageNo + spNo < countPageNumber) {
                dto.setAppPos("YES");
            }
            if ((prePageNo = currentPageNo - 1) < 1) {
                prePageNo = 1;
            }
            dto.setPrePageNo(prePageNo);
            if (1 + spNo < currentPageNo) {
                dto.setAppPre("YES");
            }
            int startPage = currentPageNo - spNo;
            int exp = spNo + 1 - (countPageNumber - currentPageNo);
            if (exp > 0) {
                startPage -= exp;
            }
            dto.setPrePageNoList(PageSpliter.prePageNumbers(startPage, currentPageNo));
            int endPage = currentPageNo + spNo + 1;
            int exn = spNo - currentPageNo + 1;
            if (exn > 0) {
                endPage += exn;
            }
            if (endPage > countPageNumber) {
                endPage = countPageNumber;
            }
            dto.setPosPageNoList(PageSpliter.posPageNumbers(currentPageNo, endPage));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JadeDaoException("err.groupon.001");
        }
    }
}

