/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import jadeutils.mongo.Condition;
import jadeutils.mongo.MongoDao;
import jadeutils.mongo.MongoDocument;
import jadeutils.mongo.MongoModel;
import jadeutils.mongo.MongoResultSet;
import jadeutils.mongo.MongoServer;
import jadeutils.mongo.impl.MongoUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMongoDao<T extends MongoModel>
implements MongoDao<T> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MongoClient client;
    private DBCollection collection;
    private String dbName;
    private String collectionName;
    private Class<T> entryClass;

    public BaseMongoDao(List<MongoServer> serverList) {
        try {
            if (null != serverList && serverList.size() > 0) {
                ArrayList<ServerAddress> addrlist = new ArrayList<ServerAddress>();
                ArrayList<MongoCredential> credentialsList = new ArrayList<MongoCredential>();
                for (MongoServer s : serverList) {
                    addrlist.add(new ServerAddress(s.getHost(), s.getPort()));
                    if (null == s.getAuthList() || s.getAuthList().size() <= 0) continue;
                    for (String[] arr : s.getAuthList()) {
                        if (null == arr[0] || null == arr[1] || null == arr[2] || arr[0].length() <= 0 || arr[1].length() <= 0 || arr[2].length() <= 0) continue;
                        MongoCredential credential = MongoCredential.createMongoCRCredential((String)arr[1], (String)arr[0], (char[])arr[2].toCharArray());
                        credentialsList.add(credential);
                    }
                }
                this.client = credentialsList.size() > 0 ? new MongoClient(addrlist, credentialsList) : new MongoClient(addrlist);
            }
            Type genType = this.getClass().getGenericSuperclass();
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            this.entryClass = (Class)params[0];
            MongoDocument md = this.entryClass.getAnnotation(MongoDocument.class);
            if (null == md) {
                throw new Exception("ERROR: no Annotation on model");
            }
            this.dbName = md.databaseName();
            this.collectionName = md.collectionName();
            if (StringUtils.isBlank((String)this.collectionName) || StringUtils.isBlank((String)this.dbName)) {
                throw new Exception(String.format("ERROR: no Annotation on model: %s, %s", this.dbName, this.collectionName));
            }
            this.initCollection();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (null != this.client) {
            this.client.close();
        }
    }

    @Override
    public void insert(T obj) throws IllegalArgumentException, IllegalAccessException {
        this.collection.insert(new DBObject[]{MongoUtil.genRecFromModel(obj)});
    }

    @Override
    public T getByMongoId(String Id) throws InstantiationException, IllegalAccessException {
        DBObject rec = this.collection.findOne();
        Object model = MongoUtil.genModelFromRec(this.entryClass, rec);
        return model;
    }

    @Override
    public T findOneByCondition(Condition cdt) throws InstantiationException, IllegalAccessException {
        BasicDBObject condition = MongoUtil.parseCondition(cdt);
        this.logger.debug("befor query: " + (null == condition ? null : condition.toString()));
        DBObject rec = this.collection.findOne((DBObject)condition);
        Object model = MongoUtil.genModelFromRec(this.entryClass, rec);
        return model;
    }

    @Override
    public MongoResultSet<T> findByCondition(Condition cdt) throws IllegalArgumentException, IllegalAccessException {
        BasicDBObject condition = MongoUtil.parseCondition(cdt);
        this.logger.debug("befor query: " + (null == condition ? null : condition.toString()));
        DBCursor cursor = this.collection.find((DBObject)condition);
        return new MongoResultSet<T>(this.entryClass, cursor);
    }

    @Override
    public void insertOrUpdate(Condition cdt, Condition opt) throws IllegalArgumentException, IllegalAccessException {
        this.update(cdt, opt, true, false);
    }

    @Override
    public void updateOne(Condition cdt, Condition opt) throws IllegalArgumentException, IllegalAccessException {
        this.update(cdt, opt, false, false);
    }

    @Override
    public void updateAll(Condition cdt, Condition opt) throws IllegalArgumentException, IllegalAccessException {
        this.update(cdt, opt, false, true);
    }

    private void update(Condition cdt, Condition opt, boolean upsert, boolean multi) throws IllegalArgumentException, IllegalAccessException {
        BasicDBObject condition = MongoUtil.parseCondition(cdt);
        this.logger.debug("befor query: " + (null == condition ? null : condition.toString()));
        this.collection.update((DBObject)condition, (DBObject)MongoUtil.parseCondition(opt), upsert, multi);
    }

    private void initCollection() {
        this.collection = this.client.getDB(this.dbName).getCollection(this.collectionName);
    }
}

