/*
 * Decompiled with CFR 0.152.
 */
package jadeutils.mongo;

import java.util.List;

public class MongoServer {
    private String host;
    private int port;
    private List<String[]> authList;

    public String toString() {
        StringBuffer sb = new StringBuffer("MongoServer {host=" + this.host + ", port=" + this.port + ", authList: [");
        if (null != this.authList && this.authList.size() > 0) {
            for (String[] str : this.authList) {
                sb.append("{");
                if (null != str && str.length > 0) {
                    for (int i = 0; i < str.length; ++i) {
                        sb.append(str[i]).append(",");
                    }
                }
                sb.append("}");
            }
        }
        return sb.append("]}").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.authList == null ? 0 : this.authList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MongoServer other = (MongoServer)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.authList != null) {
            if (other.authList == null) {
                return false;
            }
        } else {
            if (this.authList != other.authList) {
                return false;
            }
            if (this.authList.size() != other.authList.size()) {
                return false;
            }
        }
        return true;
    }

    public MongoServer(String host, int port, List<String[]> authList) {
        this.host = host;
        this.port = port;
        this.authList = authList;
    }

    public MongoServer(String host, int port) {
        new MongoServer(host, port, null);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<String[]> getAuthList() {
        return this.authList;
    }

    public void setAuthList(List<String[]> authList) {
        this.authList = authList;
    }
}

