/*
 * Decompiled with CFR 0.152.
 */
package net.jadedungeon.scalautil.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.jadedungeon.scalautil.common.Logging;
import net.jadedungeon.scalautil.dao.Dao;
import net.jadedungeon.scalautil.dao.DataSourcetHolder;
import net.jadedungeon.scalautil.dao.ORMUtil$;
import net.jadedungeon.scalautil.dao.Record;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h!B\u0010!\u0003\u0003I\u0003\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bE\u0003A\u0011\u0001*\t\u000fU\u0003!\u0019!C\u0001-\"1\u0011\r\u0001Q\u0001\n]CqA\u0019\u0001C\u0002\u0013\u00051\r\u0003\u0004h\u0001\u0001\u0006I\u0001\u001a\u0005\bQ\u0002\u0011\r\u0011\"\u0001j\u0011\u0019i\u0007\u0001)A\u0005U\"9a\u000e\u0001b\u0001\n\u0003y\u0007B\u0002;\u0001A\u0003%\u0001\u000fC\u0003v\u0001\u0011\u0005a\u000f\u0003\u0004v\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\tI\u0003\u0001C\u0001\u0003\u000bBq!!\u000b\u0001\t\u0003\tY\u0005C\u0004\u0002*\u0001!\t!!\u0016\t\u000f\u0005%\u0002\u0001\"\u0001\u0002d!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003g\u0002A\u0011AA@\u0011\u001d\t\u0019\b\u0001C\u0001\u0003\u000bCq!a\u001d\u0001\t\u0003\tY\tC\u0004\u0002t\u0001!\t!!%\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\u001a\"A\u0011\u0011\u0015\u0001!\n\u0013\t\u0019\u000bC\u0004\u00028\u0002!\t!!/\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003'\u0004A\u0011AAn\u0005=QEIQ\"UK6\u0004H.\u0019;f\t\u0006|'BA\u0011#\u0003\r!\u0017m\u001c\u0006\u0003G\u0011\n\u0011b]2bY\u0006,H/\u001b7\u000b\u0005\u00152\u0013a\u00036bI\u0016$WO\\4f_:T\u0011aJ\u0001\u0004]\u0016$8\u0001A\u000b\u0004U]\n5\u0003\u0002\u0001,c\u001d\u0003\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u001a4k\u0001k\u0011\u0001I\u0005\u0003i\u0001\u00121\u0001R1p!\t1t\u0007\u0004\u0001\u0005\u000ba\u0002!\u0019A\u001d\u0003\u0003Q\u000b\"AO\u001f\u0011\u00051Z\u0014B\u0001\u001f.\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\r A\u0013\ty\u0004E\u0001\u0004SK\u000e|'\u000f\u001a\t\u0003m\u0005#QA\u0011\u0001C\u0002\r\u0013\u0011aS\t\u0003u\u0011\u0003\"\u0001L#\n\u0005\u0019k#aA!osB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JI\u0001\u0007G>lWn\u001c8\n\u00051K%a\u0002'pO\u001eLgnZ\u0001\u000bI\u0006$\u0018m]8ve\u000e,\u0007C\u0001\u001aP\u0013\t\u0001\u0006EA\tECR\f7k\\;sG\u0016$\bj\u001c7eKJ\fa\u0001P5oSRtDCA*U!\u0011\u0011\u0004!\u000e!\t\u000b5\u0013\u0001\u0019\u0001(\u0002\u000f\u001d,g\u000eV=qKV\tq\u000b\u0005\u0002Y?6\t\u0011L\u0003\u0002[7\u00069!/\u001a4mK\u000e$(B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001-\u0017\u0002\u0005)f\u0004X-\u0001\u0005hK:$\u0016\u0010]3!\u0003%\u0001\u0018M]1n)f\u0004X-F\u0001e!\tAV-\u0003\u0002g3\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$\u0016\u0010]3\u0002\u0015A\f'/Y7UsB,\u0007%\u0001\u0004qCJ\fWn]\u000b\u0002UB\u0019Af[,\n\u00051l#!B!se\u0006L\u0018a\u00029be\u0006l7\u000fI\u0001\u000bK:$(/_\"mCN\u001cX#\u00019\u0011\u0007E\u0014X'D\u0001\\\u0013\t\u00198LA\u0003DY\u0006\u001c8/A\u0006f]R\u0014\u0018p\u00117bgN\u0004\u0013aB4fi\nK\u0018\n\u001a\u000b\u0004o\u0006\u0005\u0001c\u0001=|{6\t\u0011P\u0003\u0002{[\u0005!Q\u000f^5m\u0013\ta\u0018PA\u0002Uef\u00042\u0001\f@6\u0013\tyXF\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u0007Y\u0001\u0019\u0001!\u0002\u0005%$G#B<\u0002\b\u0005%\u0001BBA\u0002\u0019\u0001\u0007\u0001\tC\u0004\u0002\f1\u0001\r!!\u0004\u0002\u0011MDwn^\"pYN\u0004b!a\u0004\u0002\u001e\u0005\rb\u0002BA\t\u00033\u00012!a\u0005.\u001b\t\t)BC\u0002\u0002\u0018!\na\u0001\u0010:p_Rt\u0014bAA\u000e[\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t\u00191+\u001a;\u000b\u0007\u0005mQ\u0006\u0005\u0003\u0002\u0010\u0005\u0015\u0012\u0002BA\u0014\u0003C\u0011aa\u0015;sS:<\u0017AC9vKJLXj\u001c3fYR!\u0011QFA!!\u0011A80a\f\u0011\u000b\u0005E\u00121H\u001b\u000f\t\u0005M\u0012q\u0007\b\u0005\u0003'\t)$C\u0001/\u0013\r\tI$L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0007M+\u0017OC\u0002\u0002:5Bq!a\u0011\u000e\u0001\u0004\t\u0019#A\u0002tc2$b!!\f\u0002H\u0005%\u0003bBA\"\u001d\u0001\u0007\u00111\u0005\u0005\b\u0003\u0017q\u0001\u0019AA\u0007)\u0019\ti#!\u0014\u0002P!9\u00111I\bA\u0002\u0005\r\u0002bBA)\u001f\u0001\u0007\u00111K\u0001\u0007m\u0006dW/Z:\u0011\u000b\u0005E\u00121\b#\u0015\r\u00055\u0012qKA.\u0011\u001d\tI\u0006\u0005a\u0001\u0003G\t\u0001\"];fef\u001cFO\u001d\u0005\u0007QB\u0001\r!!\u0018\u0011\u000f\u0005=\u0011qLA\u0012\t&!\u0011\u0011MA\u0011\u0005\ri\u0015\r\u001d\u000b\t\u0003[\t)'a\u001a\u0002j!9\u0011\u0011L\tA\u0002\u0005\r\u0002bBA\u0006#\u0001\u0007\u0011Q\u0002\u0005\u0007QF\u0001\r!!\u0018\u0015\u0011\u00055\u0012QNA8\u0003cBq!a\u0011\u0013\u0001\u0004\t\u0019\u0003C\u0004\u0002\fI\u0001\r!!\u0004\t\u000f\u0005E#\u00031\u0001\u0002T\u0005)\u0011/^3ssR!\u0011qOA?!\u0011A80!\u001f\u0011\r\u0005E\u00121HA>!\u001d\ty!a\u0018\u0002$-Bq!a\u0011\u0014\u0001\u0004\t\u0019\u0003\u0006\u0004\u0002x\u0005\u0005\u00151\u0011\u0005\b\u0003\u0007\"\u0002\u0019AA\u0012\u0011\u001d\tY\u0001\u0006a\u0001\u0003\u001b!b!a\u001e\u0002\b\u0006%\u0005bBA\"+\u0001\u0007\u00111\u0005\u0005\b\u0003#*\u0002\u0019AA*)\u0019\t9(!$\u0002\u0010\"9\u0011\u0011\f\fA\u0002\u0005\r\u0002B\u00025\u0017\u0001\u0004\ti\u0006\u0006\u0005\u0002x\u0005M\u0015QSAL\u0011\u001d\tIf\u0006a\u0001\u0003GAq!a\u0003\u0018\u0001\u0004\ti\u0001\u0003\u0004i/\u0001\u0007\u0011Q\f\u000b\t\u0003o\nY*!(\u0002 \"9\u00111\t\rA\u0002\u0005\r\u0002bBA\u00061\u0001\u0007\u0011Q\u0002\u0005\b\u0003#B\u0002\u0019AA*\u0003%\u0011\u0017m]3Rk\u0016\u0014\u0018\u0010\u0006\u0005\u0002&\u0006E\u00161WA[!\u0011A80a*\u0011\t\u0005%\u0016QV\u0007\u0003\u0003WS1!a\u0011^\u0013\u0011\ty+a+\u0003\u0013I+7/\u001e7u'\u0016$\bbBA\"3\u0001\u0007\u00111\u0005\u0005\b\u0003\u0017I\u0002\u0019AA\u0007\u0011\u001d\t\t&\u0007a\u0001\u0003'\na\"\u001b8tKJ$xJ]+qI\u0006$X\r\u0006\u0003\u0002<\u0006\r\u0007\u0003\u0002=|\u0003{\u00032\u0001LA`\u0013\r\t\t-\f\u0002\u0004\u0013:$\bBBAc5\u0001\u0007Q'A\u0003n_\u0012,G.\u0001\u0004j]N,'\u000f\u001e\u000b\u0005\u0003w\u000bY\r\u0003\u0004\u0002Fn\u0001\r!N\u0001\u0007kB$\u0017\r^3\u0015\t\u0005m\u0016\u0011\u001b\u0005\u0007\u0003\u000bd\u0002\u0019A\u001b\u0002\u001b\u0015DXmY;uKV\u0003H-\u0019;f)\u0019\tY,a6\u0002Z\"9\u0011\u0011L\u000fA\u0002\u0005\r\u0002B\u00025\u001e\u0001\u0004\ti\u0006\u0006\u0004\u0002<\u0006u\u0017q\u001c\u0005\b\u0003\u0007r\u0002\u0019AA\u0012\u0011\u001d\t\tF\ba\u0001\u0003'\u0002")
public abstract class JDBCTemplateDao<T extends Record<K>, K>
implements Dao<T, K>,
Logging {
    private final DataSourcetHolder datasource;
    private final Type genType;
    private final ParameterizedType paramType;
    private final Type[] params;
    private final Class<T> entryClass;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public Logger getLoggerByName(String name) {
        return Logging.getLoggerByName$(this, name);
    }

    @Override
    public void logTrace(String msg, Seq<Object> refs) {
        Logging.logTrace$(this, msg, refs);
    }

    @Override
    public void logDebug(String msg, Seq<Object> refs) {
        Logging.logDebug$(this, msg, refs);
    }

    @Override
    public void logInfo(String msg, Seq<Object> refs) {
        Logging.logInfo$(this, msg, refs);
    }

    @Override
    public void logWarn(String msg, Seq<Object> refs) {
        Logging.logWarn$(this, msg, refs);
    }

    @Override
    public void logError(String msg, Seq<Object> refs) {
        Logging.logError$(this, msg, refs);
    }

    private Logger logger$lzycompute() {
        JDBCTemplateDao jDBCTemplateDao = this;
        synchronized (jDBCTemplateDao) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Type genType() {
        return this.genType;
    }

    public ParameterizedType paramType() {
        return this.paramType;
    }

    public Type[] params() {
        return this.params;
    }

    public Class<T> entryClass() {
        return this.entryClass;
    }

    @Override
    public Try<Option<T>> getById(K id) {
        return this.getById(id, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    @Override
    public Try<Option<T>> getById(K id, Set<String> showCols) {
        Failure failure;
        if (id == null) {
            failure = new Failure((Throwable)new RuntimeException("id cannot be null"));
        } else {
            try {
                Failure failure2;
                String table = (String)ORMUtil$.MODULE$.getTableName(this.entryClass(), this.datasource.dialect()).get();
                Seq<String> columns = ORMUtil$.MODULE$.getColumns(this.entryClass(), showCols);
                String colStr = ((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)s -> new StringOps(Predef$.MODULE$.augmentString("`%s`")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})), Seq$.MODULE$.canBuildFrom())).mkString(",");
                String sql = new StringBuilder(26).append("select ").append(colStr).append(" from ").append(table).append(" where id = ?").toString();
                Try<Seq<T>> try_ = this.queryModel(sql, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id}))));
                if (try_ instanceof Failure) {
                    Failure failure3 = (Failure)try_;
                    Throwable f = failure3.exception();
                    failure2 = new Failure(f);
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Seq recs = (Seq)success.value();
                    failure2 = recs.size() == 1 ? new Success((Object)new Some(recs.apply(0))) : (recs.size() < 1 ? new Success((Object)None$.MODULE$) : new Failure((Throwable)new RuntimeException("rec with same primary key")));
                } else {
                    throw new MatchError(try_);
                }
                failure = failure2;
            }
            catch (Exception e) {
                failure = new Failure((Throwable)e);
            }
        }
        return failure;
    }

    @Override
    public Try<Seq<T>> queryModel(String sql) {
        return this.queryModel(sql, (Set<String>)Predef$.MODULE$.Set().empty(), (Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    @Override
    public Try<Seq<T>> queryModel(String sql, Set<String> showCols) {
        return this.queryModel(sql, showCols, (Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    @Override
    public Try<Seq<T>> queryModel(String sql, Seq<Object> values) {
        return this.queryModel(sql, (Set<String>)Predef$.MODULE$.Set().empty(), values);
    }

    @Override
    public Try<Seq<T>> queryModel(String queryStr, Map<String, Object> params) {
        return this.queryModel(queryStr, (Set<String>)Predef$.MODULE$.Set().empty(), params);
    }

    @Override
    public Try<Seq<T>> queryModel(String queryStr, Set<String> showCols, Map<String, Object> params) {
        Seq<Object> values = ORMUtil$.MODULE$.parseValues(queryStr, params);
        String sql = ORMUtil$.MODULE$.parseQuery(queryStr);
        return this.queryModel(sql, showCols, values);
    }

    @Override
    public Try<Seq<T>> queryModel(String sql, Set<String> showCols, Seq<Object> values) {
        Failure failure;
        Try<ResultSet> try_ = this.baseQuery(sql, showCols, values);
        if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable f = failure2.exception();
            failure = new Failure(f);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            ResultSet rs = (ResultSet)success.value();
            Seq<T> result = ORMUtil$.MODULE$.allRow2obj(this.entryClass(), showCols, rs);
            if (!this.datasource.isInTransaction()) {
                this.datasource.retrunBack();
            }
            failure = new Success(result);
        } else {
            throw new MatchError(try_);
        }
        return failure;
    }

    @Override
    public Try<Seq<Map<String, Object>>> query(String sql) {
        return this.query(sql, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    @Override
    public Try<Seq<Map<String, Object>>> query(String sql, Set<String> showCols) {
        return this.query(sql, showCols, (Seq<Object>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    public Try<Seq<Map<String, Object>>> query(String sql, Seq<Object> values) {
        return this.query(sql, (Set<String>)Predef$.MODULE$.Set().empty(), values);
    }

    @Override
    public Try<Seq<Map<String, Object>>> query(String queryStr, Map<String, Object> params) {
        return this.query(queryStr, (Set<String>)Predef$.MODULE$.Set().empty(), params);
    }

    @Override
    public Try<Seq<Map<String, Object>>> query(String queryStr, Set<String> showCols, Map<String, Object> params) {
        Seq<Object> values = ORMUtil$.MODULE$.parseValues(queryStr, params);
        String sql = ORMUtil$.MODULE$.parseQuery(queryStr);
        return this.query(sql, showCols, values);
    }

    @Override
    public Try<Seq<Map<String, Object>>> query(String sql, Set<String> showCols, Seq<Object> values) {
        Failure failure;
        Try<ResultSet> try_ = this.baseQuery(sql, showCols, values);
        if (try_ instanceof Failure) {
            Failure failure2 = (Failure)try_;
            Throwable f = failure2.exception();
            failure = new Failure(f);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            ResultSet rs = (ResultSet)success.value();
            Seq<Map<String, Object>> result = ORMUtil$.MODULE$.allRow2map(showCols, rs);
            if (!this.datasource.isInTransaction()) {
                this.datasource.retrunBack();
            }
            failure = new Success(result);
        } else {
            throw new MatchError(try_);
        }
        return failure;
    }

    private Try<ResultSet> baseQuery(String sql, Set<String> showCols, Seq<Object> values) {
        Failure failure;
        try {
            this.logDebug("\n sql-query: {} \n      cols: {} \n      vals: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql, showCols, values}));
            Try<Connection> conn = this.datasource.connection();
            PreparedStatement ps = ORMUtil$.MODULE$.setQueryValues(((Connection)conn.get()).prepareStatement(sql), values);
            ResultSet rs = ps.executeQuery();
            failure = new Success((Object)rs);
        }
        catch (Exception e) {
            failure = new Failure((Throwable)e);
        }
        return failure;
    }

    @Override
    public Try<Object> insertOrUpdate(T model) {
        Try<Object> try_;
        String table = (String)ORMUtil$.MODULE$.getTableName(this.entryClass(), this.datasource.dialect()).get();
        String sql = new StringBuilder(39).append("select count(1) as c from ").append(table).append(" where id = ?").toString();
        Try<Seq<Map<String, Object>>> try_2 = this.query(sql, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Record)model).id()}))));
        if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable f = failure.exception();
            try_ = new Try<Object>(f);
        } else if (try_2 instanceof Success) {
            long l;
            Success success = (Success)try_2;
            Seq recs = (Seq)success.value();
            if (recs.length() > 0 && ((MapLike)recs.apply(0)).contains((Object)"c")) {
                long l2;
                Object object = ((MapLike)recs.apply(0)).getOrElse((Object)"c", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
                if (object instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)object);
                    l2 = n;
                } else {
                    long l3;
                    l2 = object instanceof Long ? (l3 = BoxesRunTime.unboxToLong((Object)object)) : 0L;
                }
                l = l2;
            } else {
                l = 0L;
            }
            long count = l;
            this.logDebug("insertOrUpdate old rec: {}, count: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{recs, BoxesRunTime.boxToLong((long)count)}));
            try_ = count > 0L ? this.update(model) : this.insert(model);
        } else {
            throw new MatchError(try_2);
        }
        return try_;
    }

    @Override
    public Try<Object> insert(T model) {
        Try<Object> try_;
        if (model == null) {
            try_ = new Try<Object>((Throwable)new RuntimeException("Rec caonnot by null "));
        } else if (((Record)model).id() == null) {
            try_ = new Failure((Throwable)new RuntimeException("PrimeKey id caonnot by null "));
        } else {
            String table = (String)ORMUtil$.MODULE$.getTableName(this.entryClass(), this.datasource.dialect()).get();
            Seq<Tuple2<String, Object>> seq = ORMUtil$.MODULE$.obj2kv(this.entryClass(), model, (Set<String>)Predef$.MODULE$.Set().empty());
            Tuple2 xx = seq.unzip((Function1)Predef$.MODULE$.$conforms());
            String colStr = ((TraversableOnce)((TraversableLike)xx._1()).map((Function1 & Serializable & scala.Serializable)s -> new StringOps(Predef$.MODULE$.augmentString("`%s`")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})), Seq$.MODULE$.canBuildFrom())).mkString(",");
            Seq values = (Seq)xx._2();
            String markStr = ((TraversableOnce)((TraversableLike)xx._1()).map((Function1 & Serializable & scala.Serializable)s -> "?", Seq$.MODULE$.canBuildFrom())).mkString(",");
            String sql = new StringBuilder(25).append("INSERT INTO ").append(table).append(" (").append(colStr).append(") VALUES (").append(markStr).append(")").toString();
            try_ = this.executeUpdate(sql, (Seq<Object>)values);
        }
        return try_;
    }

    @Override
    public Try<Object> update(T model) {
        String table = (String)ORMUtil$.MODULE$.getTableName(this.entryClass(), this.datasource.dialect()).get();
        Seq<Tuple2<String, Object>> seq = ORMUtil$.MODULE$.obj2kv(this.entryClass(), model, (Set<String>)Predef$.MODULE$.Set().empty());
        Tuple2 xx = seq.unzip((Function1)Predef$.MODULE$.$conforms());
        String colStr = ((TraversableOnce)((TraversableLike)xx._1()).map((Function1 & Serializable & scala.Serializable)s -> new StringOps(Predef$.MODULE$.augmentString("`%s`=?")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})), Seq$.MODULE$.canBuildFrom())).mkString(",");
        Seq values = (Seq)((SeqLike)xx._2()).$colon$plus(((Record)model).id(), Seq$.MODULE$.canBuildFrom());
        String sql = new StringBuilder(25).append("UPDATE ").append(table).append(" SET ").append(colStr).append(" WHERE id = ?").toString();
        return this.executeUpdate(sql, (Seq<Object>)values);
    }

    @Override
    public Try<Object> executeUpdate(String queryStr, Map<String, Object> params) {
        Seq<Object> values = ORMUtil$.MODULE$.parseValues(queryStr, params);
        String sql = ORMUtil$.MODULE$.parseQuery(queryStr);
        return this.executeUpdate(sql, values);
    }

    @Override
    public Try<Object> executeUpdate(String sql, Seq<Object> values) {
        Failure result;
        Failure failure;
        this.logDebug("\nsql-update: {} \n     vals: {}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql, values}));
        Try<Connection> conn = this.datasource.connection();
        PreparedStatement ps = ((Connection)conn.get()).prepareStatement(sql);
        try {
            ORMUtil$.MODULE$.setQueryValues(ps, values);
            failure = new Success((Object)BoxesRunTime.boxToInteger((int)ps.executeUpdate()));
        }
        catch (Exception e) {
            failure = result = new Failure((Throwable)e);
        }
        if (!this.datasource.isInTransaction()) {
            this.datasource.retrunBack();
        }
        ps.close();
        return result;
    }

    public JDBCTemplateDao(DataSourcetHolder datasource) {
        this.datasource = datasource;
        Logging.$init$(this);
        this.genType = this.getClass().getGenericSuperclass();
        this.paramType = (ParameterizedType)this.genType();
        this.params = this.paramType().getActualTypeArguments();
        this.entryClass = (Class)this.params()[0];
    }
}

