/*
 * Decompiled with CFR 0.152.
 */
package net.jadler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import net.jadler.KeyValues;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class Request {
    private static final Charset DEFAULT_ENCODING = Charset.forName("ISO-8859-1");
    private final String method;
    private final URI requestURI;
    private final byte[] body;
    private final KeyValues parameters;
    private final KeyValues headers;
    private final Charset encoding;

    private Request(String method, URI requestURI, KeyValues headers, byte[] body, Charset encoding) {
        Validate.notEmpty((String)method, (String)"method cannot be empty");
        this.method = method;
        Validate.notNull((Object)requestURI, (String)"requestURI cannot be null");
        this.requestURI = requestURI;
        this.encoding = encoding;
        Validate.notNull((Object)body, (String)"body cannot be null, use an empty array instead");
        this.body = body;
        Validate.notNull((Object)headers, (String)"headers cannot be null");
        this.headers = headers;
        this.parameters = this.readParameters();
    }

    public String getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.requestURI;
    }

    public KeyValues getParameters() {
        return this.parameters;
    }

    public KeyValues getHeaders() {
        return this.headers;
    }

    public InputStream getBodyAsStream() {
        return new ByteArrayInputStream(this.body);
    }

    public byte[] getBodyAsBytes() {
        return (byte[])this.body.clone();
    }

    public String getBodyAsString() {
        return new String(this.body, this.getEffectiveEncoding());
    }

    public String getContentType() {
        return this.headers.getValue("content-type");
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public static Builder builder() {
        return new Builder();
    }

    private KeyValues readParameters() {
        KeyValues params = this.readParametersFromQueryString();
        if (!StringUtils.isBlank((String)this.getContentType()) && this.getContentType().contains("application/x-www-form-urlencoded") && ("POST".equalsIgnoreCase(this.getMethod()) || "PUT".equalsIgnoreCase(this.getMethod()))) {
            params = params.addAll(this.readParametersFromBody());
        }
        return params;
    }

    private KeyValues readParametersFromQueryString() {
        return this.readParametersFromString(this.requestURI.getRawQuery());
    }

    private KeyValues readParametersFromBody() {
        return this.readParametersFromString(new String(this.body, this.getEffectiveEncoding()));
    }

    private KeyValues readParametersFromString(String parametersString) {
        String[] pairs;
        KeyValues res = new KeyValues();
        if (StringUtils.isBlank((String)parametersString)) {
            return res;
        }
        for (String pair : pairs = parametersString.split("&")) {
            int idx = pair.indexOf(61);
            if (idx > -1) {
                String name = StringUtils.substring((String)pair, (int)0, (int)idx);
                String value = StringUtils.substring((String)pair, (int)(idx + 1));
                res = res.add(name, value);
                continue;
            }
            res = res.add(pair, "");
        }
        return res;
    }

    private Charset getEffectiveEncoding() {
        return this.encoding == null ? DEFAULT_ENCODING : this.encoding;
    }

    public String toString() {
        return "Request{method='" + this.method + '\'' + ", requestURI=" + this.requestURI + ", parameters=" + this.parameters + ", headers=" + this.headers + '}';
    }

    public static class Builder {
        private String method;
        private URI requestURI;
        private byte[] body = new byte[0];
        private KeyValues headers = new KeyValues();
        private Charset encoding = null;

        private Builder() {
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder requestURI(URI requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        public Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        public Builder headers(KeyValues headers) {
            Validate.notNull((Object)headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder header(String name, String value) {
            Validate.notEmpty((String)name, (String)"name cannot be blank");
            Validate.notNull((Object)value, (String)"value cannot be null");
            this.headers = this.headers.add(name.toLowerCase(), value);
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public Request build() {
            return new Request(this.method, this.requestURI, this.headers, this.body, this.encoding);
        }
    }
}

