/*
 * Decompiled with CFR 0.152.
 */
package net.jadler;

import java.util.ArrayList;
import java.util.List;
import net.jadler.Request;
import net.jadler.RequestMatching;
import net.jadler.matchers.BodyRequestMatcher;
import net.jadler.matchers.HeaderRequestMatcher;
import net.jadler.matchers.MethodRequestMatcher;
import net.jadler.matchers.ParameterRequestMatcher;
import net.jadler.matchers.PathRequestMatcher;
import net.jadler.matchers.QueryStringRequestMatcher;
import net.jadler.matchers.RawBodyRequestMatcher;
import org.apache.commons.lang.Validate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractRequestMatching<T extends RequestMatching<T>>
implements RequestMatching<T> {
    protected final List<Matcher<? super Request>> predicates = new ArrayList<Matcher<? super Request>>();

    protected AbstractRequestMatching() {
    }

    @Override
    public T that(Matcher<? super Request> predicate) {
        Validate.notNull(predicate, (String)"predicate cannot be null");
        this.predicates.add(predicate);
        return (T)this;
    }

    @Override
    public T havingMethodEqualTo(String method) {
        Validate.notEmpty((String)method, (String)"method cannot be empty");
        return this.havingMethod((Matcher<String>)Matchers.equalToIgnoringCase((String)method));
    }

    @Override
    public T havingMethod(Matcher<? super String> predicate) {
        Validate.notNull(predicate, (String)"predicate cannot be null");
        return this.that((Matcher<Request>)MethodRequestMatcher.requestMethod(predicate));
    }

    @Override
    public T havingBodyEqualTo(String requestBody) {
        Validate.notNull((Object)requestBody, (String)"requestBody cannot be null, use an empty string instead");
        return this.havingBody((Matcher<String>)Matchers.equalTo((Object)requestBody));
    }

    @Override
    public T havingBody(Matcher<? super String> predicate) {
        Validate.notNull(predicate, (String)"predicate cannot be null");
        return this.that((Matcher<Request>)BodyRequestMatcher.requestBody(predicate));
    }

    @Override
    public T havingRawBodyEqualTo(byte[] requestBody) {
        Validate.notNull((Object)requestBody, (String)"requestBody cannot be null, use an empty array instead");
        return this.that((Matcher<Request>)RawBodyRequestMatcher.requestRawBody((Matcher<byte[]>)Matchers.equalTo((Object)requestBody)));
    }

    @Override
    public T havingPathEqualTo(String path) {
        Validate.notEmpty((String)path, (String)"path cannot be empty");
        return this.havingPath((Matcher<String>)Matchers.equalTo((Object)path));
    }

    @Override
    public T havingPath(Matcher<? super String> predicate) {
        Validate.notNull(predicate, (String)"predicate cannot be null");
        return this.that((Matcher<Request>)PathRequestMatcher.requestPath(predicate));
    }

    @Override
    public T havingQueryStringEqualTo(String queryString) {
        return this.havingQueryString((Matcher<String>)Matchers.equalTo((Object)queryString));
    }

    @Override
    public T havingQueryString(Matcher<? super String> predicate) {
        Validate.notNull(predicate, (String)"predicate cannot be null");
        return this.that((Matcher<Request>)QueryStringRequestMatcher.requestQueryString(predicate));
    }

    @Override
    public T havingParameterEqualTo(String name, String value) {
        Validate.notNull((Object)value, (String)"value cannot be null");
        return this.havingParameter(name, (Matcher<List<String>>)Matchers.hasItem((Object)value));
    }

    @Override
    public T havingParameter(String name, Matcher<? super List<String>> predicate) {
        Validate.notEmpty((String)name, (String)"name cannot be empty");
        Validate.notNull(predicate, (String)"predicate cannot be null");
        return this.that((Matcher<Request>)ParameterRequestMatcher.requestParameter(name, predicate));
    }

    @Override
    public T havingParameter(String name) {
        return this.havingParameter(name, (Matcher<List<String>>)Matchers.notNullValue());
    }

    @Override
    public T havingParameters(String ... names) {
        for (String name : names) {
            this.havingParameter(name);
        }
        return (T)this;
    }

    @Override
    public T havingHeaderEqualTo(String name, String value) {
        Validate.notNull((Object)value, (String)"value cannot be null");
        return this.havingHeader(name, (Matcher<List<String>>)Matchers.hasItem((Object)value));
    }

    @Override
    public T havingHeader(String name, Matcher<? super List<String>> predicate) {
        Validate.notEmpty((String)name, (String)"name cannot be empty");
        Validate.notNull(predicate, (String)"predicate cannot be null");
        return this.that((Matcher<Request>)HeaderRequestMatcher.requestHeader(name, predicate));
    }

    @Override
    public T havingHeader(String name) {
        return this.havingHeader(name, (Matcher<List<String>>)Matchers.notNullValue());
    }

    @Override
    public T havingHeaders(String ... names) {
        Validate.notNull((Object)names, (String)"names cannot be null");
        for (String name : names) {
            this.havingHeader(name);
        }
        return (T)this;
    }
}

