/*
 * Decompiled with CFR 0.152.
 */
package net.jadler;

import java.nio.charset.Charset;
import net.jadler.JadlerMocker;
import net.jadler.exception.JadlerException;
import net.jadler.mocking.Verifying;
import net.jadler.stubbing.RequestStubbing;
import net.jadler.stubbing.server.StubHttpServer;
import net.jadler.stubbing.server.StubHttpServerManager;

public class Jadler {
    private static ThreadLocal<JadlerMocker> jadlerMockerContainer = new InheritableThreadLocal<JadlerMocker>();
    private static String JETTY_SERVER_CLASS = "net.jadler.stubbing.server.jetty.JettyStubHttpServer";

    private Jadler() {
    }

    public static AdditionalConfiguration initJadler() {
        return Jadler.initInternal(new JadlerMocker(Jadler.getJettyServer()));
    }

    public static AdditionalConfiguration initJadlerListeningOn(int port) {
        return Jadler.initInternal(new JadlerMocker(Jadler.getJettyServer(port)));
    }

    public static AdditionalConfiguration initJadlerUsing(StubHttpServer server) {
        return Jadler.initInternal(new JadlerMocker(server));
    }

    public static void closeJadler() {
        StubHttpServerManager serverManager = jadlerMockerContainer.get();
        if (serverManager != null && serverManager.isStarted()) {
            serverManager.close();
        }
        jadlerMockerContainer.set(null);
    }

    public static int port() {
        Jadler.checkInitialized();
        return jadlerMockerContainer.get().getStubHttpServerPort();
    }

    public static RequestStubbing onRequest() {
        Jadler.checkInitialized();
        return jadlerMockerContainer.get().onRequest();
    }

    public static Verifying verifyThatRequest() {
        Jadler.checkInitialized();
        return jadlerMockerContainer.get().verifyThatRequest();
    }

    private static void checkInitialized() {
        if (jadlerMockerContainer.get() == null) {
            throw new IllegalStateException("Jadler has not been initialized yet.");
        }
    }

    private static AdditionalConfiguration initInternal(JadlerMocker jadlerMocker) {
        if (jadlerMockerContainer.get() != null) {
            throw new IllegalStateException("Jadler seems to have been initialized already.");
        }
        jadlerMockerContainer.set(jadlerMocker);
        jadlerMocker.start();
        return AdditionalConfiguration.INSTANCE;
    }

    private static StubHttpServer getJettyServer() {
        Class<?> clazz = Jadler.getJettyStubHttpServerClass();
        try {
            return (StubHttpServer)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JadlerException("Cannot instantiate default Jetty stub server", e);
        }
    }

    private static StubHttpServer getJettyServer(int port) {
        Class<?> clazz = Jadler.getJettyStubHttpServerClass();
        try {
            return (StubHttpServer)clazz.getConstructor(Integer.TYPE).newInstance(port);
        }
        catch (Exception e) {
            throw new JadlerException("Cannot instantiate default Jetty stub server with the given port", e);
        }
    }

    private static Class<?> getJettyStubHttpServerClass() {
        try {
            return Class.forName(JETTY_SERVER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new JadlerException("Class " + JETTY_SERVER_CLASS + " cannot be found. " + "Either add jadler-jetty to your classpath or use the initJadlerUsing method to specify the " + "stub server explicitly.", e);
        }
    }

    public static class AdditionalConfiguration {
        private static final AdditionalConfiguration INSTANCE = new AdditionalConfiguration();

        private AdditionalConfiguration() {
        }

        public OngoingConfiguration that() {
            return OngoingConfiguration.INSTANCE;
        }
    }

    public static class OngoingConfiguration {
        private static final OngoingConfiguration INSTANCE = new OngoingConfiguration();

        private OngoingConfiguration() {
        }

        public OngoingConfiguration respondsWithDefaultStatus(int defaultStatus) {
            ((JadlerMocker)jadlerMockerContainer.get()).setDefaultStatus(defaultStatus);
            return this;
        }

        public OngoingConfiguration respondsWithDefaultHeader(String name, String value) {
            ((JadlerMocker)jadlerMockerContainer.get()).addDefaultHeader(name, value);
            return this;
        }

        public OngoingConfiguration respondsWithDefaultEncoding(Charset defaultEncoding) {
            ((JadlerMocker)jadlerMockerContainer.get()).setDefaultEncoding(defaultEncoding);
            return this;
        }

        public OngoingConfiguration skipsRequestsRecording() {
            ((JadlerMocker)jadlerMockerContainer.get()).setRecordRequests(false);
            return this;
        }

        public OngoingConfiguration respondsWithDefaultContentType(String defaultContentType) {
            return this.respondsWithDefaultHeader("Content-Type", defaultContentType);
        }
    }
}

