/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.mocking;

import java.util.Iterator;
import net.jadler.AbstractRequestMatching;
import net.jadler.RequestManager;
import net.jadler.mocking.VerificationException;
import org.apache.commons.lang.Validate;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class Verifying
extends AbstractRequestMatching<Verifying> {
    private final RequestManager requestManager;

    public Verifying(RequestManager requestManager) {
        Validate.notNull((Object)requestManager, (String)"requestManager cannot be null");
        this.requestManager = requestManager;
    }

    public void receivedTimes(Matcher<Integer> predicate) {
        Validate.notNull(predicate, (String)"predicate cannot be null");
        int cnt = this.requestManager.numberOfRequestsMatching(this.predicates);
        if (!predicate.matches((Object)cnt)) {
            throw new VerificationException(this.mismatchDescription(cnt, predicate));
        }
    }

    public void receivedTimes(int count) {
        Validate.isTrue((count >= 0 ? 1 : 0) != 0, (String)"count cannot be negative");
        this.receivedTimes((Matcher<Integer>)Matchers.equalTo((Object)count));
    }

    public void receivedOnce() {
        this.receivedTimes(1);
    }

    public void receivedNever() {
        this.receivedTimes(0);
    }

    private String mismatchDescription(int cnt, Matcher<Integer> callsMatcher) {
        StringDescription desc = new StringDescription();
        desc.appendText("The number of http requests");
        if (!this.predicates.isEmpty()) {
            desc.appendText(" having");
        }
        desc.appendText("\n");
        Iterator it = this.predicates.iterator();
        while (it.hasNext()) {
            desc.appendText("  ");
            desc.appendDescriptionOf((SelfDescribing)it.next());
            if (it.hasNext()) {
                desc.appendText(" AND");
            }
            desc.appendText("\n");
        }
        desc.appendText("was expected to be ");
        desc.appendDescriptionOf(callsMatcher);
        desc.appendText(", but ");
        callsMatcher.describeMismatch((Object)cnt, (Description)desc);
        return desc.toString();
    }
}

