/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jadler.AbstractRequestMatching;
import net.jadler.exception.JadlerException;
import net.jadler.stubbing.HttpStub;
import net.jadler.stubbing.MutableStubResponse;
import net.jadler.stubbing.RequestStubbing;
import net.jadler.stubbing.Responder;
import net.jadler.stubbing.ResponseStubbing;
import net.jadler.stubbing.StaticResponder;
import net.jadler.stubbing.StubResponse;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class Stubbing
extends AbstractRequestMatching<RequestStubbing>
implements RequestStubbing,
ResponseStubbing {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    Responder responder;
    final List<MutableStubResponse> stubResponses = new ArrayList<MutableStubResponse>();
    private final MultiMap defaultHeaders = new MultiValueMap();
    private final int defaultStatus;
    private final Charset defaultEncoding;

    Stubbing(Charset defaultEncoding, int defaultStatus, MultiMap defaultHeaders) {
        this.defaultHeaders.putAll((Map)defaultHeaders);
        this.defaultStatus = defaultStatus;
        this.defaultEncoding = defaultEncoding;
        this.responder = null;
    }

    @Override
    public ResponseStubbing respond() {
        return this.thenRespond();
    }

    @Override
    public ResponseStubbing thenRespond() {
        MutableStubResponse response = new MutableStubResponse();
        response.addHeaders(this.defaultHeaders);
        response.setStatus(this.defaultStatus);
        response.setEncoding(this.defaultEncoding);
        response.setBody("");
        this.stubResponses.add(response);
        return this;
    }

    @Override
    public void respondUsing(Responder responder) {
        Validate.notNull((Object)responder, (String)"responder cannot be null");
        this.responder = responder;
    }

    @Override
    public ResponseStubbing withContentType(String contentType) {
        this.currentResponse().setHeaderCaseInsensitive(CONTENT_TYPE_HEADER, contentType);
        return this;
    }

    @Override
    public ResponseStubbing withEncoding(Charset encoding) {
        this.currentResponse().setEncoding(encoding);
        return this;
    }

    @Override
    public ResponseStubbing withBody(String responseBody) {
        this.currentResponse().setBody(responseBody);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseStubbing withBody(Reader reader) {
        try {
            String responseBody;
            try {
                responseBody = IOUtils.toString((Reader)reader);
            }
            catch (IOException ex) {
                throw new JadlerException("An error ocurred while reading the response body from the given Reader instance.", ex);
            }
            ResponseStubbing responseStubbing = this.withBody(responseBody);
            return responseStubbing;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseStubbing withBody(InputStream is) {
        try {
            byte[] responseBody;
            try {
                responseBody = IOUtils.toByteArray((InputStream)is);
            }
            catch (IOException e) {
                throw new JadlerException("A problem occurred while reading the given input stream", e);
            }
            ResponseStubbing responseStubbing = this.withBody(responseBody);
            return responseStubbing;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Override
    public ResponseStubbing withBody(byte[] responseBody) {
        this.currentResponse().setBody(responseBody);
        return this;
    }

    @Override
    public ResponseStubbing withHeader(String name, String value) {
        this.currentResponse().addHeader(name, value);
        return this;
    }

    @Override
    public ResponseStubbing withStatus(int status) {
        this.currentResponse().setStatus(status);
        return this;
    }

    @Override
    public ResponseStubbing withDelay(long delayValue, TimeUnit delayUnit) {
        this.currentResponse().setDelay(TimeUnit.MILLISECONDS.convert(delayValue, delayUnit));
        return this;
    }

    public HttpStub createRule() {
        if (this.responder != null) {
            return new HttpStub(this.predicates, this.responder);
        }
        ArrayList<StubResponse> res = new ArrayList<StubResponse>(this.stubResponses.size());
        for (MutableStubResponse msr : this.stubResponses) {
            res.add(msr.toStubResponse());
        }
        return new HttpStub(this.predicates, new StaticResponder(res));
    }

    private MutableStubResponse currentResponse() {
        return this.stubResponses.get(this.stubResponses.size() - 1);
    }
}

