/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.jadler.Request;
import net.jadler.stubbing.Responder;
import net.jadler.stubbing.StubResponse;
import org.apache.commons.lang.Validate;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class HttpStub {
    private final Collection<Matcher<? super Request>> predicates;
    private final Responder responder;

    public HttpStub(Collection<Matcher<? super Request>> predicates, Responder responder) {
        Validate.notNull(predicates, (String)"predicates cannot be null, use an empty list instead");
        this.predicates = new ArrayList<Matcher<? super Request>>(predicates);
        Validate.notNull((Object)responder, (String)"responder cannot be null");
        this.responder = responder;
    }

    public boolean matches(Request request) {
        return Matchers.allOf(this.predicates).matches((Object)request);
    }

    public StubResponse nextResponse(Request request) {
        return this.responder.nextResponse(request);
    }

    public String describeMismatch(Request request) {
        StringDescription desc = new StringDescription();
        boolean first = true;
        for (Matcher<? super Request> m : this.predicates) {
            if (m.matches((Object)request)) continue;
            if (!first) {
                desc.appendText(" AND\n");
            }
            desc.appendText("  ");
            m.describeMismatch((Object)request, (Description)desc);
            first = false;
        }
        return desc.toString();
    }

    public String toString() {
        StringDescription desc = new StringDescription();
        desc.appendText("WHEN request (\n");
        Iterator<Matcher<? super Request>> it = this.predicates.iterator();
        while (it.hasNext()) {
            desc.appendText("  ");
            desc.appendDescriptionOf((SelfDescribing)it.next());
            if (!it.hasNext()) continue;
            desc.appendText(" AND\n");
        }
        desc.appendText(")\n");
        desc.appendText("THEN respond with ");
        desc.appendText(this.responder.toString());
        return desc.toString();
    }
}

