/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jdk;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import net.jadler.RequestManager;
import net.jadler.exception.JadlerException;
import net.jadler.stubbing.server.StubHttpServer;
import net.jadler.stubbing.server.jdk.JdkHandler;
import org.apache.commons.lang.Validate;

public class JdkStubHttpServer
implements StubHttpServer {
    private final HttpServer server;

    public JdkStubHttpServer(int port) {
        Validate.isTrue((port >= 0 ? 1 : 0) != 0, (String)"port cannot be a negative number");
        try {
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
        }
        catch (IOException e) {
            throw new JadlerException("Cannot create JDK server", (Throwable)e);
        }
    }

    public JdkStubHttpServer() {
        this(0);
    }

    public void registerRequestManager(RequestManager ruleProvider) {
        Validate.notNull((Object)ruleProvider, (String)"ruleProvider cannot be null");
        this.server.createContext("/", new JdkHandler(ruleProvider));
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop(0);
    }

    public int getPort() {
        return this.server.getAddress().getPort();
    }
}

