/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jdk;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import net.jadler.KeyValues;
import net.jadler.Request;
import net.jadler.RequestManager;
import net.jadler.stubbing.StubResponse;
import net.jadler.stubbing.server.jdk.RequestUtils;
import org.apache.commons.lang.Validate;

class JdkHandler
implements HttpHandler {
    private final RequestManager requestManager;

    public JdkHandler(RequestManager requestManager) {
        Validate.notNull((Object)requestManager, (String)"requestManager cannot be null");
        this.requestManager = requestManager;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Request req = RequestUtils.convert(httpExchange);
        StubResponse stubResponse = this.requestManager.provideStubResponseFor(req);
        byte[] body = stubResponse.getBody();
        this.processDelay(stubResponse.getDelay());
        KeyValues headers = stubResponse.getHeaders();
        for (String key : headers.getKeys()) {
            for (String value : headers.getValues(key)) {
                httpExchange.getResponseHeaders().add(key, value);
            }
        }
        httpExchange.sendResponseHeaders(stubResponse.getStatus(), body.length > 0 ? (long)body.length : -1L);
        if (body.length > 0) {
            OutputStream outputStream = httpExchange.getResponseBody();
            outputStream.write(body);
            outputStream.close();
        }
    }

    private void processDelay(long delay) {
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

