/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jdk;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jadler.Request;
import org.apache.commons.io.IOUtils;

class RequestUtils {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i).*\\bcharset=\\s*\"?([^\\s;\"]*)");

    RequestUtils() {
    }

    static Request convert(HttpExchange httpExchange) throws IOException {
        Request.Builder builder = Request.builder().method(httpExchange.getRequestMethod()).requestURI(httpExchange.getRequestURI()).body(IOUtils.toByteArray((InputStream)httpExchange.getRequestBody()));
        RequestUtils.addEncoding(builder, httpExchange);
        RequestUtils.addHeaders(builder, httpExchange);
        return builder.build();
    }

    static void addEncoding(Request.Builder builder, HttpExchange httpExchange) {
        Matcher matcher;
        String contentType = httpExchange.getRequestHeaders().getFirst("Content-Type");
        if (contentType != null && (matcher = CHARSET_PATTERN.matcher(contentType)).matches()) {
            try {
                builder.encoding(Charset.forName(matcher.group(1)));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
    }

    private static void addHeaders(Request.Builder builder, HttpExchange httpExchange) {
        Headers requestHeaders = httpExchange.getRequestHeaders();
        for (String key : requestHeaders.keySet()) {
            Iterator iterator = requestHeaders.get(key).iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                builder.header(key, value);
            }
        }
    }
}

