/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jadler.KeyValues;
import net.jadler.Request;
import net.jadler.RequestManager;
import net.jadler.stubbing.StubResponse;
import net.jadler.stubbing.server.jetty.RequestUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jetty.server.handler.AbstractHandler;

class JadlerHandler
extends AbstractHandler {
    private final RequestManager requestManager;

    JadlerHandler(RequestManager requestManager) {
        Validate.notNull((Object)requestManager, (String)"requestManager cannot be null");
        this.requestManager = requestManager;
    }

    public void handle(String target, org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Request req = RequestUtils.convert(request);
        StubResponse stubResponse = this.requestManager.provideStubResponseFor(req);
        response.setStatus(stubResponse.getStatus());
        this.insertResponseHeaders(stubResponse.getHeaders(), response);
        baseRequest.setHandled(true);
        this.processDelay(stubResponse.getDelay());
        this.insertResponseBody(stubResponse.getBody(), response);
    }

    private void insertResponseBody(byte[] body, HttpServletResponse response) throws IOException {
        if (body.length > 0) {
            ServletOutputStream os = response.getOutputStream();
            os.write(body);
        }
    }

    private void insertResponseHeaders(KeyValues headers, HttpServletResponse response) {
        for (String key : headers.getKeys()) {
            for (String value : headers.getValues(key)) {
                response.addHeader(key, value);
            }
        }
    }

    private void processDelay(long delay) {
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

