/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.google.inject.spi.ElementSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.guice.annotation.GuiceFactoryBean;
import org.springframework.guice.annotation.InjectorFactory;
import org.springframework.guice.injector.InjectorHolder;
import org.springframework.guice.module.SpringModule;

@Configuration
@Order(value=-2147483638)
class ModuleRegistryConfiguration
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    ApplicationContext applicationContext;

    ModuleRegistryConfiguration() {
    }

    private Injector createInjector(Collection<Module> modules) {
        return Guice.createInjector(modules);
    }

    private void mapBindings(Injector injector, BeanDefinitionRegistry registry) {
        for (Map.Entry entry : injector.getBindings().entrySet()) {
            if (((Key)entry.getKey()).getTypeLiteral().getRawType().equals(Injector.class) || "spring-guice".equals(((Binding)entry.getValue()).getSource().toString())) continue;
            Binding binding = (Binding)entry.getValue();
            Key key = (Key)entry.getKey();
            Object source = binding.getSource();
            RootBeanDefinition bean = new RootBeanDefinition(GuiceFactoryBean.class);
            ConstructorArgumentValues args = new ConstructorArgumentValues();
            args.addIndexedArgumentValue(0, (Object)key.getTypeLiteral().getRawType());
            args.addIndexedArgumentValue(1, (Object)binding.getProvider());
            bean.setConstructorArgumentValues(args);
            if (source != null && source instanceof ElementSource) {
                bean.setResourceDescription(((ElementSource)source).getDeclaringSource().toString());
            } else {
                bean.setResourceDescription("spring-guice");
            }
            registry.registerBeanDefinition(this.extractName(key), (BeanDefinition)bean);
        }
        if (injector.getParent() != null) {
            this.mapBindings(injector.getParent(), registry);
        }
        ((ConfigurableListableBeanFactory)registry).registerResolvableDependency(Injector.class, (Object)injector);
    }

    private String extractName(Key<?> key) {
        if (key.getAnnotation() instanceof Named) {
            return ((Named)key.getAnnotation()).value();
        }
        return key.getTypeLiteral().getRawType().getSimpleName();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ArrayList<Module> modules = new ArrayList<Module>(((DefaultListableBeanFactory)registry).getBeansOfType(Module.class).values());
        modules.add((Module)new SpringModule(this.applicationContext));
        Injector injector = null;
        try {
            Map beansOfType = ((DefaultListableBeanFactory)registry).getBeansOfType(InjectorFactory.class);
            if (beansOfType.size() > 1) {
                throw new ApplicationContextException("Found multiple beans of type " + InjectorFactory.class.getName() + "  Please ensure that only one InjectorFactory bean is defined. InjectorFactory beans found: " + beansOfType.keySet());
            }
            if (beansOfType.size() == 1) {
                InjectorFactory injectorFactory = (InjectorFactory)beansOfType.values().iterator().next();
                injector = injectorFactory.createInjector(modules);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (injector == null) {
            injector = this.createInjector(modules);
        }
        this.mapBindings(injector, registry);
        InjectorHolder.getInstance().setInjector(injector);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

