/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.module;

import com.google.inject.Injector;
import javax.inject.Provider;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.util.Assert;

class GuiceAutowireCandidateResolver
extends ContextAnnotationAutowireCandidateResolver {
    private Provider<Injector> injectorProvider;

    public GuiceAutowireCandidateResolver(Provider<Injector> injectorProvider) {
        this.injectorProvider = injectorProvider;
    }

    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        return this.isLazy(descriptor, beanName) ? this.buildLazyResolutionProxy(descriptor, beanName) : null;
    }

    protected boolean isLazy(DependencyDescriptor descriptor, String beanName) {
        Assert.state((boolean)(this.getBeanFactory() instanceof DefaultListableBeanFactory), (String)"BeanFactory needs to be a DefaultListableBeanFactory");
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        try {
            beanFactory.doResolveDependency(descriptor, beanName, null, null);
        }
        catch (NoSuchBeanDefinitionException e) {
            return true;
        }
        return super.isLazy(descriptor);
    }

    protected Object buildLazyResolutionProxy(final DependencyDescriptor descriptor, final String beanName) {
        Assert.state((boolean)(this.getBeanFactory() instanceof DefaultListableBeanFactory), (String)"BeanFactory needs to be a DefaultListableBeanFactory");
        final DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        TargetSource ts = new TargetSource(){

            public Class<?> getTargetClass() {
                return descriptor.getDependencyType();
            }

            public boolean isStatic() {
                return false;
            }

            public Object getTarget() {
                Object target = null;
                try {
                    target = beanFactory.doResolveDependency(descriptor, beanName, null, null);
                }
                catch (NoSuchBeanDefinitionException e) {
                    target = ((Injector)GuiceAutowireCandidateResolver.this.injectorProvider.get()).getInstance(descriptor.getDependencyType());
                }
                if (target == null) {
                    throw new NoSuchBeanDefinitionException(descriptor.getDependencyType(), "Optional dependency not present for lazy injection point");
                }
                return target;
            }

            public void releaseTarget(Object target) {
            }
        };
        ProxyFactory pf = new ProxyFactory();
        pf.setTargetSource(ts);
        Class dependencyType = descriptor.getDependencyType();
        if (dependencyType.isInterface()) {
            pf.addInterface(dependencyType);
        }
        return pf.getProxy(beanFactory.getBeanClassLoader());
    }
}

