/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.module;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.ProvisionListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.guice.module.BindingTypeMatcher;
import org.springframework.guice.module.GuiceAutowireCandidateResolver;
import org.springframework.guice.module.GuiceModuleMetadata;
import org.springframework.util.ClassUtils;

public class SpringModule
extends AbstractModule {
    private BindingTypeMatcher matcher = new GuiceModuleMetadata();
    private Map<Type, Provider<?>> bound = new HashMap();
    private ConfigurableListableBeanFactory beanFactory;
    private Provider<ConfigurableListableBeanFactory> beanFactoryProvider;

    public SpringModule(ApplicationContext context) {
        this((ConfigurableListableBeanFactory)context.getAutowireCapableBeanFactory());
    }

    public SpringModule(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public SpringModule(Provider<ConfigurableListableBeanFactory> beanFactoryProvider) {
        this.beanFactoryProvider = beanFactoryProvider;
    }

    public void configure() {
        if (this.binder().currentStage() != Stage.TOOL) {
            if (this.beanFactory == null) {
                this.beanFactory = (ConfigurableListableBeanFactory)this.beanFactoryProvider.get();
            }
            if (this.beanFactory.getBeanNamesForType(ProvisionListener.class).length > 0) {
                this.binder().bindListener(Matchers.any(), this.beanFactory.getBeansOfType(ProvisionListener.class).values().toArray(new ProvisionListener[0]));
            }
            if (this.beanFactory instanceof DefaultListableBeanFactory) {
                ((DefaultListableBeanFactory)this.beanFactory).setAutowireCandidateResolver((AutowireCandidateResolver)new GuiceAutowireCandidateResolver((Provider<Injector>)this.binder().getProvider(Injector.class)));
            }
            if (this.beanFactory.getBeanNamesForType(GuiceModuleMetadata.class).length > 0) {
                this.matcher = new CompositeTypeMatcher(this.beanFactory.getBeansOfType(GuiceModuleMetadata.class).values());
            }
        }
        this.bind(this.beanFactory);
    }

    private void bind(ConfigurableListableBeanFactory beanFactory) {
        for (String name : beanFactory.getBeanDefinitionNames()) {
            Class type;
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            if (!definition.isAutowireCandidate() || definition.getRole() != 0 || (type = beanFactory.getType(name)) == null) continue;
            String beanName = name;
            Provider typeProvider = BeanFactoryProvider.typed(beanFactory, type);
            Provider namedProvider = BeanFactoryProvider.named(beanFactory, beanName, type);
            if (!type.isInterface() && !ClassUtils.isCglibProxyClass((Class)type)) {
                this.bindConditionally(this.binder(), name, type, typeProvider, namedProvider);
            }
            for (Class clazz : ClassUtils.getAllInterfacesForClass((Class)type)) {
                this.bindConditionally(this.binder(), name, clazz, typeProvider, namedProvider);
            }
            for (Type type2 : type.getGenericInterfaces()) {
                this.bindConditionally(this.binder(), name, type2, typeProvider, namedProvider);
            }
        }
    }

    private void bindConditionally(Binder binder, String name, Type type, Provider typeProvider, Provider namedProvider) {
        if (!this.matcher.matches(name, type)) {
            return;
        }
        if (type.getTypeName().startsWith("com.google.inject")) {
            return;
        }
        if (this.bound.get(type) == null) {
            binder.withSource((Object)"spring-guice").bind(Key.get((Type)type)).toProvider(typeProvider);
            this.bound.put(type, typeProvider);
        }
        binder.withSource((Object)"spring-guice").bind(TypeLiteral.get((Type)type)).annotatedWith((Annotation)Names.named((String)name)).toProvider(namedProvider);
    }

    private static class CompositeTypeMatcher
    implements BindingTypeMatcher {
        private Collection<? extends BindingTypeMatcher> matchers;

        public CompositeTypeMatcher(Collection<? extends BindingTypeMatcher> matchers) {
            this.matchers = matchers;
        }

        @Override
        public boolean matches(String name, Type type) {
            for (BindingTypeMatcher bindingTypeMatcher : this.matchers) {
                if (!bindingTypeMatcher.matches(name, type)) continue;
                return true;
            }
            return false;
        }
    }

    private static class BeanFactoryProvider<T>
    implements Provider<T> {
        private ConfigurableListableBeanFactory beanFactory;
        private String name;
        private Class<T> type;
        private T result;

        private BeanFactoryProvider(ConfigurableListableBeanFactory beanFactory, String name, Class<T> type) {
            this.beanFactory = beanFactory;
            this.name = name;
            this.type = type;
        }

        public static <S> Provider<S> named(ConfigurableListableBeanFactory beanFactory, String name, Class<S> type) {
            return new BeanFactoryProvider<S>(beanFactory, name, type);
        }

        public static <S> Provider<S> typed(ConfigurableListableBeanFactory beanFactory, Class<S> type) {
            return new BeanFactoryProvider<S>(beanFactory, null, type);
        }

        public T get() {
            if (this.result == null) {
                String[] named = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, this.type);
                ArrayList<String> names = new ArrayList<String>(named.length);
                if (named.length == 1) {
                    names.add(named[0]);
                } else {
                    for (String name : named) {
                        if (!name.equals(this.name)) continue;
                        names.add(name);
                    }
                }
                if (names.size() == 1) {
                    this.result = this.beanFactory.getBean((String)names.get(0), this.type);
                } else {
                    for (String name : named) {
                        if (!this.beanFactory.getBeanDefinition(name).isPrimary()) continue;
                        this.result = this.beanFactory.getBean(name, this.type);
                        break;
                    }
                    if (this.result == null) {
                        throw new ProvisionException("No primary bean definition for type: " + this.type);
                    }
                }
            }
            return this.result;
        }
    }
}

