package ext {
import ext.util.HashMap;

[Deprecated(message="Will be removed in 7.0.\n", since="5.0.0")]
[Native("Ext.AbstractManager", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Base Manager class</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html Original Ext JS documentation of 'Ext.AbstractManager'
 */
public class AbstractManager extends Base {
  /**
   * Contains all of the items currently managed
   * @default new Ext.util.HashMap()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#property-all Original Ext JS documentation of 'all'
   */
  public native function get all():HashMap;

  /**
   * @private
   */
  public native function set all(value:HashMap):void;

  /**
   * Creates and returns an instance of whatever this manager manages, based on
   * the supplied type and config object.
   * @param config The config object
   * @param defaultType If no type is discovered in the config object, we
   * fall back to this type
   * @return The instance of whatever this manager is managing
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-create Original Ext JS documentation of 'create'
   */
  public native function create(config:Object, defaultType:String):*;

  /**
   * Executes the specified function once for each item in the collection.
   * @param fn The function to execute.
   * <ul>
   * <li><code>key:String</code> (optional) —
   * The key of the item
   * </li>
   * <li><code>value:Number</code> (optional) —
   * The value of the item
   * </li>
   * <li><code>length:Number</code> (optional) —
   * The total number of items in the collection
   * </li>
   * <li><code>return:Boolean</code> (optional) —
   * False to cease iteration.
   * </li>
   * </ul>
   * @param scope The scope to execute in. Defaults to <code>this</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object):void;

  /**
   * Returns an item by id.
   * For additional details see →<code>ext.util.HashMap.get()</code>.
   * @param id The id of the item
   * @return The item, undefined if not found.
   * @see ext.util.HashMap#get()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(id:String):Object;

  /**
   * Gets the number of items in the collection.
   * @return The number of items in the collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-getCount Original Ext JS documentation of 'getCount'
   */
  public native function getCount():Number;

  /**
   * Checks if an item type is registered.
   * @param type The mnemonic string by which the class may be looked up
   * @return Whether the type is registered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-isRegistered Original Ext JS documentation of 'isRegistered'
   */
  public native function isRegistered(type:String):Boolean;

  /**
   * Registers a function that will be called when an item with the specified id is added
   * to the manager. This will happen on instantiation.
   * @param id The item id
   * @param fn The callback function. Called with a single parameter, the item.
   * @param scope The scope (this reference) in which the callback is executed.
   * Defaults to the item.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-onAvailable Original Ext JS documentation of 'onAvailable'
   */
  public native function onAvailable(id:String, fn:Function, scope:Object):void;

  /**
   * Registers an item to be managed
   * @param item The item to register
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-register Original Ext JS documentation of 'register'
   */
  public native function register(item:*):void;

  /**
   * Registers a new item constructor, keyed by a type key.
   * @param type The mnemonic string by which the class may be looked up.
   * @param cls The new instance class.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-registerType Original Ext JS documentation of 'registerType'
   */
  public native function registerType(type:String, cls:Class):void;

  /**
   * Unregisters an item by removing it from this manager
   * @param item The item to unregister
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.AbstractManager.html#method-unregister Original Ext JS documentation of 'unregister'
   */
  public native function unregister(item:*):void;
}
}