package ext {

[Native("Ext.Action", require)]
/**
 * An Action encapsulates a shareable, reusable set of properties which define a "clickable"
 * UI component such as a <i>button</i> (→<code>ext.button.Button</code>) or <i>menu item</i> (→<code>ext.menu.Item</code>),
 * or <i>panel header tool</i> (→<code>ext.panel.Panel.tools</code>), or an
 * <i>ActionColumn item</i> (→<code>ext.grid.column.ActionColumn</code>)
 * <p>Actions let you share handlers, configuration options and UI updates across any components
 * which were created using the Action.</p>
 * <p>You do not have to create Action instances. They can be configured into Views
 * using the →<code>ext.container.Container.actions</code> config.</p>
 * <p>Use a reference to an Action as the config object for any number of UI Components which share
 * the same configuration. The Action not only supplies the configuration, but allows all Components
 * based upon it to have a common set of methods called at once through a single call to the Action.</p>
 * <p>Any Component that is to be configured with an Action may support
 * the following methods:</p>
 * <ul>
 * <li>setText(String)</li>
 * <li>setIconCls(String)</li>
 * <li>setGlyph(String)</li>
 * <li>setDisabled(Boolean)</li>
 * <li>setVisible(Boolean)</li>
 * <li>setHandler(String)</li>
 * </ul>
 * <p>This allows the Action to control its associated Components. Use a
 * <i>reference to an Action</i> (→<code>ext.container.Container.getAction()</code>) to control
 * all components created from that action.</p>
 * <p>Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('ActionsExampleController', {
 *     extend: 'Ext.app.ViewController',
 *     alias: 'controller.actionsexample',
 *
 *     onOperationClick: function() {
 *         Ext.Msg.alert('Click', 'Perform the operation');
 *     },
 *
 *     onOperationToggle: function(btn, pressed) {
 *         // The action controls all UI components created from it.
 *         this.view.getAction('operation').setDisabled(pressed);
 *     }
 * });
 *
 * Ext.define('ActionsPanel', {
 *     extend: 'Ext.panel.Panel',
 *     controller: 'actionsexample',
 *
 *     title: 'Actions',
 *     width: 500,
 *     height: 300,
 *
 *     // Define the shared Action.  Each Component created from these will
 *     // have the same display text, icon and tooltip, and will invoke the
 *     // same controller method on click.
 *     actions: {
 *         operation: {
 *             text: 'Do operation',
 *              handler: 'onOperationClick',
 *             glyph: 'xf005&#64;FontAwesome',
 *             tooltip: 'Perform the operation'
 *         },
 *         disableOperation: {
 *             text: 'Disable operation',
 *             enableToggle: true,
 *             toggleHandler: 'onOperationToggle',
 *             tooltip: 'Disable the operation'
 *         }
 *     },
 *
 *     // Actions are interpreted as Buttons by this view.
 *     // Other descendants such as Menus and Toolbars have
 *     // their own defaults.
 *     defaultActionType: 'button',
 *
 *     tools: [
 *         '&#64;operation'
 *     ],
 *
 *     tbar: [
 *         // Add the Action directly to a toolbar as a menu button
 *         '&#64;operation',
 *         {
 *             text: 'Action Menu',
 *             menu: [
 *                 // Add the Action to a menu as a text item
 *                 '&#64;operation'
 *             ]
 *         }, '&#64;disableOperation'
 *     ],
 *
 *     bodyPadding: 10,
 *     layout: {
 *         type: 'vbox',
 *         align: 'stretch'
 *     },
 *     items: [
 *         // Add the Action to the panel body.
 *         // defaultActionType will ensure it is converted to a Button.
 *         '&#64;operation'
 *     ]
 * });
 *
 * Ext.QuickTips.init();
 * new ActionsPanel({
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.button.Button
 * @see ext.menu.Item
 * @see ext.panel.Panel#tools
 * @see ext.grid.column.ActionColumn
 * @see ext.container.Container#actions
 * @see ext.container.Container#getAction()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html Original Ext JS documentation of 'Ext.Action'
 */
public class Action extends Base {
  /**
   * Creates new Action.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Action(config:Action = null) {
    super();
  }

  [ExtConfig]
  /**
   * The key to use for this action in a container's <code>actions</code> map
   * when this action is added to the map through the container's <code>actionList</code>
   * config.
   * This should usually be specified through a constant defined in the container,
   * but it also falls back to a constant with the magic name <code>ACTION_ID</code>
   * defined in this action class.
   * @see ext.container.Container#actions
   * @see ext.container.Container#actionList
   */
  public native function get actionId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set actionId(value:String):void;

  [ExtConfig]
  /**
   * True to disable all components configured by this Action, false to enable them.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set disabled(value:Boolean):void;

  [ExtConfig]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @since 6.2.0
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-glyph Original Ext JS documentation of 'glyph'
   * @see #setGlyph()
   */
  public native function get glyph():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  /**
   * The function that will be invoked by each component tied to this Action
   * when the component's primary event is triggered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-handler Original Ext JS documentation of 'handler'
   * @see #setHandler()
   */
  public native function get handler():Function;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set handler(value:Function):void;

  [ExtConfig]
  /**
   * True to hide all components configured by this Action, false to show them.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #setHidden()
   */
  public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set hidden(value:Boolean):void;

  [ExtConfig]
  /**
   * <b>Note:</b> The CSS class(es) specifying the background image will apply
   * to all components configured by this Action.
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   * @see #setIconCls()
   */
  public native function get iconCls():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  /**
   * This Action's initial configuration specification.
   */
  public native function get initialConfig():Object;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Action, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#property-isAction Original Ext JS documentation of 'isAction'
   */
  public native function get isAction():Boolean;

  [ExtConfig]
  /**
   * See →<code>ext.Component</code>.→<code>ext.Component.itemId</code>.
   * @see ext.Component
   * @see ext.Component#itemId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-itemId Original Ext JS documentation of 'itemId'
   */
  public native function get itemId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemId(value:String):void;

  [ExtConfig]
  /**
   * The scope (this reference) in which the →<code>handler</code> is executed
   * if specified as a function instead of a named Controller method.
   * Defaults to the browser window.
   * @see #handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The text to set for all components configured by this Action.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#cfg-text Original Ext JS documentation of 'text'
   * @see #getText()
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  /**
   * The tooltip for the action - can be a string to be used as innerHTML (html tags are accepted) or
   * QuickTips config object.
   * @see #setTooltip()
   */
  public native function get tooltip():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tooltip(value:*):void;

  /**
   * @private
   */
  public native function addComponent(comp:Component):void;

  /**
   * Disables all components configured by this Action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-disable Original Ext JS documentation of 'disable'
   */
  public native function disable():void;

  /**
   * Executes the specified function once for each Component currently tied to this Action.
   * The function passed in should accept a single argument that will be an object that supports
   * the basic Action config/method interface.
   * @param fn The function to execute for each component
   * @param scope The scope (this reference) in which the function is executed.
   * Defaults to the Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-each Original Ext JS documentation of 'each'
   */
  public native function each(fn:Function, scope:Object = null):void;

  /**
   * Enables all components configured by this Action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-enable Original Ext JS documentation of 'enable'
   */
  public native function enable():void;

  /**
   * Executes this Action manually using the handler function specified in the original config
   * object or the handler function set with →<code>setHandler()</code>. Any arguments passed to this
   * function will be passed on to the handler function.
   * @param args Variable number of arguments passed to the handler function
   * @see #setHandler()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-execute Original Ext JS documentation of 'execute'
   */
  public native function execute(...args):void;

  /**
   * Gets the icon CSS class currently used by all components configured by this Action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-getIconCls Original Ext JS documentation of 'getIconCls'
   */
  public native function getIconCls():String;

  /**
   * Gets the text currently displayed by all components configured by this Action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-getText Original Ext JS documentation of 'getText'
   */
  public native function getText():String;

  /**
   * Gets the tooltip currently displayed by all components configured by this Action.
   */
  public native function getTooltip():String;

  /**
   * If no <code>handler</code> is configured, this method is used as handler.
   * The default implementation does nothing.
   * For Action subclasses, it is more convenient to override this method than to set
   * a config, and it also ensures the correct (trivial) method signature.
   */
  protected native function handle():void;

  /**
   * Hides all components configured by this Action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-hide Original Ext JS documentation of 'hide'
   */
  public native function hide():void;

  /**
   * Returns true if the components using this Action are currently disabled, else returns false.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-isDisabled Original Ext JS documentation of 'isDisabled'
   */
  public native function isDisabled():Boolean;

  /**
   * Returns true if the components configured by this Action are currently hidden,
   * else returns false.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-isHidden Original Ext JS documentation of 'isHidden'
   */
  public native function isHidden():Boolean;

  /**
   * @private
   */
  public native function removeComponent(comp:Component):void;

  /**
   * Sets the disabled state of all components configured by this Action. Shortcut method
   * for →<code>enable()</code> and →<code>disable()</code>.
   * @param disabled True to disable the component, false to enable it
   * @see #enable()
   * @see #disable()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-setDisabled Original Ext JS documentation of 'setDisabled'
   */
  public native function setDisabled(disabled:Boolean):void;

  /**
   * Sets the →<code>glyph</code> for all components configured by this
   * Action.
   * @param glyph The CSS class supplying the icon image
   * @see #glyph
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-setGlyph Original Ext JS documentation of 'setGlyph'
   */
  public native function setGlyph(glyph:String):void;

  /**
   * Sets the function that will be called by each Component using this action when its
   * primary event (usually a click or tap) is triggered.
   * @param handler The function that will be invoked by the action's components
   * when clicked. See the <code>→handler</code> config of the target component for the arguments passed.
   * @param scope The scope (this reference) in which the function is executed.
   * Defaults to an encapsulating →<code>ext.app.Controller</code>, or the Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-setHandler Original Ext JS documentation of 'setHandler'
   * @see #handler
   * @see ext.app.Controller
   */
  public native function setHandler(handler:Function, scope:Object = null):void;

  /**
   * Sets the hidden state of all components configured by this Action. Shortcut method
   * for <code>→hide()</code> and <code>→show()</code>.
   * @param hidden True to hide the component, false to show it.
   * @see #hide()
   * @see #show()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-setHidden Original Ext JS documentation of 'setHidden'
   */
  public native function setHidden(hidden:Boolean):void;

  /**
   * Sets the <i>icon CSS class</i> (→<code>iconCls</code>) for all components configured by this
   * Action. The class should supply a background image that will be used as the icon
   * image.
   * @param cls The CSS class supplying the icon image
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-setIconCls Original Ext JS documentation of 'setIconCls'
   */
  public native function setIconCls(cls:String):void;

  /**
   * Sets the text to be displayed by all components configured by this Action.
   * @param text The text to display
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-setText Original Ext JS documentation of 'setText'
   */
  public native function setText(text:String):void;

  /**
   * Sets the tooltip to be displayed by all components configured by this Action.
   * @param tooltip The tooltip to display
   */
  public native function setTooltip(tooltip:String):void;

  /**
   * Shows all components configured by this Action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Action.html#method-show Original Ext JS documentation of 'show'
   */
  public native function show():void;
}
}