package ext {

[Native("Ext.Ajax", require)]
/**
 * A singleton instance of an <code>→ext.data.Connection</code>. This class is used to
 * communicate with your server side code. It can be used as follows:
 * <pre>
 *  Ext.Ajax.request({
 *      url: 'ajax_demo/sample.json',
 *
 *      success: function(response, opts) {
 *          var obj = Ext.decode(response.responseText);
 *          console.dir(obj);
 *      },
 *
 *      failure: function(response, opts) {
 *          console.log('server-side failure with status code ' + response.status);
 *      }
 *  });
 * </pre>
 * <p>Default options for all requests can be set by changing a property on the Ext.Ajax class:</p>
 * <pre>
 *  Ext.Ajax.setTimeout(60000); // 60 seconds
 * </pre>
 * <p>Any options specified in the request method for the Ajax request will override any
 * defaults set on the <code>→ext.Ajax</code> singleton. In the code sample below, the timeout for the
 * request will be 60 seconds.</p>
 * <pre>
 *  Ext.Ajax.setTimeout(120000); // 120 seconds
 *
 *  Ext.Ajax.request({
 *      url: 'page.aspx',
 *      timeout: 60000
 *  });
 * </pre>
 * <p>In general, this class will be used for all Ajax requests in your application. The main
 * reason for creating a separate <code>→ext.data.Connection</code> is for a series of
 * requests that share common settings that are different to all other requests in the
 * application.</p>
 * @see ext.data.Connection
 * @see ext.#Ajax ext.Ajax
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Ajax.html Original Ext JS documentation of 'Ext.Ajax'
 */
public const Ajax:SAjax = new SAjax;
}