package ext {

[Native("Ext.Assert", require)]
/**
 * This class provides help value testing methods useful for diagnostics. These are often
 * used in <code>debugHooks</code>:
 * <pre>
 *  Ext.define('Foo.bar.Class', {
 *
 *      debugHooks: {
 *          method: function (a) {
 *              Ext.Assert.truthy(a, 'Expected "a" to be truthy');
 *          },
 *
 *          foo: function (object) {
 *              Ext.Assert.isFunctionProp(object, 'doSomething');
 *          }
 *      }
 *  });
 * </pre>
 * <p><b>NOTE:</b> This class is entirely removed in production builds so all uses of it should
 * be either in <code>debug</code> conditional comments or <code>debugHooks</code>.</p>
 * <p>The following type detection methods from the <code>→ext.Ext</code> object are wrapped as assertions
 * by this class:</p>
 * <ul>
 * <li><code>isEmpty</code></li>
 * <li><code>isArray</code></li>
 * <li><code>isDate</code></li>
 * <li><code>isObject</code></li>
 * <li><code>isSimpleObject</code></li>
 * <li><code>isPrimitive</code></li>
 * <li><code>isFunction</code></li>
 * <li><code>isNumber</code></li>
 * <li><code>isNumeric</code></li>
 * <li><code>isString</code></li>
 * <li><code>isBoolean</code></li>
 * <li><code>isElement</code></li>
 * <li><code>isTextNode</code></li>
 * <li><code>isDefined</code></li>
 * <li><code>isIterable</code></li>
 * </ul>
 * <p>These appear both their exact name and with a "Prop" suffix for checking a property on
 * an object. For example, these are almost identical:</p>
 * <pre>
 *  Ext.Assert.isFunction(object.foo);
 *
 *  Ext.Assert.isFunctionProp(object, 'foo');
 * </pre>
 * <p>The difference is the default error message generated is better in the second use case
 * than the first.</p>
 * <p>The above list are also expanded for "Not" flavors (and "Not...Prop"):</p>
 * <ul>
 * <li><code>isNotEmpty</code></li>
 * <li><code>isNotArray</code></li>
 * <li><code>isNotDate</code></li>
 * <li><code>isNotObject</code></li>
 * <li><code>isNotSimpleObject</code></li>
 * <li><code>isNotPrimitive</code></li>
 * <li><code>isNotFunction</code></li>
 * <li><code>isNotNumber</code></li>
 * <li><code>isNotNumeric</code></li>
 * <li><code>isNotString</code></li>
 * <li><code>isNotBoolean</code></li>
 * <li><code>isNotElement</code></li>
 * <li><code>isNotTextNode</code></li>
 * <li><code>isNotDefined</code></li>
 * <li><code>isNotIterable</code></li>
 * </ul>
 * @see ext.#Ext ext.Ext
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Assert.html Original Ext JS documentation of 'Ext.Assert'
 */
public class Assert extends Object {
  /**
   * Checks that the first argument is falsey and throws an <code>Error</code> if it is not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Assert.html#method-falsey Original Ext JS documentation of 'falsey'
   */
  public native function falsey(b:*, msg:*):void;

  /**
   * Checks that the first argument is falsey and throws an <code>Error</code> if it is not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Assert.html#method-falseyProp Original Ext JS documentation of 'falseyProp'
   */
  public native function falseyProp(object:*, property:*):void;

  /**
   * Checks that the first argument is truthy and throws an <code>Error</code> if it is not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Assert.html#method-truthy Original Ext JS documentation of 'truthy'
   */
  public native function truthy(b:*, msg:*):void;

  /**
   * Checks that the first argument is truthy and throws an <code>Error</code> if it is not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Assert.html#method-truthyProp Original Ext JS documentation of 'truthyProp'
   */
  public native function truthyProp(object:*, property:*):void;
}
}