package ext {

[Native("Ext.Base")]
/**
 * The root of all classes created with →<code>ext.Ext.define()</code>.
 * <p>Ext.Base is the building block of all Ext classes. All classes in Ext inherit from Ext.Base.
 * All prototype and static members of this class are inherited by all other classes.</p>
 * @see ext.SExt#define() ext.Ext.define()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html Original Ext JS documentation of 'Ext.Base'
 */
public class Base extends Object {
  /**
   * Add methods / properties to the prototype of this class.
   * <pre>
   * Ext.define('My.awesome.Cat', {
   *     constructor: function() {
   *         ...
   *     }
   * });
   *
   *  My.awesome.Cat.addMembers({
   *      meow: function() {
   *         alert('Meowww...');
   *      }
   *  });
   *
   *  var kitty = new My.awesome.Cat();
   *  kitty.meow();
   * </pre>
   * @param members The members to add to this class.
   * @param isStatic Pass <code>true</code> if the members are static.
   * @default false
   * @param privacy Pass <code>true</code> if the members are private. This
   * only has meaning in debug mode and only for methods.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-addMembers Original Ext JS documentation of 'addMembers'
   */
  public static native function addMembers(members:Object, isStatic:Boolean = false, privacy:Boolean = false):*;

  /**
   * Add / override static properties of this class.
   * <pre>
   * Ext.define('My.cool.Class', {
   *     ...
   * });
   *
   * My.cool.Class.addStatics({
   *     someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'
   *     method1: function() { ... },    // My.cool.Class.method1 = function() { ... };
   *     method2: function() { ... }     // My.cool.Class.method2 = function() { ... };
   * });
   * </pre>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-addStatics Original Ext JS documentation of 'addStatics'
   */
  public static native function addStatics(members:Object):Base;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-callParent Original Ext JS documentation of 'callParent'
   */
  protected static native function callParent(args:*):void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-callSuper Original Ext JS documentation of 'callSuper'
   */
  protected static native function callSuper(args:*):void;

  /**
   * Create a new instance of this Class.
   * <pre>
   * Ext.define('My.cool.Class', {
   *     ...
   * });
   *
   * My.cool.Class.create({
   *     someConfig: true
   * });
   * </pre>
   * <p>All parameters are passed to the constructor of the class.</p>
   * @return the created instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-create Original Ext JS documentation of 'create'
   */
  public static native function create():Object;

  /**
   * Create aliases for existing prototype methods. Example:
   * <pre>
   * Ext.define('My.cool.Class', {
   *     method1: function() { ... },
   *     method2: function() { ... }
   * });
   *
   * var test = new My.cool.Class();
   *
   * My.cool.Class.createAlias({
   *     method3: 'method1',
   *     method4: 'method2'
   * });
   *
   * test.method3(); // test.method1()
   *
   * My.cool.Class.createAlias('method5', 'method3');
   *
   * test.method5(); // test.method3() -&gt; test.method1()
   * </pre>
   * @param alias The new method name, or an object to set multiple aliases.
   * See →<code>ext.FunctionUtil.flexSetter()</code>
   * @param origin The original method name
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-createAlias Original Ext JS documentation of 'createAlias'
   * @see ext.SFunctionUtil#flexSetter() ext.FunctionUtil.flexSetter()
   */
  public static native function createAlias(alias:*, origin:*):void;

  /**
   * Get the current class' name in string format.
   * <pre>
   * Ext.define('My.cool.Class', {
   *     constructor: function() {
   *         alert(this.self.getName()); // alerts 'My.cool.Class'
   *     }
   * });
   *
   * My.cool.Class.getName(); // 'My.cool.Class'
   * </pre>
   * @return className
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-getName Original Ext JS documentation of 'getName'
   */
  public static native function getName():String;

  /**
   * Override members of this class. Overridden methods can be invoked via
   * →<code>ext.Base.callParent()</code>.
   * <pre>
   * Ext.define('My.Cat', {
   *     constructor: function() {
   *         alert("I'm a cat!");
   *     }
   * });
   *
   * My.Cat.override({
   *     constructor: function() {
   *         alert("I'm going to be a cat!");
   *
   *         this.callParent(arguments);
   *
   *         alert("Meeeeoooowwww");
   *     }
   * });
   *
   * var kitty = new My.Cat(); // alerts "I'm going to be a cat!"
   *                           // alerts "I'm a cat!"
   *                           // alerts "Meeeeoooowwww"
   * </pre>
   * <p>Direct use of this method should be rare. Use →<code>ext.Ext.define()</code>
   * instead:</p>
   * <pre>
   * Ext.define('My.CatOverride', {
   *     override: 'My.Cat',
   *     constructor: function() {
   *         alert("I'm going to be a cat!");
   *
   *         this.callParent(arguments);
   *
   *         alert("Meeeeoooowwww");
   *     }
   * });
   * </pre>
   * <p>The above accomplishes the same result but can be managed by the →<code>ext.Loader</code>
   * which can properly order the override and its target class and the build process
   * can determine whether the override is needed based on the required state of the
   * target class (My.Cat).</p>
   * @param members The properties to add to this class. This should be
   * specified as an object literal containing one or more properties.
   * @return this class
   * @see ext.Base#callParent()
   * @see ext.SExt#define() ext.Ext.define()
   * @see ext.#Loader ext.Loader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#static-method-override Original Ext JS documentation of 'override'
   */
  public static native function override_(members:Object):Base;

  /**
   * Setting this property to <code>false</code> will prevent nulling object references
   * on a Class instance after destruction. Setting this to <code>"async"</code> will delay
   * the clearing for approx 50ms.
   * @default true
   * @since 6.2.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#property-clearPropertiesOnDestroy Original Ext JS documentation of 'clearPropertiesOnDestroy'
   */
  public native function get clearPropertiesOnDestroy():*;

  /**
   * @private
   */
  public native function set clearPropertiesOnDestroy(value:*):void;

  /**
   * This property is set to <code>true</code> after the <code>→destroy()</code> method is called.
   * @default false
   * @see #destroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#property-destroyed Original Ext JS documentation of 'destroyed'
   */
  public native function get destroyed():Boolean;

  /**
   * @private
   */
  public native function set destroyed(value:Boolean):void;

  /**
   * This property is set to <code>true</code> during the call to <code>→initConfig()</code>.
   * @default false
   * @since 5.0.0
   * @see #initConfig()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#property-isConfiguring Original Ext JS documentation of 'isConfiguring'
   */
  public native function get isConfiguring():Boolean;

  /**
   * This property is set to <code>true</code> if this instance is the first of its class.
   * @default false
   * @since 5.0.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#property-isFirstInstance Original Ext JS documentation of 'isFirstInstance'
   */
  public native function get isFirstInstance():Boolean;

  /**
   * This value is <code>true</code> and is used to identify plain objects from instances of
   * a defined class.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#property-isInstance Original Ext JS documentation of 'isInstance'
   */
  public native function get isInstance():Boolean;

  [ExtConfig("__mixins__")]
  /**
   * This element contains additional config objects that are mixed into
   * (merged with) this config object.
   * <br/>
   * It is neither recommended to define the same property in the base config object
   * as well as in a mixin nor to define the same property in more than one mixin.
   * However, when a property is defined multiple times, the base config object has
   * precedence over mixins, and a mixin has precedence over following mixins.
   * <br/>
   * It is recommended to use a typed mixin config object in favor of using
   * dynamic attributes.
   */
  public native function set mixins(value:Array):void;

  /**
   * Get the reference to the current class from which this object was instantiated. Unlike
   * →<code>ext.Base.statics()</code>, <code>this.self</code> is scope-dependent and it's meant to be used
   * for dynamic inheritance. See →<code>ext.Base.statics()</code> for a detailed comparison
   * <pre>
   * Ext.define('My.Cat', {
   *     statics: {
   *         speciesName: 'Cat' // My.Cat.speciesName = 'Cat'
   *     },
   *
   *     constructor: function() {
   *         alert(this.self.speciesName); // dependent on 'this'
   *     },
   *
   *     clone: function() {
   *         return new this.self();
   *     }
   * });
   *
   *
   * Ext.define('My.SnowLeopard', {
   *     extend: 'My.Cat',
   *     statics: {
   *         speciesName: 'Snow Leopard' // My.SnowLeopard.speciesName = 'Snow Leopard'
   *     }
   * });
   *
   * var cat = new My.Cat();                     // alerts 'Cat'
   * var snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'
   *
   * var clone = snowLeopard.clone();
   * alert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'
   * </pre>
   * @default Base
   * @see ext.Base#statics()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#property-self Original Ext JS documentation of 'self'
   */
  public native function get self():ExtClass;

  /**
   * @private
   */
  public native function set self(value:ExtClass):void;

  [Deprecated(replacement="callParent", since="4.1.0")]
  /**
   * Call the original method that was previously overridden with →<code>ext.Base.override_()</code>
   * <pre>
   * Ext.define('My.Cat', {
   *     constructor: function() {
   *         alert("I'm a cat!");
   *     }
   * });
   *
   * My.Cat.override({
   *     constructor: function() {
   *         alert("I'm going to be a cat!");
   *
   *         this.callOverridden();
   *
   *         alert("Meeeeoooowwww");
   *     }
   * });
   *
   * var kitty = new My.Cat(); // alerts "I'm going to be a cat!"
   *                           // alerts "I'm a cat!"
   *                           // alerts "Meeeeoooowwww"
   * </pre>
   * @param args The arguments, either an array or the <code>arguments</code> object
   * from the current method, for example: <code>this.callOverridden(arguments)</code>
   * @return Returns the result of calling the overridden method
   * @see ext.Base#override_()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-callOverridden Original Ext JS documentation of 'callOverridden'
   */
  protected native function callOverridden(args:*):Object;

  /**
   * Call the "parent" method of the current method. That is the method previously
   * overridden by derivation or by an override (see →<code>ext.Ext.define()</code>).
   * <pre>
   *  Ext.define('My.Base', {
   *      constructor: function(x) {
   *          this.x = x;
   *      },
   *
   *      statics: {
   *          method: function(x) {
   *              return x;
   *          }
   *      }
   *  });
   *
   *  Ext.define('My.Derived', {
   *      extend: 'My.Base',
   *
   *      constructor: function() {
   *          this.callParent([21]);
   *      }
   *  });
   *
   *  var obj = new My.Derived();
   *
   *  alert(obj.x);  // alerts 21
   * </pre>
   * <p>This can be used with an override as follows:</p>
   * <pre>
   *  Ext.define('My.DerivedOverride', {
   *      override: 'My.Derived',
   *
   *      constructor: function(x) {
   *          this.callParent([x&#42;2]); // calls original My.Derived constructor
   *      }
   *  });
   *
   *  var obj = new My.Derived();
   *
   *  alert(obj.x);  // now alerts 42
   * </pre>
   * <p>This also works with static and private methods.</p>
   * <pre>
   *  Ext.define('My.Derived2', {
   *      extend: 'My.Base',
   *
   *      // privates: {
   *      statics: {
   *          method: function(x) {
   *              return this.callParent([x&#42;2]); // calls My.Base.method
   *          }
   *      }
   *  });
   *
   *  alert(My.Base.method(10));     // alerts 10
   *  alert(My.Derived2.method(10)); // alerts 20
   * </pre>
   * <p>Lastly, it also works with overridden static methods.</p>
   * <pre>
   *  Ext.define('My.Derived2Override', {
   *      override: 'My.Derived2',
   *
   *      // privates: {
   *      statics: {
   *          method: function(x) {
   *              return this.callParent([x&#42;2]); // calls My.Derived2.method
   *          }
   *      }
   *  });
   *
   *  alert(My.Derived2.method(10); // now alerts 40
   * </pre>
   * <p>To override a method and replace it and also call the superclass method, use
   * →<code>callSuper()</code>. This is often done to patch a method to fix a bug.</p>
   * @param args The arguments, either an array or the <code>arguments</code> object
   * from the current method, for example: <code>this.callParent(arguments)</code>
   * @return Returns the result of calling the parent method
   * @see ext.SExt#define() ext.Ext.define()
   * @see #callSuper()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-callParent Original Ext JS documentation of 'callParent'
   */
  protected native function callParent(args:*):Object;

  /**
   * This method is used by an <b>override</b> to call the superclass method but
   * bypass any overridden method. This is often done to "patch" a method that
   * contains a bug but for whatever reason cannot be fixed directly.
   * <p>Consider:</p>
   * <pre>
   *  Ext.define('Ext.some.Class', {
   *      method: function() {
   *          console.log('Good');
   *      }
   *  });
   *
   *  Ext.define('Ext.some.DerivedClass', {
   *      extend: 'Ext.some.Class',
   *
   *      method: function() {
   *          console.log('Bad');
   *
   *          // ... logic but with a bug ...
   *
   *          this.callParent();
   *      }
   *  });
   * </pre>
   * <p>To patch the bug in <code>Ext.some.DerivedClass.method</code>, the typical solution is to create an
   * override:</p>
   * <pre>
   *  Ext.define('App.patches.DerivedClass', {
   *      override: 'Ext.some.DerivedClass',
   *
   *      method: function() {
   *          console.log('Fixed');
   *
   *          // ... logic but with bug fixed ...
   *
   *          this.callSuper();
   *      }
   *  });
   * </pre>
   * <p>The patch method cannot use →<code>callParent()</code> to call the superclass
   * <code>method</code> since that would call the overridden method containing the bug. In
   * other words, the above patch would only produce "Fixed" then "Good" in the
   * console log, whereas, using <code>callParent</code> would produce "Fixed" then "Bad"
   * then "Good".</p>
   * @param args The arguments, either an array or the <code>arguments</code> object
   * from the current method, for example: <code>this.callSuper(arguments)</code>
   * @return Returns the result of calling the superclass method
   * @see #callParent()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-callSuper Original Ext JS documentation of 'callSuper'
   */
  protected native function callSuper(args:*):Object;

  /**
   * This method is called to cleanup an object and its resources. After calling
   * this method, the object should not be used any further in any way, including
   * access to its methods and properties.
   * <p>To prevent potential memory leaks, all object references will be nulled
   * at the end of destruction sequence, unless →<code>clearPropertiesOnDestroy</code>
   * is set to <code>false</code>.</p>
   * @see #clearPropertiesOnDestroy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  public native function destroy(...params):void;

  /**
   * Destroys member properties by name.
   * <p>If a property name is the name of a <i>config</i>, the getter is <i>not</i> invoked, so
   * if the config has not been initialized, nothing will be done.</p>
   * <p>The property will be destroyed, and the corrected name (if the property is a <i>config</i>
   * and config names are prefixed) will set to <code>null</code> in this object's dictionary.</p>
   * @param args One or more names of the properties to destroy and remove from
   * the object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-destroyMembers Original Ext JS documentation of 'destroyMembers'
   */
  public native function destroyMembers(...args):void;

  /**
   * Returns a specified config property value. If the name parameter is not passed,
   * all current configuration options will be returned as key value pairs.
   * @param name The name of the config property to get.
   * @param peek <code>true</code> to peek at the raw value without calling the getter.
   * @default false
   * @param ifInitialized <code>true</code> to only return the initialized property
   * value, not the raw config value, and <i>not</i> to trigger initialization. Returns
   * <code>undefined</code> if the property has not yet been initialized.
   * @default false
   * @return The config property value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-getConfig Original Ext JS documentation of 'getConfig'
   */
  public native function getConfig(name:String = null, peek:Boolean = false, ifInitialized:Boolean = false):*;

  /**
   * Returns the initial configuration passed to the constructor when
   * instantiating this class.
   * <p>Given this example Ext.button.Button definition and instance:</p>
   * <pre>
   * Ext.define('MyApp.view.Button', {
   *     extend: 'Ext.button.Button',
   *     xtype: 'mybutton',
   *
   *     scale: 'large',
   *     enableToggle: true
   * });
   *
   * var btn = Ext.create({
   *     xtype: 'mybutton',
   *     renderTo: Ext.getBody(),
   *     text: 'Test Button'
   * });
   * </pre>
   * <p>Calling <code>btn.getInitialConfig()</code> would return an object including the config
   * options passed to the <code>→create()</code> method:</p>
   * <pre>
   * xtype: 'mybutton',
   * renderTo: // The document body itself
   * text: 'Test Button'
   * </pre>
   * <p>Calling <code>btn.getInitialConfig('text')</code>returns <b>'Test Button'</b>.</p>
   * @param name Name of the config option to return.
   * @return The full config object or a single config value
   * when <code>name</code> parameter specified.
   * @see #create()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-getInitialConfig Original Ext JS documentation of 'getInitialConfig'
   */
  public native function getInitialConfig(name:String = null):*;

  /**
   * Initialize configuration for this class. a typical example:
   * <pre>
   * Ext.define('My.awesome.Class', {
   *     // The default config
   *     config: {
   *         name: 'Awesome',
   *         isAwesome: true
   *     },
   *
   *     constructor: function(config) {
   *         this.initConfig(config);
   *     }
   * });
   *
   * var awesome = new My.awesome.Class({
   *     name: 'Super Awesome'
   * });
   *
   * alert(awesome.getName()); // 'Super Awesome'
   * </pre>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-initConfig Original Ext JS documentation of 'initConfig'
   */
  protected native function initConfig(instanceConfig:Object):Base;

  /**
   * Sets a single/multiple configuration options.
   * @param name The name of the property to set, or a set of key value
   * pairs to set.
   * @param value The value to set for the name parameter.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-setConfig Original Ext JS documentation of 'setConfig'
   */
  public native function setConfig(name:*, value:* = null):Base;

  /**
   * Get the reference to the class from which this object was instantiated. Note that unlike
   * →<code>ext.Base.self</code>, <code>this.statics()</code> is scope-independent and it always returns
   * the class from which it was called, regardless of what <code>this</code> points to during run-time
   * <pre>
   * Ext.define('My.Cat', {
   *     statics: {
   *         totalCreated: 0,
   *         speciesName: 'Cat' // My.Cat.speciesName = 'Cat'
   *     },
   *
   *     constructor: function() {
   *         var statics = this.statics();
   *
   *         // always equals to 'Cat' no matter what 'this' refers to
   *         // equivalent to: My.Cat.speciesName
   *         alert(statics.speciesName);
   *
   *
   *         alert(this.self.speciesName);   // dependent on 'this'
   *
   *         statics.totalCreated++;
   *     },
   *
   *     clone: function() {
   *         var cloned = new this.self();   // dependent on 'this'
   *
   *         // equivalent to: My.Cat.speciesName
   *         cloned.groupName = this.statics().speciesName;
   *
   *         return cloned;
   *     }
   * });
   *
   *
   * Ext.define('My.SnowLeopard', {
   *     extend: 'My.Cat',
   *
   *     statics: {
   *         speciesName: 'Snow Leopard' // My.SnowLeopard.speciesName = 'Snow Leopard'
   *     },
   *
   *     constructor: function() {
   *         this.callParent();
   *     }
   * });
   *
   * var cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'
   *
   * var snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'
   *
   * var clone = snowLeopard.clone();
   * alert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'
   * alert(clone.groupName);                 // alerts 'Cat'
   *
   * alert(My.Cat.totalCreated);             // alerts 3
   * </pre>
   * @see ext.Base#self
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Base.html#method-statics Original Ext JS documentation of 'statics'
   */
  protected native function statics():ExtClass;
}
}