package ext {
import ext.app.ViewController;
import ext.app.ViewModel;
import ext.container.Container;
import ext.data.Session;
import ext.dom.Element;
import ext.event.Event;
import ext.mixin.IAccessible;
import ext.mixin.IBindable;
import ext.mixin.IComponentDelegation;
import ext.mixin.IFocusable;
import ext.mixin.IInheritable;
import ext.mixin.IKeyboard;
import ext.mixin.Observable;
import ext.plugin.AbstractPlugin;
import ext.state.IStateful;
import ext.util.IAnimate;
import ext.util.IElementContainer;
import ext.util.IFloating;
import ext.util.IPositionable;
import ext.util.IRenderable;
import ext.util.Region;

import js.HTMLElement;

[Native("Ext.Component", require)]
[ExtConfig]
/**
 * @see ext.events.Component_stateEvent.BEFORE_STATE_RESTORE
 * @eventType ext.events.Component_stateEvent.BEFORE_STATE_RESTORE
 */
[Event(name='onBeforeStateRestore', type='ext.events.Component_stateEvent')]
/**
 * @see ext.events.Component_stateEvent.BEFORE_STATE_SAVE
 * @eventType ext.events.Component_stateEvent.BEFORE_STATE_SAVE
 */
[Event(name='onBeforeStateSave', type='ext.events.Component_stateEvent')]
/**
 * @see ext.events.Component_stateEvent.STATE_RESTORE
 * @eventType ext.events.Component_stateEvent.STATE_RESTORE
 */
[Event(name='onStateRestore', type='ext.events.Component_stateEvent')]
/**
 * @see ext.events.Component_stateEvent.STATE_SAVE
 * @eventType ext.events.Component_stateEvent.STATE_SAVE
 */
[Event(name='onStateSave', type='ext.events.Component_stateEvent')]
/**
 * @see ext.events.Component_eventEvent.BLUR
 * @eventType ext.events.Component_eventEvent.BLUR
 */
[Event(name='onBlur', type='ext.events.Component_eventEvent')]
/**
 * @see ext.events.Component_eventEvent.FOCUS
 * @eventType ext.events.Component_eventEvent.FOCUS
 */
[Event(name='onFocus', type='ext.events.Component_eventEvent')]
/**
 * @see ext.events.Component_eventEvent.FOCUS_ENTER
 * @eventType ext.events.Component_eventEvent.FOCUS_ENTER
 */
[Event(name='onFocusEnter', type='ext.events.Component_eventEvent')]
/**
 * @see ext.events.Component_eventEvent.FOCUS_LEAVE
 * @eventType ext.events.Component_eventEvent.FOCUS_LEAVE
 */
[Event(name='onFocusLeave', type='ext.events.Component_eventEvent')]
/**
 * @see ext.events.ComponentEvent.ACTIVATE
 * @eventType ext.events.ComponentEvent.ACTIVATE
 */
[Event(name='onActivate', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.Component_container_posEvent.ADDED
 * @eventType ext.events.Component_container_posEvent.ADDED
 */
[Event(name='onAdded', type='ext.events.Component_container_posEvent')]
/**
 * @see ext.events.ComponentEvent.AFTER_LAYOUT_ANIMATION
 * @eventType ext.events.ComponentEvent.AFTER_LAYOUT_ANIMATION
 */
[Event(name='onAfterLayoutAnimation', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.AFTER_RENDER
 * @eventType ext.events.ComponentEvent.AFTER_RENDER
 */
[Event(name='onAfterRender', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.BEFORE_ACTIVATE
 * @eventType ext.events.ComponentEvent.BEFORE_ACTIVATE
 */
[Event(name='onBeforeActivate', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.BEFORE_DEACTIVATE
 * @eventType ext.events.ComponentEvent.BEFORE_DEACTIVATE
 */
[Event(name='onBeforeDeactivate', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.BEFORE_DESTROY
 * @eventType ext.events.ComponentEvent.BEFORE_DESTROY
 */
[Event(name='onBeforeDestroy', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.BEFORE_HIDE
 * @eventType ext.events.ComponentEvent.BEFORE_HIDE
 */
[Event(name='onBeforeHide', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.BEFORE_RENDER
 * @eventType ext.events.ComponentEvent.BEFORE_RENDER
 */
[Event(name='onBeforeRender', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.BEFORE_SHOW
 * @eventType ext.events.ComponentEvent.BEFORE_SHOW
 */
[Event(name='onBeforeShow', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.Component_width_heightEvent.BOX_READY
 * @eventType ext.events.Component_width_heightEvent.BOX_READY
 */
[Event(name='onBoxReady', type='ext.events.Component_width_heightEvent')]
/**
 * @see ext.events.ComponentEvent.DEACTIVATE
 * @eventType ext.events.ComponentEvent.DEACTIVATE
 */
[Event(name='onDeactivate', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.DESTROY
 * @eventType ext.events.ComponentEvent.DESTROY
 */
[Event(name='onDestroy', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.DISABLE
 * @eventType ext.events.ComponentEvent.DISABLE
 */
[Event(name='onDisable', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.ENABLE
 * @eventType ext.events.ComponentEvent.ENABLE
 */
[Event(name='onEnable', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.ComponentEvent.HIDE
 * @eventType ext.events.ComponentEvent.HIDE
 */
[Event(name='onHide', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.Component_x_yEvent.MOVE
 * @eventType ext.events.Component_x_yEvent.MOVE
 */
[Event(name='onMove', type='ext.events.Component_x_yEvent')]
/**
 * @see ext.events.Component_ownerCtEvent.REMOVED
 * @eventType ext.events.Component_ownerCtEvent.REMOVED
 */
[Event(name='onRemoved', type='ext.events.Component_ownerCtEvent')]
/**
 * @see ext.events.ComponentEvent.RENDER
 * @eventType ext.events.ComponentEvent.RENDER
 */
[Event(name='onRender', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.Component_width_height_oldWidth_oldHeightEvent.RESIZE
 * @eventType ext.events.Component_width_height_oldWidth_oldHeightEvent.RESIZE
 */
[Event(name='onResize', type='ext.events.Component_width_height_oldWidth_oldHeightEvent')]
/**
 * @see ext.events.ComponentEvent.SHOW
 * @eventType ext.events.ComponentEvent.SHOW
 */
[Event(name='onShow', type='ext.events.ComponentEvent')]
/**
 * @see ext.events.Component_eventEvent.BLUR
 * @eventType ext.events.Component_eventEvent.BLUR
 */
[Event(name='onBlur', type='ext.events.Component_eventEvent')]
/**
 * @see ext.events.Component_eventEvent.FOCUS
 * @eventType ext.events.Component_eventEvent.FOCUS
 */
[Event(name='onFocus', type='ext.events.Component_eventEvent')]
/**
 * @see ext.events.Component_eventEvent.FOCUS_ENTER
 * @eventType ext.events.Component_eventEvent.FOCUS_ENTER
 */
[Event(name='onFocusEnter', type='ext.events.Component_eventEvent')]
/**
 * @see ext.events.Component_eventEvent.FOCUS_LEAVE
 * @eventType ext.events.Component_eventEvent.FOCUS_LEAVE
 */
[Event(name='onFocusLeave', type='ext.events.Component_eventEvent')]
/**
 * Base class for all Ext components.
 * <p>The Component base class has built-in support for basic hide/show and enable/disable
 * and size control behavior.</p>
 * <p><b><i>xtypes</i></b></p>
 * <p>Every component has a specific xtype, which is its Ext-specific type name, along with
 * methods for checking the xtype like →<code>getXType()</code> and →<code>isXType()</code>. See the
 * <a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/components.html">Component Guide</a> for more information on xtypes
 * and the Component hierarchy.</p>
 * <p><b><i>Finding components</i></b></p>
 * <p>All Components are registered with the →<code>ext.ComponentManager</code> on construction so
 * that they can be referenced at any time via →<code>ext.Ext.getCmp()</code>, passing the
 * →<code>id</code>.</p>
 * <p>Additionally the →<code>ext.ComponentQuery</code> provides a CSS-selectors-like way to look
 * up components by their xtype and many other attributes. For example the following code
 * will find all textfield components inside component with <code>id: 'myform'</code>:</p>
 * <pre>
 * Ext.ComponentQuery.query('#myform textfield');
 * </pre>
 * <p><b><i>Extending Ext.Component</i></b></p>
 * <p>All subclasses of Component may participate in the automated Ext component
 * life cycle of creation, rendering and destruction which is provided by the
 * →<code>ext.container.Container</code> class. Components may be added to a Container
 * through the →<code>ext.container.Container.items</code> config option at the time
 * the Container is created, or they may be added dynamically via the
 * →<code>ext.container.Container.add()</code> method.</p>
 * <p>All user-developed visual widgets that are required to participate in automated
 * life cycle and size management should subclass Component.</p>
 * <p>See the Creating new UI controls chapter in
 * <a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/components.html">Component Guide</a> for details on how and to either
 * extend or augment Ext JS base classes to create custom Components.</p>
 * <p><b><i>The Ext.Component class by itself</i></b></p>
 * <p>Usually one doesn't need to instantiate the Ext.Component class. There are subclasses
 * which implement specialized use cases, covering most application needs. However it is
 * possible to instantiate a base Component, and it can be rendered to document, or handled
 * by layouts as the child item of a Container:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.Component', {
 *     html: 'Hello world!',
 *     width: 300,
 *     height: 200,
 *     padding: 20,
 *     style: {
 *         color: '#FFFFFF',
 *         backgroundColor:'#000000'
 *     },
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>The Component above creates its encapsulating <code>div</code> upon render, and use the configured
 * HTML as content. More complex internal structure may be created using the
 * →<code>renderTpl</code> configuration, although to display database-derived mass data, it is
 * recommended that an ExtJS data-backed Component such as a →<code>ext.view.DataView</code>,
 * →<code>ext.grid.GridPanel</code>, or →<code>ext.tree.TreePanel</code> be used.</p>
 * <p><b>From override Ext.layout.container.border.Region:</b></p>
 * This override provides extra, border layout specific methods for `→<code>ext.Component</code>`. The
 * `→<code>ext.layout.container.BorderLayout</code>` class requires this override so that the added functions
 * are only included in a build when `border` layout is used.
 * <p><b>From override Ext.mixin.Focusable:</b></p>
 * This mixin implements focus management functionality in Widgets and Components
 * <p><b>From override Ext.Responsive:</b></p>
 * This is an override, not a class. To use `→<code>ext.Responsive</code>` you simply require it:
 * <pre>
 *  Ext.application({
 *      requires: [
 *          'Ext.Responsive'
 *      ],
 *
 *      // ...
 *  });
 * </pre>
 * <p>Once required, this override mixes in →<code>ext.mixin.Responsive</code> into <code>→ext.Component</code>
 * and <code>→ext.Widget</code> so that these classes both gain the
 * →<code>ext.mixin.Responsive.responsiveConfig</code> and
 * →<code>ext.mixin.Responsive.responsiveFormulas</code> configs.</p>
 * <p><b>From override Ext.rtl.Component:</b></p>
 * This override adds RTL support and the `→<code>rtl</code>` config option to AbstactComponent.
 * @see #getXType()
 * @see #isXType()
 * @see ext.#ComponentManager ext.ComponentManager
 * @see ext.SExt#getCmp() ext.Ext.getCmp()
 * @see #id
 * @see ext.#ComponentQuery ext.ComponentQuery
 * @see ext.container.Container
 * @see ext.container.Container#items
 * @see ext.container.Container#add()
 * @see #renderTpl
 * @see ext.view.DataView
 * @see ext.grid.GridPanel
 * @see ext.tree.TreePanel
 * @see ext.Component
 * @see ext.layout.container.BorderLayout
 * @see ext.Responsive
 * @see ext.mixin.Responsive
 * @see ext.Widget
 * @see ext.mixin.Responsive#responsiveConfig
 * @see ext.mixin.Responsive#responsiveFormulas
 * @see #rtl
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html Original Ext JS documentation of 'Ext.Component'
 */
public class Component extends Observable implements IInheritable, IFloating, IPositionable, IComponentDelegation, IBindable, IAnimate, IElementContainer, IRenderable, IStateful, IFocusable, IAccessible, IKeyboard {
  /**
   * Cancels layout of a component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#static-method-cancelLayout Original Ext JS documentation of 'cancelLayout'
   */
  public static native function cancelLayout(comp:Component, isDestroying:* = undefined):void;

  /**
   * Performs all pending layouts that were scheduled while
   * →<code>ext.Component.suspendLayouts()</code> was in effect.
   * @see ext.Component#suspendLayouts()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#static-method-flushLayouts Original Ext JS documentation of 'flushLayouts'
   */
  public static native function flushLayouts():void;

  /**
   * Find the Widget or Component to which the given event/element belongs.
   * @since 6.5.0
   * @param el The element or event
   * from which to start to find an owning Component.
   * @param limit The element at which to stop upward
   * searching for an owning Component, or the number of Components to traverse
   * before giving up. Defaults to the document's HTML element.
   * @param selector An optional →<code>ext.ComponentQuery</code> selector to
   * filter the target.
   * @return Component, or null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#static-method-from Original Ext JS documentation of 'from'
   * @see ext.#ComponentQuery ext.ComponentQuery
   */
  public static native function from(el:*, limit:* = undefined, selector:String = null):*;

  [Deprecated(replacement="from", since="6.5.0")]
  /**
   * Find the Widget or Component to which the given Element belongs.
   * @since 6.0.1
   * @param el The element from which to start to find an owning
   * Component.
   * @param limit The element at which to stop upward
   * searching for an owning Component, or the number of Components to traverse
   * before giving up. Defaults to the document's HTML element.
   * @param selector An optional →<code>ext.ComponentQuery</code> selector to filter
   * the target.
   * @return Component, or null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#static-method-fromElement Original Ext JS documentation of 'fromElement'
   * @see ext.#ComponentQuery ext.ComponentQuery
   */
  public static native function fromElement(el:*, limit:* = undefined, selector:String = null):*;

  /**
   * Resumes layout activity in the whole framework.
   * <p>→<code>ext.Ext.suspendLayouts()</code> is alias of →<code>ext.Component.suspendLayouts()</code>.</p>
   * @param flush <code>true</code> to perform all the pending layouts. This can also
   * be achieved by calling →<code>ext.Component.flushLayouts()</code> directly.
   * @default false
   * @see ext.SExt#suspendLayouts() ext.Ext.suspendLayouts()
   * @see ext.Component#suspendLayouts()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#static-method-resumeLayouts Original Ext JS documentation of 'resumeLayouts'
   * @see ext.Component#flushLayouts()
   */
  public static native function resumeLayouts(flush:Boolean = false):void;

  /**
   * Stops layouts from happening in the whole framework.
   * <p>It's useful to suspend the layout activity while updating multiple components and
   * containers:</p>
   * <pre>
   * Ext.suspendLayouts();
   * // batch of updates...
   * Ext.resumeLayouts(true);
   * </pre>
   * <p>→<code>ext.Ext.suspendLayouts()</code> is alias of →<code>ext.Component.suspendLayouts()</code>.</p>
   * <p>See also →<code>ext.Ext.batchLayouts()</code> for more abstract way of doing this.</p>
   * @see ext.SExt#suspendLayouts() ext.Ext.suspendLayouts()
   * @see ext.Component#suspendLayouts()
   * @see ext.SExt#batchLayouts() ext.Ext.batchLayouts()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#static-method-suspendLayouts Original Ext JS documentation of 'suspendLayouts'
   */
  public static native function suspendLayouts():void;

  /**
   * TODO: IDEA cannot cope well with a static and a non-static method of the same name in the same class...
   * Updates layout of a component.
   * @param comp The component to update.
   * @param defer <code>true</code> to just queue the layout if this component.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#static-method-updateLayout Original Ext JS documentation of 'updateLayout'
   * /
   public static native function updateLayout(comp:Component, defer:Boolean = false):void;
   */

  /**
   * Creates new Component.
   * @param config The configuration options may be specified
   * as either:
   * <ul>
   * <li><b>an element</b> : it is set as the internal element and its id used as the component id</li>
   * <li><b>a string</b> : it is assumed to be the id of an existing element and is used as the
   * component id</li>
   * <li><b>anything else</b> : it is assumed to be a standard config object and is applied to the
   * component</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Component(config:Component = null) {
    super();
  }

  /**
   * Setting this property to <code>true</code> causes the →<code>isLayoutRoot()</code> method to return
   * <code>true</code> and stop the search for the top-most component for a layout.
   * @default false
   * @see #isLayoutRoot()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-_isLayoutRoot Original Ext JS documentation of '_isLayoutRoot'
   */
  public native function get _isLayoutRoot():Boolean;

  /**
   * @private
   */
  public native function set _isLayoutRoot(value:Boolean):void;

  [ExtConfig]
  /**
   * By default, when the →<code>ext.Component.alignTo()</code> method is called, a floating
   * component will scroll to keep aligned with the anchoring element if the anchoring element
   * is part of the scroll.
   * <p>If this is not necessary, and the <code>alignTo</code> is a one-off operation then set this config
   * to <code>false</code>.</p>
   * @default true
   * @see ext.Component#alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-alignOnScroll Original Ext JS documentation of 'alignOnScroll'
   */
  public native function get alignOnScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set alignOnScroll(value:Boolean):void;

  [ExtConfig]
  /**
   * A Component or Element by which to position this component according to the
   * →<code>defaultAlign</code>. Defaults to the owning Container.
   * <p><i>Only applicable if this component is →<code>floating</code></i></p>
   * <p><i>Used upon first show</i>.</p>
   * @see #defaultAlign
   * @see #floating
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-alignTarget Original Ext JS documentation of 'alignTarget'
   */
  public native function get alignTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set alignTarget(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A flag indicating that this component should be
   * on the top of the z-index stack for use by the →<code>zIndexManager</code> to sort its stack.
   * <p>This may be a positive number to prioritize the ordering of multiple visible
   * always on top components.</p>
   * <p>This may be set to a <i>negative</i> number to prioritize a component to the <i>bottom</i>
   * of the z-index stack.</p>
   * @default false
   * @see #zIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-alwaysOnTop Original Ext JS documentation of 'alwaysOnTop'
   * @see #getAlwaysOnTop()
   * @see #setAlwaysOnTop()
   */
  public native function get alwaysOnTop():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set alwaysOnTop(value:*):void;

  [ExtConfig]
  /**
   * This configuration option is to be applied to <b>child <code>items</code></b> of a container managed
   * by an <i>Anchor Layout</i> (→<code>ext.layout.container.AnchorLayout</code>).
   * <p>This value is what tells the layout how an item should be anchored to the container. <code>items</code>
   * added to an AnchorLayout accept an anchoring-specific config property of <b>anchor</b>
   * which is a string containing two values: the horizontal anchor value and the vertical anchor
   * value (for example, '100% 50%'). The following types of anchor values are supported:</p>
   * <ul>
   * <li>
   * <p><b>Percentage</b> : Any value between 1 and 100, expressed as a percentage.</p>
   * <p>The first anchor is the percentage width that the item should take up within the container,
   * and the second is the percentage height. For example:</p>
   * <pre>
   * // two values specified
   * anchor: '100% 50%' // render item complete width of the container and
   *                    // 1/2 height of the container
   * // one value specified
   * anchor: '100%'     // the width value; the height will default to auto
   * </pre>
   * </li>
   * <li>
   * <p><b>Offsets</b> : Any positive or negative integer value.</p>
   * <p>This is a raw adjustment where the first anchor is the offset from the right edge
   * of the container, and the second is the offset from the bottom edge. For example:</p>
   * <pre>
   * // two values specified
   * anchor: '-50 -100' // render item the complete width of the container
   *                    // minus 50 pixels and
   *                    // the complete height minus 100 pixels.
   * // one value specified
   * anchor: '-50'      // anchor value is assumed to be the right offset value
   *                    // bottom offset will default to 0
   * </pre>
   * </li>
   * <li>
   * <p><b>Sides</b> : Valid values are <code>right</code> (or <code>r</code>) and <code>bottom</code> (or <code>b</code>).</p>
   * <p>Either the container must have a fixed size or an anchorSize config value defined
   * at render time in order for these to have any effect.</p>
   * </li>
   * <li>
   * <p><b>Mixed</b> :</p>
   * <p>Anchor values can also be mixed as needed. For example, to render the width offset
   * from the container right edge by 50 pixels and 75% of the container's height use:</p>
   * <pre>
   * anchor:   '-50 75%'
   * </pre>
   * </li>
   * </ul>
   * @see ext.layout.container.AnchorLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-anchor Original Ext JS documentation of 'anchor'
   */
  public native function get anchor():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set anchor(value:String):void;

  [ExtConfig]
  /**
   * <code>true</code> to animate the shadow along with the component while the component is animating.
   * By default the shadow is hidden while the component is animating
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-animateShadow Original Ext JS documentation of 'animateShadow'
   */
  public native function get animateShadow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animateShadow(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing ARIA attributes to be set
   * on this Component's ARIA element. Use this to set the attributes that cannot be
   * determined by the Component's state, such as <code>aria-live</code>, <code>aria-flowto</code>, etc.
   * <p><b>Note</b> that this config is only meaningful at the Component rendering time,
   * and setting it after that will do nothing.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaAttributes Original Ext JS documentation of 'ariaAttributes'
   * @see #getAriaAttributes()
   * @see #setAriaAttributes()
   */
  public native function get ariaAttributes():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set ariaAttributes(value:Object):void;

  [ExtConfig]
  /**
   * DOM selector for a child element that is to be used
   * as description for this Component, set in <code>aria-describedby</code> attribute.
   * The selector works the same way as →<code>ariaLabelledBy</code>.
   * @see #ariaLabelledBy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaDescribedBy Original Ext JS documentation of 'ariaDescribedBy'
   */
  public native function get ariaDescribedBy():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDescribedBy(value:*):void;

  [ExtConfig]
  /**
   * ARIA label for this Component. It is best to use
   * →<code>ariaLabelledBy</code> option instead, because screen readers prefer
   * <code>aria-labelledby</code> attribute to <code>aria-label</code>. →<code>ariaLabel</code> and
   * →<code>ariaLabelledBy</code> config options are mutually exclusive.
   * @see #ariaLabelledBy
   * @see #ariaLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaLabel Original Ext JS documentation of 'ariaLabel'
   */
  public native function get ariaLabel():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaLabel(value:String):void;

  [ExtConfig]
  /**
   * DOM selector for a child element that is to be used
   * as label for this Component, set in <code>aria-labelledby</code> attribute.
   * If the selector is by <code>#id</code>, the label element can be any existing element,
   * not necessarily a child of the main Component element.
   * <p>→<code>ariaLabelledBy</code> and →<code>ariaLabel</code> config options are
   * mutually exclusive, and <code>→ariaLabelledBy</code> has the higher precedence.</p>
   * @see #ariaLabelledBy
   * @see #ariaLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Accessible.html#cfg-ariaLabelledBy Original Ext JS documentation of 'ariaLabelledBy'
   */
  public native function get ariaLabelledBy():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaLabelledBy(value:*):void;

  /**
   * @inheritDoc
   */
  public native function get ariaRole():String;

  [ExtConfig]
  /**
   * A tag name or →<code>ext.dom.DomHelper</code> spec used to create the <i>Element</i> (→<code>getEl()</code>)
   * which will encapsulate this Component.
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b>'div'</b>. The more complex Sencha classes
   * use a more complex DOM structure specified by their own →<code>renderTpl</code>s.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * encapsulated by different DOM elements. Example usage:</p>
   * <pre>
   * {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'img',
   *         src: 'http://www.example.com/example.jpg'
   *     }
   * }, {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'blockquote',
   *         html: 'autoEl is cool!'
   *     }
   * }, {
   *     xtype: 'container',
   *     autoEl: 'ul',
   *     cls: 'ux-unordered-list',
   *     items: {
   *         xtype: 'component',
   *         autoEl: 'li',
   *         html: 'First list item'
   *     }
   * }
   * </pre>
   * @since 2.3.0
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-autoEl Original Ext JS documentation of 'autoEl'
   */
  public native function get autoEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoEl(value:*):void;

  [ExtConfig]
  /**
   * This config is intended mainly for non-→<code>floating</code> Components which may or may not
   * be shown. Instead of using →<code>renderTo</code> in the configuration, and rendering upon
   * construction, this allows a Component to render itself upon first
   * <i>show (→<code>ext.Component.show()</code>)</i>. If →<code>floating</code> is <code>true</code>, the value
   * of this config is omitted as if it is <code>true</code>.
   * <p>Specify as <code>true</code> to have this Component render to the document body upon first show.</p>
   * <p>Specify as an element, or the ID of an element to have this Component render to a specific
   * element upon first show.</p>
   * @default false
   * @see #floating
   * @see #renderTo
   * @see ext.Component#show()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-autoRender Original Ext JS documentation of 'autoRender'
   */
  public native function get autoRender():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoRender(value:*):void;

  [Deprecated(replacement="scrollable", since="5.1.0")]
  [ExtConfig]
  /**
   * <code>true</code> to use overflow:'auto' on the components layout element and show scroll bars
   * automatically when necessary, <code>false</code> to clip any overflowing content.
   * <p>This should not be combined with →<code>overflowX</code> or →<code>overflowY</code>.</p>
   * @default false
   * @see #overflowX
   * @see #overflowY
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-autoScroll Original Ext JS documentation of 'autoScroll'
   * @see #setAutoScroll()
   */
  public native function get autoScroll():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set autoScroll(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to automatically show the component upon creation. This config option may only be used
   * for →<code>floating</code> components or components that use →<code>autoRender</code>.
   * @default false
   * @since 2.3.0
   * @see #floating
   * @see #autoRender
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-autoShow Original Ext JS documentation of 'autoShow'
   */
  public native function get autoShow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoShow(value:Boolean):void;

  /**
   * The Action assigned to this Component.
   */
  public native function get baseAction():Action;

  /**
   * @private
   */
  public native function set baseAction(value:Action):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'component'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Setting this config option adds or removes data bindings for other configs.
   * For example, to bind the <code>title</code> config:
   * <pre>
   *  var panel = Ext.create({
   *      xtype: 'panel',
   *      bind: {
   *          title: 'Hello {user.name}'
   *      }
   *  });
   * </pre>
   * <p>To dynamically add bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: 'Greetings {user.name}!'
   *  });
   * </pre>
   * <p>To remove bindings:</p>
   * <pre>
   *  panel.setBind({
   *      title: null
   *  });
   * </pre>
   * <p>The bind expressions are presented to <code>→ext.app.ViewModel.bind()</code>. The
   * <code>ViewModel</code> instance is determined by <code>→lookupViewModel()</code>.</p>
   * <p><b>Note:</b> If bind is passed as a string, it will use the
   * →<code>ext.Component.defaultBindProperty</code> for the binding.</p>
   * @default null
   * @see ext.app.ViewModel#bind()
   * @see #lookupViewModel()
   * @see ext.Component#defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-bind Original Ext JS documentation of 'bind'
   * @see #getBind()
   * @see #setBind()
   */
  public native function get bind():*;

  [ExtConfig(extractXType)]
  [Bindable]
  /**
   * @private
   */
  public native function set bind(value:*):void;

  [ExtConfig]
  /**
   * Specifies the border size for this component. The border can be a single numeric value
   * to apply to all sides or it can be a CSS style specification for each style,
   * for example: '10 5 3 10' (top, right, bottom, left).
   * <p>For components that have no border by default, setting this won't make the border appear
   * by itself. You also need to specify border color and style:</p>
   * <pre>
   * border: 5,
   * style: {
   *     borderColor: 'red',
   *     borderStyle: 'solid'
   * }
   * </pre>
   * <p>To turn off the border, use <code>border: false</code>.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-border Original Ext JS documentation of 'border'
   * @see #setBorder()
   */
  public native function get border():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set border(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default {}
   * @see #childEls
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.ElementContainer.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * An optional extra CSS class that will be added to this component's Element.
   * The value can be a string, a list of strings separated by spaces, or an array of strings.
   * This can be useful for adding customized styles to the component or any of its children
   * using standard CSS rules.
   * @default ''
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-cls Original Ext JS documentation of 'cls'
   */
  public native function get cls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cls(value:String):void;

  [ExtConfig]
  /**
   * Defines the column width inside <i>column layout</i> (→<code>ext.layout.container.ColumnLayout</code>).
   * <p>The columnWidth property is always evaluated as a percentage and must be a decimal value
   * greater than 0 and less than 1 (e.g., .25). See the description at the top of
   * <i>column layout</i> (→<code>ext.layout.container.ColumnLayout</code>) for additional usage details when combining
   * width and columnWidth configs within the layout.</p>
   * @see ext.layout.container.ColumnLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-columnWidth Original Ext JS documentation of 'columnWidth'
   */
  public native function get columnWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columnWidth(value:Number):void;

  [ExtConfig]
  /**
   * CSS Class to be added to a components root level element to give distinction to it
   * via styling.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-componentCls Original Ext JS documentation of 'componentCls'
   */
  public native function get componentCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set componentCls(value:String):void;

  [ExtConfig]
  /**
   * The sizing and positioning of a Component's internal Elements is the responsibility
   * of the Component's layout manager which sizes a Component's internal structure in response
   * to the Component being sized.
   * <p>Generally, developers will not use this configuration as all provided Components which need
   * their internal elements sizing (Such as <i>input fields</i> (→<code>ext.form.field.BaseField</code>)) come with
   * their own componentLayout managers.</p>
   * <p>The <i>default layout manager</i> (→<code>ext.layout.container.AutoLayout</code>) will be used on instances of the
   * base Ext.Component class which simply sizes the Component's encapsulating element to the
   * height and width specified in the →<code>setSize()</code> method.</p>
   * @default 'autocomponent'
   * @see ext.form.field.BaseField
   * @see ext.layout.container.AutoLayout
   * @see #setSize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-componentLayout Original Ext JS documentation of 'componentLayout'
   */
  public native function get componentLayout():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set componentLayout(value:*):void;

  [ExtConfig]
  /**
   * True to constrain this Components within its containing element, false to allow it to fall
   * outside of its containing element. By default this Component will be rendered to
   * <code>document.body</code>. To render and constrain this Component within another element specify
   * →<code>ext.Component.renderTo</code>.
   * @default false
   * @see ext.Component#renderTo
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-constrain Original Ext JS documentation of 'constrain'
   */
  public native function get constrain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrain(value:Boolean):void;

  [ExtConfig]
  /**
   * A →<code>ext.util.Region</code> (or an element from which a Region measurement will be read)
   * which is used to constrain the component. Only applies when the component is floating.
   * @see ext.util.Region
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-constrainTo Original Ext JS documentation of 'constrainTo'
   */
  public native function get constrainTo():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrainTo(value:*):void;

  [ExtConfig]
  /**
   * An object or a string (in TRBL order) specifying insets from the configured
   * <i>constrain region</i> (→<code>constrainTo</code>) within which this component must be constrained
   * when positioning or sizing. Example:
   * <pre>
   * constraintInsets: '10 10 10 10' // Constrain with 10px insets from parent
   * </pre>
   * @see #constrainTo
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-constraintInsets Original Ext JS documentation of 'constraintInsets'
   */
  public native function get constraintInsets():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constraintInsets(value:*):void;

  /**
   * <code>true</code> if this currently focused element
   * is within this Component's or Container's hierarchy. This property is set separately
   * from →<code>hasFocus</code>, and can be <code>true</code> when <code>→hasFocus</code> is <code>false</code>.
   * <p>Examples:</p>
   * <ul>
   * <li>
   * <p>Text field with input element focused would be:
   * focusable: true,
   * hasFocus: true,
   * containsFocus: true</p>
   * </li>
   * <li>
   * <p>Date field with drop-down picker currently focused would be:
   * focusable: true,
   * hasFocus: false,
   * containsFocus: true</p>
   * </li>
   * <li>
   * <p>Form Panel with a child input field currently focused would be:
   * focusable: false,
   * hasFocus: false,
   * containsFocus: true</p>
   * </li>
   * </ul>
   * <p>See also →<code>hasFocus</code>.</p>
   * @default false
   * @see #hasFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-containsFocus Original Ext JS documentation of 'containsFocus'
   */
  public native function get containsFocus():Boolean;

  [ExtConfig]
  /**
   * Specify an existing HTML element, or the <code>→id</code> of an existing HTML element to use as the
   * content for this component.
   * <p>This config option is used to take an existing HTML element and place it in the layout
   * element of a new component (it simply moves the specified DOM element <i>after the Component
   * is rendered</i> to use as the content.</p>
   * <p><b>Notes:</b></p>
   * <p>The specified HTML element is appended to the layout element of the component <i>after any
   * configured HTML (→<code>html</code>) has been inserted</i>, and so the document will not contain
   * this element at the time the →<code>event:onRender</code> event is fired.</p>
   * <p>The specified HTML element used will not participate in any
   * <b><code>→ext.container.Container.layout</code></b> scheme that the Component may use.
   * It is just HTML. Layouts operate on child
   * <b><code>→ext.container.Container.items</code></b>.</p>
   * <p>Add either the <code>x-hidden</code> or the <code>x-hidden-display</code> CSS class to prevent a brief flicker
   * of the content before it is rendered to the panel.</p>
   * @since 3.4.0
   * @see #id
   * @see #html
   * @see #event:onRender
   * @see ext.container.Container#layout
   * @see ext.container.Container#items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-contentEl Original Ext JS documentation of 'contentEl'
   */
  public native function get contentEl():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set contentEl(value:String):void;

  /**
   * The name of the padding property that is used by the layout to manage
   * padding. See →<code>ext.layout.container.AutoLayout.managePadding</code>
   * @default 'padding'
   * @see ext.layout.container.AutoLayout#managePadding
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-contentPaddingProperty Original Ext JS documentation of 'contentPaddingProperty'
   */
  public native function get contentPaddingProperty():String;

  /**
   * @private
   */
  public native function set contentPaddingProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A string alias, a configuration object or an instance of a <code>ViewController</code> for
   * this container. Sample usage:
   * <pre>
   * Ext.define('MyApp.UserController', {
   *     alias: 'controller.user'
   * });
   *
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: 'user'
   * });
   * // Or
   * Ext.define('UserContainer', {
   *     extend: 'Ext.container.container',
   *     controller: {
   *         type: 'user',
   *         someConfig: true
   *     }
   * });
   *
   * // Can also instance at runtime
   * var ctrl = new MyApp.UserController();
   * var view = new UserContainer({
   *     controller: ctrl
   * });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-controller Original Ext JS documentation of 'controller'
   * @see #getController()
   * @see #setController()
   */
  public native function get controller():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set controller(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The initial set of data to apply to the <code>→tpl</code> to update the content
   * area of the Component.
   * @since 3.4.0
   * @see #tpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-data Original Ext JS documentation of 'data'
   * @see #getData()
   * @see #setData()
   */
  public native function get data():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set data(value:Object):void;

  [ExtConfig]
  /**
   * The default <i>Ext.dom.Element.getAlignToXY</i> (→<code>ext.util.Positionable.getAlignToXY()</code>) anchor
   * position value for this component relative to its →<code>alignTarget</code>
   * (which defaults to its owning Container).
   * <p><i>Only applicable if this component is →<code>floating</code></i></p>
   * <p><i>Used upon first show</i>.</p>
   * @default 'c-c'
   * @see ext.util.Positionable#getAlignToXY()
   * @see #alignTarget
   * @see #floating
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-defaultAlign Original Ext JS documentation of 'defaultAlign'
   */
  public native function get defaultAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultAlign(value:String):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  public native function get defaultBindProperty():String;

  /**
   * @private
   */
  public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * If <code>true</code>, this component will be the default scope (this pointer) for events
   * specified with string names so that the scope can be dynamically resolved. The
   * component will automatically become the defaultListenerScope if a
   * →<code>controller</code> is specified.
   * <p>See the introductory docs for →<code>ext.container.Container</code> for some sample
   * usages.</p>
   * <p><b>NOTE</b>: This value can only be reliably set at construction time. Setting it
   * after that time may not correctly rewire all of the potentially effected
   * listeners.</p>
   * @default false
   * @see #controller
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-defaultListenerScope Original Ext JS documentation of 'defaultListenerScope'
   * @see #getDefaultListenerScope()
   * @see #setDefaultListenerScope()
   */
  public native function get defaultListenerScope():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set defaultListenerScope(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to disable the component.
   * @default false
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set disabled(value:Boolean):void;

  [ExtConfig]
  /**
   * CSS class to add when the Component is disabled.
   * @default Ext.baseCSSPrefix + 'item-disabled'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-disabledCls Original Ext JS documentation of 'disabledCls'
   */
  public native function get disabledCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabledCls(value:String):void;

  [ExtConfig]
  /**
   * The side of the <i>panel</i> (→<code>ext.panel.Panel</code>) where this component is to be
   * docked when specified in the panel's
   * →<code>ext.panel.Panel.dockedItems</code> config.
   * <p>Possible values are:</p>
   * <ul>
   * <li>top</li>
   * <li>bottom</li>
   * <li>left</li>
   * <li>right</li>
   * </ul>
   * @see ext.panel.Panel
   * @see ext.panel.Panel#dockedItems
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-dock Original Ext JS documentation of 'dock'
   * @see #setDock()
   */
  public native function get dock():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set dock(value:String):void;

  [ExtConfig]
  /**
   * Specify as true to make a →<code>floating</code> Component draggable using the Component's
   * encapsulating element as the drag handle.
   * <p>This may also be specified as a config object for the
   * →<code>ext.util.ComponentDragger</code> which is instantiated to perform dragging.</p>
   * <p>For example to create a Component which may only be dragged around using a certain internal
   * element as the drag handle, use the delegate option:</p>
   * <pre>
   * new Ext.Component({
   *     constrain: true,
   *     floating: true,
   *     style: {
   *         backgroundColor: '#fff',
   *         border: '1px solid black'
   *     },
   *     html: '&lt;h1 style="cursor:move"&gt;The title&lt;/h1&gt;&lt;p&gt;The content&lt;/p&gt;',
   *     draggable: {
   *         delegate: 'h1'
   *     }
   * }).show();
   * </pre>
   * @default false
   * @see #floating
   * @see ext.util.ComponentDragger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-draggable Original Ext JS documentation of 'draggable'
   */
  public native function get draggable():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set draggable(value:*):void;

  /**
   * @see #getEl()
   */
  public native function get el():Element;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to have this Component fixed at its <code>X, Y</code> coordinates in the browser
   * viewport, immune to scrolling the document.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-fixed Original Ext JS documentation of 'fixed'
   */
  public native function get fixed():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fixed(value:Boolean):void;

  [ExtConfig]
  /**
   * Flex may be applied to <b>child items</b> of a box layout
   * (<i>vbox</i> (→<code>ext.layout.container.VBoxLayout</code>) or <i>hbox</i> (→<code>ext.layout.container.HBoxLayout</code>)).
   * Each child item with a flex property will fill space (horizontally in <code>hbox</code>, vertically
   * in <code>vbox</code>) according to that item's <b>relative</b> flex value compared to the sum of all items
   * with a flex value specified.
   * <p>Any child items that have either a <code>→flex</code> of <code>0</code> or <code>undefined</code>
   * will not be 'flexed' (the initial size will not be changed).</p>
   * @see ext.layout.container.VBoxLayout
   * @see ext.layout.container.HBoxLayout
   * @see #flex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-flex Original Ext JS documentation of 'flex'
   */
  public native function get flex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set flex(value:Number):void;

  /**
   * <b>Only present for →<code>floating</code> Components which were inserted as child items
   * of Containers.</b>
   * <p>There are other similar relationships such as the <i>button</i> (→<code>ext.button.Button</code>) which
   * activates a →<code>ext.button.Button.menu</code>, or the
   * <i>menu item</i> (→<code>ext.menu.Item</code>) which activated a <i>submenu</i> (→<code>ext.menu.Item.menu</code>),
   * or the <i>column header</i> (→<code>ext.grid.column.Column</code>) which activated the column menu.</p>
   * <p>These differences are abstracted away by the →<code>up()</code> method.</p>
   * <p>Floating Components that are programmatically <i>rendered</i> (→<code>ext.Component.render()</code>)
   * will not have a <code>→floatParent</code> property.</p>
   * <p>See →<code>floating</code> and →<code>zIndexManager</code></p>
   * @see #floating
   * @see ext.button.Button
   * @see ext.button.Button#menu
   * @see ext.menu.Item
   * @see ext.menu.Item#menu
   * @see ext.grid.column.Column
   * @see #up()
   * @see ext.Component#render()
   * @see #floatParent
   * @see #zIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-floatParent Original Ext JS documentation of 'floatParent'
   */
  public native function get floatParent():Container;

  [ExtConfig]
  /**
   * Specify as true to float the Component outside of the document flow using CSS absolute
   * positioning.
   * <p>Components such as →<code>ext.window.Window</code>s and →<code>ext.menu.Menu</code>s are
   * floating by default.</p>
   * <p>Floating Components that are programmatically <i>rendered</i> (→<code>ext.Component.render()</code>)
   * will register themselves with the global <i>ZIndexManager</i> (→<code>ext.WindowManager</code>)</p>
   * <p><i>Floating Components as child items of a Container</i></p>
   * <p>A floating Component may be used as a child item of a Container. This just allows
   * the floating Component to seek a ZIndexManager by examining the ownerCt chain.</p>
   * <p>When configured as floating, Components acquire, at render time, a
   * →<code>ext.ZIndexManager</code> which manages a stack of related floating Components.
   * The ZIndexManager sorts its stack according to an incrementing access counter and the
   * →<code>ext.util.Floating.alwaysOnTop</code> config when the Component's
   * →<code>toFront()</code> method is called.</p>
   * <p>The ZIndexManager is found by traversing up the →<code>ownerCt</code> chain to find an ancestor
   * which itself is floating. This is so that descendant floating Components of floating
   * <i>Containers</i> (Such as a ComboBox dropdown within a Window) can have its zIndex managed
   * relative to any siblings, but always <b>above</b> that floating ancestor Container.</p>
   * <p>If no floating ancestor is found, a floating Component registers itself with the default
   * <i>ZIndexManager</i> (→<code>ext.WindowManager</code>).</p>
   * <p>Floating components <i>do not participate in the Container's layout</i>. Because of this,
   * they are not rendered until you explicitly →<code>show()</code> them.</p>
   * <p>After rendering, the ownerCt reference is deleted, and the →<code>floatParent</code> property
   * is set to the found floating ancestor Container. If no floating ancestor Container was found
   * the →<code>floatParent</code> property will not be set.</p>
   * @default false
   * @see ext.window.Window
   * @see ext.menu.Menu
   * @see ext.Component#render()
   * @see ext.#WindowManager ext.WindowManager
   * @see ext.ZIndexManager
   * @see ext.util.Floating#alwaysOnTop
   * @see #toFront()
   * @see #ownerCt
   * @see #show()
   * @see #floatParent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-floating Original Ext JS documentation of 'floating'
   */
  public native function get floating():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set floating(value:Boolean):void;

  [ExtConfig]
  /**
   * CSS class that will be added to focused
   * component's →<code>focusClsEl</code>, and removed when component blurs.
   * @default 'x-focused'
   * @see #focusClsEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#cfg-focusCls Original Ext JS documentation of 'focusCls'
   */
  public native function get focusCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set focusCls(value:String):void;

  /**
   * The element that will have the
   * →<code>focusCls</code> applied when component's →<code>focusEl</code> is focused.
   * @see #focusCls
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-focusClsEl Original Ext JS documentation of 'focusClsEl'
   */
  public native function get focusClsEl():Element;

  /**
   * @private
   */
  public native function set focusClsEl(value:Element):void;

  /**
   * The element that will be focused
   * when →<code>focus()</code> method is called on this component. Usually this is
   * the same element that receives focus via mouse clicks, taps, and pressing
   * Tab key.
   * @default 'el'
   * @see #focus()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-focusEl Original Ext JS documentation of 'focusEl'
   */
  public native function get focusEl():Element;

  /**
   * @private
   */
  public native function set focusEl(value:Element):void;

  [ExtConfig]
  /**
   * Specifies whether the floated component should be automatically
   * <i>focused</i> (→<code>ext.Component.focus()</code>) when it is <i>brought to the front</i> (→<code>toFront()</code>).
   * @default true
   * @see ext.Component#focus()
   * @see #toFront()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-focusOnToFront Original Ext JS documentation of 'focusOnToFront'
   */
  public native function get focusOnToFront():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set focusOnToFront(value:Boolean):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default false
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  public native function get focusable():Boolean;

  [ExtConfig]
  /**
   * When inside FormPanel, any component configured with <code>formBind: true</code> will
   * be enabled/disabled depending on the validity state of the form.
   * See →<code>ext.form.FormPanel</code> for more information and example.
   * @default false
   * @see ext.form.FormPanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-formBind Original Ext JS documentation of 'formBind'
   */
  public native function get formBind():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set formBind(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to have the Component inject framing elements within the Component
   * at render time to provide a graphical rounded frame around the Component content.
   * <p>This is only necessary when running on outdated, or non standard-compliant browsers
   * such as Microsoft's Internet Explorer prior to version 9 which do not support rounded corners
   * natively.</p>
   * <p>The extra space taken up by this framing is available from the read only property
   * →<code>frameSize</code>.</p>
   * @see #frameSize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-frame Original Ext JS documentation of 'frame'
   */
  public native function get frame():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set frame(value:Boolean):void;

  /**
   * Indicates the width of any framing elements which were added within the encapsulating
   * element to provide graphical, rounded borders. See the →<code>frame</code> config. This
   * property is <code>null</code> if the component is not framed.
   * <p>This is an object containing the frame width in pixels for all four sides of the
   * Component containing the following properties:</p>
   * <ul>
   * <li><code>top:Number</code> (default = <code>0</code>) —
   * The width of the top framing element in pixels.
   * </li>
   * <li><code>right:Number</code> (default = <code>0</code>) —
   * The width of the right framing element in pixels.
   * </li>
   * <li><code>bottom:Number</code> (default = <code>0</code>) —
   * The width of the bottom framing element in pixels.
   * </li>
   * <li><code>left:Number</code> (default = <code>0</code>) —
   * The width of the left framing element in pixels.
   * </li>
   * <li><code>width:Number</code> (default = <code>0</code>) —
   * The total width of the left and right framing elements
   * in pixels.
   * </li>
   * <li><code>height:Number</code> (default = <code>0</code>) —
   * The total height of the top and right bottom elements
   * in pixels.
   * </li>
   * </ul>
   * @see #frame
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-frameSize Original Ext JS documentation of 'frameSize'
   */
  public native function get frameSize():Object;

  /**
   * <code>true</code> if this component's →<code>focusEl</code> is focused.
   * See also →<code>containsFocus</code>.
   * @default false
   * @see #focusEl
   * @see #containsFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-hasFocus Original Ext JS documentation of 'hasFocus'
   */
  public native function get hasFocus():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The height of this component. A numeric value will be interpreted as the number of
   * pixels; a string value will be treated as a CSS value with units.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-height Original Ext JS documentation of 'height'
   * @see #getHeight()
   * @see #setHeight()
   */
  public native function get height():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set height(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to hide the component.
   * @default false
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #setHidden()
   */
  public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set hidden(value:Boolean):void;

  [ExtConfig]
  /**
   * A String which specifies how this Component's encapsulating DOM element will be hidden.
   * Values may be:
   * <ul>
   * <li><code>'display'</code> : The Component will be hidden using the <code>display: none</code> style.</li>
   * <li><code>'visibility'</code> : The Component will be hidden using the <code>visibility: hidden</code> style.</li>
   * <li><code>'offsets'</code> : The Component will be hidden by absolutely positioning it out of the
   * visible area of the document.
   * This is useful when a hidden Component must maintain measurable dimensions. Hiding using
   * <code>display</code> results in a Component having zero dimensions.</li>
   * </ul>
   * @default 'display'
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-hideMode Original Ext JS documentation of 'hideMode'
   */
  public native function get hideMode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideMode(value:String):void;

  [ExtConfig]
  /**
   * An HTML fragment, or a →<code>ext.dom.DomHelper</code> specification to use as the layout
   * element content. The HTML content is added after the component is rendered, so the document
   * will not contain this HTML at the time the →<code>event:onRender</code> event is fired. This content
   * is inserted into the body <i>before</i> any configured →<code>contentEl</code> is appended.
   * @default ''
   * @since 3.4.0
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #event:onRender
   * @see #contentEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-html Original Ext JS documentation of 'html'
   * @see #setHtml()
   */
  public native function get html():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set html(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The <b>unique</b> id of this component instance.
   * <p>Use of this config should be considered carefully as this value must be unique across
   * all existing components. Components created with an <code>→id</code> may be accessed globally
   * using →<code>ext.Ext.getCmp()</code>.</p>
   * <p>Instead of using assigned ids, consider a →<code>reference</code> config and
   * a <i>ViewController</i> (→<code>controller</code>) to respond to events and perform processing
   * upon this Component.</p>
   * <p>Alternatively, →<code>itemId</code> and →<code>ext.ComponentQuery</code> can be
   * used to perform selector-based searching for Components analogous to DOM querying.
   * The →<code>ext.container.Container</code> class contains several helpful
   * <i>shortcut methods</i> (→<code>ext.container.Container.down()</code>) to query its descendant
   * Components by selector.</p>
   * <p>Note that this <code>→id</code> will also be used as the element id for the containing HTML
   * element that is rendered to the page for this component. This allows you to write
   * id-based CSS rules to style the specific instance of this component uniquely, and
   * also to select sub-elements using this component's <code>→id</code> as the parent.</p>
   * <p>Defaults to an <i>auto-assigned id</i> (→<code>getId()</code>).</p>
   * <p><b>Note</b>: Valid identifiers start with a letter or underscore and are followed by
   * (optional) additional letters, underscores, digits or hyphens.</p>
   * @since 1.1.0
   * @see #id
   * @see ext.SExt#getCmp() ext.Ext.getCmp()
   * @see #reference
   * @see #controller
   * @see #itemId
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see ext.container.Container
   * @see ext.container.Container#down()
   * @see #getId()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-id Original Ext JS documentation of 'id'
   */
  public native function get id():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set id(value:String):void;

  [ExtConfig("id")]
  /**
   * Alias for <code>id</code> property to make it accessible from MXML.
   * @copy #id
   * @see #id
   */
  public native function set id_(value:String):void;

  /**
   * Template method to do any Focusable related initialization that
   * does not involve event listeners creation.
   * @default Ext.emptyFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#property-initFocusable Original Ext JS documentation of 'initFocusable'
   */
  public native function get initFocusable():*;

  /**
   * @private
   */
  public native function set initFocusable(value:*):void;

  /**
   * The config object passed to the constructor during Component creation.
   * @default config
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-initialConfig Original Ext JS documentation of 'initialConfig'
   */
  public native function get initialConfig():Object;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Component, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-isComponent Original Ext JS documentation of 'isComponent'
   */
  public native function get isComponent():Boolean;

  /**
   * @private
   */
  public native function set isComponent(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The <b>unique</b> id of this component instance within its container. See also the
   * →<code>reference</code> config.
   * <p>An <code>→itemId</code> can be used as an alternative way to get a reference to a component
   * when no object reference is available. Instead of using an <code>→id</code> with
   * →<code>ext.Ext.getCmp()</code>, use <code>→itemId</code> with
   * →<code>ext.container.Container.getComponent()</code> which will retrieve <code>→itemId</code>'s
   * or →<code>id</code>'s. Since <code>→itemId</code>'s are an index to the container's internal collection,
   * the <code>→itemId</code> is scoped locally to the container -- avoiding potential conflicts with
   * →<code>ext.ComponentManager</code>, which requires a <b>unique</b> →<code>id</code> value.</p>
   * <pre>
   * var c = new Ext.panel.Panel({ //
   *     height: 300,
   *     renderTo: document.body,
   *     layout: 'auto',
   *     items: [{
   *         itemId: 'p1',
   *         title: 'Panel 1',
   *         height: 150
   *     },{
   *         itemId: 'p2',
   *         title: 'Panel 2',
   *         height: 150
   *     }]
   * });
   *
   * p1 = c.getComponent('p1'); // not the same as Ext.getCmp()
   * console.log(p1);
   * p2 = p1.ownerCt.getComponent('p2'); // reference via a sibling
   * console.log(p2);
   * </pre>
   * <p>Also see →<code>id</code>, <code>→ext.container.Container.query()</code>,
   * <code>→ext.container.Container.down()</code> and <code>→ext.container.Container.child()</code>.</p>
   * <p><b>Note</b>: Valid identifiers start with a letter or underscore and are followed by
   * (optional) additional letters, underscores, digits or hyphens.</p>
   * <p><b>Note</b>: to access the container of an item see →<code>ownerCt</code>.</p>
   * @since 3.4.0
   * @see #reference
   * @see #itemId
   * @see #id
   * @see ext.SExt#getCmp() ext.Ext.getCmp()
   * @see ext.container.Container#getComponent()
   * @see ext.#ComponentManager ext.ComponentManager
   * @see ext.container.Container#query()
   * @see ext.container.Container#down()
   * @see ext.container.Container#child()
   * @see #ownerCt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-itemId Original Ext JS documentation of 'itemId'
   * @see #getItemId()
   */
  public native function get itemId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemId(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing handlers for keyboard events. The property names of this
   * object are the key name and any modifiers. The values of the properties are the
   * descriptors of how to handle each event.
   * <p>The handler descriptor can be simply the handler function(either the
   * literal function or the method name), or it can be an object with these
   * properties:</p>
   * <ul>
   * <li><code>handler</code>: The function or its name to call to handle the event.</li>
   * <li><code>scope</code>: The this pointer context (can be "this" or "controller").</li>
   * <li><code>event</code>: An optional override of the key event to which to listen.</li>
   * </ul>
   * <p><b>Important:</b> Calls to <code>setKeyMap</code> do not replace the entire <code>→keyMap</code> but
   * instead update the provided mappings. That is, unless <code>null</code> is passed as the
   * value of the <code>→keyMap</code> which will clear the <code>→keyMap</code> of all entries.</p>
   * <ul>
   * <li><code>scope:String</code> (optional) —
   * The default scope to apply to key handlers
   * which do not specify a scope. This is processed the same way as the scope of
   * →<code>listeners</code>. It defaults to the <code>"controller"</code>, but using <code>'this'</code>
   * means that an instance method will be used.
   * </li>
   * </ul>
   * @see #keyMap
   * @see #listeners
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#cfg-keyMap Original Ext JS documentation of 'keyMap'
   * @see #getKeyMap()
   * @see #setKeyMap()
   */
  public native function get keyMap():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set keyMap(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Enables or disables processing keys in the <code>→keyMap</code>. This value starts as
   * <code>null</code> and if it is <code>null</code> when <code>→initKeyMap()</code> is called, it will automatically
   * be set to <code>true</code>. Since <code>→initKeyMap()</code> is called by <code>→ext.Component</code> at the
   * proper time, this is not something application code normally handles.
   * @default null
   * @see #keyMap
   * @see #initKeyMap()
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#cfg-keyMapEnabled Original Ext JS documentation of 'keyMapEnabled'
   * @see #getKeyMapEnabled()
   * @see #setKeyMapEnabled()
   */
  public native function get keyMapEnabled():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set keyMapEnabled(value:Boolean):void;

  [ExtConfig]
  /**
   * The name of the member that should be used to listen for keydown/keypress events.
   * This is intended to be controlled at the class level not per instance.
   * @default 'el'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#cfg-keyMapTarget Original Ext JS documentation of 'keyMapTarget'
   */
  public native function get keyMapTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyMapTarget(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get lastKeyMapEvent():Event;

  /**
   * @inheritDoc
   */
  public native function set lastKeyMapEvent(value:Event):void;

  [ExtConfig]
  /**
   * Components that achieve their internal layout results using solely CSS with no JS
   * intervention must set this to true. This allows the component to opt out of the
   * layout run when used inside certain container layouts such as →<code>ext.layout.container.FormLayout</code> and →<code>ext.layout.container.AutoLayout</code>
   * resulting in a performance gain. The following components currently use liquid
   * layout (<code>liquidLayout: true</code>):
   * <ul>
   * <li>All Form Fields (subclasses of →<code>ext.form.field.BaseField</code>)</li>
   * <li>→<code>ext.button.Button</code></li>
   * </ul>
   * <p>It is important to keep in mind that components using liquidLayout do not fire
   * the following events:</p>
   * <ul>
   * <li>→<code>event:onResize</code></li>
   * <li>→<code>event:onBoxReady</code></li>
   * </ul>
   * <p>In addition, liquidLayout components do not call the following template methods:</p>
   * <ul>
   * <li>→<code>afterComponentLayout()</code></li>
   * <li>→<code>onBoxReady()</code></li>
   * <li>→<code>onResize()</code></li>
   * </ul>
   * <p>Any component that needs to fire these events or to have these methods called during
   * its life cycle needs to set <code>→liquidLayout</code> to <code>false</code>. The following example
   * demonstrates how to enable the resize event for a
   * <i>TextArea Field</i> (→<code>ext.form.field.TextArea</code>):</p>
   * <p><b>Example:</b></p>
   * <pre>
   * var win = Ext.create({
   *         xtype: 'window',
   *         title: 'Resize This Window!',
   *         height: 100,
   *         width: 200,
   *         layout: 'anchor',
   *         items: [{
   *             xtype: 'textarea',
   *             anchor: '0 0',
   *             liquidLayout: false // allows the textarea to fire "resize"
   *         }]
   *     }),
   *     textfield = win.items.getAt(0);
   *
   * win.show();
   *
   * textfield.on('resize', function(textfield, width, height) {
   *     Ext.Msg.alert('Text Field Resized', 'width: ' + width + ', height: ' + height);
   * });
   * </pre>
   * <p>Use caution when setting <code>→liquidLayout</code> to <code>false</code> as it carries a performance penalty
   * since it means the layout system must perform expensive DOM reads to determine the
   * Component's size.</p>
   * @default false
   * @see ext.layout.container.FormLayout
   * @see ext.layout.container.AutoLayout
   * @see ext.form.field.BaseField
   * @see ext.button.Button
   * @see #event:onResize
   * @see #event:onBoxReady
   * @see #afterComponentLayout()
   * @see #onBoxReady()
   * @see #onResize()
   * @see #liquidLayout
   * @see ext.form.field.TextArea
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-liquidLayout Original Ext JS documentation of 'liquidLayout'
   */
  public native function get liquidLayout():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set liquidLayout(value:Boolean):void;

  [ExtConfig]
  /**
   * True to drag the component itself. Else a lightweight version of the component
   * will be shown (<i>using the component's ghost() method</i>).
   * <p><b>Note:</b> This config is only relevant when used with dragging implemented via
   * →<code>ext.util.ComponentDragger</code>.</p>
   * @default false
   * @see ext.util.ComponentDragger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-liveDrag Original Ext JS documentation of 'liveDrag'
   */
  public native function get liveDrag():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set liveDrag(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * A configuration object or an instance of a →<code>ext.ComponentLoader</code> to load remote content
   * for this Component.
   * <pre>
   * Ext.create('Ext.Component', {
   *     loader: {
   *         url: 'content.html',
   *         autoLoad: true
   *     },
   *     renderTo: Ext.getBody()
   * });
   * </pre>
   * @see ext.ComponentLoader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-loader Original Ext JS documentation of 'loader'
   * @see #getLoader()
   */
  public native function get loader():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loader(value:*):void;

  [ExtConfig]
  /**
   * Specifies the margin for this component. The margin can be a single numeric value to apply
   * to all sides or it can be a CSS style specification for each style,
   * for example: '10 5 3 10' (top, right, bottom, left).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-margin Original Ext JS documentation of 'margin'
   * @see #setMargin()
   */
  public native function get margin():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set margin(value:*):void;

  [ExtConfig]
  /**
   * Default LoadMask configuration for →<code>setLoading()</code>.
   * @see #setLoading()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-maskDefaults Original Ext JS documentation of 'maskDefaults'
   */
  public native function get maskDefaults():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maskDefaults(value:Object):void;

  [ExtConfig]
  /**
   * Related to the →<code>childEls</code> configuration which specifies named properties
   * which correspond to component sub-elements.
   * <p>The name of the element property in this component to mask when masked by a LoadMask.</p>
   * <p>Defaults to <code>null</code> to indicate that Components cannot by default contain a LoadMask,
   * and that any LoadMask should be rendered into the document body.</p>
   * <p>For example, Panels use <code>"el"</code> to indicate that the whole panel should be masked.
   * This could be configured to be <code>"body"</code> so that only the body is masked and toolbars
   * and the header are still mouse-accessible.</p>
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-maskElement Original Ext JS documentation of 'maskElement'
   */
  public native function get maskElement():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maskElement(value:String):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value in pixels which this Component will set its height to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-maxHeight Original Ext JS documentation of 'maxHeight'
   * @see #getMaxHeight()
   * @see #setMaxHeight()
   */
  public native function get maxHeight():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maxHeight(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The maximum value in pixels which this Component will set its width to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-maxWidth Original Ext JS documentation of 'maxWidth'
   * @see #getMaxWidth()
   * @see #setMaxWidth()
   */
  public native function get maxWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set maxWidth(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value in pixels which this Component will set its height to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-minHeight Original Ext JS documentation of 'minHeight'
   * @see #getMinHeight()
   * @see #setMinHeight()
   */
  public native function get minHeight():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minHeight(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value in pixels which this Component will set its width to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-minWidth Original Ext JS documentation of 'minWidth'
   * @see #getMinWidth()
   * @see #setMinWidth()
   */
  public native function get minWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minWidth(value:Number):void;

  [ExtConfig]
  /**
   * True to make the floated component modal and mask everything behind it when displayed,
   * false to display it without restricting access to other UI elements.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-modal Original Ext JS documentation of 'modal'
   */
  public native function get modal():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set modal(value:Boolean):void;

  [ExtConfig]
  /**
   * This config enables binding to your <code>→ext.data.Model.validators</code>. This
   * is only processed by form fields (e.g., <code>→ext.form.field.TextField</code>) at present, but
   * this setting is inherited and so can be set on a parent container.
   * <p>When set to <code>true</code> by a component or not set by a component but inherited from
   * an ancestor container, <code>→ext.data.Validation</code> records are used to automatically
   * bind validation results for any form field to which a <code>value</code> is bound.</p>
   * <p>While this config can be set arbitrarily high in the component hierarchy, doing
   * so can create a lot overhead if most of your form fields do not actually rely on
   * <code>validators</code> in your data model.</p>
   * <p>Using this setting for a form that is bound to an <code>→ext.data.Model</code> might look
   * like this:</p>
   * <pre>
   *  {
   *      xtype: 'panel',
   *      modelValidation: true,
   *      items: [{
   *          xtype: 'textfield',
   *          bind: '{theUser.firstName}'
   *      },{
   *          xtype: 'textfield',
   *          bind: '{theUser.lastName}'
   *      },{
   *          xtype: 'textfield',
   *          bind: '{theUser.phoneNumber}'
   *      },{
   *          xtype: 'textfield',
   *          bind: '{theUser.email}'
   *      }]
   *  }
   * </pre>
   * <p>Notice that "validation" is a pseudo-association defined for all entities. See
   * <code>→ext.data.Model.getValidation()</code> for further details.</p>
   * @see ext.data.Model#validators
   * @see ext.form.field.TextField
   * @see ext.data.Validation
   * @see ext.data.Model
   * @see ext.data.Model#getValidation()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-modelValidation Original Ext JS documentation of 'modelValidation'
   */
  public native function get modelValidation():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set modelValidation(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> for this component's <code>name</code> property to be tracked by its containing
   * <code>nameHolder</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-nameable Original Ext JS documentation of 'nameable'
   */
  public native function get nameable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set nameable(value:Boolean):void;

  [ExtConfig]
  /**
   * An optional extra CSS class that will be added to this component's Element when the mouse
   * moves over the Element, and removed when the mouse moves out. This can be useful for adding
   * customized 'active' or 'hover' styles to the component or any of its children using standard
   * CSS rules.
   * @default ''
   * @since 2.3.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-overCls Original Ext JS documentation of 'overCls'
   */
  public native function get overCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overCls(value:String):void;

  [Deprecated(replacement="scrollable", since="5.1.0")]
  [ExtConfig]
  /**
   * Possible values are...
   * <ul>
   * <li><code>'auto'</code> to enable automatic horizontal scrollbar (Style overflow-x: 'auto').</li>
   * <li><code>'scroll'</code> to always enable horizontal scrollbar (Style overflow-x: 'scroll').</li>
   * </ul>
   * <p>The default is overflow-x: 'hidden'. This should not be combined with →<code>autoScroll</code>.</p>
   * @see #autoScroll
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-overflowX Original Ext JS documentation of 'overflowX'
   */
  public native function get overflowX():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overflowX(value:String):void;

  [Deprecated(replacement="scrollable", since="5.1.0")]
  [ExtConfig]
  /**
   * Possible values are...
   * <ul>
   * <li><code>'auto'</code> to enable automatic vertical scrollbar (Style overflow-y: 'auto').</li>
   * <li><code>'scroll'</code> to always enable vertical scrollbar (Style overflow-y: 'scroll').</li>
   * </ul>
   * <p>The default is overflow-y: 'hidden'. This should not be combined with →<code>autoScroll</code>.</p>
   * @see #autoScroll
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-overflowY Original Ext JS documentation of 'overflowY'
   */
  public native function get overflowY():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set overflowY(value:String):void;

  /**
   * This Component's owner →<code>ext.container.Container</code> (is set automatically
   * when this Component is added to a Container).
   * <p><i>Important.</i> This is not a universal upwards navigation pointer. It indicates the Container
   * which owns and manages this Component if any. There are other similar relationships such as
   * the <i>button</i> (→<code>ext.button.Button</code>) which activates a
   * →<code>ext.button.Button.menu</code>, or the <i>menu item</i> (→<code>ext.menu.Item</code>) which
   * activated a <i>submenu</i> (→<code>ext.menu.Item.menu</code>), or the
   * <i>column header</i> (→<code>ext.grid.column.Column</code>) which activated the column menu.</p>
   * <p>These differences are abstracted away by the →<code>up()</code> method.</p>
   * <p><b>Note</b>: to access items within the Container see →<code>itemId</code>.</p>
   * @since 2.3.0
   * @see ext.container.Container
   * @see ext.button.Button
   * @see ext.button.Button#menu
   * @see ext.menu.Item
   * @see ext.menu.Item#menu
   * @see ext.grid.column.Column
   * @see #up()
   * @see #itemId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-ownerCt Original Ext JS documentation of 'ownerCt'
   */
  public native function get ownerCt():Container;

  [ExtConfig]
  /**
   * Specifies the padding for this component. The padding can be a single numeric value to apply
   * to all sides or it can be a CSS style specification for each style,
   * for example: '10 5 3 10' (top, right, bottom, left).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-padding Original Ext JS documentation of 'padding'
   */
  public native function get padding():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set padding(value:*):void;

  [ExtConfig]
  /**
   * This config describes one or more plugin config objects used to create plugin
   * instances for this component.
   * <p>Plugins are a way to bundle and reuse custom functionality. Plugins should extend
   * <code>→ext.plugin.AbstractPlugin</code> but technically the only requirement for a valid plugin
   * is that it contain an <code>init</code> method that accepts a reference to its owner. Once
   * a plugin is created, the owner will call the <code>init</code> method, passing a reference
   * to itself. Each plugin can then call methods or respond to events on its owner
   * as needed to provide its functionality.</p>
   * <p>This config's value can take several different forms.</p>
   * <p>The value can be a single string with the plugin's <i>alias</i> (→<code>null</code>):</p>
   * <pre>
   * plugins: 'cellediting',
   * </pre>
   * <p>The preferred form for multiple plugins or to configure plugins is the keyed-object
   * form (new in version 6.5):</p>
   * <pre>
   *  plugins: {
   *      gridviewdragdrop: true,
   *      cellediting: {
   *          clicksToEdit: 1
   *      }
   *  },
   * </pre>
   * <p>The keys are <code>→id</code>'s as well as the default type alias.</p>
   * <p>The <code>→plugins</code> config can also be an array of plugin aliases:</p>
   * <pre>
   * plugins: [ 'cellediting', 'gridviewdragdrop' ],
   * </pre>
   * <p>An array can also contain elements that are config objects with a <code>ptype</code> property
   * holding the type alias:</p>
   * <pre>
   *  plugins: ['gridviewdragdrop', {
   *      ptype: 'cellediting',
   *      clicksToEdit: 1
   *  }],
   * </pre>
   * @since 2.3.0
   * @see ext.plugin.AbstractPlugin
   * @see null
   * @see #id
   * @see #plugins
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-plugins Original Ext JS documentation of 'plugins'
   */
  public native function get plugins():Array;

  [ExtConfig]
  [ArrayElementType("ext.Plugin")]
  /**
   * @private
   */
  public native function set plugins(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default null
   * @since 5.0.0
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Specifies a name for this component inside its component hierarchy. This name
   * must be unique within its <i>view</i> (→<code>ext.container.Container.referenceHolder</code>)
   * or its →<code>ext.app.ViewController</code>. See the documentation in
   * →<code>ext.container.Container</code> for more information about references.
   * <p><b>Note</b>: Valid identifiers start with a letter or underscore and are followed
   * by zero or more additional letters, underscores or digits. References are case
   * sensitive.</p>
   * @see ext.container.Container#referenceHolder
   * @see ext.app.ViewController
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-reference Original Ext JS documentation of 'reference'
   */
  public native function get reference():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reference(value:String):void;

  [ExtConfig]
  /**
   * Defines the region inside <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>).
   * <p>Possible values:</p>
   * <ul>
   * <li>north - Positions component at top.</li>
   * <li>south - Positions component at bottom.</li>
   * <li>east - Positions component at right.</li>
   * <li>west - Positions component at left.</li>
   * <li>center - Positions component at the remaining space.
   * There <b>must</b> be a component with <code>region: "center"</code> in every border layout.</li>
   * </ul>
   * @default undefined
   * @see ext.layout.container.BorderLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-region Original Ext JS documentation of 'region'
   * @see #setRegion()
   */
  public native function get region():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set region(value:String):void;

  [ExtConfig]
  /**
   * renderConfig wraps configs that do not get applied until after the component is
   * rendered. Unlike normal config system properties, renderConfigs use a special
   * setter method to store values on the instance instead of running the apply and
   * update methods if it is called before the component is rendered. Then, after the
   * component has been rendered, these values are processed by the normal apply and
   * update method for the config.
   * <p>This means that calling the get method for the config prior to render will return
   * whatever raw value has been set, while calling the getter after render will return
   * the value after processing by the config's apply method. If this distinction needs
   * to be made, it is the caller's responsibility to check for the rendered state and
   * handle such intermediate config values.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-renderConfig Original Ext JS documentation of 'renderConfig'
   */
  public native function get renderConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set renderConfig(value:Object):void;

  [ExtConfig]
  /**
   * The data used by →<code>renderTpl</code> in addition to the following property values
   * of the component...
   * <ul>
   * <li>id</li>
   * <li>ui</li>
   * <li>uiCls</li>
   * <li>baseCls</li>
   * <li>componentCls</li>
   * <li>frame</li>
   * </ul>
   * <p>See →<code>renderSelectors</code> and →<code>childEls</code> for usage examples.</p>
   * @see #renderTpl
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-renderData Original Ext JS documentation of 'renderData'
   */
  public native function get renderData():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set renderData(value:Object):void;

  [Deprecated(replacement="childEls", since="5.0")]
  [ExtConfig]
  /**
   * An object containing properties specifying CSS selectors which identify child elements
   * created by the render process.
   * <p>After the Component's internal structure is rendered according to the →<code>renderTpl</code>,
   * this object is iterated through, and the found Elements are added as properties
   * to the Component using the <code>renderSelector</code> property name.</p>
   * <p>For example, a Component which renders a title and description into its element:</p>
   * <pre>
   *  Ext.create('Ext.Component', {
   *      renderTo: Ext.getBody(),
   *      renderTpl: [
   *          '&lt;h1 class="title"&gt;{title}&lt;/h1&gt;',
   *          '&lt;p&gt;{desc}&lt;/p&gt;'
   *      ],
   *      renderData: {
   *          title: "Error",
   *          desc: "Something went wrong"
   *      },
   *      renderSelectors: {
   *          titleEl: 'h1.title',
   *          descEl: 'p'
   *      },
   *      listeners: {
   *          afterrender: function(cmp){
   *              // After rendering the component will have a titleEl and descEl properties
   *              cmp.titleEl.setStyle({color: "red"});
   *          }
   *      }
   *  });
   * </pre>
   * <p>The use of <code>→renderSelectors</code> is deprecated (for performance reasons). The above
   * code should be refactored into something like this:</p>
   * <pre>
   *  Ext.create('Ext.Component', {
   *      renderTo: Ext.getBody(),
   *      renderTpl: [
   *          '&lt;h1 class="title" id="{id}-titleEl" data-ref="titleEl"&gt;{title}&lt;/h1&gt;',
   *          '&lt;p id="{id}-descEl" data-ref="descEl"&gt;{desc}&lt;/p&gt;'
   *      ],
   *      renderData: {
   *          title: "Error",
   *          desc: "Something went wrong"
   *      },
   *      childEls: [
   *          'titleEl',
   *          'descEl'
   *      ]
   *  });
   * </pre>
   * <p>To use <code>→childEls</code> yet retain the use of selectors (which remains as expensive as
   * <code>→renderSelectors</code>):</p>
   * <pre>
   *  Ext.create('Ext.Component', {
   *      renderTo: Ext.getBody(),
   *      renderTpl: [
   *          '&lt;h1 class="title"&gt;{title}&lt;/h1&gt;',
   *          '&lt;p&gt;{desc}&lt;/p&gt;'
   *      ],
   *      renderData: {
   *          title: "Error",
   *          desc: "Something went wrong"
   *      },
   *      childEls: {
   *          titleEl: { selectNode: 'h1.title' },
   *          descEl: { selectNode: 'p' }
   *      }
   *  });
   * </pre>
   * @see #renderTpl
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-renderSelectors Original Ext JS documentation of 'renderSelectors'
   */
  public native function get renderSelectors():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set renderSelectors(value:Object):void;

  [ExtConfig]
  /**
   * Specify the <code>→id</code> of the element, a DOM element or an existing Element that this component
   * will be rendered into.
   * <p><b>Notes:</b></p>
   * <p>Do <i>not</i> use this option if the Component is to be a child item of a
   * →<code>ext.container.Container</code>. It is the responsibility of the
   * →<code>ext.container.Container</code>'s
   * <i>layout manager</i> (→<code>ext.container.Container.layout</code>) to render and manage its child items.</p>
   * <p>When using this config, a call to <code>render()</code> is not required.</p>
   * <p>See also: →<code>render()</code>.</p>
   * @since 2.3.0
   * @see #id
   * @see ext.container.Container
   * @see ext.container.Container#layout
   * @see #render()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-renderTo Original Ext JS documentation of 'renderTo'
   */
  public native function get renderTo():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set renderTo(value:*):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default '{%this.renderContent(out,values)%}'
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set renderTpl(value:*):void;

  /**
   * Indicates whether or not the component has been rendered.
   * @default false
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#property-rendered Original Ext JS documentation of 'rendered'
   */
  public native function get rendered():Boolean;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to apply a →<code>ext.resizer.Resizer</code> to this Component
   * after rendering.
   * <p>May also be specified as a config object to be passed to the constructor of
   * →<code>ext.resizer.Resizer</code> to override any defaults. By default the Component
   * passes its minimum and maximum size, and uses <code>→ext.resizer.Resizer.dynamic: false</code></p>
   * @see ext.resizer.Resizer
   * @see ext.resizer.Resizer#dynamic
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-resizable Original Ext JS documentation of 'resizable'
   */
  public native function get resizable():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set resizable(value:*):void;

  [ExtConfig]
  /**
   * A valid →<code>ext.resizer.Resizer</code> handles config string. Only applies when
   * resizable = true.
   * @default 'all'
   * @see ext.resizer.Resizer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-resizeHandles Original Ext JS documentation of 'resizeHandles'
   */
  public native function get resizeHandles():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set resizeHandles(value:String):void;

  [ExtConfig]
  /**
   * True to layout this component and its descendants in "rtl" (right-to-left) mode.
   * Can be explicitly set to false to override a true value inherited from an ancestor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-rtl Original Ext JS documentation of 'rtl'
   */
  public native function get rtl():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rtl(value:Boolean):void;

  [ExtConfig]
  /**
   * A buffer to be applied if many state events are fired within a short period.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Stateful.html#cfg-saveDelay Original Ext JS documentation of 'saveDelay'
   */
  public native function get saveDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set saveDelay(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configuration options to make this Component scrollable. Acceptable values are:
   * <ul>
   * <li><code>true</code> to enable auto scrolling.</li>
   * <li><code>false</code> (or <code>null</code>) to disable scrolling - this is the default.</li>
   * <li><code>x</code> or <code>horizontal</code> to enable horizontal scrolling only</li>
   * <li><code>y</code> or <code>vertical</code> to enable vertical scrolling only</li>
   * </ul>
   * <p>Also accepts a configuration object for a <code>→ext.scroll.Scroller</code> if
   * if advanced configuration is needed.</p>
   * <p>The getter for this config returns the →<code>ext.scroll.Scroller</code>
   * instance. You can use the Scroller API to read or manipulate the scroll position:</p>
   * <pre>
   * // scrolls the component to 5 on the x axis and 10 on the y axis
   * component.getScrollable().scrollTo(5, 10);
   * </pre>
   * @default null
   * @see ext.scroll.Scroller
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-scrollable Original Ext JS documentation of 'scrollable'
   * @see #getScrollable()
   * @see #setScrollable()
   */
  public native function get scrollable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set scrollable(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * If provided this creates a new <code>Session</code> instance for this component. If this
   * is a <code>Container</code>, this will then be inherited by all child components.
   * <p>To create a new session you can specify <code>true</code>:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: true,
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * <p>Alternatively, a config object can be provided:</p>
   * <pre>
   *  Ext.create({
   *      xtype: 'viewport',
   *      session: {
   *          ...
   *      },
   *
   *      items: [{
   *          ...
   *      }]
   *  });
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-session Original Ext JS documentation of 'session'
   * @see #getSession()
   * @see #setSession()
   */
  public native function get session():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set session(value:*):void;

  [ExtConfig]
  /**
   * Specifies whether the floating component should be given a shadow. Set to true
   * to automatically create an →<code>ext.dom.Shadow</code>, or a string indicating the shadow's display
   * →<code>ext.dom.Shadow.mode</code>. Set to false to disable the shadow.
   * @default 'sides'
   * @see ext.dom.Shadow
   * @see ext.dom.Shadow#mode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-shadow Original Ext JS documentation of 'shadow'
   */
  public native function get shadow():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shadow(value:*):void;

  [ExtConfig]
  /**
   * Number of pixels to offset the shadow.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-shadowOffset Original Ext JS documentation of 'shadowOffset'
   */
  public native function get shadowOffset():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shadowOffset(value:Number):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to allow this component's <code>name</code> to be shared by other items in the
   * same <code>nameHolder</code>. Such items will be returned in an array from <code>lookupName</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-shareableName Original Ext JS documentation of 'shareableName'
   */
  public native function get shareableName():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shareableName(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to enable an iframe shim for this Component to keep
   * windowed objects from showing through.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Floating.html#cfg-shim Original Ext JS documentation of 'shim'
   */
  public native function get shim():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shim(value:Boolean):void;

  [ExtConfig]
  /**
   * The possible values for shrinkWrap are...
   * <ul>
   * <li>0 (or <code>false</code>): Neither width nor height depend on content.</li>
   * <li>1: Width depends on content (shrink wraps), but height does not.</li>
   * <li>2: Height depends on content (shrink wraps), but width does not.</li>
   * <li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>
   * </ul>
   * <p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed
   * to a block-level element.</p>
   * <p><b><i>Non-Panel Components</i></b></p>
   * <p>The shrinkWrap config is a class-level config and should be used when defining a
   * subclass.
   * It is not intended to be set as a config on instances of a given component.</p>
   * <p>For non-Panel components, shrinkWrap is a descriptive config only. It should be
   * set when defining your own custom class including the DOM elements used to
   * construct the component. The shrinkWrap property does not itself apply styling on
   * the component elements. Rather, it should describe the CSS styling you've applied
   * to your custom component (<i>refer to the numeric matrix above</i>).</p>
   * <p>When a component is owned by a container the layout of that container will inspect
   * the component's shrinkWrap property during layout. The layout then uses the
   * content-wrapping policy described by shrinkWrap to correctly size and position the
   * container's child items.</p>
   * @default 2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-shrinkWrap Original Ext JS documentation of 'shrinkWrap'
   */
  public native function get shrinkWrap():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shrinkWrap(value:*):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of events that, when fired, should trigger this object to
   * save its state. <code>→stateEvents</code> defaults to the <code>→stateEvents</code> associated with the
   * component you are using. Any events you statically set will be appended to that list.
   * <code>→stateEvents</code> may be any type of event supported by this object, including
   * browser or custom events (e.g., <code>['click', 'customerchange']</code>).
   * <p>See <code>→stateful</code> for an explanation of saving and
   * restoring object state.</p>
   * @see #stateEvents
   * @see #stateful
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Stateful.html#cfg-stateEvents Original Ext JS documentation of 'stateEvents'
   */
  public native function get stateEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stateEvents(value:Array):void;

  [ExtConfig]
  /**
   * The unique id for this object to use for state management purposes.
   * <p>See →<code>stateful</code> for an explanation of saving and restoring state.</p>
   * @see #stateful
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Stateful.html#cfg-stateId Original Ext JS documentation of 'stateId'
   */
  public native function get stateId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stateId(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A flag which causes the object to attempt to restore the state of
   * internal properties from a saved state on startup. The object must have
   * a →<code>stateId</code> for state to be managed.
   * <p>Auto-generated ids are not guaranteed to be stable across page loads and
   * cannot be relied upon to save and restore the same state for a object.</p>
   * <p>For state saving to work, the state manager's provider must have been
   * set to an implementation of →<code>ext.state.Provider</code> which overrides the
   * →<code>ext.state.Provider.set()</code> and →<code>ext.state.Provider.get()</code>
   * methods to save and recall name/value pairs. A built-in implementation,
   * →<code>ext.state.CookieProvider</code> is available.</p>
   * <p>To set the state provider for the current page:</p>
   * <pre>
   * Ext.state.Manager.setProvider(new Ext.state.CookieProvider({
   *     expires: new Date(new Date().getTime()+(1000&#42;60&#42;60&#42;24&#42;7)), // 7 days from now
   * }));
   * </pre>
   * <p>A stateful object attempts to save state when one of the events
   * listed in the →<code>stateEvents</code> configuration fires.</p>
   * <p>To save state, a stateful object first serializes its state by
   * calling <i>→<code>getState()</code></i>.</p>
   * <p>The Component base class implements →<code>getState()</code> to save its width and
   * height within the state only if they were initially configured, and have
   * changed from the configured value.</p>
   * <p>The Panel class saves its collapsed state in addition to that.</p>
   * <p>The Grid class saves its column state and store state (sorters and filters and grouper)
   * in addition to its superclass state.</p>
   * <p>If there is more application state to be save, the developer must provide
   * an implementation which first calls the superclass method to inherit the above behaviour,
   * and then injects new properties into the returned object.</p>
   * <p>The value yielded by <code>→getState()</code> is passed to →<code>ext.state.StateManager.set()</code>
   * which uses the configured →<code>ext.state.Provider</code> to save the object
   * keyed by the →<code>stateId</code>.</p>
   * <p>During construction, a stateful object attempts to <i>restore</i> its state by calling
   * →<code>ext.state.StateManager.get()</code> passing the →<code>stateId</code></p>
   * <p>The resulting object is passed to →<code>applyState()</code>&#42;. The default implementation of
   * →<code>applyState()</code> simply copies properties into the object, but a developer may
   * override this to support restoration of more complex application state.</p>
   * <p>You can perform extra processing on state save and restore by attaching
   * handlers to the →<code>event:onBeforeStateRestore</code>, →<code>event:onStateRestore</code>,
   * →<code>event:onBeforeStateSave</code> and →<code>event:onStateSave</code> events. In some simple cases,
   * passing an object for the <code>→stateful</code> config may suffice. If an object is
   * provided, the properties of that object are used to include or exclude stateful
   * properties returned by <code>→getState()</code>. For example:</p>
   * <pre>
   *  stateful: {
   *      height: false, // never persist the height
   *      width: true    // always persist the width
   *  }
   * </pre>
   * <p>The above is roughly equivalent to the following:</p>
   * <pre>
   *  getState: function () {
   *      var state = this.callParent();
   *
   *      delete state.height;
   *      state.width = this.width;
   *
   *      return state;
   *  }
   * </pre>
   * @default false
   * @see #stateId
   * @see ext.state.Provider
   * @see ext.state.Provider#set()
   * @see ext.state.Provider#get()
   * @see ext.state.CookieProvider
   * @see #stateEvents
   * @see #getState()
   * @see ext.state.SStateManager#set() ext.state.StateManager.set()
   * @see ext.state.SStateManager#get() ext.state.StateManager.get()
   * @see #applyState()
   * @see #event:onBeforeStateRestore
   * @see #event:onStateRestore
   * @see #event:onBeforeStateSave
   * @see #event:onStateSave
   * @see #stateful
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.state.Stateful.html#cfg-stateful Original Ext JS documentation of 'stateful'
   * @see #getStateful()
   * @see #setStateful()
   */
  public native function get stateful():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set stateful(value:*):void;

  [ExtConfig]
  /**
   * A custom style specification to be applied to this component's Element.
   * Should be a valid argument to →<code>ext.dom.Element.applyStyles()</code>.
   * <pre>
   * new Ext.panel.Panel({
   *     title: 'Some Title',
   *     renderTo: Ext.getBody(),
   *     width: 400, height: 300,
   *     layout: 'form',
   *     items: [{
   *         xtype: 'textarea',
   *         style: {
   *             width: '95%',
   *             marginBottom: '10px'
   *         }
   *     },
   *     new Ext.button.Button({
   *         text: 'Send',
   *         minWidth: '100',
   *         style: {
   *             marginBottom: '10px'
   *         }
   *     })
   *     ]
   * });
   * </pre>
   * @since 1.1.0
   * @see ext.dom.Element#applyStyles()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-style Original Ext JS documentation of 'style'
   * @see #setStyle()
   */
  public native function get style():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set style(value:*):void;

  [ExtConfig]
  /**
   * DOM tabIndex attribute for this component's →<code>focusEl</code>.
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  public native function get tabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tabIndex(value:Number):void;

  [ExtConfig]
  /**
   * True to automatically call →<code>toFront()</code> when the →<code>show()</code> method is called
   * on an already visible, floating component.
   * @default true
   * @see #toFront()
   * @see #show()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-toFrontOnShow Original Ext JS documentation of 'toFrontOnShow'
   */
  public native function get toFrontOnShow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set toFrontOnShow(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Emulates the behavior of the CSS
   * <a href="https://www.w3.org/TR/pointerevents/#the-touch-action-css-property">touch-action</a>
   * property in a cross-browser compatible manner.
   * <p>Keys in this object are touch action names, and values are <code>false</code> to disable
   * a touch action or <code>true</code> to enable it. Accepted keys are:</p>
   * <ul>
   * <li><code>panX</code></li>
   * <li><code>panY</code></li>
   * <li><code>pinchZoom</code></li>
   * <li><code>doubleTapZoom</code></li>
   * </ul>
   * <p>All touch actions are enabled (<code>true</code>) by default, so it is usually only necessary
   * to specify which touch actions to disable. For example, the following disables
   * only horizontal scrolling and pinch-to-zoom on the component's main element:</p>
   * <pre>
   * touchAction: {
   *     panX: false,
   *     pinchZoom: false
   * }
   * </pre>
   * <p>Touch actions can be specified on child elements using the child element name,
   * for example:</p>
   * <pre>
   * // disables horizontal scrolling on the main element, and double-tap-zoom
   * // on the child element named "body"
   * touchAction: {
   *     panY: false
   *     body: {
   *         doubleTapZoom: false
   *     }
   * }
   * </pre>
   * <p>The primary motivation for setting the touch-action of an element is to prevent
   * the browser's default handling of a gesture such as pinch-to-zoom, or
   * drag-to-scroll, so that the application can implement its own handling of that
   * gesture on the element. Suppose, for example, a component has a custom drag
   * handler on its element and wishes to prevent horizontal scrolling of its container
   * while it is being dragged:</p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     touchAction: {
   *         panX: false
   *     },
   *     listeners: {
   *         drag: function(e) {
   *             // implement drag logic
   *         }
   *     }
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-touchAction Original Ext JS documentation of 'touchAction'
   * @see #getTouchAction()
   * @see #setTouchAction()
   */
  public native function get touchAction():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set touchAction(value:Object):void;

  [ExtConfig]
  /**
   * An →<code>ext.Template</code>, →<code>ext.XTemplate</code> or an array of strings to form
   * an Ext.XTemplate. Used in conjunction with the <code>→data</code> and <code>→tplWriteMode</code>
   * configurations.
   * @since 3.4.0
   * @see ext.Template
   * @see ext.XTemplate
   * @see #data
   * @see #tplWriteMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-tpl Original Ext JS documentation of 'tpl'
   */
  public native function get tpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tpl(value:*):void;

  [ExtConfig]
  /**
   * The Ext.(X)Template method to use when updating the content area of the Component.
   * See <code>→ext.XTemplate.overwrite()</code> for information on default mode.
   * @default 'overwrite'
   * @since 3.4.0
   * @see ext.XTemplate#overwrite()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-tplWriteMode Original Ext JS documentation of 'tplWriteMode'
   */
  public native function get tplWriteMode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tplWriteMode(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default null
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  /**
   * A UI style for a component.
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-ui Original Ext JS documentation of 'ui'
   */
  public native function get ui():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ui(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more CSS classes to add to the component's primary element. This config
   * is intended solely for use by the component instantiator (the "user"), not by
   * derived classes.
   * <p>For example:</p>
   * <pre>
   *  items: [{
   *      xtype: 'button',
   *      userCls: 'my-button'
   *  ...
   *  }]
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-userCls Original Ext JS documentation of 'userCls'
   * @see #getUserCls()
   * @see #setUserCls()
   */
  public native function get userCls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set userCls(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The <code>ViewModel</code> is a data provider for this component and its children. The
   * data contained in the <code>ViewModel</code> is typically used by adding <code>→bind</code> configs
   * to the components that want present or edit this data.
   * <p>When set, the <code>ViewModel</code> is created and links to any inherited <code>→viewModel</code>
   * instance from an ancestor container as the "parent". The <code>ViewModel</code> hierarchy,
   * once established, only supports creation or destruction of children. The
   * parent of a <code>ViewModel</code> cannot be changed on the fly.</p>
   * <p>If this is a root-level <code>ViewModel</code>, the data model connection is made to this
   * component's associated <code>Data Session (→ext.data.Session)</code>. This is
   * determined by calling <code>getInheritedSession</code>.</p>
   * @default null
   * @see #bind
   * @see #viewModel
   * @see ext.data.Session
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#cfg-viewModel Original Ext JS documentation of 'viewModel'
   * @see #getViewModel()
   * @see #setViewModel()
   */
  public native function get viewModel():ViewModel;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set viewModel(value:ViewModel):void;

  [ExtConfig]
  /**
   * A value to control how Components are laid out in a
   * →<code>ext.layout.container.BorderLayout</code> layout or as docked items.
   * <p>In a Border layout, this can control how the regions (not the center) region lay out
   * if the west or east take full height or if the north or south region take full width.
   * Also look at the →<code>ext.layout.container.BorderLayout.regionWeights</code> on the Border layout.
   * An example to show how you can take control of this is:</p>
   * <pre>
   * Ext.create('Ext.container.Viewport', {
   *     layout      : 'border',
   *     defaultType : 'panel',
   *     items       : [
   *         {
   *             region : 'north',
   *             title  : 'North',
   *             height : 100
   *         },
   *         {
   *             region : 'south',
   *             title  : 'South',
   *             height : 100,
   *             weight : -25
   *         },
   *         {
   *             region : 'west',
   *             title  : 'West',
   *             width  : 200,
   *             weight : 15
   *         },
   *         {
   *             region : 'east',
   *             title  : 'East',
   *             width  : 200
   *         },
   *         {
   *             region : 'center',
   *             title  : 'center'
   *         }
   *     ]
   * });
   * </pre>
   * <p>If docked items, the weight will order how the items are laid out. Here is an example
   * to put a →<code>ext.toolbar.Toolbar</code> above a →<code>ext.panel.Panel</code>'s header:</p>
   * <pre>
   * Ext.create('Ext.panel.Panel', {
   *     renderTo    : document.body,
   *     width       : 300,
   *     height      : 300,
   *     title       : 'Panel',
   *     html        : 'Panel Body',
   *     dockedItems : [
   *         {
   *             xtype : 'toolbar',
   *             items : [
   *                 {
   *                     text : 'Save'
   *                 }
   *             ]
   *         },
   *         {
   *             xtype  : 'toolbar',
   *             weight : -10,
   *             items  : [
   *                 {
   *                     text : 'Remove'
   *                 }
   *             ]
   *         }
   *     ]
   * });
   * </pre>
   * @default null
   * @see ext.layout.container.BorderLayout
   * @see ext.layout.container.BorderLayout#regionWeights
   * @see ext.toolbar.Toolbar
   * @see ext.panel.Panel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-weight Original Ext JS documentation of 'weight'
   * @see #setWeight()
   */
  public native function get weight():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set weight(value:Number):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The width of this component. A numeric value will be interpreted as the number of
   * pixels; a string value will be treated as a CSS value with units.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-width Original Ext JS documentation of 'width'
   * @see #getWidth()
   * @see #setWidth()
   */
  public native function get width():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set width(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The current X position of the DOM element based on page coordinates.
   */
  public native function get x():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set x(value:Number):void;

  [ExtConfig]
  /**
   * <b>Note:</b> Only applies to →<code>ext.Component</code> derived classes when used as
   * a config in →<code>ext.Ext.define()</code>.
   * <p>This property provides a shorter alternative to creating objects than using a full
   * class name. Using <code>→xtype</code> is the most common way to define component instances,
   * especially in a container. For example, the items in a form containing text fields
   * could be created explicitly like so:</p>
   * <pre>
   *  items: [
   *      Ext.create('Ext.form.field.Text', {
   *          fieldLabel: 'Foo'
   *      }),
   *      Ext.create('Ext.form.field.Text', {
   *          fieldLabel: 'Bar'
   *      }),
   *      Ext.create('Ext.form.field.Number', {
   *          fieldLabel: 'Num'
   *      })
   *  ]
   * </pre>
   * <p>But by using <code>→xtype</code>, the above becomes:</p>
   * <pre>
   *  items: [
   *      {
   *          xtype: 'textfield',
   *          fieldLabel: 'Foo'
   *      },
   *      {
   *          xtype: 'textfield',
   *          fieldLabel: 'Bar'
   *      },
   *      {
   *          xtype: 'numberfield',
   *          fieldLabel: 'Num'
   *      }
   *  ]
   * </pre>
   * <p>When the <code>→xtype</code> is common to many items, →<code>ext.container.Container.defaultType</code>
   * is another way to specify the <code>→xtype</code> for all items that don't have an explicit <code>→xtype</code>:</p>
   * <pre>
   *  defaultType: 'textfield',
   *  items: [
   *      { fieldLabel: 'Foo' },
   *      { fieldLabel: 'Bar' },
   *      { fieldLabel: 'Num', xtype: 'numberfield' }
   *  ]
   * </pre>
   * <p>Each member of the <code>items</code> array is now just a "configuration object". These objects
   * are used to create and configure component instances. A configuration object can be
   * manually used to instantiate a component using →<code>ext.Ext.widget()</code>:</p>
   * <pre>
   *  var text1 = Ext.create('Ext.form.field.Text', {
   *      fieldLabel: 'Foo'
   *  });
   *
   *  // or alternatively:
   *
   *  var text1 = Ext.widget({
   *      xtype: 'textfield',
   *      fieldLabel: 'Foo'
   *  });
   * </pre>
   * <p>This conversion of configuration objects into instantiated components is done when
   * a container is created as part of its {Ext.container.AbstractContainer#initComponent}
   * process. As part of the same process, the <code>items</code> array is converted from its raw
   * array form into a →<code>ext.util.MixedCollection</code> instance.</p>
   * <p>You can define your own <code>→xtype</code> on a custom <i>component</i> (→<code>ext.Component</code>) by specifying
   * the <code>→xtype</code> property in →<code>ext.Ext.define()</code>. For example:</p>
   * <pre>
   * Ext.define('MyApp.PressMeButton', {
   *     extend: 'Ext.button.Button',
   *     xtype: 'pressmebutton',
   *     text: 'Press Me'
   * });
   * </pre>
   * <p>Care should be taken when naming an <code>→xtype</code> in a custom component because there is
   * a single, shared scope for all xtypes. Third part components should consider using
   * a prefix to avoid collisions.</p>
   * <pre>
   * Ext.define('Foo.form.CoolButton', {
   *     extend: 'Ext.button.Button',
   *     xtype: 'ux-coolbutton',
   *     text: 'Cool!'
   * });
   * </pre>
   * <p>See →<code>null</code> for list of all available xtypes.</p>
   * @since 2.3.0
   * @see ext.Component
   * @see ext.SExt#define() ext.Ext.define()
   * @see #xtype
   * @see ext.container.Container#defaultType
   * @see ext.SExt#widget() ext.Ext.widget()
   * @see ext.util.MixedCollection
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#cfg-xtype Original Ext JS documentation of 'xtype'
   */
  public native function get xtype():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set xtype(value:String):void;

  /**
   * The xtype of this component class.
   * @see #xtype
   */
  public static native function get xtype():String;

  [ExtConfig]
  [Bindable]
  /**
   * The current Y position of the DOM element based on page coordinates.
   */
  public native function get y():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set y(value:Number):void;

  /**
   * @inheritDoc
   */
  public native function get zIndexManager():ZIndexManager;

  /**
   * @inheritDoc
   */
  public native function get zIndexParent():Container;

  [Deprecated(replacement="addCls", since="4.1")]
  /**
   * Adds a CSS class to the top level element representing this component.
   * @since 2.3.0
   * @param cls The CSS class name to add.
   * @return Returns the Component to allow method chaining.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-addClass Original Ext JS documentation of 'addClass'
   */
  public native function addClass(cls:*):Component;

  /**
   * Adds a CSS class to the top level element representing this component.
   * @param cls The CSS class name to add.
   * @return Returns the Component to allow method chaining.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-addCls Original Ext JS documentation of 'addCls'
   */
  public native function addCls(cls:*):Component;

  /**
   * Adds a <code>→cls</code> to the <code>→uiCls</code> array, which will also call →<code>addUIClsToElement()</code>
   * and adds to all elements of this component.
   * @param classes A string or an array of strings to add to the <code>→uiCls</code>.
   * @param skip <code>true</code> to skip adding it to the class and do it later
   * (via the return).
   * @see #cls
   * @see #uiCls
   * @see #addUIClsToElement()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-addClsWithUI Original Ext JS documentation of 'addClsWithUI'
   */
  public native function addClsWithUI(classes:*, skip:Boolean = false):void;

  /**
   * Adds a plugin. May be called at any time in the component's life cycle.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-addPlugin Original Ext JS documentation of 'addPlugin'
   */
  protected native function addPlugin(plugin:Plugin):void;

  /**
   * Save a property to the given state object if it is not its default or configured
   * value.
   * @param state The state object.
   * @param propName The name of the property on this object to save.
   * @param value The value of the state property (defaults to <code>this[propName]</code>).
   * @return The state object or a new object if state was <code>null</code> and the property
   * was saved.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-addPropertyToState Original Ext JS documentation of 'addPropertyToState'
   */
  protected native function addPropertyToState(state:Object, propName:String, value:String = null):Object;

  /**
   * @inheritDoc
   */
  public native function addStateEvents(events:*):void;

  /**
   * Method which adds a specified UI + <code>→uiCls</code> to the components element. Can be overridden
   * to add the UI to more than just the component's element.
   * @param uiCls The UI class to add to the element.
   * @see #uiCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-addUIClsToElement Original Ext JS documentation of 'addUIClsToElement'
   */
  protected native function addUIClsToElement(uiCls:String):void;

  /**
   * Called by the layout system after the Component has been laid out.
   * <p>This method is not called on components that use →<code>liquidLayout</code>, such as
   * <i>Buttons</i> (→<code>ext.button.Button</code>) and <i>Form Fields</i> (→<code>ext.form.field.BaseField</code>).</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param width The width that was set
   * @param height The height that was set
   * @param oldWidth The old width, or <code>undefined</code> if this was the initial
   * layout.
   * @param oldHeight The old height, or <code>undefined</code> if this was the initial
   * layout.
   * @see #liquidLayout
   * @see ext.button.Button
   * @see ext.form.field.BaseField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-afterComponentLayout Original Ext JS documentation of 'afterComponentLayout'
   */
  protected native function afterComponentLayout(width:Number, height:Number, oldWidth:*, oldHeight:*):void;

  /**
   * Invoked after the Component has been hidden.
   * <p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that #onHide received.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-afterHide Original Ext JS documentation of 'afterHide'
   */
  protected native function afterHide(callback:Function = null, scope:Object = null):void;

  /**
   * Allows additional behavior after rendering is complete. At this stage, the
   * <i>Component's</i> (→<code>ext.Component</code>) <i>Element</i> (→<code>ext.Component.getEl()</code>) will have
   * been styled according to the configuration, will have had any configured CSS
   * class names added, and will be in the configured visibility and configured enable
   * state.
   * <p><b>Note:</b> If the Component has a <i>ViewController</i> (→<code>ext.Component.controller</code>)
   * and the controller has an →<code>ext.app.ViewController.afterRender()</code>
   * method it will be called passing the Component as the single param.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see ext.Component
   * @see ext.Component#getEl()
   * @see ext.Component#controller
   * @see ext.app.ViewController#afterRender()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-afterRender Original Ext JS documentation of 'afterRender'
   */
  protected native function afterRender():void;

  /**
   * Template method called after a Component has been positioned.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-afterSetPosition Original Ext JS documentation of 'afterSetPosition'
   */
  protected native function afterSetPosition(x:Number, y:Number):void;

  /**
   * Invoked after the Component is shown (after #onShow is called).
   * <p>Gets passed the same parameters as #show.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-afterShow Original Ext JS documentation of 'afterShow'
   */
  protected native function afterShow(animateTarget:* = undefined, callback:Function = null, scope:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function alignTo(anchorToEl:*, alignment:String = "tl-bl?", offsets:Array = null, animate:* = undefined):void;

  /**
   * @inheritDoc
   */
  public native function anchorTo(anchorToEl:*, alignment:String = "tl-bl?", offsets:Array = null, animate:* = undefined, monitorScroll:* = 50, callback:Function = null):void;

  /**
   * @inheritDoc
   */
  public native function animate(animObj:Object):Object;

  /**
   * @inheritDoc
   */
  public native function applyState(state:Object):void;

  /**
   * Template method to do any pre-blur processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-beforeBlur Original Ext JS documentation of 'beforeBlur'
   */
  protected native function beforeBlur(e:Event):void;

  [Deprecated(replacement="onDestroy", since="6.2.0")]
  /**
   * Invoked before the Component is destroyed.
   * This method is deprecated, override →<code>onDestroy()</code> instead.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see #onDestroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-beforeDestroy Original Ext JS documentation of 'beforeDestroy'
   */
  protected native function beforeDestroy():void;

  /**
   * Template method to do any pre-focus processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-beforeFocus Original Ext JS documentation of 'beforeFocus'
   */
  protected native function beforeFocus(e:Event):void;

  /**
   * Occurs before componentLayout is run. In previous releases, this method could
   * return <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or
   * higher. This method is simply a notification of the impending layout to give the
   * component a chance to adjust the DOM. Ideally, DOM reads should be avoided at this
   * time to reduce expensive document reflows.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-beforeLayout Original Ext JS documentation of 'beforeLayout'
   */
  protected native function beforeLayout():void;

  /**
   * Allows additional behavior before rendering.
   * <p><b>Note:</b> If the Component has a <i>ViewController</i> (→<code>ext.Component.controller</code>)
   * and the controller has a →<code>ext.app.ViewController.beforeRender()</code>
   * method it will be called passing the Component as the single param.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see ext.Component#controller
   * @see ext.app.ViewController#beforeRender()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-beforeRender Original Ext JS documentation of 'beforeRender'
   */
  protected native function beforeRender():void;

  /**
   * Invoked before the Component is shown.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-beforeShow Original Ext JS documentation of 'beforeShow'
   */
  protected native function beforeShow():void;

  /**
   * Bubbles up the component/container hierarchy, calling the specified function with each
   * component. The scope (<i>this</i>) of function call will be the scope provided or the current
   * component. The arguments to the function will be the args provided or the current component.
   * If the function returns false at any point, the bubble is stopped.
   * @param fn The function to call
   * @param scope The scope of the function. Defaults to current node.
   * @param args The args to call the function with. Defaults to passing the current
   * component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-bubble Original Ext JS documentation of 'bubble'
   */
  public native function bubble(fn:Function, scope:Object = null, args:Array = null):void;

  /**
   * Cancel any deferred focus on this component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-cancelFocus Original Ext JS documentation of 'cancelFocus'
   */
  protected native function cancelFocus():void;

  /**
   * @inheritDoc
   */
  public native function center():Component;

  /**
   * Clone the current component using the original config values passed into this instance
   * by default.
   * @param overrides A new config containing any properties to override in the cloned
   * version. An id property can be passed on this object, otherwise one will be generated
   * to avoid duplicates.
   * @return clone The cloned copy of this component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-cloneConfig Original Ext JS documentation of 'cloneConfig'
   */
  public native function cloneConfig(overrides:Object):Component;

  /**
   * Destroys the Component. This method <b>must not</b> be overridden because Component
   * destruction sequence is conditional; if a <code>→event:onBeforeDestroy</code> handler returns <code>false</code>
   * we must abort destruction.
   * <p>To add extra functionality to destruction time in a subclass, override the
   * →<code>doDestroy()</code> method.</p>
   * @since 1.1.0
   * @see #event:onBeforeDestroy
   * @see #doDestroy()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Disable the component.
   * @since 1.1.0
   * @param silent Passing <code>true</code> will suppress the <code>disable</code> event
   * from being fired.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-disable Original Ext JS documentation of 'disable'
   */
  public native function disable(silent:Boolean = false):void;

  [Deprecated(replacement="updateLayout", since="4.1")]
  /**
   * This method needs to be called whenever you change something on this
   * component that equires the Component's layout to be recalculated.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-doComponentLayout Original Ext JS documentation of 'doComponentLayout'
   */
  public native function doComponentLayout():Component;

  /**
   * @inheritDoc
   */
  public native function doConstrain(constrainTo:* = undefined):void;

  /**
   * Enable the component
   * @since 1.1.0
   * @param silent Passing <code>true</code> will suppress the <code>enable</code> event
   * from being fired.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-enable Original Ext JS documentation of 'enable'
   */
  public native function enable(silent:Boolean = false):void;

  /**
   * @inheritDoc
   */
  public native function ensureAttachedToBody(runLayout:Boolean = false):void;

  /**
   * Find a container above this component at any level by a custom function. If the passed
   * function returns true, the container will be returned.
   * <p>See also the →<code>ext.Component.up()</code> method.</p>
   * @param fn The custom function to call with the arguments
   * (container, this component).
   * @return The first Container for which the custom function
   * returns true
   * @see ext.Component#up()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-findParentBy Original Ext JS documentation of 'findParentBy'
   */
  public native function findParentBy(fn:Function):Container;

  /**
   * Find a container above this component at any level by xtype or class.
   * <p>See also the →<code>ext.Component.up()</code> method.</p>
   * @param xtype The xtype string for a component, or the class
   * of the component directly
   * @param shallow False to check whether this Component is descended from the xtype (this is the default), or true to check whether this Component is directly of the specified xtype.
   * @return The first Container which matches the given xtype or class
   * @see ext.Component#up()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-findParentByType Original Ext JS documentation of 'findParentByType'
   */
  public native function findParentByType(xtype:*, shallow:Boolean = false):Container;

  /**
   * Retrieves plugin from this component's collection by its <code>ptype</code>.
   * <pre>
   * var grid = Ext.create('Ext.grid.Panel', {
   *     store: {
   *         fields: ['name'],
   *         data: [{
   *             name: 'Scott Pilgrim'
   *         }]
   *     },
   *     columns: [{
   *         header: 'Name',
   *         dataIndex: 'name',
   *         editor: 'textfield',
   *         flex: 1
   *     }],
   *     selType: 'cellmodel',
   *     plugins: [{
   *         ptype: 'cellediting',
   *         clicksToEdit: 1,
   *         id: 'myplugin'
   *     }],
   *     height: 200,
   *     width: 400,
   *     renderTo: Ext.getBody()
   * });
   *
   * grid.findPlugin('cellediting');  // the cellediting plugin
   * </pre>
   * <p><b>Note:</b> See also →<code>getPlugin()</code></p>
   * @param ptype The Plugin's <code>ptype</code> as specified by the class's
   * →<code>ext.ExtClass.alias</code> configuration.
   * @return plugin instance or <code>undefined</code> if not found
   * @see #getPlugin()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-findPlugin Original Ext JS documentation of 'findPlugin'
   * @see ext.ExtClass#alias
   */
  public native function findPlugin(ptype:String):AbstractPlugin;

  /**
   * Try to focus this component.
   * <p>If this component is disabled or otherwise not focusable, a close relation
   * will be targeted for focus instead to keep focus localized for keyboard users.</p>
   * @param selectText If applicable, <code>true</code> to also select all the text in this
   * component, or an array consisting of start and end (defaults to start) position of selection.
   * @param delay Delay the focus this number of milliseconds (true for
   * 10 milliseconds).
   * @param callback Only needed if the <code>delay</code> parameter is used. A function to call
   * upon focus.
   * @param scope Only needed if the <code>delay</code> parameter is used. The scope (<code>this</code>
   * reference) in which to execute the callback.
   * @return The focused Component. Usually <code>this</code> Component. Some Containers may
   * delegate focus to a descendant Component (→<code>ext.window.Window</code>s can do this
   * through their →<code>ext.window.Window.defaultFocus</code> config option. If this
   * component is disabled, a closely related component will be focused and that will be returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-focus Original Ext JS documentation of 'focus'
   * @see ext.window.Window
   * @see ext.window.Window#defaultFocus
   */
  [Return("this")]
  public native function focus(selectText:* = undefined, delay:* = undefined, callback:Function = null, scope:Function = null):Component;

  [Deprecated(replacement="updateLayout", since="4.1")]
  /**
   * Updates this component's layout. If this update affects this components →<code>ownerCt</code>,
   * that component's <code>updateLayout</code> method will be called to perform the layout instead.
   * Otherwise, just this component (and its child items) will layout.
   * @param options An object with layout options.
   * <ul>
   * <li><code>defer:Boolean</code> (optional) —
   * <code>true</code> if this layout should be deferred.
   * </li>
   * <li><code>isRoot:Boolean</code> (optional) —
   * <code>true</code> if this layout should be the root of the layout.
   * </li>
   * </ul>
   * @see #ownerCt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-forceComponentLayout Original Ext JS documentation of 'forceComponentLayout'
   */
  public native function forceComponentLayout(options:Object = null):void;

  /**
   * @inheritDoc
   */
  public native function getActiveAnimation():*;

  /**
   * @inheritDoc
   */
  public native function getAlignToXY(alignToEl:*, position:String = "tl-bl?", offsets:Array = null):Array;

  /**
   * Returns the value of <code>alwaysOnTop</code>.
   * @see #alwaysOnTop
   */
  public native function getAlwaysOnTop():*;

  /**
   * @inheritDoc
   */
  public native function getAnchorXY(anchor:String = 'tl', local:Boolean = false, size:Object = null):Array;

  /**
   * Returns the value of <code>ariaAttributes</code>.
   * @see #ariaAttributes
   */
  public native function getAriaAttributes():Object;

  /**
   * Returns the value of <code>bind</code>.
   * @see #bind
   */
  public native function getBind():*;

  /**
   * @inheritDoc
   */
  public native function getBox(contentBox:Boolean = false, local:Boolean = false):Object;

  /**
   * Implements an upward event bubbling policy. By default a Component bubbles events
   * up to its <i>reference owner</i> (→<code>getRefOwner()</code>).
   * <p>Component subclasses may implement a different bubbling strategy by overriding this method.</p>
   * @see #getRefOwner()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getBubbleTarget Original Ext JS documentation of 'getBubbleTarget'
   */
  protected native function getBubbleTarget():Component;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  public native function getChildEls():*;

  /**
   * @inheritDoc
   */
  public native function getClientRegion():Region;

  /**
   * @inheritDoc
   */
  public native function getConstrainRegion():Region;

  /**
   * @inheritDoc
   */
  public native function getConstrainVector(constrainTo:* = undefined, proposedPosition:Array = null, proposedSize:Array = null):*;

  /**
   * Returns the value of <code>controller</code>.
   * @see #controller
   */
  public native function getController():*;

  /**
   * Returns the value of <code>data</code>.
   * @see #data
   */
  public native function getData():Object;

  /**
   * Returns the value of <code>defaultListenerScope</code>.
   * @see #defaultListenerScope
   */
  public native function getDefaultListenerScope():Boolean;

  /**
   * Retrieves the top level element representing this component.
   * @since 1.1.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getEl Original Ext JS documentation of 'getEl'
   */
  public native function getEl():Element;

  /**
   * Returns the element used to apply focus styling CSS class when Focusable's
   * →<code>focusEl</code> becomes focused. By default it is →<code>focusEl</code>.
   * @param focusEl Return focus styling element for the given
   * focused element. This is used by Components implementing multiple focusable
   * elements.
   * @return The focus styling element.
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-getFocusClsEl Original Ext JS documentation of 'getFocusClsEl'
   */
  protected native function getFocusClsEl(focusEl:Element = null):Element;

  /**
   * Returns the main focus holder element associated with this Focusable, i.e.
   * the element that will be focused when Focusable's →<code>focus()</code> method is
   * called. For most Focusables, this will be the →<code>focusEl</code>.
   * @see #focus()
   * @see #focusEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-getFocusEl Original Ext JS documentation of 'getFocusEl'
   */
  protected native function getFocusEl():Element;

  /**
   * Gets the current height of the component's underlying element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getHeight Original Ext JS documentation of 'getHeight'
   */
  public native function getHeight():*;

  /**
   * Retrieves the <code>→id</code> of this component. Will auto-generate an <code>→id</code> if one has not already
   * been set.
   * @see #id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getId Original Ext JS documentation of 'getId'
   */
  override public native function getId():String;

  /**
   * @inheritDoc
   */
  public native function getInherited(inner:Boolean = false):Object;

  /**
   * @inheritDoc
   */
  public native function getInheritedConfig(property:String, skipThis:Boolean = false):*;

  /**
   * @inheritDoc
   */
  public native function getInsertPosition(position:*):HTMLElement;

  /**
   * Returns the value of →<code>itemId</code> assigned to this component, or when that
   * is not set, returns the value of →<code>id</code>.
   * @see #itemId
   * @see #id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getItemId Original Ext JS documentation of 'getItemId'
   */
  public native function getItemId():String;

  /** @inheritDoc */
  public native function getKeyMap():Object;

  /** @inheritDoc */
  public native function getKeyMapEnabled():Boolean;

  /**
   * Gets the →<code>ext.ComponentLoader</code> for this Component.
   * @return The loader instance, null if it doesn't exist.
   * @see ext.ComponentLoader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getLoader Original Ext JS documentation of 'getLoader'
   */
  public native function getLoader():ComponentLoader;

  /**
   * @inheritDoc
   */
  public native function getLocalX():Number;

  /**
   * @inheritDoc
   */
  public native function getLocalXY():Array;

  /**
   * @inheritDoc
   */
  public native function getLocalY():Number;

  /**
   * Returns the element which is masked by the →<code>mask()</code> method, or into which the
   * <i>LoadMask</i> (→<code>setLoading()</code>) is rendered into.
   * <p>The default implementation uses the →<code>maskElement</code> configuration to access
   * the Component's child element by name. By default, →<code>maskElement</code> is <code>null</code> which means
   * that <code>null</code> is returned from this method indicating that the mask needs to be rendered into
   * the document because component structure should not be contaminated by mask elements.</p>
   * <p>Some subclasses may override this method if they have knowledge about external structures
   * where a mask could usefully be rendered.</p>
   * <p>For example a <i>GridView</i> (→<code>ext.view.TableView</code>) will request that its owning
   * <i>GridPanel</i> (→<code>ext.panel.TablePanel</code>) be masked. The GridPanel will have its own implementation
   * of <code>→getMaskTarget()</code> which will return the element dictated by its own →<code>maskElement</code>
   * Panels use <code>"el"</code> as their →<code>maskElement</code> by default, but that could be overridden
   * to be <code>"body"</code> to leave toolbars and the header mouse-accessible.</p>
   * @see #mask()
   * @see #setLoading()
   * @see #maskElement
   * @see ext.view.TableView
   * @see ext.panel.TablePanel
   * @see #getMaskTarget()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getMaskTarget Original Ext JS documentation of 'getMaskTarget'
   */
  protected native function getMaskTarget():Element;

  /**
   * Returns the value of <code>maxHeight</code>.
   * @see #maxHeight
   */
  public native function getMaxHeight():Number;

  /**
   * Returns the value of <code>maxWidth</code>.
   * @see #maxWidth
   */
  public native function getMaxWidth():Number;

  /**
   * Returns the value of <code>minHeight</code>.
   * @see #minHeight
   */
  public native function getMinHeight():Number;

  /**
   * Returns the value of <code>minWidth</code>.
   * @see #minWidth
   */
  public native function getMinWidth():Number;

  /**
   * @inheritDoc
   */
  public native function getOffsetsTo(offsetsTo:*):Array;

  /**
   * Retrieves a plugin from this component's collection by its <code>→id</code>.
   * <pre>
   * var grid = Ext.create('Ext.grid.Panel', {
   *     store: {
   *         fields: ['name'],
   *         data: [{
   *             name: 'Scott Pilgrim'
   *         }]
   *     },
   *     columns: [{
   *         header: 'Name',
   *         dataIndex: 'name',
   *         editor: 'textfield',
   *         flex: 1
   *     }],
   *     selType: 'cellmodel',
   *     plugins: [{
   *         ptype: 'cellediting',
   *         clicksToEdit: 1,
   *         id: 'myplugin'
   *     }],
   *     height: 200,
   *     width: 400,
   *     renderTo: Ext.getBody()
   * });
   *
   * grid.getPlugin('myplugin');  // the cellediting plugin
   * </pre>
   * <p><b>Note:</b> See also →<code>findPlugin()</code>. Prior to 6.2.0 the plugin had to have a
   * <code>→ext.plugin.AbstractPlugin.pluginId</code> property but this can now be just
   * <code>→ext.plugin.AbstractPlugin.id</code>. Both are supported (so plugins with a
   * matching <code>pluginId</code> are still found) but <code>→id</code> is preferred.</p>
   * @param id The <code>→id</code> set on the plugin config object.
   * @return plugin instance or <code>null</code> if not found
   * @see #id
   * @see #findPlugin()
   * @see ext.plugin.AbstractPlugin#pluginId
   * @see ext.plugin.AbstractPlugin#id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getPlugin Original Ext JS documentation of 'getPlugin'
   */
  public native function getPlugin(id:String):AbstractPlugin;

  [ArrayElementType("Number")]
  /**
   * Gets the current XY position of the component's underlying element.
   * @param local If true the element's left and top are returned instead of
   * page XY.
   * @default false
   * @return The XY position of the element (e.g., [100, 200])
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getPosition Original Ext JS documentation of 'getPosition'
   */
  public native function getPosition(local:Boolean = false):Array;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  public native function getPublishes():*;

  /**
   * Used by →<code>ext.ComponentQuery</code>, and the →<code>ext.Component.up()</code>
   * method to find the owning Component in the linkage hierarchy.
   * <p>By default this returns the Container which contains this Component.</p>
   * <p>This may be overridden by Component authors who implement ownership hierarchies
   * which are not based upon ownerCt, such as BoundLists being owned by Fields or Menus
   * being owned by Buttons.</p>
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see ext.Component#up()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-getRefOwner Original Ext JS documentation of 'getRefOwner'
   */
  protected native function getRefOwner():Component;

  /**
   * @inheritDoc
   */
  public native function getRegion(contentBox:Boolean = false, local:Boolean = false):Region;

  /**
   * Returns the "x" scroll position for this component. Only applicable for
   * →<code>scrollable</code> components
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getScrollX Original Ext JS documentation of 'getScrollX'
   */
  public native function getScrollX():Number;

  /**
   * Returns the "y" scroll position for this component. Only applicable for
   * →<code>scrollable</code> components
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getScrollY Original Ext JS documentation of 'getScrollY'
   */
  public native function getScrollY():Number;

  /**
   * Returns the value of <code>scrollable</code>.
   * @see #scrollable
   */
  public native function getScrollable():*;

  /**
   * Returns the value of <code>session</code>.
   * @see #session
   */
  public native function getSession():*;

  /**
   * Gets the current size of the component's underlying element.
   * @param contentSize true to get the width/size minus borders and padding
   * @return An object containing the element's size:
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getSize Original Ext JS documentation of 'getSize'
   */
  public native function getSize(contentSize:Boolean = false):Object;

  /**
   * Returns an object that describes how this component's width and height are managed.
   * All of these objects are shared and should not be modified.
   * @return The size model for this component.
   * <ul>
   * <li><code>width:ext.Base</code> (optional) —
   * The <i>size model</i> (→<code>null</code>)
   * for the width.
   * </li>
   * <li><code>height:ext.Base</code> (optional) —
   * The <i>size model</i> (→<code>null</code>)
   * for the height.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getSizeModel Original Ext JS documentation of 'getSizeModel'
   * @see null
   */
  protected native function getSizeModel(ownerCtSizeModel:*):Object;

  /**
   * The supplied default state gathering method for the Component class.
   * <p>This method returns dimension settings such as <code>→flex</code>, <code>→anchor</code>, <code>→width</code> and <code>→height</code>
   * along with <code>collapsed</code> state.</p>
   * <p>Subclasses which implement more complex state should call the superclass's implementation,
   * and apply their state to the result if this basic state is to be saved.</p>
   * <p>Note that Component state will only be saved if the Component has a →<code>stateId</code>
   * and there as a StateProvider configured for the document.</p>
   * @see #flex
   * @see #anchor
   * @see #width
   * @see #height
   * @see #stateId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getState Original Ext JS documentation of 'getState'
   */
  public native function getState():Object;

  /**
   * Returns the value of <code>stateful</code>.
   * @see #stateful
   */
  public native function getStateful():*;

  /**
   * Return the actual tabIndex for this Focusable.
   * @return tabIndex attribute value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getTabIndex Original Ext JS documentation of 'getTabIndex'
   */
  public native function getTabIndex():Number;

  /**
   * Returns the value of <code>touchAction</code>.
   * @see #touchAction
   */
  public native function getTouchAction():Object;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>userCls</code>.
   * @see #userCls
   */
  public native function getUserCls():*;

  /**
   * Returns the value of <code>viewModel</code>.
   * @see #viewModel
   */
  public native function getViewModel():*;

  /**
   * @inheritDoc
   */
  public native function getViewRegion():Region;

  /**
   * Gets the current width of the component's underlying element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getWidth Original Ext JS documentation of 'getWidth'
   */
  public native function getWidth():*;

  /**
   * @inheritDoc
   */
  public native function getX():Number;

  /**
   * Gets the xtype for this component as registered with →<code>ext.ComponentManager</code>.
   * For a list of all available xtypes, see the →<code>ext.Component</code> header.
   * Example usage:
   * <pre>
   * var t = new Ext.form.field.Text();
   * alert(t.getXType());  // alerts 'textfield'
   * </pre>
   * @return The xtype
   * @see ext.#ComponentManager ext.ComponentManager
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getXType Original Ext JS documentation of 'getXType'
   */
  public native function getXType():String;

  /**
   * Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all
   * available xtypes, see the →<code>ext.Component</code> header.
   * <p><b>If using your own subclasses, be aware that a Component must register its own xtype
   * to participate in determination of inherited xtypes.</b></p>
   * <p>Example usage:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * var t = new Ext.form.field.Text();
   * alert(t.getXTypes());  // alerts 'component/field/textfield'
   * </pre>
   * @since 2.3.0
   * @return The xtype hierarchy string
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-getXTypes Original Ext JS documentation of 'getXTypes'
   */
  public native function getXTypes():String;

  /**
   * @inheritDoc
   */
  public native function getXY():Array;

  /**
   * @inheritDoc
   */
  public native function getY():Number;

  /**
   * @inheritDoc
   */
  public native function hasActiveFx():*;

  /**
   * Checks if the specified CSS class exists on this element's DOM node.
   * @param className The CSS class to check for.
   * @return <code>true</code> if the class exists, else <code>false</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-hasCls Original Ext JS documentation of 'hasCls'
   */
  public native function hasCls(className:String):Boolean;

  /**
   * Checks if there is currently a specified <code>→uiCls</code>.
   * @param cls The <code>→cls</code> to check.
   * @see #uiCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-hasUICls Original Ext JS documentation of 'hasUICls'
   * @see #cls
   */
  public native function hasUICls(cls:String):void;

  /**
   * Hides this Component, setting it to invisible using the configured →<code>hideMode</code>.
   * @param animateTarget <b>only valid for
   * →<code>floating</code> Components such as →<code>ext.window.Window</code>s or
   * →<code>ext.tip.ToolTip</code>s, or regular Components which have been configured with
   * <code>floating: true</code>.</b>. The target to which the Component should animate while hiding.
   * @default null
   * @param callback A callback function to call after the Component is hidden.
   * @param scope The scope (<code>this</code> reference) in which the callback is executed.
   * Defaults to this Component.
   * @see #hideMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-hide Original Ext JS documentation of 'hide'
   * @see #floating
   * @see ext.window.Window
   * @see ext.tip.ToolTip
   */
  public native function hide(animateTarget:Object = null, callback:Function = null, scope:Object = null):void;

  /**
   * The initComponent template method is an important initialization step for a Component.
   * It is intended to be implemented by each subclass of Ext.Component to provide any needed
   * constructor logic. The initComponent method of the class being created is called first,
   * with each initComponent method up the hierarchy to Ext.Component being called thereafter.
   * This makes it easy to implement and, if needed, override the constructor logic
   * of the Component at any step in the hierarchy.
   * <p>The initComponent method <b>must</b> contain a call to
   * →<code>ext.Base.callParent()</code> in order to ensure that the parent class'
   * initComponent method is also called.</p>
   * <p>All config options passed to the constructor are applied to <code>this</code> before initComponent
   * is called, so you can simply access them with <code>this.someOption</code>.</p>
   * <p>The following example demonstrates using a dynamic string for the text of a button
   * at the time of instantiation of the class.</p>
   * <pre>
   * Ext.define('DynamicButtonText', {
   *     extend: 'Ext.button.Button',
   *
   *     initComponent: function() {
   *         this.text = new Date();
   *         this.renderTo = Ext.getBody();
   *         this.callParent();
   *     }
   * });
   *
   * Ext.onReady(function() {
   *     Ext.create('DynamicButtonText');
   * });
   * </pre>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @since 1.1.0
   * @see ext.Base#callParent()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-initComponent Original Ext JS documentation of 'initComponent'
   */
  protected native function initComponent():void;

  /**
   * Initialize any events on this component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-initEvents Original Ext JS documentation of 'initEvents'
   */
  protected native function initEvents():void;

  /**
   * Template method to do any event listener initialization for a Focusable.
   * This generally happens after the focusEl is available.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-initFocusableEvents Original Ext JS documentation of 'initFocusableEvents'
   */
  protected native function initFocusableEvents(force:*):void;

  /**
   * This method is called to initialize the <code>inheritedState</code> objects for this instance.
   * This amounts to typically copying certain properties from the instance to the given
   * object.
   * @since 5.0.0
   * @param inheritedState The state object for this instance.
   * @param inheritedStateInner This object is only provided for containers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-initInheritedState Original Ext JS documentation of 'initInheritedState'
   */
  protected native function initInheritedState(inheritedState:Object, inheritedStateInner:Object = null):void;

  /**
   * This method should be called when the instance is ready to start listening for
   * keyboard events. This is called automatically for <code>→ext.Component</code> and derived
   * classes. This is done after the component is rendered.
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Keyboard.html#method-initKeyMap Original Ext JS documentation of 'initKeyMap'
   */
  protected native function initKeyMap():void;

  /**
   * Initialized the renderData to be used when rendering the renderTpl.
   * @return Object with keys and values that are going to be applied to the renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-initRenderData Original Ext JS documentation of 'initRenderData'
   */
  protected native function initRenderData():Object;

  /**
   * @inheritDoc
   */
  public native function isAncestor(possibleDescendant:Component):Boolean;

  /**
   * @inheritDoc
   */
  public native function isBound(name:String = null):Boolean;

  /**
   * @inheritDoc
   */
  public native function isDescendantOf(ancestor:Component):Boolean;

  /**
   * Method to determine whether this Component is currently disabled.
   * @return the disabled state of this Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isDisabled Original Ext JS documentation of 'isDisabled'
   */
  public native function isDisabled():Boolean;

  /**
   * Method to determine whether this Component is draggable.
   * @return the draggable state of this component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isDraggable Original Ext JS documentation of 'isDraggable'
   */
  public native function isDraggable():Boolean;

  /**
   * Method to determine whether this Component is droppable.
   * @return the droppable state of this component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isDroppable Original Ext JS documentation of 'isDroppable'
   */
  public native function isDroppable():Boolean;

  /**
   * Method to determine whether this Component is floating.
   * @return the floating state of this component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isFloating Original Ext JS documentation of 'isFloating'
   */
  public native function isFloating():Boolean;

  /**
   * Determine if this Focusable can receive focus at this time.
   * <p>Note that Containers can be non-focusable themselves while delegating
   * focus treatment to a child Component; see <i>defaultFocus</i> (→<code>ext.container.Container</code>)
   * for more information.</p>
   * @param deep Optionally determine if the container itself
   * is focusable, or if container's focus is delegated to a child component
   * and that child is focusable.
   * @default false
   * @return True if component is focusable, false if not.
   * @see ext.container.Container
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isFocusable Original Ext JS documentation of 'isFocusable'
   */
  public native function isFocusable(deep:Boolean = false):Boolean;

  /**
   * Method to determine whether this Component is currently set to hidden.
   * @return the hidden state of this Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isHidden Original Ext JS documentation of 'isHidden'
   */
  public native function isHidden():Boolean;

  /**
   * Determines whether this Component is the root of a layout. This returns <code>true</code> if
   * this component can run its layout without assistance from or impact on its owner.
   * If this component cannot run its layout given these restrictions, <code>false</code> is returned
   * and its owner will be considered as the next candidate for the layout root.
   * <p>Setting the →<code>_isLayoutRoot</code> property to <code>true</code> causes this method to always
   * return <code>true</code>. This may be useful when updating a layout of a Container which shrink
   * wraps content, and you know that it will not change size, and so can safely be the
   * topmost participant in the layout run.</p>
   * @see #_isLayoutRoot
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isLayoutRoot Original Ext JS documentation of 'isLayoutRoot'
   */
  protected native function isLayoutRoot():Boolean;

  /**
   * Returns <code>true</code> if layout is suspended for this component. This can come from direct
   * suspension of this component's layout activity (→<code>ext.container.Container.suspendLayout</code>)
   * or if one of this component's containers is suspended.
   * @return <code>true</code> layout of this component is suspended.
   * @see ext.container.Container#suspendLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isLayoutSuspended Original Ext JS documentation of 'isLayoutSuspended'
   */
  public native function isLayoutSuspended():Boolean;

  /**
   * Returns masked state for this Component.
   * @param deep True to look up this Component's parent masked state.
   * @default false
   * @return True if masked, false otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isMasked Original Ext JS documentation of 'isMasked'
   */
  public native function isMasked(deep:Boolean = false):Boolean;

  /**
   * Returns <code>true</code> if this component is visible.
   * @since 1.1.0
   * @param deep Pass <code>true</code> to interrogate the visibility status of all
   * parent Containers to determine whether this Component is truly visible to the user.
   * <p>Generally, to determine whether a Component is hidden, the no argument form is needed.
   * For example when creating dynamically laid out UIs in a hidden Container before showing them.</p>
   * @default false
   * @return <code>true</code> if this component is visible, <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isVisible Original Ext JS documentation of 'isVisible'
   */
  public native function isVisible(deep:Boolean = false):Boolean;

  /**
   * Tests whether or not this Component is of a specific xtype. This can test whether this
   * Component is descended from the xtype (default) or whether it is directly of the xtype
   * specified (<code>shallow = true</code>).
   * <p><b>If using your own subclasses, be aware that a Component must register its own xtype
   * to participate in determination of inherited xtypes.</b></p>
   * <p>For a list of all available xtypes, see the →<code>ext.Component</code> header.</p>
   * <p>Example usage:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * var t = new Ext.form.field.Text();
   * var isText = t.isXType('textfield');          // true
   * var isBoxSubclass = t.isXType('field');       // true, descended from Ext.form.field.Base
   * var isBoxInstance = t.isXType('field', true); // false, not a direct Ext.form.field.Base
   *                                               // instance
   * </pre>
   * @since 2.3.0
   * @param xtype The xtype to check for this Component
   * @param shallow <code>true</code> to check whether this Component is directly
   * of the specified xtype, <code>false</code> to check whether this Component is descended from the xtype.
   * @default false
   * @return <code>true</code> if this component descends from the specified xtype,
   * <code>false</code> otherwise.
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-isXType Original Ext JS documentation of 'isXType'
   */
  public native function isXType(xtype:String, shallow:Boolean = false):Boolean;

  /**
   * @inheritDoc
   */
  public native function lookupController(skipThis:Boolean = false):ViewController;

  /**
   * @inheritDoc
   */
  public native function lookupSession(skipThis:Boolean = false):Session;

  /**
   * Gets a named template instance for this class. See →<code>ext.XTemplate.getTpl()</code>.
   * @since 6.2.0
   * @param name The name of the property that holds the template.
   * @return The template, <code>null</code> if not found.
   * @see ext.XTemplate#getTpl()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-lookupTpl Original Ext JS documentation of 'lookupTpl'
   */
  public native function lookupTpl(name:String):XTemplate;

  /**
   * @inheritDoc
   */
  public native function lookupViewModel(skipThis:Boolean = false):ViewModel;

  /**
   * Masks this component with a semi-opaque layer and makes the contents unavailable to clicks.
   * <p>See →<code>unmask()</code>.</p>
   * @param msg A message to show in the center of the mask layer.
   * @param msgCls A CSS class name to use on the message element in the center
   * of the layer.
   * @see #unmask()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-mask Original Ext JS documentation of 'mask'
   */
  public native function mask(msg:String = null, msgCls:String = null):void;

  /**
   * Tests whether this Component matches a →<code>ext.ComponentQuery</code>
   * selector string.
   * @param selector The selector string to test against.
   * @return <code>true</code> if this Component matches the selector.
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-is Original Ext JS documentation of 'is'
   */
  public native function matches(selector:String):Boolean;

  /**
   * @inheritDoc
   */
  public native function move(direction:String, distance:Number, animate:* = undefined):void;

  /**
   * Returns the next node in the Component tree in tree traversal order.
   * <p>Note that this is not limited to siblings, and if invoked upon a node with no matching
   * siblings, will walk the tree to attempt to find a match. Contrast with →<code>nextSibling()</code>.</p>
   * @param selector A →<code>ext.ComponentQuery</code> selector to filter
   * the following nodes.
   * @return The next node (or the next node which matches the selector).
   * Returns <code>null</code> if there is no matching node.
   * @see #nextSibling()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-nextNode Original Ext JS documentation of 'nextNode'
   * @see ext.#ComponentQuery ext.ComponentQuery
   */
  public native function nextNode(selector:String = null):Component;

  /**
   * Returns the next sibling of this Component.
   * <p>Optionally selects the next sibling which matches the passed
   * →<code>ext.ComponentQuery</code> selector.</p>
   * <p>May also be referred to as <b><code>next()</code></b></p>
   * <p>Note that this is limited to siblings, and if no siblings of the item match,
   * <code>null</code> is returned. Contrast with →<code>nextNode()</code></p>
   * @param selector A →<code>ext.ComponentQuery</code> selector to filter
   * the following items.
   * @return The next sibling (or the next sibling which matches the selector).
   * Returns <code>null</code> if there is no matching sibling.
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see #nextNode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-nextSibling Original Ext JS documentation of 'nextSibling'
   */
  public native function nextSibling(selector:String = null):Component;

  /**
   * Method to manage awareness of when components are added to their
   * respective Container, firing an #added event. References are
   * established at add time rather than at render time.
   * <p>Allows addition of behavior when a Component is added to a
   * Container. At this stage, the Component is in the parent
   * Container's collection of child items. After calling the
   * superclass's <code>→onAdded()</code>, the <code>→ownerCt</code> reference will be present,
   * and if configured with a ref, the <code>refOwner</code> will be set.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @since 3.4.0
   * @param container Container which holds the component.
   * @param pos Position at which the component was added.
   * @param instanced <code>false</code> if this component was instanced by the parent
   * container. <code>true</code> if the instance already existed when it was passed to the container.
   * @see #onAdded()
   * @see #ownerCt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onAdded Original Ext JS documentation of 'onAdded'
   */
  protected native function onAdded(container:Container, pos:Number, instanced:Boolean):void;

  /**
   * Invoked when this component has first achieved size. This occurs after the
   * →<code>componentLayout</code> has completed its initial run.
   * <p>This method is not called on components that use →<code>liquidLayout</code>, such as
   * <i>Buttons</i> (→<code>ext.button.Button</code>) and <i>Form Fields</i> (→<code>ext.form.field.BaseField</code>).</p>
   * <p><b>Note:</b> If the Component has a <i>ViewController</i> (→<code>ext.Component.controller</code>)
   * and the controller has a →<code>ext.app.ViewController.boxReady()</code> method
   * it will be called passing the Component and its width and height.</p>
   * <pre>
   *  boxReady: function(view, width, height) {
   *      // ...
   *  }
   * </pre>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param width The width of this component
   * @param height The height of this component
   * @see #componentLayout
   * @see #liquidLayout
   * @see ext.button.Button
   * @see ext.form.field.BaseField
   * @see ext.Component#controller
   * @see ext.app.ViewController#boxReady()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onBoxReady Original Ext JS documentation of 'onBoxReady'
   */
  protected native function onBoxReady(width:Number, height:Number):void;

  /**
   * Allows addition of behavior to the destroy operation.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onDestroy Original Ext JS documentation of 'onDestroy'
   */
  protected native function onDestroy():void;

  /**
   * Allows addition of behavior to the disable operation.
   * After calling the superclass's <code>→onDisable()</code>, the Component will be disabled.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see #onDisable()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onDisable Original Ext JS documentation of 'onDisable'
   */
  protected native function onDisable():void;

  /**
   * Allows addition of behavior to the enable operation.
   * After calling the superclass's <code>→onEnable()</code>, the Component will be enabled.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see #onEnable()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onEnable Original Ext JS documentation of 'onEnable'
   */
  protected native function onEnable():void;

  /**
   * Called when focus enters this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying DOM event.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>relatedTarget:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * <li><code>backwards:Boolean</code> (optional) —
   * <code>true</code> if the <code>fromComponent</code> is <i>after</i> the <code>toComponent&#42; in the DOM tree, indicating that the user used</code>SHIFT+TAB<code>to move focus. Note that setting</code>tabIndex<code>values to affect tabbing order can cause this to be incorrect. Setting</code>tabIndex` values is not advised.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusEnter Original Ext JS documentation of 'onFocusEnter'
   */
  protected native function onFocusEnter(e:Event):void;

  /**
   * Called when focus exits from this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param e
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying DOM event.
   * </li>
   * <li><code>target:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>relatedTarget:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusLeave Original Ext JS documentation of 'onFocusLeave'
   */
  protected native function onFocusLeave(e:Event):void;

  /**
   * Called when focus moves <i>within</i> this Component's hierarchy
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info
   * <ul>
   * <li><code>event:ext.event.Event</code> (optional) —
   * The underlying Event object.
   * </li>
   * <li><code>toElement:js.HTMLElement</code> (optional) —
   * The element gaining focus.
   * </li>
   * <li><code>fromElement:js.HTMLElement</code> (optional) —
   * The element losing focus.
   * </li>
   * <li><code>toComponent:ext.Component</code> (optional) —
   * The Component gaining focus.
   * </li>
   * <li><code>fromComponent:ext.Component</code> (optional) —
   * The Component losing focus.
   * </li>
   * <li><code>backwards:Boolean</code> (optional) —
   * <code>true</code> if the focus movement is backward in DOM order
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-onFocusMove Original Ext JS documentation of 'onFocusMove'
   */
  protected native function onFocusMove(info:Object):void;

  /**
   * Allows addition of behavior to the hide operation. After
   * calling the superclass's onHide, the Component will be hidden.
   * <p>Gets passed the same parameters as #hide.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param animateTarget
   * @param callback Callback function to be called when finished
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onHide Original Ext JS documentation of 'onHide'
   */
  protected native function onHide(animateTarget:* = undefined, callback:Function = null, scope:Object = null):void;

  /**
   * Called after the component is moved, this method is empty by default but can be implemented
   * by any subclass that needs to perform custom logic after a move occurs.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param x The new x position.
   * @param y The new y position.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onPosition Original Ext JS documentation of 'onPosition'
   */
  protected native function onPosition(x:Number, y:Number):void;

  /**
   * Method to manage awareness of when components are removed from their
   * respective Container, firing a #removed event. References are properly
   * cleaned up after removing a component from its owning container.
   * <p>Allows addition of behavior when a Component is removed from
   * its parent Container. At this stage, the Component has been
   * removed from its parent Container's collection of child items,
   * but has not been destroyed (It will be destroyed if the parent
   * Container's <code>autoDestroy</code> is <code>true</code>, or if the remove call was
   * passed a truthy second parameter). After calling the
   * superclass's <code>→onRemoved()</code>, the <code>→ownerCt</code> and the <code>refOwner</code> will not
   * be present.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @since 3.4.0
   * @param destroying Will be passed as <code>true</code> if the Container performing
   * the remove operation will delete this Component upon remove.
   * @see #onRemoved()
   * @see #ownerCt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onRemoved Original Ext JS documentation of 'onRemoved'
   */
  protected native function onRemoved(destroying:Boolean):void;

  /**
   * Template method called when this Component's DOM structure is created.
   * <p>At this point, this Component's (and all descendants') DOM structure <i>exists</i> but it has not
   * been layed out (positioned and sized).</p>
   * <p>Subclasses which override this to gain access to the structure at render time should
   * call the parent class's method before attempting to access any child elements of the
   * Component.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param parentNode The parent Element in which this Component's
   * encapsulating element is contained.
   * @param containerIdx The index within the parent Container's child collection
   * of this Component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.Renderable.html#method-onRender Original Ext JS documentation of 'onRender'
   */
  protected native function onRender(parentNode:Element, containerIdx:Number):void;

  /**
   * Called when the component is resized.
   * <p>This method is not called on components that use →<code>liquidLayout</code>, such as
   * <i>Buttons</i> (→<code>ext.button.Button</code>) and <i>Form Fields</i> (→<code>ext.form.field.BaseField</code>).</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param width The new width that was set
   * @param height The new height that was set
   * @param oldWidth The previous width
   * @param oldHeight The previous height
   * @see #liquidLayout
   * @see ext.button.Button
   * @see ext.form.field.BaseField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onResize Original Ext JS documentation of 'onResize'
   */
  protected native function onResize(width:Number, height:Number, oldWidth:Number, oldHeight:Number):void;

  /**
   * Invoked when a scroll operation is completed via this component's
   * <i>scroller</i> (→<code>scrollable</code>).
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param x The current x position
   * @param y The current y position
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onScrollEnd Original Ext JS documentation of 'onScrollEnd'
   */
  protected native function onScrollEnd(x:Number, y:Number):void;

  /**
   * Invoked when this component is scrolled via its <i>scroller</i> (→<code>scrollable</code>).
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param x The current x position
   * @param y The current y position
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onScrollMove Original Ext JS documentation of 'onScrollMove'
   */
  protected native function onScrollMove(x:Number, y:Number):void;

  /**
   * Invoked when a scroll is initiated on this component via its <i>scroller</i> (→<code>scrollable</code>).
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param x The current x position
   * @param y The current y position
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onScrollStart Original Ext JS documentation of 'onScrollStart'
   */
  protected native function onScrollStart(x:Number, y:Number):void;

  /**
   * Allows addition of behavior to the show operation. After
   * calling the superclass's onShow, the Component will be visible.
   * <p>Override in subclasses where more complex behaviour is needed.</p>
   * <p>Gets passed the same parameters as #show.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onShow Original Ext JS documentation of 'onShow'
   */
  protected native function onShow(animateTarget:* = undefined, callback:Function = null, scope:Object = null):void;

  /**
   * Invoked after the #afterShow method is complete.
   * <p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that #afterShow received.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-onShowComplete Original Ext JS documentation of 'onShowComplete'
   */
  protected native function onShowComplete(callback:Function = null, scope:Object = null):void;

  /**
   * Template method to do any post-blur processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-postBlur Original Ext JS documentation of 'postBlur'
   */
  protected native function postBlur(e:Event):void;

  /**
   * Template method to do any post-focus processing.
   * @param e The event object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Focusable.html#method-postFocus Original Ext JS documentation of 'postFocus'
   */
  protected native function postFocus(e:Event):void;

  /**
   * Returns the previous node in the Component tree in tree traversal order.
   * <p>Note that this is not limited to siblings, and if invoked upon a node with no matching
   * siblings, will walk the tree in reverse order to attempt to find a match. Contrast with
   * →<code>previousSibling()</code>.</p>
   * @param selector A →<code>ext.ComponentQuery</code> selector to filter
   * the preceding nodes.
   * @return The previous node (or the previous node which matches the selector).
   * Returns <code>null</code> if there is no matching node.
   * @see #previousSibling()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-previousNode Original Ext JS documentation of 'previousNode'
   * @see ext.#ComponentQuery ext.ComponentQuery
   */
  public native function previousNode(selector:String = null):Component;

  /**
   * Returns the previous sibling of this Component.
   * <p>Optionally selects the previous sibling which matches the passed
   * →<code>ext.ComponentQuery</code> selector.</p>
   * <p>May also be referred to as <b><code>prev()</code></b></p>
   * <p>Note that this is limited to siblings, and if no siblings of the item match,
   * <code>null</code> is returned. Contrast with →<code>previousNode()</code></p>
   * @param selector A →<code>ext.ComponentQuery</code> selector to filter
   * the preceding items.
   * @return The previous sibling (or the previous sibling which matches
   * the selector).
   * Returns <code>null</code> if there is no matching sibling.
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see #previousNode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-previousSibling Original Ext JS documentation of 'previousSibling'
   */
  public native function previousSibling(selector:String = null):Component;

  /**
   * Publish this components state to the <code>ViewModel</code>. If no arguments are given (or if
   * this is the first call), the entire state is published. This state is determined by
   * the <code>→publishes</code> property.
   * <p>This method is called only by component authors.</p>
   * @since 5.0.0
   * @param property The name of the property to update.
   * @param value The value of <code>property</code>. Only needed if <code>property</code> is given.
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Bindable.html#method-publishState Original Ext JS documentation of 'publishState'
   */
  protected native function publishState(property:String = null, value:Object = null):void;

  /**
   * Called by Component#doAutoRender.
   * <p>Register a Container configured <code>floating: true</code> with this Component's
   * →<code>ext.ZIndexManager</code>.</p>
   * <p>Components added in this way will not participate in any layout, but will be rendered
   * upon first show in the way that →<code>ext.window.Window</code>s are.</p>
   * @see ext.ZIndexManager
   * @see ext.window.Window
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-registerFloatingItem Original Ext JS documentation of 'registerFloatingItem'
   */
  public native function registerFloatingItem(cmp:*):void;

  /**
   * @inheritDoc
   */
  public native function removeAnchor():void;

  [Deprecated(replacement="addCls", since="4.1")]
  /**
   * Removes a CSS class from the top level element representing this component.
   * @since 2.3.0
   * @param cls The CSS class name to remove.
   * @return Returns the Component to allow method chaining.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-removeClass Original Ext JS documentation of 'removeClass'
   */
  public native function removeClass(cls:*):Component;

  /**
   * Removes a CSS class from the top level element representing this component.
   * @param cls The CSS class name to remove.
   * @return Returns the Component to allow method chaining.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-removeCls Original Ext JS documentation of 'removeCls'
   */
  public native function removeCls(cls:*):Component;

  /**
   * Removes a <code>→cls</code> to the <code>→uiCls</code> array, which will also call →<code>removeUIClsFromElement()</code>
   * and removes it from all elements of this component.
   * @param classes A string or an array of strings to remove to the <code>→uiCls</code>.
   * @param skip True to remove the class
   * @see #cls
   * @see #uiCls
   * @see #removeUIClsFromElement()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-removeClsWithUI Original Ext JS documentation of 'removeClsWithUI'
   */
  public native function removeClsWithUI(classes:*, skip:Boolean):void;

  /**
   * Method which removes a specified UI + <code>→uiCls</code> from the components element. The <code>→cls</code>
   * which is added to the element will be: <code>this.baseCls + '-' + ui + uiCls</code>.
   * @param uiCls The UI class to remove from the element.
   * @see #uiCls
   * @see #cls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-removeUIClsFromElement Original Ext JS documentation of 'removeUIClsFromElement'
   */
  protected native function removeUIClsFromElement(uiCls:String):void;

  /**
   * @inheritDoc
   */
  public native function render(container:* = undefined, position:* = undefined):void;

  /**
   * Gets the Controller or Component that is used as the event root for this view.
   * @since 5.0.0
   * @param defaultScope (Default this) The default scope to return if none is found.
   * @default this
   * @return The default listener scope.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-resolveListenerScope Original Ext JS documentation of 'resolveListenerScope'
   */
  override protected native function resolveListenerScope(defaultScope:Object = null):Object;

  /**
   * Returns the default listener scope for a "satellite" of this component.
   * Used for resolving scope for observable objects that are not part of the normal
   * Container/Component hierarchy (for example, plugins)
   * @since 5.1.1
   * @return The listener scope
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.mixin.Inheritable.html#method-resolveSatelliteListenerScope Original Ext JS documentation of 'resolveSatelliteListenerScope'
   */
  protected native function resolveSatelliteListenerScope(satellite:Observable, defaultScope:Object = null):Object;

  /**
   * @inheritDoc
   */
  public native function savePropToState(propName:String, state:Object, stateName:String = null):Boolean;

  /**
   * @inheritDoc
   */
  public native function savePropsToState(propNames:*, state:Object):Object;

  /**
   * @inheritDoc
   */
  public native function saveState():void;

  /**
   * Scrolls this Component by the passed delta values, optionally animating.
   * <p>All of the following are equivalent:</p>
   * <pre>
   *  comp.scrollBy(10, 10, true);
   *  comp.scrollBy([10, 10], true);
   *  comp.scrollBy({ x: 10, y: 10 }, true);
   * </pre>
   * @param deltaX Either the x delta, an Array specifying x and y deltas
   * or an object with "x" and "y" properties.
   * @param deltaY Either the y delta, or an animate flag
   * or config object.
   * @param animate Animate flag/config object if the delta values were passed
   * separately.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-scrollBy Original Ext JS documentation of 'scrollBy'
   */
  public native function scrollBy(deltaX:*, deltaY:*, animate:*):void;

  /**
   * Scrolls this component to the specified <code>x</code> and <code>y</code> coordinates. Only applicable
   * for →<code>scrollable</code> components.
   * @param x
   * @param y
   * @param animate true for the default animation or a standard Element
   * animation config object
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-scrollTo Original Ext JS documentation of 'scrollTo'
   */
  public native function scrollTo(x:Number, y:Number, animate:* = undefined):void;

  /**
   * @inheritDoc
   */
  public native function sequenceFx():Object;

  /**
   * Sets the value of <code>alwaysOnTop</code>.
   * @param alwaysOnTop The new value.
   * @see #alwaysOnTop
   */
  public native function setAlwaysOnTop(alwaysOnTop:*):void;

  /**
   * Sets the value of <code>ariaAttributes</code>.
   * @param ariaAttributes The new value.
   * @see #ariaAttributes
   */
  public native function setAriaAttributes(ariaAttributes:Object):void;

  [Deprecated(replacement="setScrollable", since="5.0.0")]
  /**
   * Sets the overflow on the content element of the component.
   * @param scroll True to allow the Component to auto scroll.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setAutoScroll Original Ext JS documentation of 'setAutoScroll'
   */
  public native function setAutoScroll(scroll:Boolean):Component;

  /**
   * Sets the value of <code>bind</code>.
   * @param bind The new value.
   * @see #bind
   */
  public native function setBind(bind:*):void;

  /**
   * @param border The border, see →<code>border</code>. If a falsey value is passed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setBorder Original Ext JS documentation of 'setBorder'
   * @see #border
   */
  public native function setBorder(border:*):void;

  /**
   * @inheritDoc
   */
  public native function setBox(box:Object, animate:Boolean = undefined):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  public native function setChildEls(childEls:*):void;

  /**
   * Sets the value of <code>controller</code>.
   * @param controller The new value.
   * @see #controller
   */
  public native function setController(controller:*):void;

  /**
   * Sets the value of <code>data</code>.
   * @param data The new value.
   * @see #data
   */
  [Return("this")]
  public native function setData(data:Object):void;

  /**
   * Sets the value of <code>defaultListenerScope</code>.
   * @param defaultListenerScope The new value.
   * @see #defaultListenerScope
   */
  public native function setDefaultListenerScope(defaultListenerScope:Boolean):void;

  /**
   * Enable or disable the component.
   * @param disabled <code>true</code> to disable.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setDisabled Original Ext JS documentation of 'setDisabled'
   */
  [Return("this")]
  public native function setDisabled(disabled:Boolean):void;

  /**
   * Sets the dock position of this component in its parent panel. Note that this only has effect
   * if this item is part of the <code>dockedItems</code> collection of a parent that has a DockLayout
   * (note that any Panel has a DockLayout by default)
   * @param dock The dock position.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setDock Original Ext JS documentation of 'setDock'
   */
  public native function setDock(dock:Object):Component;

  [Deprecated(replacement="setDock", since="5.0")]
  /**
   * Sets the dock position of this component in its parent panel. Note that this only has effect
   * if this item is part of the <code>dockedItems</code> collection of a parent that has a DockLayout
   * (note that any Panel has a DockLayout by default)
   * @param dock The dock position.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setDocked Original Ext JS documentation of 'setDocked'
   */
  public native function setDocked(dock:Object):Component;

  /**
   * Sets the height of the component. This method fires the →<code>event:onResize</code> event.
   * @param height The new height to set. This may be one of:
   * <ul>
   * <li>A Number specifying the new height in pixels.</li>
   * <li>A String used to set the CSS height style.</li>
   * <li><code>undefined</code> to leave the height unchanged.</li>
   * <li><code>null</code> to clear the height.</li>
   * </ul>
   * @return this
   * @see #event:onResize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setHeight Original Ext JS documentation of 'setHeight'
   */
  public native function setHeight(height:*):Component;

  /**
   * Sets the hidden state of this component. This is basically the same as
   * <code>→setVisible()</code> but the boolean parameter has the opposite meaning.
   * @see #setVisible()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setHidden Original Ext JS documentation of 'setHidden'
   */
  public native function setHidden(hidden:Boolean):Component;

  /**
   * Update the content area of a component.
   * @since 3.4.0
   * @param html If this component has been configured with a
   * template via the tpl config then it will use this argument as data to populate the
   * template. If this component was not configured with a template, the components
   * content area will be updated via Ext.Element update.
   * @param loadScripts Only legitimate when using the <code>→html</code>
   * configuration. Causes embedded script tags to be executed. Inline source will be executed
   * with this Component as the scope (<code>this</code> reference).
   * @default false
   * @param callback Only legitimate when using the <code>→html</code> configuration.
   * Callback to execute when scripts have finished loading.
   * @param scriptScope The scope (<code>this</code> reference) in which to
   * execute <i>inline</i> script elements content. Scripts with a <code>src</code> attribute cannot
   * be executed with this scope.
   * @default 'this'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setHtml Original Ext JS documentation of 'setHtml'
   * @see #html
   */
  public native function setHtml(html:*, loadScripts:Boolean = false, callback:Function = null, scriptScope:Object = 'this'):void;

  /** @inheritDoc */
  public native function setKeyMap(keyMap:Object):void;

  /** @inheritDoc */
  public native function setKeyMapEnabled(keyMapEnabled:Boolean):void;

  /**
   * This method allows you to show or hide a LoadMask on top of this component.
   * <p>The mask will be rendered into the element returned by →<code>getMaskTarget()</code> which for most
   * Components is the Component's element. See →<code>getMaskTarget()</code> and →<code>maskElement</code>.</p>
   * <p>Most Components will return <code>null</code> indicating that their LoadMask cannot reside inside
   * their element, but must be rendered into the document body.</p>
   * <p><i>Grid Views</i> (→<code>ext.view.TableView</code>) however will direct a LoadMask to be rendered into
   * the owning <i>GridPanel</i> (→<code>ext.panel.TablePanel</code>).</p>
   * @param load True to show the default LoadMask, a config object
   * that will be passed to the LoadMask constructor, or a message String to show. False to hide
   * the current LoadMask.
   * @return The LoadMask instance that has just been shown.
   * @see #getMaskTarget()
   * @see #maskElement
   * @see ext.view.TableView
   * @see ext.panel.TablePanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setLoading Original Ext JS documentation of 'setLoading'
   */
  public native function setLoading(load:*):LoadMask;

  /**
   * @inheritDoc
   */
  public native function setLocalX(x:Number):void;

  /**
   * @inheritDoc
   */
  public native function setLocalXY(x:*, y:Number = NaN):void;

  /**
   * @inheritDoc
   */
  public native function setLocalY(y:Number):void;

  /**
   * Sets the margin on the target element.
   * @param margin The margin to set. See the →<code>margin</code> config.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setMargin Original Ext JS documentation of 'setMargin'
   * @see #margin
   */
  public native function setMargin(margin:*):void;

  /**
   * Sets the value of <code>maxHeight</code>.
   * @param maxHeight The new value.
   * @see #maxHeight
   */
  public native function setMaxHeight(maxHeight:Number):void;

  /**
   * Sets the value of <code>maxWidth</code>.
   * @param maxWidth The new value.
   * @see #maxWidth
   */
  public native function setMaxWidth(maxWidth:Number):void;

  /**
   * Sets the value of <code>minHeight</code>.
   * @param minHeight The new value.
   * @see #minHeight
   */
  public native function setMinHeight(minHeight:Number):void;

  /**
   * Sets the value of <code>minWidth</code>.
   * @param minWidth The new value.
   * @see #minWidth
   */
  public native function setMinWidth(minWidth:Number):void;

  [Deprecated(replacement="setScrollable", since="5.0.0")]
  /**
   * Sets the overflow x/y on the content element of the component. The x/y overflow
   * values can be any valid CSS overflow (e.g., 'auto' or 'scroll'). By default, the
   * value is 'hidden'. Passing <code>undefined</code> will preserve the current value.
   * @param overflowX The overflow-x value.
   * @param overflowY The overflow-y value.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setOverflowXY Original Ext JS documentation of 'setOverflowXY'
   */
  public native function setOverflowXY(overflowX:String, overflowY:String):Component;

  /**
   * Sets the page XY position of the component. To set the left and top instead,
   * use →<code>setPosition()</code>. This method fires the →<code>event:onMove</code> event.
   * @param x The new x position or an array of <code>[x,y]</code>.
   * @param y The new y position.
   * @param animate True to animate the Component into its new position.
   * You may also pass an animation configuration.
   * @return this
   * @see #setPosition()
   * @see #event:onMove
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setPagePosition Original Ext JS documentation of 'setPagePosition'
   */
  public native function setPagePosition(x:Number, y:Number = NaN, animate:* = undefined):Component;

  /**
   * Sets the left and top of the component. To set the page XY position instead,
   * use →<code>ext.Component.setPagePosition()</code>. This method fires the
   * →<code>event:onMove</code> event.
   * @param x The new left, an array of <code>[x,y]</code>, or animation config
   * object containing <code>x</code> and <code>y</code> properties.
   * @param y The new top.
   * @param animate If <code>true</code>, the Component is <i>animated</i> into
   * its new position. You may also pass an animation configuration.
   * @return this
   * @see ext.Component#setPagePosition()
   * @see #event:onMove
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setPosition Original Ext JS documentation of 'setPosition'
   */
  public native function setPosition(x:Number, y:Number = NaN, animate:* = undefined):Component;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  public native function setPublishes(publishes:*):void;

  /**
   * This method changes the <code>region</code> config property for this border region. This is
   * only valid if this component is in a <code>border</code> layout (<code>→ext.layout.container.BorderLayout</code>).
   * @param region The new <code>region</code> value (<code>"north"</code>, <code>"south"</code>, <code>"east"</code> or
   * <code>"west"</code>).
   * @return The previous value of the <code>region</code> property.
   * @see ext.layout.container.BorderLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setRegion Original Ext JS documentation of 'setRegion'
   */
  public native function setRegion(region:String):String;

  /**
   * Sets the "x" scroll position for this component. Only applicable for
   * →<code>scrollable</code> components
   * @param x
   * @param animate true for the default animation or a standard Element
   * animation config object
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setScrollX Original Ext JS documentation of 'setScrollX'
   */
  public native function setScrollX(x:Number, animate:* = undefined):void;

  /**
   * Sets the "y" scroll position for this component. Only applicable for
   * →<code>scrollable</code> components
   * @param y
   * @param animate true for the default animation or a standard Element
   * animation config object
   * @see #scrollable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setScrollY Original Ext JS documentation of 'setScrollY'
   */
  public native function setScrollY(y:Number, animate:* = undefined):void;

  /**
   * Sets the value of <code>scrollable</code>.
   * @param scrollable The new value.
   * @see #scrollable
   */
  public native function setScrollable(scrollable:*):void;

  /**
   * Sets the value of <code>session</code>.
   * @param session The new value.
   * @see #session
   */
  public native function setSession(session:*):void;

  /**
   * Sets the width and height of this Component. This method fires the →<code>event:onResize</code> event.
   * This method can accept either width and height as separate arguments, or you can pass
   * a size object like <code>{ width:10, height:20 }</code>.
   * @param width The new width to set. This may be one of:
   * <ul>
   * <li>A Number specifying the new width in pixels.</li>
   * <li>A String used to set the CSS width style.</li>
   * <li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>
   * <li><code>undefined</code> to leave the width unchanged.</li>
   * </ul>
   * @param height The new height to set (not required if a size object is passed
   * as the first arg). This may be one of:
   * <ul>
   * <li>A Number specifying the new height in pixels.</li>
   * <li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>
   * <li><code>undefined</code> to leave the height unchanged.</li>
   * </ul>
   * @return this
   * @see #event:onResize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setSize Original Ext JS documentation of 'setSize'
   */
  [Return("this")]
  public native function setSize(width:*, height:*):Component;

  /**
   * Sets the value of <code>stateful</code>.
   * @param stateful The new value.
   * @see #stateful
   */
  public native function setStateful(stateful:*):void;

  /**
   * Sets the style for this Component's primary element.
   * <p>Styles should be a valid DOM element style property.
   * <a href="http://www.w3schools.com/jsref/dom_obj_style.asp">Valid style property names</a>
   * (<i>along with the supported CSS version for each</i>)</p>
   * <pre>
   * var name = Ext.create({
   *     xtype: 'component',
   *     renderTo: Ext.getBody(),
   *     html: 'Phineas Flynn'
   * });
   *
   * // two-param syntax
   * name.setStyle('color', 'white');
   *
   * // single-param syntax
   * name.setStyle({
   *     fontWeight: 'bold',
   *     backgroundColor: 'gray',
   *     padding: '10px'
   * });
   * </pre>
   * @param property The style property to be set, or an object of
   * multiple styles.
   * @param value The value to apply to the given property, or null if an
   * object was passed.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setStyle Original Ext JS documentation of 'setStyle'
   */
  public native function setStyle(property:*, value:String = null):Component;

  /**
   * Set the tabIndex property for this Focusable. If the focusEl
   * is available, set tabIndex attribute on it, too.
   * @param newTabIndex new tabIndex to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setTabIndex Original Ext JS documentation of 'setTabIndex'
   */
  public native function setTabIndex(newTabIndex:Number):void;

  /**
   * Sets the value of <code>touchAction</code>.
   * @param touchAction The new value.
   * @see #touchAction
   */
  public native function setTouchAction(touchAction:Object):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the UI for the component. This will remove any existing UIs on the component.
   * It will also loop through any <code>→uiCls</code> set on the component and rename them so they include
   * the new UI.
   * @param ui The new UI for the component.
   * @see #uiCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setUI Original Ext JS documentation of 'setUI'
   */
  public native function setUI(ui:String):void;

  /**
   * Sets the value of <code>userCls</code>.
   * @param userCls The new value.
   * @see #userCls
   */
  public native function setUserCls(userCls:*):void;

  /**
   * Sets the value of <code>viewModel</code>.
   * @param viewModel The new value.
   * @see #viewModel
   */
  public native function setViewModel(viewModel:*):void;

  /**
   * Convenience function to hide or show this component by Boolean.
   * @since 1.1.0
   * @param visible <code>true</code> to show, <code>false</code> to hide.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setVisible Original Ext JS documentation of 'setVisible'
   */
  public native function setVisible(visible:Boolean):Component;

  /**
   * Sets the <code>weight</code> config property for this component. This is only valid if this
   * component is in a <code>border</code> layout (<code>→ext.layout.container.BorderLayout</code>).
   * @param weight The new <code>weight</code> value.
   * @return The previous value of the <code>weight</code> property.
   * @see ext.layout.container.BorderLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setWeight Original Ext JS documentation of 'setWeight'
   */
  public native function setWeight(weight:Number):Number;

  /**
   * Sets the width of the component. This method fires the →<code>event:onResize</code> event.
   * @param width The new width to set. This may be one of:
   * <ul>
   * <li>A Number specifying the new width in pixels.</li>
   * <li>A String used to set the CSS width style.</li>
   * <li><code>undefined</code> to leave the width unchanged.</li>
   * <li><code>null</code> to clear the width.</li>
   * </ul>
   * @return this
   * @see #event:onResize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-setWidth Original Ext JS documentation of 'setWidth'
   */
  public native function setWidth(width:*):Component;

  /**
   * @inheritDoc
   */
  public native function setX(x:Number, animate:* = undefined):void;

  /**
   * @inheritDoc
   */
  public native function setXY(pos:Array, animate:* = undefined):void;

  /**
   * @inheritDoc
   */
  public native function setY(y:Number, animate:* = undefined):void;

  /**
   * Shows this Component, rendering it first if →<code>autoRender</code> or →<code>floating</code>
   * are <code>true</code>.
   * <p>After being shown, a →<code>floating</code> Component (such as a →<code>ext.window.Window</code>),
   * is activated it and brought to the front of its <i>z-index stack</i> (→<code>zIndexManager</code>).</p>
   * @param animateTarget <b>only valid for →<code>floating</code>
   * Components such as →<code>ext.window.Window</code>s or →<code>ext.tip.ToolTip</code>s,
   * or regular Components which have been configured with <code>floating: true</code>.</b> The target
   * from which the Component should animate from while opening.
   * @default null
   * @param callback A callback function to call after the Component is displayed.
   * Only necessary if animation was specified.
   * @param scope The scope (<code>this</code> reference) in which the callback is executed.
   * Defaults to this Component.
   * @see #autoRender
   * @see #floating
   * @see ext.window.Window
   * @see #zIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-show Original Ext JS documentation of 'show'
   * @see ext.tip.ToolTip
   */
  [Return("this")]
  public native function show(animateTarget:* = null, callback:Function = null, scope:Object = null):void;

  /**
   * Displays component at specific xy position.
   * A floating component (like a menu) is positioned relative to its ownerCt if any.
   * Useful for popping up a context menu:
   * <pre>
   * listeners: {
   *     itemcontextmenu: function(view, record, item, index, event, options) {
   *         Ext.create('Ext.menu.Menu', {
   *             width: 100,
   *             height: 100,
   *             margin: '0 0 10 0',
   *             items: [{
   *                 text: 'regular item 1'
   *             },{
   *                 text: 'regular item 2'
   *             },{
   *                 text: 'regular item 3'
   *             }]
   *         }).showAt(event.getXY());
   *     }
   * }
   * </pre>
   * @param x The new x position or array of <code>[x,y]</code>.
   * @param y The new y position
   * @param animate True to animate the Component into its new position.
   * You may also pass an animation configuration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-showAt Original Ext JS documentation of 'showAt'
   */
  public native function showAt(x:Array, y:Number = NaN, animate:* = undefined):void;

  /**
   * Shows this component by the specified →<code>ext.Component</code> or
   * →<code>ext.dom.Element</code>. Used when this component is →<code>floating</code>.
   * @param component The →<code>ext.Component</code> or
   * →<code>ext.dom.Element</code> to show the component by.
   * @param position Alignment position as used by
   * →<code>ext.util.Positionable.getAlignToXY()</code>. Defaults to <code>→defaultAlign</code>.
   * See →<code>alignTo()</code> for possible values.
   * @param offset Alignment offsets as used by
   * →<code>ext.util.Positionable.getAlignToXY()</code>. See →<code>alignTo()</code> for possible values.
   * @see ext.Component
   * @see ext.dom.Element
   * @see #floating
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-showBy Original Ext JS documentation of 'showBy'
   * @see ext.util.Positionable#getAlignToXY()
   * @see #defaultAlign
   * @see #alignTo()
   */
  public native function showBy(component:*, position:String = null, offset:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function stopAnimation(suppressEvent:* = undefined):Element;

  /**
   * @inheritDoc
   */
  public native function stopFx():Element;

  /**
   * @inheritDoc
   */
  public native function syncFx():Object;

  /**
   * @inheritDoc
   */
  public native function toBack():Component;

  /**
   * @inheritDoc
   */
  public native function toFront(preventFocus:Boolean = false):Component;

  /**
   * Toggles the specified CSS class on this component (removes it if it already exists,
   * otherwise adds it).
   * @param className The CSS class to toggle.
   * @param state If specified as <code>true</code>, causes the class to be added. If
   * specified as <code>false</code>, causes the class to be removed.
   * @return Returns the Component to allow method chaining.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-toggleCls Original Ext JS documentation of 'toggleCls'
   */
  public native function toggleCls(className:String, state:Boolean = false):Component;

  /**
   * @inheritDoc
   */
  public native function translatePoints(x:*, y:Number = NaN):Object;

  /**
   * Removes the mask applied by →<code>mask()</code>
   * @see #mask()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-unmask Original Ext JS documentation of 'unmask'
   */
  public native function unmask():void;

  /**
   * Navigates up the ownership hierarchy searching for an ancestor Container which matches
   * any passed selector or component.
   * <p><i>Important.</i> There is not a universal upwards navigation pointer. There are several upwards
   * relationships such as the <i>button</i> (→<code>ext.button.Button</code>) which activates
   * a →<code>ext.button.Button.menu</code>, or the <i>menu item</i> (→<code>ext.menu.Item</code>)
   * which activated a <i>submenu</i> (→<code>ext.menu.Item.menu</code>), or the
   * <i>column header</i> (→<code>ext.grid.column.Column</code>) which activated the column menu.</p>
   * <p>These differences are abstracted away by this method.</p>
   * <p>Example:</p>
   * <pre>
   * var owningTabPanel = grid.up('tabpanel');
   * </pre>
   * @param selector The selector component or actual component to test.
   * If not passed the immediate owner/activator is returned.
   * @param limit This may be a selector upon which to stop
   * the upward scan, or a limit of the number of steps, or Component reference to stop on.
   * @return The matching ancestor Container (or <code>undefined</code> if no match
   * was found).
   * @see ext.button.Button
   * @see ext.button.Button#menu
   * @see ext.menu.Item
   * @see ext.menu.Item#menu
   * @see ext.grid.column.Column
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-up Original Ext JS documentation of 'up'
   */
  public native function up(selector:* = undefined, limit:* = undefined):Container;

  /**
   * Update the content area of a component.
   * @since 3.4.0
   * @param htmlOrData If this component has been configured with a
   * template via the tpl config then it will use this argument as data to populate the
   * template. If this component was not configured with a template, the components
   * content area will be updated via Ext.Element update.
   * @param loadScripts Only legitimate when using the <code>→html</code>
   * configuration. Causes embedded script tags to be executed. Inline source will be executed
   * with this Component as the scope (<code>this</code> reference).
   * @default false
   * @param callback Only legitimate when using the <code>→html</code> configuration.
   * Callback to execute when scripts have finished loading.
   * @param scriptScope (Default `this`) The scope (<code>this</code> reference) in which to
   * execute <i>inline</i> script elements content. Scripts with a <code>src</code> attribute cannot
   * be executed with this scope.
   * @default this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-update Original Ext JS documentation of 'update'
   * @see #html
   */
  public native function update(htmlOrData:*, loadScripts:Boolean = false, callback:Function = null, scriptScope:Object = null):void;

  /**
   * Sets the current box measurements of the component's underlying element.
   * @param box An object in the format {x, y, width, height}
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-updateBox Original Ext JS documentation of 'updateBox'
   */
  public native function updateBox(box:Object):Component;

  /**
   * Updates this component's layout. If this update affects this components →<code>ownerCt</code>,
   * that component's <code>updateLayout</code> method will be called to perform the layout instead.
   * Otherwise, just this component (and its child items) will layout.
   * @param options An object with layout options.
   * <ul>
   * <li><code>defer:Boolean</code> (optional) —
   * <code>true</code> if this layout should be deferred.
   * </li>
   * <li><code>isRoot:Boolean</code> (optional) —
   * <code>true</code> if this layout should be the root of the layout.
   * </li>
   * </ul>
   * @see #ownerCt
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#method-updateLayout Original Ext JS documentation of 'updateLayout'
   */
  public native function updateLayout(options:Object = null):void;
}
}