package ext {

[Native("Ext.ComponentLoader", require)]
/**
 * This class is used to load content via Ajax into a →<code>ext.Component</code>. In general
 * this class will not be instanced directly, rather a loader configuration will be passed to the
 * constructor of the →<code>ext.Component</code>.
 * <p><b><i>HTML Renderer</i></b></p>
 * <p>By default, the content loaded will be processed as raw html. The response text
 * from the request is taken and added to the component. This can be used in
 * conjunction with the →<code>scripts</code> option to execute any inline scripts in
 * the resulting content. Using this renderer has the same effect as passing the
 * →<code>ext.Component.html</code> configuration option.</p>
 * <p><b><i>Data Renderer</i></b></p>
 * <p>This renderer allows content to be added by using JSON data and a →<code>ext.XTemplate</code>.
 * The content received from the response is passed to the →<code>ext.Component.update()</code> method.
 * This content is run through the attached →<code>ext.Component.tpl</code> and the data is added to
 * the Component. Using this renderer has the same effect as using the →<code>ext.Component.data</code>
 * configuration in conjunction with a →<code>ext.Component.tpl</code>.</p>
 * <p><b><i>Component Renderer</i></b></p>
 * <p>This renderer can only be used with a →<code>ext.container.Container</code> and subclasses. It allows
 * for Components to be loaded remotely into a Container. The response is expected to be
 * a single/series of →<code>ext.Component</code> configuration objects. When the response is received,
 * the data is decoded and then passed to →<code>ext.container.Container.add()</code>. Using this
 * renderer has the same effect as specifying the →<code>ext.container.Container.items</code>
 * configuration on a Container.</p>
 * <p><b><i>Custom Renderer</i></b></p>
 * <p>A custom function can be passed to handle any other special case, see the →<code>renderer</code>
 * option.</p>
 * <p><b><i>Example Usage</i></b></p>
 * <pre>
 * var cmp = Ext.create('Ext.Component', {
 *     renderTo: Ext.getBody(),
 *     tpl: '{firstName} - {lastName}',
 *     loader: {
 *         url: 'myPage.php',
 *         renderer: 'data',
 *         params: {
 *             userId: 1
 *         }
 *     }
 * });
 *
 * // call the loader manually (or use autoLoad:true instead)
 * cmp.getLoader().load();
 * </pre>
 * @see ext.Component
 * @see #scripts
 * @see ext.Component#html
 * @see ext.XTemplate
 * @see ext.Component#update()
 * @see ext.Component#tpl
 * @see ext.Component#data
 * @see ext.container.Container
 * @see ext.container.Container#add()
 * @see ext.container.Container#items
 * @see #renderer
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html Original Ext JS documentation of 'Ext.ComponentLoader'
 */
public class ComponentLoader extends ElementLoader {
  /**
   * @param config @inheritDoc
   */
  public function ComponentLoader(config:ComponentLoader = null) {
    super();
  }

  [ExtConfig]
  /**
   * True or a →<code>ext.LoadMask</code> configuration to enable masking
   * during loading.
   * @default false
   * @see ext.LoadMask
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html#cfg-loadMask Original Ext JS documentation of 'loadMask'
   */
  override public native function get loadMask():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set loadMask(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to have the loader make a request when the →<code>target</code> is rendered. If the target
   * is already rendered, a load will take place immediately.
   * This argument can also be a set of options that will be passed to →<code>load()</code> when
   * it is called.
   * @default false
   * @see #target
   * @see #load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html#cfg-loadOnRender Original Ext JS documentation of 'loadOnRender'
   */
  public native function get loadOnRender():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadOnRender(value:*):void;

  [ExtConfig]
  /**
   * The type of content that is to be loaded into, which can be one of 3 types...
   * <ul>
   * <li><b>html</b>: Loads raw html content, see →<code>ext.Component.html</code></li>
   * <li><b>data</b>: Loads raw html content, see →<code>ext.Component.data</code></li>
   * <li><b>component</b>: Loads child {Ext.Component} instances. This option is only valid when used
   * with a Container.</li>
   * </ul>
   * <p>Alternatively, you can pass a function which is called with the following parameters.</p>
   * <ul>
   * <li>loader - Loader instance</li>
   * <li>response - The server response</li>
   * <li>active - The active request</li>
   * </ul>
   * <p>The function must return false is loading is not successful. Below is a sample of using
   * a custom renderer:</p>
   * <pre>
   * new Ext.Component({
   *     loader: {
   *         url: 'myPage.php',
   *         renderer: function(loader, response, active) {
   *             var text = response.responseText;
   *             loader.getTarget().setHtml('The response is ' + text);
   *             return true;
   *         }
   *     }
   * });
   * </pre>
   * @default 'html'
   * @see ext.Component#html
   * @see ext.Component#data
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html#cfg-renderer Original Ext JS documentation of 'renderer'
   */
  override public native function get renderer():Function;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderer(value:Function):void;

  [ExtConfig]
  /**
   * The scope (<code>this</code> reference)to execute the →<code>renderer</code> function in. If the
   * →<code>scripts</code> option is <code>true</code>, <i>inline</i> script source (not scripts with a <code>src</code>
   * attribute) is also executed in this scope.
   * Defaults to this Component.
   * @default this
   * @see #renderer
   * @see #scripts
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html#cfg-rendererScope Original Ext JS documentation of 'rendererScope'
   */
  override public native function get rendererScope():Object;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set rendererScope(value:Object):void;

  [ExtConfig]
  /**
   * True to parse any inline script tags in the response. This only used
   * when using the html →<code>renderer</code>. The scripts will be executed with the target Component
   * as the scope (<code>this</code> reference).
   * @see #renderer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html#cfg-scripts Original Ext JS documentation of 'scripts'
   */
  override public native function get scripts():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set scripts(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The target →<code>ext.Component</code> for the loader.
   * If a string is passed it will be looked up via the id.
   * @default null
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html#cfg-target Original Ext JS documentation of 'target'
   * @see #getTarget()
   * @see #setTarget()
   */
  override public native function get target():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set target(value:*):void;

  /**
   * Set a {Ext.Component} as the target of this loader. Note that if the target is changed,
   * any active requests will be aborted.
   * @param target The component to be the target of this loader.
   * If a string is passed it will be looked up via its id.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ComponentLoader.html#method-setTarget Original Ext JS documentation of 'setTarget'
   */
  override public native function setTarget(target:*):void;
}
}